/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.AbstractBasicExportDialog;
import mpi.eudico.client.annotator.ngramstats.NgramStatsResult;
import mpi.eudico.server.corpora.clom.Transcription;
import nl.mpi.util.FileExtension;

public class ExportNgramRawData
extends AbstractBasicExportDialog {
    private static final long serialVersionUID = -8050510198504976188L;
    private NgramStatsResult result;
    public static final String DELIM = "\t";
    private static final String NEWLINE = "\n";

    public ExportNgramRawData(Frame parent, boolean modal, Transcription transcription, NgramStatsResult res) {
        super(parent, modal, null);
        this.result = res;
        try {
            this.startExport();
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n(" + ee.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
        }
    }

    @Override
    protected boolean startExport() throws IOException {
        File file = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), null, FileExtension.TEXT_EXT, true);
        if (file == null) {
            return false;
        }
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, this.encoding);
        BufferedWriter writer = new BufferedWriter(osw);
        writer.write("# RAW DATA Export of N-gram Analysis done on " + new Date().toString() + NEWLINE);
        writer.write("# Selected Domain: " + this.result.getDomain() + NEWLINE);
        writer.write("# Selected Tier: " + this.result.getTier() + NEWLINE);
        writer.write("# N-gram Size: " + this.result.getNgramSize() + NEWLINE);
        writer.write("# Search Time: " + this.result.getSearchTime() + "s\n");
        writer.write("# Files Inspected: " + this.result.getNumFiles() + NEWLINE);
        writer.write("# Total Annotations: " + this.result.getNumAnnotations() + NEWLINE);
        writer.write("# Total N-grams: " + this.result.getNumNgrams() + NEWLINE);
        writer.write("#\n");
        List<String> columns = this.result.getNgramAt(0).toCSVColumns();
        Iterator<String> itr = columns.iterator();
        while (itr.hasNext()) {
            writer.write(itr.next());
            if (!itr.hasNext()) {
                writer.write(NEWLINE);
                continue;
            }
            writer.write(DELIM);
        }
        for (int i = 0; i < this.result.getNumNgrams(); ++i) {
            writer.write(this.result.getNgramAt(i).toCSV(DELIM) + NEWLINE);
        }
        writer.close();
        return true;
    }
}

