/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.TransformerException;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.export.DisplaySettingsPane;
import mpi.eudico.client.annotator.export.ExportQtSmilDialog;
import mpi.eudico.client.util.Transcription2QtSubtitle;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import nl.mpi.util.FileExtension;

public class ExportQtSubtitleDialog
extends AbstractExtTierExportDialog
implements ChangeListener {
    private JCheckBox minimalDurCB;
    private JTextField minimalDurTF;
    private JCheckBox correctTimesCB;
    private JCheckBox mergeTiersCB;
    private JCheckBox recalculateTimesCB;
    private JButton fontSettingsButton;
    private Map<String, Object> fontSettingHashMap;
    private JCheckBox reuseSettingsCB;
    private boolean smilExport;
    final String prefSmilPrefix = "ExportQtSMILDialog";
    final String prefSubtitlePrefix = "ExportQtSubtitleDialog";
    String prefStringPrefix = "ExportQtSubtitleDialog";
    final String prefSelectionOnly = this.prefStringPrefix + ".SelectionOnly";
    final String prefSelectedTiers = this.prefStringPrefix + ".selectedTiers";
    final String prefTierOrder = this.prefStringPrefix + ".TierOrder";
    final String prefSelectTiersMode = this.prefStringPrefix + ".SelectTiersMode";
    final String prefLastSelectedItems = this.prefStringPrefix + ".LastSelectedItems";
    final String prefHiddenTiers = this.prefStringPrefix + ".HiddenTiers";
    final String prefAddOffsetTime = this.prefStringPrefix + ".AddOffsetTime";
    final String prefMergeTiers = this.prefStringPrefix + ".MergeTiers";
    final String prefRecalculateTime = this.prefStringPrefix + ".RecalculateTimeFromZero";
    final String prefMinDur = this.prefStringPrefix + ".MinimumDuration";
    final String prefMinDurValue = this.prefStringPrefix + ".MinimumDurationValue";
    final String prefReuseLastDisplaySet = this.prefStringPrefix + ".ReuseLastCustomDisplaySettings";

    public ExportQtSubtitleDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        this(parent, modal, transcription, selection, false);
    }

    public ExportQtSubtitleDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection, boolean smilExport) {
        super(parent, modal, transcription, selection);
        this.smilExport = smilExport;
        this.prefStringPrefix = smilExport ? "ExportQtSMILDialog" : "ExportQtSubtitleDialog";
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.restrictCheckBox.requestFocus();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString(this.prefTierOrder, this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(false);
        }
        stringsPref = Preferences.getListOfString(this.prefSelectedTiers, this.transcription);
        if (stringsPref != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString(this.prefSelectTiersMode, this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString(this.prefLastSelectedItems, this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        this.recalculateTimesCB = new JCheckBox();
        this.recalculateTimesCB.setEnabled(false);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 22, 4, 6);
        this.optionsPanel.add((Component)this.recalculateTimesCB, gridBagConstraints);
        this.correctTimesCB = new JCheckBox();
        this.correctTimesCB.setSelected(true);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.minimalDurCB = new JCheckBox();
        this.minimalDurCB.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurCB, gridBagConstraints);
        this.minimalDurTF = new JTextField(6);
        this.minimalDurTF.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.minimalDurTF, gridBagConstraints);
        this.mergeTiersCB = new JCheckBox();
        this.mergeTiersCB.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.mergeTiersCB, gridBagConstraints);
        this.fontSettingsButton = new JButton();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.fontSettingsButton, gridBagConstraints);
        this.fontSettingsButton.addActionListener(this);
        this.reuseSettingsCB = new JCheckBox();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.reuseSettingsCB, gridBagConstraints);
        this.minimalDurCB.addChangeListener(this);
        this.restrictCheckBox.addChangeListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List<MediaDescriptor> mediaDescriptors;
        File exportFile;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int minimalDur = 0;
        if (this.minimalDurCB.isSelected()) {
            String dur = this.minimalDurTF.getText();
            if (dur == null || dur.length() == 0) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
            try {
                minimalDur = Integer.parseInt(dur);
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.InvalidNumber"), ElanLocale.getString("Message.Warning"), 2);
                this.minimalDurTF.requestFocus();
                return false;
            }
        }
        if (this.smilExport) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSmilDialog.Title"), null, FileExtension.SMIL_EXT, false);
            if (exportFile == null) {
                return false;
            }
        } else {
            ArrayList<String[]> extensions = new ArrayList<String[]>();
            extensions.add(FileExtension.TEXT_EXT);
            extensions.add(FileExtension.XML_EXT);
            exportFile = this.promptForFile(ElanLocale.getString("ExportQtSubtitleDialog.Title"), extensions, FileExtension.TEXT_EXT, false);
        }
        if (exportFile == null) {
            return false;
        }
        long offset = 0L;
        if (this.correctTimesCB.isSelected() && (mediaDescriptors = this.transcription.getMediaDescriptors()).size() > 0) {
            offset = mediaDescriptors.get((int)0).timeOrigin;
        }
        boolean merge = this.mergeTiersCB.isSelected();
        long mediaDur = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        String[] tierNames = selectedTiers.toArray(new String[0]);
        long b = 0L;
        long e = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            b = this.selection.getBeginTime();
            e = this.selection.getEndTime();
        }
        String mediaURL = "";
        if (this.transcription.getMediaDescriptors().size() > 0) {
            mediaURL = this.transcription.getMediaDescriptors().get((int)0).mediaURL;
        }
        if (this.fontSettingHashMap == null && this.reuseSettingsCB.isEnabled() && this.reuseSettingsCB.isSelected()) {
            this.fontSettingHashMap = DisplaySettingsPane.getLastUsedSetting();
        }
        int vidWidth = -1;
        if (ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getVisualComponent() != null) {
            vidWidth = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getSourceWidth();
        }
        if (vidWidth > 0) {
            if (this.fontSettingHashMap == null) {
                this.fontSettingHashMap = new HashMap<String, Object>(1);
            }
            this.fontSettingHashMap.put("width", vidWidth);
        }
        int vidHeight = -1;
        if (ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getVisualComponent() != null) {
            vidHeight = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getSourceHeight();
        }
        if (vidHeight > 0) {
            if (this.fontSettingHashMap == null) {
                this.fontSettingHashMap = new HashMap<String, Object>(1);
            }
            this.fontSettingHashMap.put("videoHeight", vidHeight);
        }
        if (!merge) {
            Transcription2QtSubtitle.exportTiers(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        } else {
            Transcription2QtSubtitle.exportTiersMerged(this.transcription, tierNames, exportFile, b, e, offset, minimalDur, mediaDur, this.recalculateTimesCB.isSelected(), this.fontSettingHashMap);
        }
        if (this.smilExport) {
            Object smilFile = exportFile.getAbsolutePath();
            int index = ((String)smilFile).lastIndexOf(46);
            if (index > 0) {
                smilFile = ((String)smilFile).substring(0, index);
            }
            smilFile = (String)smilFile + "." + FileExtension.SMIL_EXT[1];
            String mediaPath = "";
            if (mediaURL.length() > 0) {
                index = mediaURL.lastIndexOf("/");
                mediaPath = mediaURL.substring(index + 1);
            }
            try {
                if (this.selection != null && this.restrictCheckBox.isSelected()) {
                    ExportQtSmilDialog.export2SMILQt(new File(this.transcription.getPathName()), new File((String)smilFile), tierNames, mediaPath, b + offset, e + offset, this.recalculateTimesCB.isSelected(), merge, this.fontSettingHashMap);
                } else {
                    ExportQtSmilDialog.export2SMILQt(new File(this.transcription.getPathName()), new File((String)smilFile), tierNames, mediaPath, mediaDur, merge, this.fontSettingHashMap);
                }
                return true;
            }
            catch (TransformerException te) {
                throw new IOException("TransformerException: " + te.getMessage());
            }
        }
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        if (this.smilExport) {
            this.setTitle(ElanLocale.getString("ExportQtSmilDialog.Title"));
            this.titleLabel.setText(ElanLocale.getString("ExportQtSmilDialog.TitleLabel"));
        } else {
            this.setTitle(ElanLocale.getString("ExportQtSubtitleDialog.Title"));
            this.titleLabel.setText(ElanLocale.getString("ExportQtSubtitleDialog.TitleLabel"));
        }
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.minimalDurCB.setText(ElanLocale.getString("ExportDialog.Label.MinimalDur"));
        this.mergeTiersCB.setText(ElanLocale.getString("ExportQtSubtitleDialog.Label.Merge"));
        this.fontSettingsButton.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.FontSetting"));
        this.recalculateTimesCB.setText(ElanLocale.getString("ExportDialog.RecalculateTimes"));
        this.reuseSettingsCB.setText(ElanLocale.getString("ExportQtSubtitleDialog.Button.ReuseSetting"));
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.minimalDurCB) {
            this.minimalDurTF.setEnabled(this.minimalDurCB.isSelected());
        } else if (e.getSource() == this.restrictCheckBox) {
            this.recalculateTimesCB.setEnabled(this.restrictCheckBox.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (ae.getSource() == this.fontSettingsButton) {
            this.setNewFontSetting(DisplaySettingsPane.getNewFontSetting(this, ElanLocale.getString("DisplaySettingsPane.Title")));
        }
    }

    protected void setNewFontSetting(Map<String, Object> newSetting) {
        if (newSetting != null) {
            this.fontSettingHashMap = newSetting;
        }
    }

    protected void setPreferredSetting() {
        Map<String, Object> setMap;
        String stringPref;
        Boolean boolPref = Preferences.getBool(this.prefSelectionOnly, null);
        if (boolPref == null) {
            boolPref = Preferences.getBool(this.prefStringPrefix + ".restrictCheckBox", null);
            Preferences.set(this.prefStringPrefix + ".restrictCheckBox", null, null);
        }
        if (boolPref != null) {
            this.restrictCheckBox.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(this.prefMinDur, null)) == null) {
            boolPref = Preferences.getBool(this.prefStringPrefix + ".minimalDurCB", null);
            Preferences.set(this.prefStringPrefix + ".minimalDurCB", null, null);
        }
        if (boolPref != null) {
            this.minimalDurCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(this.prefAddOffsetTime, null)) == null) {
            boolPref = Preferences.getBool(this.prefStringPrefix + ".correctTimesCB", null);
            Preferences.set(this.prefStringPrefix + ".correctTimesCB", null, null);
        }
        if (boolPref != null) {
            this.correctTimesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(this.prefMergeTiers, null)) == null) {
            boolPref = Preferences.getBool(this.prefStringPrefix + ".mergeTiersCB", null);
            Preferences.set(this.prefStringPrefix + ".mergeTiersCB", null, null);
        }
        if (boolPref != null) {
            this.mergeTiersCB.setSelected(boolPref);
        }
        if ((stringPref = Preferences.getString(this.prefMinDurValue, null)) == null) {
            stringPref = Preferences.getString(this.prefStringPrefix + ".minimalDurTF", null);
            Preferences.set(this.prefStringPrefix + ".minimalDurTF", null, null);
        }
        if (stringPref != null) {
            this.minimalDurTF.setText(stringPref);
        }
        if ((boolPref = Preferences.getBool(this.prefRecalculateTime, null)) == null) {
            boolPref = Preferences.getBool(this.prefStringPrefix + ".recalculateTimesCB", null);
            Preferences.set(this.prefStringPrefix + ".recalculateTimesCB", null, null);
        }
        if (boolPref != null) {
            this.recalculateTimesCB.setSelected(boolPref);
        }
        if ((boolPref = Preferences.getBool(this.prefReuseLastDisplaySet, null)) instanceof Boolean) {
            this.reuseSettingsCB.setSelected(boolPref);
        }
        if ((setMap = DisplaySettingsPane.getLastUsedSetting()) == null) {
            this.reuseSettingsCB.setEnabled(false);
        }
    }

    protected void savePreferences() {
        Preferences.set(this.prefSelectionOnly, this.restrictCheckBox.isSelected(), null);
        Preferences.set(this.prefMinDur, this.minimalDurCB.isSelected(), null);
        Preferences.set(this.prefAddOffsetTime, this.correctTimesCB.isSelected(), null);
        Preferences.set(this.prefMergeTiers, this.mergeTiersCB.isSelected(), null);
        Preferences.set(this.prefRecalculateTime, this.recalculateTimesCB.isSelected(), null);
        if (this.minimalDurTF.getText() != null) {
            Preferences.set(this.prefMinDurValue, this.minimalDurTF.getText(), null);
        }
        Preferences.set(this.prefSelectedTiers, this.getSelectedTiers(), (Transcription)this.transcription);
        Preferences.set(this.prefSelectTiersMode, this.getSelectionMode(), (Transcription)this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set(this.prefLastSelectedItems, this.getSelectedItems(), (Transcription)this.transcription);
        }
        Preferences.set(this.prefHiddenTiers, this.getHiddenTiers(), (Transcription)this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set(this.prefTierOrder, tierOrder, (Transcription)this.transcription);
        Preferences.set(this.prefReuseLastDisplaySet, this.reuseSettingsCB.isSelected(), null);
    }
}

