/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.commands.ClipMediaCA;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.LinkedFileDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import nl.mpi.util.FileExtension;
import nl.mpi.util.FileUtility;

public class ExportSelectionAsEAF {
    private TranscriptionImpl transcription;
    private TranscriptionImpl nextTrans;
    private String path;
    private String mediaFolder;
    private long beginTime;
    private long endTime;
    private boolean clipMedia;
    private ProgressMonitor monitor;

    public ExportSelectionAsEAF(TranscriptionImpl transcription, long beginTime, long endTime) {
        this.transcription = transcription;
        this.beginTime = beginTime;
        this.endTime = endTime;
        if (transcription != null) {
            this.startExport();
        }
    }

    private void startExport() {
        this.path = this.promptForFileName();
        if (this.path == null) {
            return;
        }
        this.nextTrans = new TranscriptionImpl();
        this.monitor = new ProgressMonitor(null, ElanLocale.getString("SaveDialog.Message.Title"), "", 0, 100);
        this.monitor.setMillisToDecideToPopup(10);
        this.monitor.setMillisToPopup(10);
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(50L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ExportSelectionAsEAF.this.startCopy();
            }
        }.start();
    }

    private void startCopy() {
        if (this.transcription == null || this.nextTrans == null) {
            this.progressUpdate(null, 100);
            return;
        }
        this.progressUpdate(null, 10);
        this.copy(this.transcription, this.nextTrans, this.beginTime, this.endTime, this.clipMedia);
        this.progressUpdate(null, 100);
    }

    private String createClipMediaFileName(String fileName, long begin, long end, boolean relativePath) {
        if (fileName != null) {
            int index = ((String)fileName).lastIndexOf(".");
            fileName = index > -1 ? ((String)fileName).substring(0, index) + "_" + begin + "_" + end + ((String)fileName).substring(index) : (String)fileName + "_" + begin + "_" + end;
            if (this.mediaFolder != null && !relativePath) {
                fileName = FileUtility.fileNameFromPath((String)fileName);
                fileName = this.mediaFolder + (String)fileName;
                fileName = FileUtility.pathToURLString((String)fileName);
            }
        }
        return fileName;
    }

    private void copy(TranscriptionImpl sourceTrans, TranscriptionImpl copyTrans, long begin, long end, boolean clipMedia) {
        TierImpl t1;
        String name;
        DefaultMutableTreeNode node;
        LinguisticType lt2;
        LinguisticType lt1;
        copyTrans.setNotifying(false);
        if (clipMedia) {
            CommandAction ca = ELANCommandFactory.getCommandAction(sourceTrans, "Menu.File.Export.MediaWithScript");
            this.mediaFolder = this.path;
            this.mediaFolder = File.separatorChar == '/' ? this.mediaFolder.replace('\\', File.separatorChar) : this.mediaFolder.replace('/', File.separatorChar);
            int index = this.mediaFolder.lastIndexOf(File.separatorChar);
            if (index >= 0) {
                this.mediaFolder = this.mediaFolder.substring(0, index);
            }
            if (!this.mediaFolder.endsWith(File.separator)) {
                this.mediaFolder = this.mediaFolder + File.separatorChar;
            }
            ((ClipMediaCA)ca).setPath(this.mediaFolder);
            ca.actionPerformed(null);
        }
        List<MediaDescriptor> mds = sourceTrans.getMediaDescriptors();
        ArrayList<MediaDescriptor> cmds = new ArrayList<MediaDescriptor>(mds.size());
        for (int i = 0; i < mds.size(); ++i) {
            MediaDescriptor md = (MediaDescriptor)mds.get(i).clone();
            if (clipMedia) {
                long offset = md.timeOrigin;
                md.mediaURL = this.createClipMediaFileName(md.mediaURL, begin + offset, end + offset, false);
                if (md.extractedFrom != null) {
                    md.extractedFrom = this.createClipMediaFileName(md.extractedFrom, begin + offset, end + offset, false);
                }
                if (md.relativeMediaURL != null) {
                    md.relativeMediaURL = this.createClipMediaFileName(md.relativeMediaURL, begin + offset, end + offset, true);
                }
            } else {
                md.timeOrigin += begin;
            }
            cmds.add(md);
        }
        copyTrans.setMediaDescriptors(cmds);
        List<LinkedFileDescriptor> lfds = sourceTrans.getLinkedFileDescriptors();
        ArrayList<LinkedFileDescriptor> clfds = new ArrayList<LinkedFileDescriptor>(lfds.size());
        for (int i = 0; i < lfds.size(); ++i) {
            LinkedFileDescriptor lfd = lfds.get(i);
            clfds.add((LinkedFileDescriptor)lfd.clone());
        }
        copyTrans.setLinkedFileDescriptors(clfds);
        this.progressUpdate(null, 20);
        if (this.isCancelled()) {
            return;
        }
        List<ControlledVocabulary> cvs = sourceTrans.getControlledVocabularies();
        ArrayList<ControlledVocabulary> cvc = new ArrayList<ControlledVocabulary>(cvs.size());
        for (int i = 0; i < cvs.size(); ++i) {
            ControlledVocabulary cv1 = cvs.get(i);
            ControlledVocabulary cv2 = new ControlledVocabulary(cv1.getName());
            cv2.cloneStructure(cv1);
            for (CVEntry ent1 : cv1) {
                CVEntry ent2 = new CVEntry(cv2, ent1);
                cv2.addEntry(ent2);
            }
            cvc.add(cv2);
        }
        copyTrans.setControlledVocabularies(cvc);
        this.progressUpdate(null, 30);
        if (this.isCancelled()) {
            return;
        }
        List<LinguisticType> types = sourceTrans.getLinguisticTypes();
        ArrayList<LinguisticType> typc = new ArrayList<LinguisticType>(types.size());
        ConstraintImpl con2 = null;
        for (int i = 0; i < types.size(); ++i) {
            lt1 = types.get(i);
            lt2 = new LinguisticType(lt1.getLinguisticTypeName());
            lt2.setTimeAlignable(lt1.isTimeAlignable());
            lt2.setControlledVocabularyName(lt1.getControlledVocabularyName());
            Constraint con1 = lt1.getConstraints();
            if (con1 != null) {
                switch (con1.getStereoType()) {
                    case 0: {
                        con2 = new TimeSubdivision();
                        break;
                    }
                    case 3: {
                        con2 = new SymbolicSubdivision();
                        break;
                    }
                    case 4: {
                        con2 = new SymbolicAssociation();
                        break;
                    }
                    case 1: {
                        con2 = new IncludedIn();
                    }
                }
                lt2.addConstraint(con2);
            }
            typc.add(lt2);
        }
        copyTrans.setLinguisticTypes(typc);
        this.progressUpdate(null, 35);
        if (this.isCancelled()) {
            return;
        }
        TierTree tree = new TierTree(sourceTrans);
        DefaultMutableTreeNode root = tree.getTree();
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            TierImpl copyTier = null;
            node = (DefaultMutableTreeNode)en.nextElement();
            name = (String)node.getUserObject();
            t1 = sourceTrans.getTierWithId(name);
            if (t1 != null) {
                lt1 = t1.getLinguisticType();
                lt2 = copyTrans.getLinguisticTypeByName(lt1.getLinguisticTypeName());
                if (lt2 != null) {
                    if (t1.hasParentTier()) {
                        String parentName = t1.getParentTier().getName();
                        TierImpl t2 = copyTrans.getTierWithId(parentName);
                        if (t2 != null) {
                            copyTier = new TierImpl(t2, name, t1.getParticipant(), copyTrans, lt2);
                            copyTier.setDefaultLocale(t1.getDefaultLocale());
                            copyTier.setAnnotator(t1.getAnnotator());
                            copyTier.setLangRef(t1.getLangRef());
                        } else {
                            ClientLogger.LOG.warning("The parent tier: " + parentName + " for tier: " + name + " was not found in the destination transcription");
                        }
                    } else {
                        copyTier = new TierImpl(name, t1.getParticipant(), copyTrans, lt2);
                        copyTier.setDefaultLocale(t1.getDefaultLocale());
                        copyTier.setAnnotator(t1.getAnnotator());
                        copyTier.setLangRef(t1.getLangRef());
                    }
                } else {
                    ClientLogger.LOG.warning("Could not add tier: " + name + " because the Linguistic Type was not found in the destination transcription.");
                }
            }
            if (copyTier == null) continue;
            copyTrans.addTier(copyTier);
        }
        this.progressUpdate(null, 40);
        if (this.isCancelled()) {
            return;
        }
        float incr = 40.0f / (float)Math.max(root.getChildCount(), 1);
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (DefaultMutableTreeNode)root.getChildAt(i);
            name = (String)node.getUserObject();
            t1 = sourceTrans.getTierWithId(name);
            List<AlignableAnnotation> srcAnnos = t1.getAlignableAnnotations();
            for (int j = 0; j < srcAnnos.size(); ++j) {
                AlignableAnnotation ann = srcAnnos.get(j);
                if (ann.getEndTimeBoundary() <= begin) continue;
                if (ann.getBeginTimeBoundary() >= end) break;
                DefaultMutableTreeNode record = AnnotationRecreator.createTreeForAnnotation(ann);
                AlignableAnnotation copyAnn = (AlignableAnnotation)AnnotationRecreator.createAnnotationFromTree(copyTrans, record);
                if (copyAnn.getBeginTimeBoundary() < begin) {
                    copyAnn.updateTimeInterval(begin, copyAnn.getEndTimeBoundary());
                }
                if (copyAnn.getEndTimeBoundary() <= end) continue;
                copyAnn.updateTimeInterval(copyAnn.getBeginTimeBoundary(), end);
            }
            this.progressUpdate(null, 40 + (int)((float)i * incr));
            if (!this.isCancelled()) continue;
            return;
        }
        this.progressUpdate(null, 80);
        if (this.isCancelled()) {
            return;
        }
        copyTrans.shiftAllAnnotations(-begin);
        TranscriptionStore store = ACMTranscriptionStore.getCurrentTranscriptionStore();
        int saveAsType = SaveAs27Preferences.saveAsTypeWithCheck(copyTrans);
        try {
            store.storeTranscription(copyTrans, null, new ArrayList<TierImpl>(), this.path, saveAsType);
            copyTrans.setPathName(this.path);
            this.copyPreferences(sourceTrans, copyTrans);
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, String.format("%s: %s", ElanLocale.getString("Message.Error.Save"), ioe.getMessage()), ElanLocale.getString("Message.Warning"), 2);
        }
        ClientLogger.LOG.info("Selection saved as new .eaf");
    }

    private void copyPreferences(TranscriptionImpl sourceTrans, TranscriptionImpl copyTrans) {
        String sourcePath = sourceTrans.getFullPath();
        if (sourcePath != null && !sourcePath.equals("aishug294879ryshfda9763afo8947a5gf") && sourcePath.endsWith(FileExtension.EAF_EXT[0])) {
            Object prefFile = sourcePath.substring(0, sourcePath.length() - FileExtension.EAF_EXT[0].length()) + FileExtension.ELAN_XML_PREFS_EXT[0];
            prefFile = FileUtility.urlToAbsPath((String)prefFile);
            Preferences.importPreferences((Transcription)copyTrans, (String)prefFile);
        }
    }

    private String promptForFileName() {
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.transcription));
        chooser.createAndShowFileAndClipMediaDialog(ElanLocale.getString("SaveDialog.Title"), 1, null, FileExtension.EAF_EXT, "LastUsedEAFDir");
        File exportFile = chooser.getSelectedFile();
        this.clipMedia = chooser.doClipMedia();
        if (exportFile != null) {
            return exportFile.getAbsolutePath();
        }
        return null;
    }

    private void progressUpdate(String note, int progress) {
        if (this.monitor != null) {
            if (note != null) {
                this.monitor.setNote(note);
            }
            this.monitor.setProgress(progress);
        }
    }

    private boolean isCancelled() {
        if (this.monitor != null) {
            return this.monitor.isCanceled();
        }
        return false;
    }
}

