/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.client.util.Transcription2TeX;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportTeXDialog
extends AbstractTierExportDialog {
    public ExportTeXDialog(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.updateLocale();
        this.postInit();
    }

    public static void main(String[] args) {
        String filename = "resources/testdata/elan/elan-example2.eaf";
        TranscriptionImpl transcription = new TranscriptionImpl(filename);
        JFrame frame = new JFrame();
        ExportTeXDialog dialog = new ExportTeXDialog((Frame)frame, false, transcription, null);
        dialog.setVisible(true);
    }

    @Override
    public boolean startExport() throws IOException {
        String fileExtension = "tex";
        File exportFile = this.promptForFile("ExportTeXDialog.Title", null, new String[]{fileExtension}, false);
        if (this.restrictCheckBox.isSelected()) {
            Transcription2TeX.exportTiers(this.transcription, this.getSelectedTiers().toArray(new String[0]), exportFile, this.selection.getBeginTime(), this.selection.getEndTime());
        } else {
            Transcription2TeX.exportTiers(this.transcription, this.getSelectedTiers().toArray(new String[0]), exportFile);
        }
        return true;
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                List<TierImpl> v = this.transcription.getTiers();
                this.model.extractTierNames(v);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTeXDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTeXDialog.TitleLabel"));
    }
}

