/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.wordlist.Transcription2WordList;
import mpi.eudico.server.corpora.clomimpl.wordlist.WordListEncoderInfo;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;
import nl.mpi.util.FileExtension;

public class ExportWordListDialog
extends AbstractExtTierExportDialog
implements ChangeListener,
ItemListener {
    private JRadioButton customDelimRB;
    private JLabel tokenDelimLabel;
    private JRadioButton defaultDelimRB;
    private JTextField customDelimField;
    private ButtonGroup delimButtonGroup;
    private JCheckBox countTokensCB;
    private JCheckBox includeTotalsCB;
    private JCheckBox includeFreqPercentCB;
    private int mode = WordListEncoderInfo.WORDS;

    public ExportWordListDialog(Frame parent, boolean modal, TranscriptionImpl transcription) {
        super(parent, modal, transcription, null);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    public ExportWordListDialog(Frame parent, boolean modal, List<File> files) {
        this(parent, modal, files, WordListEncoderInfo.WORDS);
    }

    public ExportWordListDialog(Frame parent, boolean modal, List<File> files, int mode) {
        super(parent, modal, files);
        this.files = files;
        if (mode == WordListEncoderInfo.ANNOTATIONS || mode == WordListEncoderInfo.WORDS) {
            this.mode = mode;
        }
        this.makeLayout();
        this.extractTiersFromFiles();
        this.postInit();
    }

    protected void extractTiers() {
        String stringPref;
        List<String> stringsPref = Preferences.getListOfString("ExportWordListDialog.TierOrder", this.transcription);
        if (stringsPref != null) {
            this.setTierOrder(stringsPref);
        } else {
            super.extractTiers(false);
        }
        stringsPref = Preferences.getListOfString("ExportWordListDialog.selectedTiers", this.transcription);
        if (stringsPref != null) {
            this.setSelectedTiers(stringsPref);
        }
        if ((stringPref = Preferences.getString("ExportWordListDialog.SelectTiersMode", this.transcription)) != null) {
            List<String> selItems;
            this.setSelectionMode(stringPref);
            if (!"Tier".equals(stringPref) && (selItems = Preferences.getListOfString("ExportWordListDialog.LastSelectedItems", this.transcription)) != null) {
                this.setSelectedItems(selItems);
            }
        }
        if (stringPref == null) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.tierRB", null);
            if (boolPref != null) {
                if (boolPref.booleanValue()) {
                    this.setSelectionMode("Tier");
                } else {
                    this.setSelectionMode("Type");
                }
            } else {
                boolPref = Preferences.getBool("ExportWordListDialog.typeRB", null);
                if (boolPref != null) {
                    if (boolPref.booleanValue()) {
                        this.setSelectionMode("Type");
                    } else {
                        this.setSelectionMode("Tier");
                    }
                }
            }
        }
    }

    @Override
    protected void extractTiersFromFiles() {
        super.extractTiersFromFiles();
        String stringPref = Preferences.getString("ExportWordListDialog.SelectTiersMode", null);
        if (stringPref != null) {
            this.setSelectionMode(stringPref);
        }
        if (stringPref == null) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.tierRB", null);
            if (boolPref != null) {
                if (boolPref.booleanValue()) {
                    this.setSelectionMode("Tier");
                } else {
                    this.setSelectionMode("Type");
                }
            } else {
                boolPref = Preferences.getBool("ExportWordListDialog.typeRB", null);
                if (boolPref != null) {
                    if (boolPref.booleanValue()) {
                        this.setSelectionMode("Type");
                    } else {
                        this.setSelectionMode("Tier");
                    }
                }
            }
        }
    }

    @Override
    protected void makeLayout() {
        int county;
        GridBagConstraints gridBagConstraints;
        super.makeLayout();
        this.countTokensCB = new JCheckBox();
        this.includeTotalsCB = new JCheckBox();
        this.includeFreqPercentCB = new JCheckBox();
        if (this.mode == WordListEncoderInfo.WORDS) {
            this.delimButtonGroup = new ButtonGroup();
            this.tokenDelimLabel = new JLabel();
            this.defaultDelimRB = new JRadioButton();
            this.customDelimRB = new JRadioButton();
            this.customDelimField = new JTextField();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.tokenDelimLabel, gridBagConstraints);
            this.defaultDelimRB.setSelected(true);
            this.defaultDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.defaultDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.defaultDelimRB, gridBagConstraints);
            this.customDelimRB.addChangeListener(this);
            this.delimButtonGroup.add(this.customDelimRB);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimRB, gridBagConstraints);
            this.customDelimField.setEnabled(false);
            this.customDelimField.setColumns(6);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.customDelimField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(12, 6, 4, 6);
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
            county = gridBagConstraints.gridy;
        } else {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = this.insets;
            this.optionsPanel.add((Component)this.countTokensCB, gridBagConstraints);
            county = gridBagConstraints.gridy;
        }
        int indent = 26;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.insets = new Insets(4, indent, 4, 6);
        gridBagConstraints2.gridy = county + 1;
        this.optionsPanel.add((Component)this.includeTotalsCB, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        this.optionsPanel.add((Component)this.includeFreqPercentCB, gridBagConstraints2);
        this.countTokensCB.addItemListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
        if (this.mode == WordListEncoderInfo.WORDS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.WordList.Title"));
            this.tokenDelimLabel.setText(ElanLocale.getString("TokenizeDialog.Label.TokenDelimiter"));
            this.defaultDelimRB.setText(ElanLocale.getString("Button.Default") + "( . , ! ? \" ' )");
            this.customDelimRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Custom"));
        } else if (this.mode == WordListEncoderInfo.ANNOTATIONS) {
            this.titleLabel.setText(ElanLocale.getString("ExportDialog.AnnotationList.Title"));
        }
        this.countTokensCB.setText(ElanLocale.getString("ExportDialog.WordList.CountOccur"));
        this.includeTotalsCB.setText(ElanLocale.getString("ExportDialog.WordList.IncludeCounts"));
        this.includeFreqPercentCB.setText(ElanLocale.getString("ExportDialog.WordList.IncludeFreqs"));
    }

    @Override
    protected boolean startExport() throws IOException {
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        File exportFile = null;
        if (this.mode == WordListEncoderInfo.WORDS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.WordList.Title"), null, FileExtension.TEXT_EXT, true);
        } else if (this.mode == WordListEncoderInfo.ANNOTATIONS) {
            exportFile = this.promptForFile(ElanLocale.getString("ExportDialog.AnnotationList.Title"), null, FileExtension.TEXT_EXT, true);
        }
        if (exportFile == null) {
            return false;
        }
        String delimiters = null;
        if (this.mode == WordListEncoderInfo.WORDS && this.customDelimRB.isSelected()) {
            delimiters = this.customDelimField.getText();
        }
        boolean countOccurrences = this.countTokensCB.isSelected();
        WordListEncoderInfo encoderInfo = new WordListEncoderInfo();
        encoderInfo.setCountOccurrences(countOccurrences);
        if (countOccurrences) {
            encoderInfo.setIncludeCounts(this.includeTotalsCB.isSelected());
            encoderInfo.setIncludeFreqPercent(this.includeFreqPercentCB.isSelected());
        }
        encoderInfo.setDelimiters(delimiters);
        encoderInfo.setExportFile(exportFile);
        encoderInfo.setSelectedTiers(selectedTiers);
        if (this.mode == WordListEncoderInfo.ANNOTATIONS) {
            encoderInfo.setDelimiters("");
        }
        encoderInfo.setExportMode(this.mode);
        encoderInfo.setEncoding(this.encoding);
        Transcription2WordList twl = new Transcription2WordList();
        twl.setProcessReport(new SimpleReport());
        try {
            if (this.transcription != null) {
                twl.encodeAndSave(this.transcription, encoderInfo, null, null);
            } else {
                twl.encodeAndSave(this.files, encoderInfo);
            }
            ProcessReport report = twl.getProcessReport();
            if (report != null) {
                ReportDialog rd = new ReportDialog((Dialog)this, report);
                rd.setModal(true);
                rd.setVisible(true);
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Error"), 2);
            return false;
        }
        return true;
    }

    @Override
    public void stateChanged(ChangeEvent ce) {
        if (ce.getSource() == this.defaultDelimRB || ce.getSource() == this.customDelimField) {
            if (this.defaultDelimRB.isSelected()) {
                this.customDelimField.setEnabled(false);
            } else {
                this.customDelimField.setEnabled(true);
                this.customDelimField.requestFocus();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.countTokensCB) {
            this.updateBoxes();
        }
    }

    private void updateBoxes() {
        this.includeTotalsCB.setEnabled(this.countTokensCB.isSelected());
        this.includeFreqPercentCB.setEnabled(this.countTokensCB.isSelected());
    }

    private void setPreferredSetting() {
        if (this.mode == WordListEncoderInfo.WORDS) {
            Boolean boolPref = Preferences.getBool("ExportWordListDialog.customDelimRB", null);
            if (boolPref != null) {
                this.customDelimRB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.defaultDelimRB", null)) != null) {
                this.defaultDelimRB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.customDelimField", null)) != null) {
                this.customDelimField.setText(boolPref.toString());
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.includeTotalsCB", null)) != null) {
                this.includeTotalsCB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.includeFreqPercCB", null)) != null) {
                this.includeFreqPercentCB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportWordListDialog.countTokensCB", null)) != null) {
                this.countTokensCB.setSelected(boolPref);
            }
        } else {
            Boolean boolPref = Preferences.getBool("ExportAnnotationListDialog.includeTotalsCB", null);
            if (boolPref != null) {
                this.includeTotalsCB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportAnnotationListDialog.includeFreqPercCB", null)) != null) {
                this.includeFreqPercentCB.setSelected(boolPref);
            }
            if ((boolPref = Preferences.getBool("ExportAnnotationListDialog.countTokensCB", null)) != null) {
                this.countTokensCB.setSelected(boolPref);
            }
        }
        this.updateBoxes();
    }

    private void savePreferences() {
        if (this.mode == WordListEncoderInfo.WORDS) {
            Preferences.set("ExportWordListDialog.customDelimRB", this.customDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.defaultDelimRB", this.defaultDelimRB.isSelected(), null);
            Preferences.set("ExportWordListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
            Preferences.set("ExportWordListDialog.includeTotalsCB", this.includeTotalsCB.isSelected(), null);
            Preferences.set("ExportWordListDialog.includeFreqPercCB", this.includeFreqPercentCB.isSelected(), null);
            if (this.customDelimField.getText() != null) {
                Preferences.set("ExportWordListDialog.customDelimField", this.customDelimField.getText(), null);
            }
            if (!this.multipleFileExport) {
                Preferences.set("ExportWordListDialog.selectedTiers", this.getSelectedTiers(), (Transcription)this.transcription);
                Preferences.set("ExportWordListDialog.SelectTiersMode", this.getSelectionMode(), (Transcription)this.transcription);
                Preferences.set("ExportWordListDialog.HiddenTiers", this.getHiddenTiers(), (Transcription)this.transcription);
                if (this.getSelectionMode() != "Tier") {
                    Preferences.set("ExportWordListDialog.LastSelectedItems", this.getSelectedItems(), (Transcription)this.transcription);
                }
                List<String> tierOrder = this.getTierOrder();
                Preferences.set("ExportWordListDialog.TierOrder", tierOrder, (Transcription)this.transcription);
            } else {
                Preferences.set("ExportWordListDialog.SelectTiersMode", this.getSelectionMode(), null);
            }
        } else {
            Preferences.set("ExportAnnotationListDialog.countTokensCB", this.countTokensCB.isSelected(), null);
            Preferences.set("ExportAnnotationListDialog.includeTotalsCB", this.includeTotalsCB.isSelected(), null);
            Preferences.set("ExportAnnotationListDialog.includeFreqPercCB", this.includeFreqPercentCB.isSelected(), null);
        }
    }
}

