/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;

class MinimalTabExportTableModel {
    public final Object HIDDEN = new Object();
    private List<String> columnIds;
    private List<List<Object>> rows;
    private List<Object> template;
    private final Object filler = null;
    private int numCols;
    private final String TAB = "\t";
    private boolean repeatValues = true;
    private boolean hideSpanningRowsInsteadOfRemove = false;
    private boolean includeAnnotationIds = false;
    private long[] span;
    private String fileName = null;
    private String filePath = null;
    private List<Annotation> annotations;
    private Map<String, String> cvEntryMap;

    MinimalTabExportTableModel(List<String> columnNames, List<Annotation> annotations, Map<String, String> cvEntryMap) {
        this(columnNames, annotations, cvEntryMap, true, false, false);
    }

    MinimalTabExportTableModel(List<String> columnNames, List<Annotation> annotations, Map<String, String> cvEntryMap, boolean repeatValues, boolean hideSpanningRowsInsteadOfRemove, boolean includeAnnotationIds) {
        this.repeatValues = repeatValues;
        this.hideSpanningRowsInsteadOfRemove = hideSpanningRowsInsteadOfRemove;
        this.includeAnnotationIds = includeAnnotationIds;
        this.columnIds = new ArrayList<String>(columnNames);
        this.numCols = this.columnIds.size() + 3;
        if (cvEntryMap != null) {
            ++this.numCols;
        }
        this.template = new ArrayList<Object>(this.numCols);
        for (int i = 0; i < this.numCols; ++i) {
            this.template.add(this.filler);
        }
        this.rows = new ArrayList<List<Object>>(annotations.size());
        this.annotations = annotations;
        this.cvEntryMap = cvEntryMap;
        this.initTable();
    }

    private void initTable() {
        List<Object> prevRow;
        int i;
        ArrayList<Annotation> repRemovals = new ArrayList<Annotation>();
        block0: for (int i2 = 0; i2 < this.annotations.size(); ++i2) {
            List<Annotation> pl;
            Annotation curAnn = this.annotations.get(i2);
            String curTier = curAnn.getTier().getName();
            int index = this.columnIds.indexOf(curTier);
            if (index <= -1) continue;
            index += 3;
            ArrayList<Object> row = new ArrayList<Object>(this.template);
            row.set(0, curAnn);
            row.set(1, curAnn.getBeginTimeBoundary());
            row.set(2, curAnn.getEndTimeBoundary());
            if (!this.includeAnnotationIds) {
                row.set(index, curAnn.getValue());
            } else {
                row.set(index, curAnn.getValue() + " [" + curAnn.getId() + "]");
            }
            if (this.cvEntryMap != null) {
                row.set(row.size() - 1, this.cvEntryMap.get(curAnn.getValue()));
            }
            this.rows.add(row);
            if (!this.repeatValues || (pl = ((AbstractAnnotation)curAnn).getParentListeners()).size() <= 0) continue;
            ArrayList<String> overlapsPart = new ArrayList<String>(10);
            for (int j = 0; j < pl.size(); ++j) {
                Annotation otherAnn = pl.get(j);
                if (!this.columnIds.contains(otherAnn.getTier().getName()) || otherAnn.getBeginTimeBoundary() == curAnn.getBeginTimeBoundary() && otherAnn.getEndTimeBoundary() == curAnn.getEndTimeBoundary()) continue;
                if (!overlapsPart.contains(otherAnn.getTier().getName())) {
                    overlapsPart.add(otherAnn.getTier().getName());
                    continue;
                }
                repRemovals.add(curAnn);
                continue block0;
            }
        }
        ArrayList<Integer> removals = new ArrayList<Integer>();
        block2: for (i = this.rows.size() - 1; i >= 0; --i) {
            List<Object> curRow = this.rows.get(i);
            long l1 = (Long)curRow.get(1);
            long l2 = (Long)curRow.get(2);
            for (int j = 0; j < i; ++j) {
                prevRow = this.rows.get(j);
                long l3 = (Long)prevRow.get(1);
                long l4 = (Long)prevRow.get(2);
                if (l1 != l3 || l2 != l4) continue;
                removals.add(i);
                for (int k = 3; k < curRow.size(); ++k) {
                    Object val = curRow.get(k);
                    if (val == this.filler) continue;
                    prevRow.set(k, val);
                }
                continue block2;
            }
        }
        for (i = 0; i < removals.size(); ++i) {
            this.rows.remove((Integer)removals.get(i));
        }
        List<Object> curRow = null;
        prevRow = null;
        if (this.repeatValues) {
            Object val = null;
            for (int j = 0; j < this.rows.size(); ++j) {
                curRow = this.rows.get(j);
                long l1 = (Long)curRow.get(1);
                long l2 = (Long)curRow.get(2);
                for (int i3 = 0; i3 < this.rows.size(); ++i3) {
                    if (i3 == j) continue;
                    prevRow = this.rows.get(i3);
                    long l3 = (Long)prevRow.get(1);
                    long l4 = (Long)prevRow.get(2);
                    if (l1 > l3 || l2 < l4) continue;
                    for (int k = 3; k < this.numCols; ++k) {
                        Object curVal = prevRow.get(k);
                        val = curRow.get(k);
                        if (curVal != null || val == null) continue;
                        prevRow.set(k, val);
                    }
                }
            }
            if (repRemovals.size() > 0) {
                for (int i4 = this.rows.size() - 1; i4 >= 0; --i4) {
                    curRow = this.rows.get(i4);
                    if (!repRemovals.contains(curRow.get(0))) continue;
                    if (this.hideSpanningRowsInsteadOfRemove) {
                        curRow.set(0, this.HIDDEN);
                        continue;
                    }
                    this.rows.remove(i4);
                }
            }
        }
        Collections.sort(this.rows, new RowComparator());
        this.annotations = null;
    }

    public long[] getSpan() {
        return this.span;
    }

    public void setSpan(long[] span) {
        this.span = span;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    private void tabOutput() {
        System.out.print("BT\tET\t");
        for (int i = 0; i < this.columnIds.size(); ++i) {
            System.out.print(this.columnIds.get(i) + "\t");
        }
        System.out.println();
        System.out.println();
        List<Object> curRow = null;
        for (int i = 0; i < this.rows.size(); ++i) {
            curRow = this.rows.get(i);
            for (int j = 1; j < curRow.size(); ++j) {
                Object val = curRow.get(j);
                if (val != null) {
                    if (val instanceof String) {
                        System.out.print(((String)val).replace("\n", " "));
                    } else {
                        System.out.print(val);
                    }
                } else {
                    System.out.print("*");
                }
                System.out.print("\t");
            }
            System.out.println();
        }
    }

    public String getTableAsString() {
        StringBuilder buf = new StringBuilder();
        List<Object> curRow = null;
        for (int i = 0; i < this.rows.size(); ++i) {
            curRow = this.rows.get(i);
            for (int j = 1; j < curRow.size(); ++j) {
                Object val = curRow.get(j);
                if (val != null) {
                    if (val instanceof String) {
                        buf.append(((String)val).replace("\n", " "));
                    } else {
                        buf.append(val);
                    }
                } else {
                    buf.append("*");
                }
                buf.append("\t");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public List<List<Object>> getRows() {
        return this.rows;
    }

    private class RowComparator
    implements Comparator<List<Object>> {
        private long l1;
        private long l2;
        private long l3;
        private long l4;

        private RowComparator() {
        }

        @Override
        public int compare(List<Object> row1, List<Object> row2) {
            this.l1 = (Long)row1.get(1);
            this.l2 = (Long)row1.get(2);
            this.l3 = (Long)row2.get(1);
            this.l4 = (Long)row2.get(2);
            if (this.l1 < this.l3 || this.l1 == this.l3 && this.l2 > this.l4) {
                return -1;
            }
            if (this.l1 == this.l3 && this.l2 == this.l4) {
                return 0;
            }
            return 1;
        }
    }
}

