/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TabExportTableModel
implements TableModel {
    public final String BT = "begin";
    public final String ET = "end";
    public final String DES = ElanLocale.getString("EditCVDialog.Label.CVDescription");
    private List<String> columnIds;
    private List<List<Object>> rows;
    private String fileName = null;
    private String absoluteFilePath = null;

    public TabExportTableModel(List<Annotation> annotations, Map<String, Map<String, String>> cvMap, List<String> tierNames) {
        this.columnIds = new ArrayList<String>(tierNames.size() + 3);
        this.rows = new ArrayList<List<Object>>(annotations.size());
        this.columnIds.add("begin");
        this.columnIds.add("end");
        this.columnIds.addAll(tierNames);
        if (cvMap != null) {
            this.columnIds.add(this.DES);
        }
        this.fillRows(annotations, cvMap);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getAbsoluteFilePath() {
        return this.absoluteFilePath;
    }

    public void setAbsoluteFilePath(String filePath) {
        this.absoluteFilePath = filePath;
    }

    private void fillRows(List<Annotation> annotations, Map<String, Map<String, String>> cvMap) {
        long lastBT = -1L;
        long lastET = -1L;
        String description = null;
        for (int i = 0; i < annotations.size(); ++i) {
            String cvName;
            Annotation ann = annotations.get(i);
            long bt = ann.getBeginTimeBoundary();
            long et = ann.getEndTimeBoundary();
            if (cvMap != null && (cvName = ((TierImpl)ann.getTier()).getLinguisticType().getControlledVocabularyName()) != null) {
                Map<String, String> map = cvMap.get(cvName);
                description = map.get(ann.getValue());
            }
            if (bt != lastBT || et != lastET) {
                ArrayList<Object> row = new ArrayList<Object>(this.columnIds.size());
                for (int j = 0; j < this.columnIds.size(); ++j) {
                    row.add(j, null);
                }
                row.set(0, bt);
                row.set(1, et);
                int col = this.findColumn(ann.getTier().getName());
                if (col > -1) {
                    row.set(col, ann.getValue());
                }
                if ((col = this.findColumn(this.DES)) > -1 && description != null) {
                    row.set(col, description);
                }
                this.rows.add(row);
            } else {
                int col = this.findColumn(ann.getTier().getName());
                if (col > -1) {
                    this.setValueAt(ann.getValue(), this.rows.size() - 1, col);
                }
                if ((col = this.findColumn(this.DES)) > -1 && description != null) {
                    List<Object> row = this.rows.get(this.rows.size() - 1);
                    row.set(col, description);
                }
            }
            lastBT = bt;
            lastET = et;
        }
    }

    public int findColumn(String columnId) {
        return this.columnIds.indexOf(columnId);
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        return this.columnIds.get(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (columnIndex == 0 || columnIndex == 1) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + rowIndex + " < 0 or > " + (this.rows.size() - 1));
        }
        List<Object> row = this.rows.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + columnIndex + " < 0 or > " + (this.columnIds.size() - 1));
        }
        if (rowIndex < 0 || rowIndex >= this.rows.size()) {
            throw new ArrayIndexOutOfBoundsException("Index " + rowIndex + " < 0 or > " + (this.rows.size() - 1));
        }
        List<Object> row = this.rows.get(rowIndex);
        row.set(columnIndex, aValue);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
    }
}

