/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.io.IOException;
import java.util.List;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractMultiFileExportProgessStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTextGridEncoder;

public class MultipleFileExportPraatStep3
extends AbstractMultiFileExportProgessStepPane {
    private boolean correctTimes;
    private String encoding;

    public MultipleFileExportPraatStep3(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    protected boolean doExport(TranscriptionImpl transImpl, String fileName) {
        List<MediaDescriptor> mds;
        long begin = 0L;
        long end = transImpl.getLatestTime();
        long mediaOffset = 0L;
        if (this.correctTimes && (mds = transImpl.getMediaDescriptors()) != null && mds.size() > 0) {
            mediaOffset = mds.get((int)0).timeOrigin;
        }
        PraatTGEncoderInfo encInfo = new PraatTGEncoderInfo(begin, end);
        encInfo.setEncoding(this.encoding);
        encInfo.setOffset(mediaOffset);
        encInfo.setExportSelection(false);
        PraatTextGridEncoder encoder = new PraatTextGridEncoder();
        try {
            encoder.encodeAndSave(transImpl, encInfo, transImpl.getTiersWithIds(this.selectedTiers), fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void enterStepForward() {
        this.correctTimes = (Boolean)this.multiPane.getStepProperty("CorrectTimes");
        this.encoding = (String)this.multiPane.getStepProperty("Encoding");
        super.enterStepForward();
    }
}

