/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.export.multiplefiles.AbstractMultiFileExportProgessStepPane;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoder;
import mpi.eudico.server.corpora.clomimpl.flex.FlexEncoderInfo;

public class MultipleFileFlexExportStep5
extends AbstractMultiFileExportProgessStepPane {
    private Map<String, List<String>> itemTypeMap;
    private Map<String, String> elementTypeMap;
    private Map<String, List<String>> linTypeMap;
    private String morphType;
    private FlexEncoderInfo encoderInfo;
    private boolean getFromTierName;
    private List<String> tierContentLanguages;

    public MultipleFileFlexExportStep5(MultiStepPane multiPane) {
        super(multiPane);
    }

    @Override
    public void enterStepForward() {
        this.elementTypeMap = (Map)this.multiPane.getStepProperty("ElementTypeMap");
        this.itemTypeMap = (Map)this.multiPane.getStepProperty("ElementItemMap");
        this.morphType = (String)this.multiPane.getStepProperty("Morph-Type");
        this.linTypeMap = (Map)this.multiPane.getStepProperty("TypeLangMap");
        this.getFromTierName = (Boolean)this.multiPane.getStepProperty("GetFromTierName");
        this.tierContentLanguages = (List)this.multiPane.getStepProperty("languages");
        super.enterStepForward();
    }

    @Override
    protected boolean doExport(TranscriptionImpl transcription, String fileName) {
        if (transcription != null && fileName != null) {
            this.encoderInfo = this.getFlexEncoderInfo(transcription);
            this.encoderInfo.setFile(fileName);
            FlexEncoder encoder = new FlexEncoder();
            encoder.setEncoderInfo(this.encoderInfo);
            encoder.encode(transcription);
            return true;
        }
        return false;
    }

    private FlexEncoderInfo getFlexEncoderInfo(TranscriptionImpl transcription) {
        this.encoderInfo = new FlexEncoderInfo();
        this.updateElementMappingTiers(transcription);
        this.updateElementItemMappingTiers(transcription);
        this.updateTypeLangMap(transcription);
        return this.encoderInfo;
    }

    private void updateElementMappingTiers(TranscriptionImpl transcription) {
        TierImpl t;
        TierImpl t2;
        int i;
        List<TierImpl> tierList;
        ArrayList<TierImpl> itTiers = new ArrayList<TierImpl>();
        ArrayList<TierImpl> paraList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> phraseList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> wordList = new ArrayList<TierImpl>();
        ArrayList<TierImpl> morphList = new ArrayList<TierImpl>();
        this.encoderInfo.setMappingForElement("interlinear-text", itTiers);
        this.encoderInfo.setMappingForElement("paragraph", paraList);
        this.encoderInfo.setMappingForElement("phrase", phraseList);
        this.encoderInfo.setMappingForElement("word", wordList);
        this.encoderInfo.setMappingForElement("morph", morphList);
        String type = this.elementTypeMap.get("interlinear-text");
        TierImpl selectTextTier = null;
        if (type != null) {
            tierList = transcription.getTiersWithLinguisticType(type);
            for (i = 0; i < tierList.size(); ++i) {
                t2 = tierList.get(i);
                if (t2.getLinguisticType().getConstraints() != null) continue;
                if (selectTextTier == null) {
                    selectTextTier = t2;
                }
                if (!t2.getName().contains("interlinear-text")) continue;
                selectTextTier = t2;
                break;
            }
        }
        if (selectTextTier != null) {
            itTiers.add(selectTextTier);
        }
        if ((type = this.elementTypeMap.get("paragraph")) != null && (tierList = transcription.getTiersWithLinguisticType(type)).size() > 0) {
            if (tierList.get(0).getLinguisticType().getConstraints() == null) {
                paraList.addAll(tierList);
            } else {
                for (i = 0; i < tierList.size(); ++i) {
                    t2 = tierList.get(i);
                    if (selectTextTier != null && (!t2.hasParentTier() || !t2.getParentTier().equals(selectTextTier)) || !this.hasPhraseTier(t2)) continue;
                    paraList.add(t2);
                }
            }
        }
        if ((type = this.elementTypeMap.get("phrase")) != null) {
            if (paraList.size() > 0) {
                for (int x = 0; x < paraList.size(); ++x) {
                    List<TierImpl> tiers = ((TierImpl)paraList.get(x)).getChildTiers();
                    for (int i2 = 0; i2 < tiers.size(); ++i2) {
                        t = tiers.get(i2);
                        if (!t.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                        phraseList.add(t);
                    }
                }
            } else {
                phraseList.addAll(transcription.getTiersWithLinguisticType(type));
            }
        }
        if ((type = this.elementTypeMap.get("word")) != null) {
            for (int x = 0; x < phraseList.size(); ++x) {
                List<TierImpl> tiers = ((TierImpl)phraseList.get(x)).getChildTiers();
                for (int i3 = 0; i3 < tiers.size(); ++i3) {
                    t = tiers.get(i3);
                    if (!t.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                    wordList.add(t);
                }
            }
        }
        if ((type = this.elementTypeMap.get("morph")) != null) {
            for (int x = 0; x < wordList.size(); ++x) {
                List<TierImpl> tiers = ((TierImpl)wordList.get(x)).getChildTiers();
                for (int i4 = 0; i4 < tiers.size(); ++i4) {
                    t = tiers.get(i4);
                    if (!t.getLinguisticType().getLinguisticTypeName().equals(type)) continue;
                    morphList.add(t);
                }
            }
        }
    }

    private void updateElementItemMappingTiers(Transcription transcription) {
        this.encoderInfo.setMappingForItem("interlinear-text", this.getTiersForItem("interlinear-text"));
        this.encoderInfo.setMappingForItem("phrase", this.getTiersForItem("phrase"));
        this.encoderInfo.setMappingForItem("word", this.getTiersForItem("word"));
        this.encoderInfo.setMappingForItem("morph", this.getTiersForItem("morph"));
        ArrayList<TierImpl> morphTypeTierList = new ArrayList<TierImpl>();
        this.encoderInfo.setMorphTypeTiers(morphTypeTierList);
        if (this.morphType != null) {
            List<TierImpl> tierList = this.encoderInfo.getMappingForElement("morph");
            for (int i = 0; i < tierList.size(); ++i) {
                TierImpl t = tierList.get(i);
                List<TierImpl> childTiers = t.getChildTiers();
                for (int j = 0; j < childTiers.size(); ++j) {
                    t = childTiers.get(j);
                    if (!this.morphType.equals(t.getLinguisticType().getLinguisticTypeName())) continue;
                    morphTypeTierList.add(t);
                }
            }
        }
    }

    private List<TierImpl> getTiersForItem(String itemType) {
        List<TierImpl> tierList = this.encoderInfo.getMappingForElement(itemType);
        List<String> typeList = this.itemTypeMap.get(itemType);
        ArrayList<TierImpl> itemTierList = new ArrayList<TierImpl>();
        for (int i = 0; i < tierList.size(); ++i) {
            TierImpl t = tierList.get(i);
            List<TierImpl> childTiers = t.getChildTiers();
            for (int j = 0; j < childTiers.size(); ++j) {
                t = childTiers.get(j);
                if (!typeList.contains(t.getLinguisticType().getLinguisticTypeName())) continue;
                itemTierList.add(t);
            }
        }
        return itemTierList;
    }

    private boolean hasPhraseTier(TierImpl tier) {
        if (tier != null) {
            List<TierImpl> childTiers = tier.getChildTiers();
            for (int i = 0; i < childTiers.size(); ++i) {
                tier = childTiers.get(i);
                if (!tier.getLinguisticType().getLinguisticTypeName().equals(this.elementTypeMap.get("phrase"))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateTypeLangMap(TranscriptionImpl transcription) {
        ArrayList<TierImpl> tierList = new ArrayList<TierImpl>();
        tierList.addAll(this.encoderInfo.getMappingForElement("interlinear-text"));
        tierList.addAll(this.encoderInfo.getMappingForElement("phrase"));
        tierList.addAll(this.encoderInfo.getMappingForElement("word"));
        tierList.addAll(this.encoderInfo.getMappingForElement("morph"));
        tierList.addAll(this.encoderInfo.getMappingForItem("interlinear-text"));
        tierList.addAll(this.encoderInfo.getMappingForItem("phrase"));
        tierList.addAll(this.encoderInfo.getMappingForItem("word"));
        tierList.addAll(this.encoderInfo.getMappingForItem("morph"));
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : this.linTypeMap.entrySet()) {
            String lingType = entry.getKey();
            List<String> valueList = entry.getValue();
            List<TierImpl> tiers = transcription.getTiersWithLinguisticType(lingType);
            for (TierImpl t : tiers) {
                if (!tierList.contains(t)) continue;
                if (this.getFromTierName) {
                    String type = this.getTypeName(t.getName());
                    String lang = this.getLanguage(t.getName());
                    if (type != null || lang != null) {
                        ArrayList<String> tvList = new ArrayList<String>(valueList);
                        if (type != null) {
                            tvList.set(0, type);
                        }
                        if (lang != null) {
                            tvList.set(1, lang);
                        }
                        map.put(t.getName(), tvList);
                        continue;
                    }
                    map.put(t.getName(), valueList);
                    continue;
                }
                map.put(t.getName(), valueList);
            }
        }
        this.encoderInfo.setTypeLangMap(map);
    }

    private String getTypeName(String typeName) {
        String[] compsArray;
        String type = null;
        if (typeName.startsWith("interlinear-text")) {
            typeName = typeName.substring("interlinear-text".length());
        }
        if (this.tierContentLanguages != null) {
            for (String cl : this.tierContentLanguages) {
                int li;
                if (!typeName.endsWith(cl) || (li = typeName.lastIndexOf(cl)) <= 0 || typeName.charAt(li - 1) != '-') continue;
                int fi = (typeName = typeName.substring(0, li - 1)).indexOf("-");
                if (fi > -1 && fi < typeName.length() - 1) {
                    return typeName.substring(fi + 1);
                }
                return typeName;
            }
        }
        if ((compsArray = typeName.split("-")).length == 3) {
            type = compsArray[1];
        } else if (compsArray.length > 3) {
            type = typeName.substring(typeName.indexOf("-") + 1, typeName.lastIndexOf("-"));
        } else if (compsArray.length == 2) {
            type = compsArray[0];
        }
        if (type == null || type.equals("item")) {
            type = null;
        }
        return type;
    }

    private String getLanguage(String typeName) {
        int lindex;
        String lang = null;
        if (typeName.startsWith("interlinear-text")) {
            typeName = typeName.substring("interlinear-text".length());
        }
        if (this.tierContentLanguages != null) {
            for (String cl : this.tierContentLanguages) {
                int li;
                if (!typeName.endsWith(cl) || (li = typeName.lastIndexOf(cl)) <= 0 || typeName.charAt(li - 1) != '-') continue;
                return typeName.substring(li);
            }
        }
        if ((lindex = typeName.lastIndexOf("-")) > -1 && lindex < typeName.length() - 2) {
            lang = typeName.substring(lindex + 1);
        }
        return lang;
    }
}

