/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class AnnotationTableListSelectionListener
implements ListSelectionListener {
    protected final AbstractViewer viewer;
    protected final JTable table;

    public AnnotationTableListSelectionListener(AbstractViewer viewer, JTable table) {
        this.viewer = viewer;
        this.table = table;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object object;
        AnnotationCore ann;
        if (!e.getValueIsAdjusting()) {
            return;
        }
        if (this.table.getSelectedRowCount() <= 0) {
            return;
        }
        GridViewerTableModel tableModel = (GridViewerTableModel)this.table.getModel();
        int row = this.table.getSelectedRow();
        if (this.table.getRowSorter() != null) {
            row = this.table.convertRowIndexToModel(row);
        }
        AnnotationCore annotationCore = ann = (object = tableModel.getValueAt(row, this.table.getSelectedColumn())) instanceof Annotation ? (Annotation)object : tableModel.getAnnotationCore(row);
        if (ann instanceof Annotation) {
            this.viewer.setActiveAnnotation((Annotation)ann);
        }
        if (this.table.getSelectedRowCount() > 1) {
            int[] rows = this.table.getSelectedRows();
            long selectedBeginTime = tableModel.getAnnotationCore(rows[0]).getBeginTimeBoundary();
            long selectedEndTime = tableModel.getAnnotationCore(rows[rows.length - 1]).getEndTimeBoundary();
            this.viewer.setSelection(selectedBeginTime, selectedEndTime);
        }
    }
}

