/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.util.multilangcv.LangInfo;
import mpi.eudico.util.multilangcv.LanguageCollection;
import mpi.eudico.util.multilangcv.RecentLanguages;

public abstract class AbstractEditLanguagesDialog
extends JDialog
implements ActionListener {
    protected JComboBox languageComboBox;
    protected JComboBox newLanguageComboBox;
    protected LangInfo selectedNewLanguage;
    protected ComboBoxLanguageEditor editor;
    protected JButton addButton;
    protected JButton changeButton;
    protected JButton deleteButton;
    protected JButton closeButton;
    protected String localePrefix;

    abstract int addLanguage(String var1, String var2, String var3);

    abstract void removeLanguage(int var1);

    abstract boolean setLanguageIds(int var1, String var2, String var3, String var4);

    abstract int getNumberOfLanguages();

    abstract LangInfo getLangInfo(int var1);

    public AbstractEditLanguagesDialog(Dialog parent, String localePrefix) {
        super(parent, true);
        this.localePrefix = localePrefix;
        this.makeLayout();
    }

    void makeLayout() {
        String title = ElanLocale.getString(this.localePrefix + ".Title");
        this.setTitle(title);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(6, 10, 6, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 10;
        gbc.insets = insets;
        GridBagConstraints gbc_center_x = (GridBagConstraints)gbc.clone();
        gbc_center_x.fill = 0;
        JLabel topLabel = new JLabel(title);
        topLabel.setFont(topLabel.getFont().deriveFont(16.0f));
        topLabel.setMaximumSize(topLabel.getPreferredSize());
        this.add((Component)topLabel, gbc_center_x);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridBagLayout());
        contentPanel.setBorder(new TitledBorder(ElanLocale.getString("EditLanguagesDialog.Border")));
        JLabel label = new JLabel(ElanLocale.getString(this.localePrefix + ".Label.Available"));
        contentPanel.add((Component)label, gbc);
        this.languageComboBox = new JComboBox();
        contentPanel.add((Component)this.languageComboBox, gbc);
        label = new JLabel(ElanLocale.getString("EditLanguagesDialog.Label.Edit"));
        contentPanel.add((Component)label, gbc);
        this.newLanguageComboBox = this.getNewLanguageComboBox();
        this.newLanguageComboBox.setMaximumRowCount(20);
        contentPanel.add((Component)this.newLanguageComboBox, gbc);
        Box buttonBox = new Box(0);
        this.addButton = new JButton(ElanLocale.getString("EditLanguagesDialog.Button.Add"));
        buttonBox.add(this.addButton);
        this.changeButton = new JButton(ElanLocale.getString("EditLanguagesDialog.Button.Change"));
        buttonBox.add(this.changeButton);
        this.deleteButton = new JButton(ElanLocale.getString("EditLanguagesDialog.Button.Delete"));
        buttonBox.add(this.deleteButton);
        contentPanel.add((Component)buttonBox, gbc_center_x);
        this.add((Component)contentPanel, gbc);
        this.closeButton = new JButton(ElanLocale.getString("EditLanguagesDialog.Button.Close"));
        this.add((Component)this.closeButton, gbc_center_x);
        this.languageComboBox.addActionListener(this);
        this.newLanguageComboBox.addActionListener(this);
        this.addButton.addActionListener(this);
        this.changeButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addButton) {
            String lab;
            String l;
            this.getSelectedNewLanguage();
            if (this.selectedNewLanguage == null) {
                this.showErrorDialog(ElanLocale.getString("EditLanguagesDialog.Error.NothingToAdd"));
                return;
            }
            String s = this.selectedNewLanguage.getId();
            int newindex = this.addLanguage(s, l = this.selectedNewLanguage.getLongId(), lab = this.selectedNewLanguage.getLabel());
            if (newindex >= 0) {
                this.updateLanguageComboBox();
                this.languageComboBox.setSelectedIndex(newindex);
            } else {
                this.showErrorDialog(ElanLocale.getString(this.localePrefix + ".Error.AddFailed"));
            }
        } else if (source == this.deleteButton) {
            int index = this.languageComboBox.getSelectedIndex();
            if (index >= 0) {
                LangInfo item = (LangInfo)this.languageComboBox.getItemAt(index);
                String name = item.toString();
                String sure = String.format(ElanLocale.getString(this.localePrefix + ".Confirm.Delete"), name);
                if (this.showConfirmDialog(sure)) {
                    this.removeLanguage(index);
                    this.updateLanguageComboBox();
                }
            }
        } else if (source == this.changeButton) {
            this.getSelectedNewLanguage();
            if (this.selectedNewLanguage == null) {
                this.showErrorDialog(ElanLocale.getString("EditLanguagesDialog.Error.NothingToChange"));
                return;
            }
            String s = this.selectedNewLanguage.getId();
            String l = this.selectedNewLanguage.getLongId();
            String lab = this.selectedNewLanguage.getLabel();
            int index = this.languageComboBox.getSelectedIndex();
            if (index >= 0 && this.setLanguageIds(index, s, l, lab)) {
                this.updateLanguageComboBox();
                this.languageComboBox.setSelectedIndex(index);
            } else {
                this.showErrorDialog(ElanLocale.getString(this.localePrefix + ".Error.ChangeFailed"));
            }
        } else if (source == this.closeButton) {
            this.closeDialog();
        } else if (source == this.languageComboBox) {
            int index = this.languageComboBox.getSelectedIndex();
            if (index >= 0) {
                int index2 = this.getIdIndex(this.getLongLanguageId(index));
                if (index2 == -1 && this.newLanguageComboBox.isEditable()) {
                    Object customItem = this.languageComboBox.getSelectedItem();
                    this.newLanguageComboBox.setSelectedItem(customItem);
                } else {
                    this.newLanguageComboBox.setSelectedIndex(index2);
                }
            }
        } else if (source == this.editor) {
            boolean valid = !e.getActionCommand().equals("invalid");
            this.addButton.setEnabled(valid);
            this.changeButton.setEnabled(valid);
        }
    }

    protected String getLongLanguageId(int index) {
        return this.getLangInfo(index).getLongId();
    }

    private LangInfo getSelectedNewLanguage() {
        Object selection;
        if (this.newLanguageComboBox.isEditable()) {
            ComboBoxEditor editor = this.newLanguageComboBox.getEditor();
            selection = editor.getItem();
        } else {
            selection = this.newLanguageComboBox.getSelectedItem();
        }
        if (selection instanceof LangInfo) {
            this.selectedNewLanguage = (LangInfo)selection;
        }
        return this.selectedNewLanguage;
    }

    protected int getIdIndex(String id) {
        int size = this.newLanguageComboBox.getItemCount();
        for (int i = 0; i < size; ++i) {
            LangInfo li;
            Object o = this.newLanguageComboBox.getItemAt(i);
            if (!(o instanceof LangInfo) || !id.equals((li = (LangInfo)o).getId()) && !id.equals(li.getLongId())) continue;
            return i;
        }
        return -1;
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected void updateBoxes() {
        this.updateNewLanguageComboBox();
        this.updateLanguageComboBox();
        this.pack();
    }

    protected void updateLanguageComboBox() {
        int nLangs = this.getNumberOfLanguages();
        this.languageComboBox.removeAllItems();
        for (int i = 0; i < nLangs; ++i) {
            this.languageComboBox.addItem(this.getLangInfo(i));
        }
        if (nLangs > 0) {
            this.languageComboBox.setSelectedIndex(0);
        }
        this.updateButtons();
    }

    protected JComboBox getNewLanguageComboBox() {
        JComboBox box = new JComboBox();
        box.setEditable(true);
        return box;
    }

    protected void updateNewLanguageComboBox() {
        LanguageCollection.setLocalCacheFolder(Constants.ELAN_DATA_DIR);
        List<LangInfo> languages = LanguageCollection.getLanguages();
        this.editor = new ComboBoxLanguageEditor(null);
        LanguagesListModel m = new LanguagesListModel(languages);
        this.newLanguageComboBox.setPrototypeDisplayValue(languages.get(0));
        this.newLanguageComboBox.setModel(m);
        this.newLanguageComboBox.setEditor(this.editor);
        if (this.getNumberOfLanguages() > 0) {
            this.newLanguageComboBox.setSelectedIndex(this.getIdIndex(this.getLongLanguageId(0)));
        }
        this.editor.setActionListener(this);
    }

    protected void updateButtons() {
        boolean atLeastOneLanguage = this.getNumberOfLanguages() > 0;
        this.deleteButton.setEnabled(atLeastOneLanguage);
        this.changeButton.setEnabled(atLeastOneLanguage);
        this.addButton.setEnabled(true);
    }

    protected boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, ElanLocale.getString("Message.Warning"), 0);
        return confirm == 0;
    }

    protected void showErrorDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Error"), 0);
    }

    public static class ComboBoxLanguageEditor
    implements ComboBoxEditor,
    DocumentListener {
        LangInfoPanel panel;
        LangInfo origLangInfo;
        ActionListener validListener;
        boolean prevValid;
        private boolean updating;
        private static final Pattern idPattern = Pattern.compile("[a-zA-Z][a-zA-Z0-9\\-]*");
        private final Matcher idMatcher = idPattern.matcher("");

        public ComboBoxLanguageEditor(LangInfo defaultChoice) {
            this.panel = new LangInfoPanel(defaultChoice);
            this.panel.addDocumentListener(this);
            this.prevValid = true;
        }

        public void setActionListener(ActionListener validListener) {
            this.validListener = validListener;
        }

        @Override
        public void setItem(Object anObject) {
            if (anObject instanceof LangInfo) {
                LangInfo li;
                this.origLangInfo = li = (LangInfo)anObject;
                this.updating = true;
                this.panel.setLangInfo(li);
                this.updating = false;
                this.sendValidAction();
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        @Override
        public Object getItem() {
            return this.checkIfValid(this.panel.getLangInfo());
        }

        private LangInfo checkIfValid(LangInfo li) {
            String s = li.getId();
            String l = li.getLongId();
            boolean edited = true;
            if (this.origLangInfo != null) {
                boolean bl = edited = !s.equals(this.origLangInfo.getId()) || !l.equals(this.origLangInfo.getLongId());
            }
            if (edited) {
                if (s.length() < 2) {
                    return null;
                }
                this.idMatcher.reset(s);
                if (!this.idMatcher.matches()) {
                    return null;
                }
                if (LanguageCollection.validate(li) == null) {
                    return null;
                }
                if (!RecentLanguages.getInstance().canAddLanguage(li)) {
                    return null;
                }
            }
            return li;
        }

        private void sendValidAction() {
            if (this.updating) {
                return;
            }
            boolean valid = this.getItem() != null;
            this.panel.setValid(valid);
            if (valid != this.prevValid) {
                if (this.validListener != null) {
                    this.validListener.actionPerformed(new ActionEvent(this, 1001, valid ? "valid" : "invalid"));
                }
                this.prevValid = valid;
            }
        }

        @Override
        public void selectAll() {
            this.panel.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.panel.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.panel.removeActionListener(l);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.sendValidAction();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.sendValidAction();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.sendValidAction();
        }

        class LangInfoPanel
        extends JPanel {
            JTextField label;
            JTextField shortId;
            JTextField longId;

            public LangInfoPanel(LangInfo initialEntry) {
                this.setLayout(new BoxLayout(this, 2));
                this.label = new JTextField(initialEntry == null ? "" : initialEntry.getLabel());
                this.label.setColumns(10);
                this.label.setBorder(new BevelBorder(1));
                this.shortId = new JTextField(initialEntry == null ? "" : initialEntry.getId());
                this.shortId.setColumns(6);
                this.shortId.setBorder(new BevelBorder(1));
                this.longId = new JTextField(initialEntry == null ? "" : initialEntry.getLongId());
                this.longId.setColumns(25);
                this.longId.setBorder(new BevelBorder(1));
                this.add(this.label);
                this.add(this.shortId);
                this.add(this.longId);
            }

            public void setLangInfo(LangInfo li) {
                this.label.setText(li.getLabel());
                this.shortId.setText(li.getId());
                this.longId.setText(li.getLongId());
            }

            public LangInfo getLangInfo() {
                return new LangInfo(this.shortId.getText(), this.longId.getText(), this.label.getText());
            }

            public void selectAll() {
                this.label.selectAll();
                this.shortId.selectAll();
                this.longId.selectAll();
            }

            public void setValid(boolean valid) {
                Color c = valid ? Color.BLACK : Color.RED;
                this.shortId.setForeground(c);
                this.longId.setForeground(c);
            }

            public void addActionListener(ActionListener l) {
                this.label.addActionListener(l);
                this.shortId.addActionListener(l);
                this.longId.addActionListener(l);
            }

            public void removeActionListener(ActionListener l) {
                this.label.removeActionListener(l);
                this.shortId.removeActionListener(l);
                this.longId.removeActionListener(l);
            }

            public void addDocumentListener(DocumentListener l) {
                this.shortId.getDocument().addDocumentListener(l);
                this.longId.getDocument().addDocumentListener(l);
            }
        }
    }

    private static class LanguagesListModel
    extends AbstractListModel
    implements ComboBoxModel {
        final List<LangInfo> languages;
        final int size;
        Object selectedItem;

        LanguagesListModel(List<LangInfo> languages) {
            this.languages = languages;
            this.size = languages.size();
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0) {
                return "";
            }
            if (index < this.size) {
                return this.languages.get(index);
            }
            return "";
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (this.selectedItem != null && !this.selectedItem.equals(anItem) || this.selectedItem == null && anItem != null) {
                this.selectedItem = anItem;
                this.fireContentsChanged(this, -1, -1);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

