/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;

public abstract class AbstractTierSortAndSelectPanel
extends JPanel
implements ActionListener,
ChangeListener,
ItemListener,
TableModelListener {
    protected final String NOT_SPECIFIED = "not specified";
    public static final String BY_TIER = "Tier";
    public static final String BY_TYPE = "Type";
    public static final String BY_PART = "Participant";
    public static final String BY_ANN = "Annotators";
    public static final String BY_LANG = "ContentLanguage";
    protected final int TIER_INDEX = 0;
    protected final int TYPE_INDEX = 1;
    protected final int PART_INDEX = 2;
    protected final int ANN_INDEX = 3;
    protected final int LANG_INDEX = 4;
    protected JPanel tierButtonPanel;
    protected JButton downButton;
    protected JButton upButton;
    protected JButton allButton;
    protected JButton noneButton;
    protected JButton sortButton;
    protected JButton unsortButton;
    protected JCheckBox rootTiersOnlyCB;
    protected TierExportTableModel model;
    protected JPanel tierSelectionPanel;
    protected final JTabbedPane selectTiersTabPane = new JTabbedPane();
    protected JTable tierTable;
    protected final String SELECT_COLUMN = "select";
    protected final String TIER_NAME_COLUMN = "tier";
    protected List<String> returnedTiers = null;
    protected int currentTabIndex = 0;
    protected List<String> allTierNames;
    protected List<String> oldTierOrder;
    protected List<String> selectedTypeNames;
    protected List<String> selectedTierNames;
    protected List<String> selectedParts;
    protected List<String> selectedAnns;
    protected List<String> selectedLangs;
    protected List<String> hiddenTiers;
    protected boolean allowReordering;
    protected boolean allowSorting;
    protected TierExportTableModel typeModel;
    protected TierExportTableModel partModel;
    protected TierExportTableModel annotModel;
    protected TierExportTableModel langModel;
    protected Modes mode = Modes.ALL_TIERS;
    protected Map<Integer, String> tabIndices;
    protected boolean pendingChanges = false;
    protected LinkedHashMap<String, Boolean> unfilteredTiers;
    protected LinkedHashMap<String, Boolean> unfilteredTypes;
    protected boolean initialSelectedTiersProvided = false;

    protected void initComponents() {
        this.selectedTypeNames = new ArrayList<String>();
        this.selectedParts = new ArrayList<String>();
        this.selectedAnns = new ArrayList<String>();
        this.selectedLangs = new ArrayList<String>();
        this.hiddenTiers = new ArrayList<String>();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        this.model = this.getNewModel();
        this.tierTable = new TierExportTable(this.model);
        this.typeModel = this.getNewModel();
        TierExportTable typeTable = new TierExportTable(this.typeModel);
        this.partModel = this.getNewModel();
        TierExportTable partTable = new TierExportTable(this.partModel);
        this.annotModel = this.getNewModel();
        TierExportTable annotTable = new TierExportTable(this.annotModel);
        this.langModel = this.getNewModel();
        TierExportTable langTable = new TierExportTable(this.langModel);
        this.initTables();
        Dimension tableDim = new Dimension(450, 160);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        this.selectTiersTabPane.setPreferredSize(tableDim);
        this.selectTiersTabPane.addTab(ElanLocale.getString("ExportDialog.Tab.Tier"), tierScrollPane);
        this.selectTiersTabPane.addTab(ElanLocale.getString("ExportDialog.Tab.Type"), new JScrollPane(typeTable));
        this.selectTiersTabPane.addTab(ElanLocale.getString("ExportDialog.Tab.Participant"), new JScrollPane(partTable));
        this.selectTiersTabPane.addTab(ElanLocale.getString("ExportDialog.Tab.Annotators"), new JScrollPane(annotTable));
        this.selectTiersTabPane.addTab(ElanLocale.getString("ExportDialog.Tab.Languages"), new JScrollPane(langTable));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.selectTiersTabPane, gridBagConstraints);
        this.selectTiersTabPane.addChangeListener(this);
        this.tierButtonPanel = new JPanel(new GridBagLayout());
        int gridx = 0;
        int gridy = 0;
        if (this.mode != Modes.ROOT_TIERS) {
            this.rootTiersOnlyCB = new JCheckBox(ElanLocale.getString("ExportTradTranscript.Label.RootTiers"));
            this.rootTiersOnlyCB.addItemListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = gridy++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 6, 0, 6);
            this.tierButtonPanel.add((Component)this.rootTiersOnlyCB, gridBagConstraints);
        }
        if (this.allowReordering) {
            this.upButton = new JButton();
            this.downButton = new JButton();
            try {
                ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
                ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
                this.upButton.setIcon(upIcon);
                this.downButton.setIcon(downIcon);
            }
            catch (Exception ex) {
                this.upButton.setText("Up");
                this.downButton.setText("Down");
            }
            this.upButton.addActionListener(this);
            this.downButton.addActionListener(this);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = insets;
            this.tierButtonPanel.add((Component)this.upButton, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 0, 4, 6);
            this.tierButtonPanel.add((Component)this.downButton, gridBagConstraints);
        }
        if (this.allowSorting) {
            this.sortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Sort"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = insets;
            this.tierButtonPanel.add((Component)this.sortButton, gridBagConstraints);
            this.unsortButton = new JButton(ElanLocale.getString("MultiTierControlPanel.Menu.Button.Default"));
            this.unsortButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = gridx++;
            gridBagConstraints.gridy = gridy;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 0, 4, 6);
            this.tierButtonPanel.add((Component)this.unsortButton, gridBagConstraints);
            this.sortButton.addActionListener(this);
            this.unsortButton.addActionListener(this);
        }
        this.allButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.noneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.tierButtonPanel.add((Component)this.allButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = gridx++;
        gridBagConstraints.gridy = gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.noneButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.tierButtonPanel, gridBagConstraints);
        this.model.addTableModelListener(this);
        this.typeModel.addTableModelListener(this);
        this.partModel.addTableModelListener(this);
        this.annotModel.addTableModelListener(this);
        this.langModel.addTableModelListener(this);
    }

    TierExportTableModel getNewModel() {
        TierExportTableModel model = new TierExportTableModel();
        model.setColumnIdentifiers(new String[]{"select", "tier"});
        return model;
    }

    protected abstract void initTables();

    public List<String> getSelectedTiers() {
        if (this.pendingChanges) {
            this.updateChanges(this.currentTabIndex);
        }
        this.returnedTiers = this.selectedTierNames;
        return this.returnedTiers;
    }

    public void setSelectedTiers(List<String> selectedTiers) {
        if (selectedTiers == null) {
            return;
        }
        this.model.removeTableModelListener(this);
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (selectedTiers.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    public List<String> getTierOrder() {
        ArrayList<String> orderedTiers = new ArrayList<String>();
        if (this.rootTiersOnlyCB == null || !this.rootTiersOnlyCB.isSelected() || this.unfilteredTiers == null) {
            int nameCol = this.model.findColumn("tier");
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                orderedTiers.add((String)this.model.getValueAt(i, nameCol));
            }
        } else {
            orderedTiers.addAll(this.unfilteredTiers.keySet());
        }
        return orderedTiers;
    }

    public void setTierOrder(List<String> tierOrder) {
        String name;
        if (tierOrder == null) {
            return;
        }
        this.model.removeTableModelListener(this);
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        HashMap<String, Boolean> currentSelected = new HashMap<String, Boolean>(this.model.getRowCount());
        ArrayList<String> curOrder = new ArrayList<String>(this.model.getRowCount());
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            name = (String)this.model.getValueAt(i, nameCol);
            Boolean sel = (Boolean)this.model.getValueAt(i, includeCol);
            curOrder.add(name);
            currentSelected.put(name, sel);
        }
        while (this.model.getRowCount() > 0) {
            this.model.removeRow(this.model.getRowCount() - 1);
        }
        ArrayList<String> newTierOrder = new ArrayList<String>(this.model.getRowCount());
        for (String s : tierOrder) {
            if (newTierOrder.contains(s)) continue;
            newTierOrder.add(s);
        }
        for (int i = 0; i < newTierOrder.size(); ++i) {
            name = (String)newTierOrder.get(i);
            if (!this.allTierNames.contains(name)) continue;
            if (curOrder.contains(name)) {
                this.model.addRow((Boolean)currentSelected.get(name), name);
                continue;
            }
            this.model.addRow(Boolean.FALSE, name);
        }
        for (String s : curOrder) {
            if (newTierOrder.contains(s)) continue;
            this.model.addRow((Boolean)currentSelected.get(s), s);
        }
        this.pendingChanges = true;
        this.model.addTableModelListener(this);
    }

    public List<String> getHiddenTiers() {
        if (this.pendingChanges) {
            this.updateChanges(this.currentTabIndex);
        }
        return this.hiddenTiers;
    }

    public void setHiddenTiers(List<String> hiddenTiers) {
        if (hiddenTiers == null) {
            return;
        }
        this.hiddenTiers = hiddenTiers;
        this.model.removeTableModelListener(this);
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (hiddenTiers.contains(value.toString())) {
                this.model.setValueAt(Boolean.FALSE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.TRUE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    public void setSelectionMode(String selectionMode, List<String> hiddenItems) {
        if (selectionMode == null) {
            return;
        }
        for (Integer curInt : this.tabIndices.keySet()) {
            if (!this.tabIndices.get(curInt).equals(selectionMode)) continue;
            this.currentTabIndex = curInt;
            break;
        }
        this.selectTiersTabPane.setSelectedIndex(this.currentTabIndex);
        if (hiddenItems != null) {
            this.setUnselectedItems(hiddenItems);
        }
    }

    public String getSelectionMode() {
        int index = this.selectTiersTabPane.getSelectedIndex();
        return this.tabIndices.get(index);
    }

    public List<String> getSelectedItems() {
        int tab = this.selectTiersTabPane.getSelectedIndex();
        String selectionMode = this.tabIndices.get(tab);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        int includeCol = iterModel.findColumn("select");
        int nameCol = iterModel.findColumn("tier");
        ArrayList<String> selected = new ArrayList<String>();
        for (int i = 0; i < iterModel.getRowCount(); ++i) {
            Object value = iterModel.getValueAt(i, includeCol);
            if (!((Boolean)value).booleanValue()) continue;
            selected.add((String)iterModel.getValueAt(i, nameCol));
        }
        return selected;
    }

    public List<String> getUnselectedItems() {
        int tab = this.selectTiersTabPane.getSelectedIndex();
        String selectionMode = this.tabIndices.get(tab);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        int includeCol = iterModel.findColumn("select");
        int nameCol = iterModel.findColumn("tier");
        ArrayList<String> unselected = new ArrayList<String>();
        for (int i = 0; i < iterModel.getRowCount(); ++i) {
            Object value = iterModel.getValueAt(i, includeCol);
            if (((Boolean)value).booleanValue()) continue;
            unselected.add((String)iterModel.getValueAt(i, nameCol));
        }
        return unselected;
    }

    public void setSelectedItems(List<String> items) {
        if (items == null) {
            return;
        }
        int tab = this.selectTiersTabPane.getSelectedIndex();
        String selectionMode = this.tabIndices.get(tab);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        int includeCol = iterModel.findColumn("select");
        int nameCol = iterModel.findColumn("tier");
        iterModel.removeTableModelListener(this);
        for (int i = 0; i < iterModel.getRowCount(); ++i) {
            Object value = iterModel.getValueAt(i, nameCol);
            iterModel.setValueAt(items.contains(value), i, includeCol);
        }
        iterModel.addTableModelListener(this);
        this.pendingChanges = true;
    }

    public void setUnselectedItems(List<String> items) {
        if (items == null) {
            return;
        }
        int tab = this.selectTiersTabPane.getSelectedIndex();
        String selectionMode = this.tabIndices.get(tab);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        int includeCol = iterModel.findColumn("select");
        int nameCol = iterModel.findColumn("tier");
        iterModel.removeTableModelListener(this);
        int rowCount = iterModel.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            Object value = iterModel.getValueAt(i, nameCol);
            iterModel.setValueAt(!items.contains(value), i, includeCol);
        }
        iterModel.addTableModelListener(this);
        this.pendingChanges = true;
    }

    public void setRootTiersOnly(boolean rootsOnly) {
        if (this.mode == Modes.ROOT_TIERS) {
            return;
        }
        this.rootTiersOnlyCB.setSelected(rootsOnly);
    }

    public boolean isRootTiersOnly() {
        if (this.mode == Modes.ROOT_TIERS) {
            return true;
        }
        return this.rootTiersOnlyCB.isSelected();
    }

    public void applyChanges() {
        int tab = this.selectTiersTabPane.getSelectedIndex();
        this.updateChanges(tab);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.allButton) {
            this.selectAllOrNone(Boolean.TRUE);
        } else if (ae.getSource() == this.noneButton) {
            this.selectAllOrNone(Boolean.FALSE);
        } else if (ae.getSource() == this.upButton) {
            this.moveUp();
        } else if (ae.getSource() == this.downButton) {
            this.moveDown();
        } else if (ae.getSource() == this.sortButton) {
            this.sortAZ();
        } else if (ae.getSource() == this.unsortButton) {
            this.undoSort();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.pendingChanges) {
            this.updateChanges(this.currentTabIndex);
        }
        this.currentTabIndex = this.selectTiersTabPane.getSelectedIndex();
        this.updateTabAtIndex(this.currentTabIndex);
        this.updateButtons(this.currentTabIndex);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.rootTiersOnlyCB) {
            if (e.getStateChange() == 2) {
                this.toggleRootsOnly(false);
            } else {
                this.toggleRootsOnly(true);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.pendingChanges = true;
    }

    protected void toggleRootsOnly(boolean rootsOnly) {
    }

    private void updateButtons(int selIndex) {
        String tabTitle = this.tabIndices.get(selIndex);
        boolean up = false;
        boolean down = false;
        boolean unsort = false;
        if (BY_TIER.equals(tabTitle)) {
            boolean enable;
            up = enable = this.model.getRowCount() > 1;
            down = enable;
            boolean bl = unsort = this.oldTierOrder != null;
        }
        if (this.upButton != null) {
            this.upButton.setEnabled(up);
        }
        if (this.downButton != null) {
            this.downButton.setEnabled(down);
        }
        if (this.unsortButton != null) {
            this.unsortButton.setEnabled(unsort);
        }
    }

    protected DefaultTableModel getModel(String selectionMode) {
        if (BY_ANN.equals(selectionMode)) {
            return this.annotModel;
        }
        if (BY_PART.equals(selectionMode)) {
            return this.partModel;
        }
        if (BY_TYPE.equals(selectionMode)) {
            return this.typeModel;
        }
        if (BY_LANG.equals(selectionMode)) {
            return this.langModel;
        }
        return this.model;
    }

    protected void selectAllOrNone(Boolean select) {
        String selectionMode = this.tabIndices.get(this.currentTabIndex);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        int includeCol = iterModel.findColumn("select");
        for (int i = 0; i < iterModel.getRowCount(); ++i) {
            iterModel.setValueAt(select, i, includeCol);
        }
    }

    protected void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    protected void moveUp() {
        int[] selected;
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        for (int element : selected = this.tierTable.getSelectedRows()) {
            int row = element;
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    private void sortAZ() {
        String value;
        int i;
        String selectionMode = this.tabIndices.get(this.currentTabIndex);
        DefaultTableModel iterModel = this.getModel(selectionMode);
        if (iterModel.getRowCount() < 2) {
            return;
        }
        if (iterModel == this.model) {
            this.oldTierOrder = new ArrayList<String>(this.allTierNames.size());
        } else {
            iterModel.removeTableModelListener(this);
        }
        HashMap<String, Boolean> curSelected = new HashMap<String, Boolean>(iterModel.getRowCount());
        ArrayList<String> values = new ArrayList<String>(iterModel.getRowCount());
        int includeCol = iterModel.findColumn("select");
        int nameCol = iterModel.findColumn("tier");
        for (i = 0; i < iterModel.getRowCount(); ++i) {
            value = (String)iterModel.getValueAt(i, nameCol);
            values.add(value);
            curSelected.put(value, (Boolean)iterModel.getValueAt(i, includeCol));
            if (iterModel != this.model) continue;
            this.oldTierOrder.add(value);
        }
        Collections.sort(values);
        for (i = 0; i < iterModel.getRowCount() && i < values.size(); ++i) {
            value = (String)values.get(i);
            iterModel.setValueAt(value, i, nameCol);
            iterModel.setValueAt(curSelected.get(value), i, includeCol);
        }
        if (iterModel == this.model) {
            this.unsortButton.setEnabled(true);
        }
        if (iterModel != this.model) {
            iterModel.addTableModelListener(this);
        }
    }

    private void undoSort() {
        if (this.oldTierOrder != null) {
            String value;
            int i;
            HashMap<String, Boolean> curSelected = new HashMap<String, Boolean>(this.model.getRowCount());
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            for (i = 0; i < this.model.getRowCount(); ++i) {
                value = (String)this.model.getValueAt(i, nameCol);
                curSelected.put(value, (Boolean)this.model.getValueAt(i, includeCol));
            }
            for (i = 0; i < this.model.getRowCount() && i < this.oldTierOrder.size(); ++i) {
                value = this.oldTierOrder.get(i);
                this.model.setValueAt(value, i, nameCol);
                this.model.setValueAt(curSelected.get(value), i, includeCol);
            }
            this.unsortButton.setEnabled(false);
        }
    }

    protected void showTiersTab() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        this.model.removeTableModelListener(this);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (this.selectedTierNames.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    protected void updateTiers() {
        if (this.pendingChanges) {
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            this.selectedTierNames.clear();
            this.hiddenTiers.clear();
            for (int i = 0; i < this.model.getRowCount(); ++i) {
                Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
                String tierName = (String)this.model.getValueAt(i, nameCol);
                if (include.booleanValue()) {
                    this.selectedTierNames.add(tierName);
                    continue;
                }
                this.hiddenTiers.add(tierName);
            }
        }
    }

    protected abstract void updateLinguisticTypes();

    protected abstract void updateParticipants();

    protected abstract void updateAnnotators();

    protected abstract void updateLanguages();

    protected void updateChanges(int index) {
        switch (index) {
            case 0: {
                this.updateTiers();
                break;
            }
            case 1: {
                this.updateLinguisticTypes();
                break;
            }
            case 2: {
                this.updateParticipants();
                break;
            }
            case 3: {
                this.updateAnnotators();
                break;
            }
            case 4: {
                this.updateLanguages();
                break;
            }
        }
        this.pendingChanges = false;
    }

    protected void updateTabAtIndex(int index) {
        if (index == 0) {
            this.showTiersTab();
        }
    }

    public static enum Modes {
        ALL_TIERS,
        ROOT_TIERS,
        ALIGNABLE_TIERS,
        ROOT_W_INCLUDED;

    }
}

