/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public abstract class AbstractTwoTierOpDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    protected JRadioButton overwriteRB;
    protected JLabel titleLabel;
    protected JRadioButton preserveRB;
    protected JPanel dividePanel;
    protected JPanel titlePanel;
    protected JLabel destTierLabel;
    protected ButtonGroup existButtonGroup;
    protected JComboBox sourceTierComboBox;
    protected JPanel tierSelectionPanel;
    protected JButton startButton;
    protected JLabel sourceTierLabel;
    protected JPanel buttonPanel;
    protected JComboBox destTierComboBox;
    protected JButton closeButton;
    protected JLabel existingLabel;
    protected JButton createTierButton;
    protected JCheckBox emptyAnnCheckBox;
    protected JPanel optionsPanel;
    protected TranscriptionImpl transcription;
    protected final String EMPTY = "-";

    public AbstractTwoTierOpDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.initComponents();
        this.extractSourceTiers();
    }

    protected void extractSourceTiers() {
        if (this.transcription != null) {
            for (Tier tier : this.transcription.getTiers()) {
                this.sourceTierComboBox.addItem(tier.getName());
            }
        } else {
            this.sourceTierComboBox.addItem("-");
        }
        this.extractDestinationTiers();
    }

    protected abstract void extractDestinationTiers();

    private void editTierDialog() {
        String currentSelected = (String)this.destTierComboBox.getSelectedItem();
        int numCand = this.destTierComboBox.getItemCount();
        ArrayList<String> oldCandidates = new ArrayList<String>(numCand);
        for (int i = 0; i < numCand; ++i) {
            oldCandidates.add((String)this.destTierComboBox.getItemAt(i));
        }
        Command command = ELANCommandFactory.createCommand(this.transcription, "CommandActions.EditTier");
        Object[] args = new Object[]{0, null};
        command.execute(this.transcription, args);
        this.extractDestinationTiers();
        int newNumCand = this.destTierComboBox.getItemCount();
        if (newNumCand > numCand) {
            for (int i = 0; i < newNumCand; ++i) {
                if (oldCandidates.contains(this.destTierComboBox.getItemAt(i))) continue;
                this.destTierComboBox.setSelectedIndex(i);
                break;
            }
        } else {
            this.destTierComboBox.setSelectedItem(currentSelected);
        }
    }

    protected abstract void startOperation();

    protected void initComponents() {
        this.existButtonGroup = new ButtonGroup();
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.tierSelectionPanel = new JPanel();
        this.sourceTierLabel = new JLabel();
        this.sourceTierComboBox = new JComboBox();
        this.destTierLabel = new JLabel();
        this.destTierComboBox = new JComboBox();
        this.createTierButton = new JButton();
        this.optionsPanel = new JPanel();
        this.existingLabel = new JLabel();
        this.overwriteRB = new JRadioButton();
        this.preserveRB = new JRadioButton();
        this.emptyAnnCheckBox = new JCheckBox();
        this.dividePanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.startButton = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AbstractTwoTierOpDialog.this.closeDialog(evt);
            }
        });
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel.setLayout(new BorderLayout(0, 4));
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titleLabel.setHorizontalAlignment(0);
        JPanel titleLabelPanel = new JPanel();
        titleLabelPanel.add(this.titleLabel);
        this.titlePanel.add((Component)titleLabelPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.tierSelectionPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.sourceTierLabel, gridBagConstraints);
        this.sourceTierComboBox.addItemListener(this);
        this.sourceTierComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.sourceTierComboBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.destTierLabel, gridBagConstraints);
        this.destTierComboBox.setMaximumRowCount(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.destTierComboBox, gridBagConstraints);
        this.createTierButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.tierSelectionPanel.add((Component)this.createTierButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.optionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.dividePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.existingLabel, gridBagConstraints);
        this.overwriteRB.setSelected(true);
        this.existButtonGroup.add(this.overwriteRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.overwriteRB, gridBagConstraints);
        this.existButtonGroup.add(this.preserveRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.preserveRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.optionsPanel.add((Component)this.emptyAnnCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gridBagConstraints);
        this.buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        this.startButton.addActionListener(this);
        this.buttonPanel.add(this.startButton);
        this.closeButton.addActionListener(this);
        this.buttonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
    }

    protected void addOptionsPanel(JPanel opPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.optionsPanel.add((Component)opPanel, gridBagConstraints);
        this.optionsPanel.revalidate();
    }

    protected void updateLocale() {
        this.tierSelectionPanel.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.SelectTiers")));
        this.sourceTierLabel.setText(ElanLocale.getString("TokenizeDialog.Label.SourceTier"));
        this.destTierLabel.setText(ElanLocale.getString("TokenizeDialog.Label.DestinationTier"));
        this.createTierButton.setText(ElanLocale.getString("TokenizeDialog.Button.NewTier"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        this.existingLabel.setText(ElanLocale.getString("TokenizeDialog.Label.ExistingAnnotations"));
        this.overwriteRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Overwrite"));
        this.preserveRB.setText(ElanLocale.getString("TokenizeDialog.RadioButton.Preserve"));
        this.emptyAnnCheckBox.setText(ElanLocale.getString("TokenizeDialog.Checkbox.EmptyAnnotations"));
        this.startButton.setText(ElanLocale.getString("TokenizeDialog.Button.Start"));
        this.closeButton.setText(ElanLocale.getString("Button.Close"));
    }

    protected void postInit() {
        this.pack();
        int w = 550;
        int h = 400;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
    }

    protected void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.createTierButton) {
            this.editTierDialog();
        } else if (source == this.startButton) {
            this.startOperation();
        } else if (source == this.closeButton) {
            this.closeDialog(null);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getStateChange() == 2) {
            this.extractDestinationTiers();
        }
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }
}

