/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mpi.eudico.util.CVEntry;

public class CVEntryTableCellRenderer
extends DefaultTableCellRenderer {
    private CVEIcon icon = new CVEIcon();

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int col) {
        this.icon.color = null;
        this.icon.s = null;
        if (value instanceof CVEntry) {
            CVEntry entry = (CVEntry)value;
            this.icon.color = entry.getPrefColor();
            int code = entry.getShortcutKeyCode();
            if (code != -1) {
                this.icon.s = KeyEvent.getKeyText(code);
            }
            this.setIcon(this.icon);
            col = table.convertColumnIndexToModel(col);
            super.getTableCellRendererComponent(table, entry.getValue(col), isSelected, cellHasFocus, row, col);
        } else {
            super.getTableCellRendererComponent(table, value, isSelected, cellHasFocus, row, col);
        }
        this.setIcon(this.icon);
        this.setHorizontalTextPosition(4);
        return this;
    }

    private class CVEIcon
    extends ImageIcon {
        int width = 20;
        Color color;
        String s;

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            if (this.color != null) {
                g.setColor(this.color);
                g.fillRect(x, y, this.width, c.getHeight());
            }
            if (this.s != null) {
                g.setColor(c.getForeground());
                g.setFont(c.getFont());
                int sw = c.getFontMetrics(c.getFont()).stringWidth(this.s);
                g.drawString(this.s, x + (this.width - sw) / 2, c.getHeight() - (c.getHeight() - c.getFont().getSize()) / 2 - 1);
            }
        }

        @Override
        public int getIconHeight() {
            return CVEntryTableCellRenderer.this.getHeight() - 4;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }
    }
}

