/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.type.LinguisticTypeTableModel;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class DocumentInfoDialog
extends ClosableDialog {
    private Transcription transcription;
    private Insets insets = new Insets(2, 6, 2, 6);

    public DocumentInfoDialog(Frame owner, Transcription transcription) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        JPanel allPanel = new JPanel();
        allPanel.setLayout(new GridBagLayout());
        JPanel titlePanel = new JPanel();
        JLabel titleLabel = new JLabel(ElanLocale.getString("DocumentInfoDialog.Document.Info"));
        titleLabel.setFont(titleLabel.getFont().deriveFont(16.0f));
        titlePanel.add(titleLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        int y = 0;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridy = y++;
        allPanel.add((Component)titlePanel, gbc);
        gbc.gridy = y++;
        allPanel.add((Component)this.createInformationComponent(), gbc);
        gbc.gridy = y++;
        this.addPanel(allPanel, this.createLicensesComponent(), gbc);
        gbc.gridy = y++;
        this.addPanel(allPanel, this.createTiersComponent(), gbc);
        gbc.gridy = y++;
        this.addPanel(allPanel, this.createTypeComponent(), gbc);
        gbc.gridy = y++;
        this.addPanel(allPanel, this.createControlledVocabulariesComponent(), gbc);
        gbc.gridy = y++;
        this.addPanel(allPanel, this.createLinkedFilesComponent(), gbc);
        this.getContentPane().add(new JScrollPane(allPanel));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(ElanLocale.getString("DocumentInfoDialog.Document.Info"));
        this.setVisible(true);
    }

    private void addPanel(JPanel receiver, JPanel nextPanel, GridBagConstraints gbc) {
        if (nextPanel.getComponent(0) instanceof JLabel) {
            gbc.weighty = 0.0;
            gbc.fill = 2;
        } else {
            gbc.weighty = 1.0;
            gbc.fill = 1;
        }
        receiver.add((Component)nextPanel, gbc);
    }

    private JPanel createInformationComponent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.Information")));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.insets = this.insets;
        panel.add((Component)new JLabel(ElanLocale.getString("DocumentInfoDialog.Author")), gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        String auth = this.transcription.getAuthor();
        if (auth == null || auth.isEmpty()) {
            auth = "-";
        }
        panel.add((Component)new JLabel(auth), gbc);
        return panel;
    }

    private JPanel createLicensesComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.Licensing")));
        if (this.transcription.getLicenses().size() > 0) {
            Object[] cols = new String[]{"#", "URL", ElanLocale.getString("DocumentInfoDialog.Content")};
            Object[][] data = new String[this.transcription.getLicenses().size()][3];
            for (int i = 0; i < this.transcription.getLicenses().size(); ++i) {
                data[i][0] = Integer.toString(i + 1);
                data[i][1] = this.transcription.getLicenses().get(i).getUrl();
                data[i][2] = this.transcription.getLicenses().get(i).getText();
            }
            JTable table = new JTable(data, cols);
            table.setEnabled(false);
            table.getTableHeader().getColumnModel().getColumn(0).sizeWidthToFit();
            JScrollPane sp = new JScrollPane(table);
            int h = table.getRowHeight() * (table.getRowCount() + 2);
            sp.setPreferredSize(new Dimension(400, Math.min(80, h)));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)sp, gbc);
        } else {
            panel.setLayout(new FlowLayout(0));
            panel.add(new JLabel(ElanLocale.getString("DocumentInfoDialog.NoLicenses")));
        }
        return panel;
    }

    private JPanel createTiersComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.Tiers")));
        if (this.transcription.getTiers().size() > 0) {
            List<? extends Tier> tiers = this.transcription.getTiers();
            Object[] cols = new String[]{ElanLocale.getString("DocumentInfoDialog.Name"), "# " + ElanLocale.getString("DocumentInfoDialog.Annotations"), ElanLocale.getString("DocumentInfoDialog.Type")};
            Object[][] data = new String[tiers.size()][3];
            for (int i = 0; i < tiers.size(); ++i) {
                data[i][0] = tiers.get(i).getName();
                data[i][1] = Integer.toString(tiers.get(i).getNumberOfAnnotations());
                data[i][2] = tiers.get(i).getLinguisticType().getLinguisticTypeName();
            }
            JTable table = new JTable(data, cols);
            table.setEnabled(false);
            JScrollPane sp = new JScrollPane(table);
            int h = table.getRowHeight() * (table.getRowCount() + 2);
            sp.setPreferredSize(new Dimension(400, Math.min(100, h)));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = this.insets;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)sp, gbc);
        } else {
            panel.setLayout(new FlowLayout(0));
            panel.add(new JLabel(ElanLocale.getString("DocumentInfoDialog.NoTiers")));
        }
        return panel;
    }

    private JPanel createTypeComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.Type")));
        if (this.transcription.getLinguisticTypes().size() > 0) {
            List<LinguisticType> types = this.transcription.getLinguisticTypes();
            String[] columns = new String[]{"Type", "Stereotype", "CV"};
            LinguisticTypeTableModel model = new LinguisticTypeTableModel(types, columns);
            JTable table = new JTable(model);
            table.setEnabled(false);
            JScrollPane sp = new JScrollPane(table);
            int h = table.getRowHeight() * (table.getRowCount() + 2);
            sp.setPreferredSize(new Dimension(400, Math.min(100, h)));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = this.insets;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)sp, gbc);
        } else {
            panel.setLayout(new FlowLayout(0));
            panel.add(new JLabel(ElanLocale.getString("DocumentInfoDialog.NoTypes")));
        }
        return panel;
    }

    private JPanel createControlledVocabulariesComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.ControlledVocabularies")));
        if (this.transcription.getControlledVocabularies().size() > 0) {
            List<ControlledVocabulary> cvs = this.transcription.getControlledVocabularies();
            Object[] cols = new String[]{ElanLocale.getString("DocumentInfoDialog.Name"), "# " + ElanLocale.getString("DocumentInfoDialog.Languages"), "# " + ElanLocale.getString("DocumentInfoDialog.Entries")};
            Object[][] data = new String[cvs.size()][3];
            for (int i = 0; i < cvs.size(); ++i) {
                data[i][0] = cvs.get(i).getName();
                data[i][1] = Integer.toString(cvs.get(i).getNumberOfLanguages());
                data[i][2] = Integer.toString(cvs.get(i).size());
            }
            JTable table = new JTable(data, cols);
            table.setEnabled(false);
            JScrollPane sp = new JScrollPane(table);
            int h = table.getRowHeight() * (table.getRowCount() + 2);
            sp.setPreferredSize(new Dimension(400, Math.min(100, h)));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = this.insets;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)sp, gbc);
        } else {
            panel.setLayout(new FlowLayout(0));
            panel.add(new JLabel(ElanLocale.getString("DocumentInfoDialog.NoCVs")));
        }
        return panel;
    }

    private JPanel createLinkedFilesComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(new TitledBorder(ElanLocale.getString("DocumentInfoDialog.Linked.Media")));
        if (this.transcription.getMediaDescriptors().size() > 0) {
            List<MediaDescriptor> files = this.transcription.getMediaDescriptors();
            Object[] cols = new String[]{ElanLocale.getString("DocumentInfoDialog.Location"), ElanLocale.getString("DocumentInfoDialog.Relative.Location"), ElanLocale.getString("DocumentInfoDialog.MIME.Type"), ElanLocale.getString("DocumentInfoDialog.Time.Origin")};
            Object[][] data = new String[files.size()][4];
            for (int i = 0; i < files.size(); ++i) {
                data[i][0] = files.get((int)i).mediaURL;
                data[i][1] = files.get((int)i).relativeMediaURL;
                data[i][2] = files.get((int)i).mimeType;
                data[i][3] = Long.toString(files.get((int)i).timeOrigin);
            }
            JTable table = new JTable(data, cols);
            table.setEnabled(false);
            JScrollPane sp = new JScrollPane(table);
            int h = table.getRowHeight() * (table.getRowCount() + 2);
            sp.setPreferredSize(new Dimension(400, Math.min(100, h)));
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = this.insets;
            gbc.anchor = 18;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            panel.add((Component)sp, gbc);
        } else {
            panel.setLayout(new FlowLayout(0));
            panel.add(new JLabel(ElanLocale.getString("DocumentInfoDialog.NoLinkedMedia")));
        }
        return panel;
    }
}

