/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.LicenseRecord;
import nl.mpi.util.FileExtension;

public class DocumentPropertiesDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private final String[] defLicense = new String[]{"Attribution (CC BY)", "Attribution ShareAlike (CC BY-SA)", "Attribution-NoDerivs (CC BY-ND)", "Attribution-NonCommercial (CC BY-NC)", "Attribution-NonCommercial-ShareAlike (CC BY-NC-SA)", "Attribution-NonCommercial-NoDerivs (CC BY-NC-ND)", "GNU General Public License", "GNU Lesser General Public License"};
    private final String[] urlLicense = new String[]{"https://creativecommons.org/licenses/by-sa/4.0/legalcode", "https://creativecommons.org/licenses/by-nd/4.0/legalcode", "https://creativecommons.org/licenses/by-nc/4.0/legalcode", "https://creativecommons.org/licenses/by-nc-sa/4.0/legalcode", "https://creativecommons.org/licenses/by-nc-nd/4.0/legalcode", "https://creativecommons.org/licenses/by/4.0/legalcode", "https://www.gnu.org/licenses/gpl-3.0.en.html", "https://www.gnu.org/licenses/lgpl-3.0.html"};
    private Transcription transcription;
    private boolean handleChanges;
    private JTextField textAuthor;
    private JTextField textURL;
    private JTextArea textLicense;
    private JComboBox<String> comboLicense;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JButton buttonImport;
    private JButton buttonNew;
    private JButton buttonRemove;
    private JButton buttonDefault;
    private String tfAuthor;
    private List<LicenseRecord> copiedRecords;

    public DocumentPropertiesDialog(Frame owner, Transcription transcription) throws HeadlessException {
        super(owner, true);
        this.transcription = transcription;
        this.handleChanges = false;
        this.tfAuthor = transcription.getAuthor();
        this.copiedRecords = new ArrayList<LicenseRecord>(transcription.getLicenses().size());
        for (LicenseRecord lr : transcription.getLicenses()) {
            LicenseRecord cr = new LicenseRecord();
            cr.setUrl(lr.getUrl());
            cr.setText(lr.getText());
            this.copiedRecords.add(cr);
        }
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        pane.add((Component)this.createAuthorPanel(), "North");
        pane.add((Component)this.createLicensePanel(), "Center");
        pane.add((Component)this.createButtonsPanel(), "South");
        this.initElements();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setTitle(ElanLocale.getString("DocumentPropertiesDialog.Document.Properties"));
        this.setVisible(true);
        this.handleChanges = true;
    }

    private JPanel createAuthorPanel() {
        JPanel panelAuthor = new JPanel(new GridBagLayout());
        panelAuthor.setBorder(new TitledBorder(ElanLocale.getString("DocumentPropertiesDialog.Created.By")));
        this.textAuthor = new JTextField("", 20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 4);
        panelAuthor.add((Component)new JLabel(ElanLocale.getString("DocumentPropertiesDialog.Author")), gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panelAuthor.add((Component)this.textAuthor, gbc);
        return panelAuthor;
    }

    private JPanel createLicensePanel() {
        JPanel panelLicense = new JPanel(new BorderLayout());
        JPanel panelNorth = new JPanel(new GridBagLayout());
        JPanel panelSouth = new JPanel();
        panelLicense.setBorder(new TitledBorder(ElanLocale.getString("DocumentPropertiesDialog.License.Information")));
        this.comboLicense = new JComboBox();
        this.comboLicense.addItemListener(this);
        this.textURL = new JTextField("", 30);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 4, 2, 4);
        panelNorth.add(this.comboLicense, gbc);
        gbc.gridx = 1;
        panelNorth.add((Component)new JLabel("URL:"), gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.5;
        gbc.fill = 2;
        panelNorth.add((Component)this.textURL, gbc);
        this.buttonNew = new JButton(ElanLocale.getString("Button.New"));
        this.buttonNew.addActionListener(this);
        this.buttonRemove = new JButton(ElanLocale.getString("Button.Remove"));
        this.buttonRemove.addActionListener(this);
        this.buttonImport = new JButton(ElanLocale.getString("Button.Import"));
        this.buttonImport.addActionListener(this);
        this.buttonDefault = new JButton(ElanLocale.getString("Button.Default"));
        this.buttonDefault.addActionListener(this);
        panelSouth.add(this.buttonNew);
        panelSouth.add(this.buttonRemove);
        panelSouth.add(this.buttonImport);
        panelSouth.add(this.buttonDefault);
        this.textLicense = new JTextArea(15, 35);
        panelLicense.add((Component)panelNorth, "North");
        panelLicense.add((Component)new JScrollPane(this.textLicense), "Center");
        panelLicense.add((Component)panelSouth, "South");
        return panelLicense;
    }

    private JPanel createButtonsPanel() {
        JPanel panelButtons = new JPanel();
        this.buttonOK = new JButton(ElanLocale.getString("Button.OK"));
        this.buttonOK.addActionListener(this);
        this.buttonCancel = new JButton(ElanLocale.getString("Button.Cancel"));
        this.buttonCancel.addActionListener(this);
        panelButtons.add(this.buttonOK);
        panelButtons.add(this.buttonCancel);
        return panelButtons;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.buttonCancel) {
            this.setVisible(false);
        } else if (evt.getSource() == this.buttonOK) {
            this.saveAndExit();
        } else if (evt.getSource() == this.buttonImport) {
            this.importLicense();
        } else if (evt.getSource() == this.buttonDefault) {
            this.defaultLicense();
        } else if (evt.getSource() == this.buttonNew) {
            this.newLicense();
        } else if (evt.getSource() == this.buttonRemove) {
            this.removeLicense();
        }
    }

    private void initElements() {
        this.handleChanges = false;
        this.textAuthor.setText(this.tfAuthor);
        this.comboLicense.removeAllItems();
        if (this.copiedRecords.size() == 0) {
            this.comboLicense.insertItemAt(ElanLocale.getString("DocumentPropertiesDialog.No.License"), 0);
            this.comboLicense.setSelectedIndex(0);
            this.textLicense.setText("");
        } else {
            int size = this.copiedRecords.size();
            for (int i = 0; i < size; ++i) {
                this.comboLicense.insertItemAt(Integer.toString(i + 1), i);
            }
            this.comboLicense.setSelectedIndex(size - 1);
            LicenseRecord lr = this.copiedRecords.get(size - 1);
            this.textURL.setText(lr.getUrl());
            this.textLicense.setText(lr.getText());
        }
        this.handleChanges = true;
    }

    private void saveCurrentLicense() {
        if (this.copiedRecords.size() > 0) {
            int index = this.comboLicense.getSelectedIndex();
            this.copiedRecords.get(index).setUrl(this.textURL.getText());
            this.copiedRecords.get(index).setText(this.textLicense.getText());
        }
    }

    private void saveAndExit() {
        this.tfAuthor = this.textAuthor.getText();
        this.saveCurrentLicense();
        if (this.isChanged()) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "Menu.Edit.DocumentProperties");
            com.execute(this.transcription, new Object[]{this.tfAuthor, this.copiedRecords});
        }
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importLicense() {
        FileChooser fc = new FileChooser(this);
        fc.createAndShowFileDialog("", 0, FileExtension.TEXT_EXT, "LastUsedImportDir");
        File file = fc.getSelectedFile();
        StringBuffer license = new StringBuffer();
        if (file != null && file.canRead()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    license.append(line).append("\r\n");
                }
                this.textLicense.setText(license.toString());
            }
            catch (IOException exception) {
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("DocumentPropertiesDialog.Read.Error"), ElanLocale.getString("DocumentPropertiesDialog.Error"), 0);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }

    private void defaultLicense() {
        String select = (String)JOptionPane.showInputDialog(ELANCommandFactory.getRootFrame(this.transcription), ElanLocale.getString("DocumentPropertiesDialog.Select.Default"), ElanLocale.getString("DocumentPropertiesDialog.Default.Licenses"), -1, null, this.defLicense, this.defLicense[0]);
        for (int i = 0; i < this.urlLicense.length; ++i) {
            if (this.defLicense[i] != select) continue;
            this.textURL.setText(this.urlLicense[i]);
            this.textLicense.setText("License: " + select + " (text available at URL).");
            break;
        }
    }

    private void newLicense() {
        this.handleChanges = false;
        this.saveCurrentLicense();
        int size = this.copiedRecords.size();
        if (size == 0) {
            this.comboLicense.removeAllItems();
        }
        LicenseRecord lr = new LicenseRecord();
        lr.setText("");
        lr.setUrl("");
        this.copiedRecords.add(lr);
        this.comboLicense.insertItemAt(Integer.toString(size + 1), size);
        this.comboLicense.setSelectedIndex(size);
        this.textURL.setText("");
        this.textLicense.setText("");
        this.handleChanges = true;
    }

    private void removeLicense() {
        if (this.copiedRecords.size() > 0) {
            this.handleChanges = false;
            int index = this.comboLicense.getSelectedIndex();
            this.copiedRecords.remove(index);
            this.initElements();
            this.handleChanges = true;
        }
    }

    private boolean isChanged() {
        if (this.tfAuthor != null && !this.tfAuthor.equals(this.transcription.getAuthor())) {
            return true;
        }
        if (this.copiedRecords.size() != this.transcription.getLicenses().size()) {
            return true;
        }
        for (int i = 0; i < this.copiedRecords.size(); ++i) {
            LicenseRecord lr1 = this.copiedRecords.get(i);
            LicenseRecord lr2 = this.transcription.getLicenses().get(i);
            if (lr1.getUrl() == null && lr2.getUrl() != null || lr1.getUrl() != null && !lr1.getUrl().equals(lr2.getUrl())) {
                return true;
            }
            if (lr1.getText().equals(lr2.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        LicenseRecord lr;
        int index;
        if (this.handleChanges && event.getStateChange() == 2 && this.copiedRecords.size() > 0) {
            index = Integer.parseInt(event.getItem().toString()) - 1;
            lr = this.copiedRecords.get(index);
            lr.setUrl(this.textURL.getText());
            lr.setText(this.textLicense.getText());
        }
        if (this.handleChanges && event.getStateChange() == 1 && this.copiedRecords.size() > 0) {
            index = Integer.parseInt(event.getItem().toString()) - 1;
            lr = this.copiedRecords.get(index);
            this.textURL.setText(lr.getUrl());
            this.textLicense.setText(lr.getText());
        }
    }
}

