/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.mediadisplayer.MediaDisplayerFactory;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.annotator.player.VideoScaleAndMove;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.util.MediaDescriptorUtility;

public class DynamicVideoPlayer
implements Runnable {
    private JComponent component;
    private Rectangle bounds;
    private MediaDescriptor md;
    private int delay;
    private MediaDisplayerFactory.MEDIA_ORIENTATION horizontalOrientation;
    private MediaDisplayerFactory.MEDIA_ORIENTATION verticalOrientation;
    private ElanMediaPlayer player;
    private Boolean cleanedUp = false;

    public DynamicVideoPlayer(JComponent component, Rectangle bounds, int delay, File videoFile, MediaDisplayerFactory.MEDIA_ORIENTATION horizontalOrientation, MediaDisplayerFactory.MEDIA_ORIENTATION verticalOrientation) {
        this.component = component;
        this.setBounds(bounds);
        this.setVideoFile(videoFile);
        this.delay = delay;
        this.setOrientation(horizontalOrientation, verticalOrientation);
    }

    public DynamicVideoPlayer(JComponent component, Rectangle bounds, int delay, File videoFile) {
        this(component, bounds, delay, videoFile, MediaDisplayerFactory.MEDIA_ORIENTATION.WEST, MediaDisplayerFactory.MEDIA_ORIENTATION.NORTH);
    }

    public void setVideoFile(File videoFile) {
        this.md = MediaDescriptorUtility.createMediaDescriptor(videoFile.getAbsolutePath());
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void setOrientation(MediaDisplayerFactory.MEDIA_ORIENTATION horizontalOrientation, MediaDisplayerFactory.MEDIA_ORIENTATION verticalOrientation) {
        this.horizontalOrientation = horizontalOrientation;
        this.verticalOrientation = verticalOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setCleanedUp(false);
        try {
            Thread.sleep(this.delay);
            this.player = PlayerFactory.createElanMediaPlayer(this.md);
            float playerAspectRatio = this.player.getAspectRatio();
            float boundsAspectRatio = this.bounds.width / this.bounds.height;
            Rectangle displayBounds = new Rectangle(this.bounds);
            if (playerAspectRatio > 0.0f) {
                if (playerAspectRatio < boundsAspectRatio) {
                    displayBounds.setSize((int)Math.ceil((float)this.bounds.height * playerAspectRatio), this.bounds.height);
                } else if (playerAspectRatio > boundsAspectRatio) {
                    displayBounds.setSize(this.bounds.width, (int)Math.ceil((float)this.bounds.width / playerAspectRatio));
                }
            }
            if (this.horizontalOrientation == MediaDisplayerFactory.MEDIA_ORIENTATION.EAST) {
                displayBounds.x -= displayBounds.width;
            }
            if (this.verticalOrientation == MediaDisplayerFactory.MEDIA_ORIENTATION.SOUTH) {
                displayBounds.y -= displayBounds.height;
            }
            Component videoComponent = this.player.getVisualComponent();
            videoComponent.setBounds(displayBounds);
            if (this.player instanceof VideoScaleAndMove) {
                ((VideoScaleAndMove)((Object)this.player)).setVideoBounds(displayBounds.x, displayBounds.y, displayBounds.width, displayBounds.height);
                ((VideoScaleAndMove)((Object)this.player)).setVideoScaleFactor(0.5f);
                ((VideoScaleAndMove)((Object)this.player)).repaintVideo();
            }
            this.component.add(videoComponent);
            videoComponent.setVisible(true);
            this.component.validate();
            this.component.repaint();
            this.player.setMediaTime(0L);
            this.player.start();
            Thread.sleep(this.player.getMediaDuration() + 10L);
        }
        catch (InterruptedException ee) {
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("Displaying video " + this.md.mediaURL + " interrupted (" + ee.getMessage() + ")");
            }
        }
        catch (NoPlayerException e) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.warning("Not able to create a player for " + this.md.mediaURL + " (" + e.getMessage() + ")");
            }
        }
        finally {
            this.cleanUp();
        }
    }

    public void cleanUp() {
        if (this.component != null && this.player != null) {
            this.component.remove(this.player.getVisualComponent());
            this.player = null;
        }
        this.setCleanedUp(true);
    }

    public Boolean isCleanedUp() {
        return this.cleanedUp;
    }

    public void setCleanedUp(Boolean cleanedUp) {
        this.cleanedUp = cleanedUp;
    }
}

