/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.AbstractEditCVDialog;
import mpi.eudico.client.annotator.gui.CtrlWCloseAction;
import mpi.eudico.client.annotator.gui.ElanEditCVPanel;
import mpi.eudico.client.annotator.gui.EscCloseAction;
import mpi.eudico.client.annotator.gui.ExportExternalCVDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.GetExternalCVURLDialog;
import mpi.eudico.client.util.TranscriptionECVLoader;
import mpi.eudico.server.corpora.clom.ExternalReference;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.delimitedtext.DelimitedTextReader;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Encoder;
import mpi.eudico.server.corpora.clomimpl.dobes.ECV02Parser;
import mpi.eudico.server.corpora.clomimpl.dobes.ECVStore;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;
import mpi.eudico.util.ExternalCVEntry;
import nl.mpi.util.FileExtension;

public class EditCVDialog
extends AbstractEditCVDialog
implements ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(EditCVDialog.class.getName());
    private JButton importButton;
    private JButton exportButton;
    private JButton externalCVButton;
    private TranscriptionImpl transcription;
    private final int SKIP = 0;
    private final int REPLACE = 1;
    private final int RENAME = 2;
    private final int MERGE = 3;
    private boolean cvPrefsImported = false;

    public EditCVDialog(Transcription transcription) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true, true, new ElanEditCVPanel());
        this.transcription = (TranscriptionImpl)transcription;
        this.addCloseActions();
        this.updateLabels();
        this.setPosition();
        this.updateComboBox();
        this.cvNameTextField.requestFocus();
        this.postInit();
    }

    protected void postInit() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.importButton) {
            this.importCV();
        } else if (source == this.externalCVButton) {
            this.connectExternalCV();
        } else if (source == this.exportButton) {
            this.exportECV();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void updateLocale() {
        ((ElanEditCVPanel)this.cvEditorPanel).updateLabels();
        this.updateLabels();
    }

    @Override
    protected List<ControlledVocabulary> getCVList() {
        return this.transcription.getControlledVocabularies();
    }

    @Override
    protected void updateCVButtons() {
        super.updateCVButtons();
        this.exportButton.setEnabled(this.cvComboBox.getItemCount() > 0);
    }

    @Override
    protected void addCV(String name) {
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddCV");
        Object[] args = new Object[]{name, this.cvDescArea.getText()};
        com.execute(this.transcription, args);
        this.updateComboBox();
        this.cvComboBox.setSelectedIndex(this.cvComboBox.getItemCount() - 1);
    }

    @Override
    protected void changeCV(ControlledVocabulary cv, String name, String description) {
        Map curCVPref;
        Map<String, ?> cvPrefs = Preferences.getMap("CV.ML.Prefs", this.transcription);
        if (cvPrefs != null && (curCVPref = (Map)cvPrefs.remove(cv.getName())) != null) {
            cvPrefs.put(name, curCVPref);
            Preferences.set("CV.ML.Prefs", cvPrefs, this.transcription, true, false);
        }
        int languageIndex = this.cvLanguageComboBox.getSelectedIndex();
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ChangeCV");
        Object[] args = new Object[]{this.oldCVName, description != null ? description : this.oldCVDesc, name != null ? name : this.oldCVName, description, languageIndex};
        com.execute(this.transcription, args);
        this.updateComboBox();
        this.cvComboBox.setSelectedItem(cv);
        this.cvLanguageComboBox.setSelectedIndex(languageIndex);
    }

    @Override
    protected void deleteCV() {
        String mes;
        ControlledVocabulary conVoc = (ControlledVocabulary)this.cvComboBox.getSelectedItem();
        if (this.transcription.getTiersWithCV(conVoc.getName()).size() > 0 && !this.showConfirmDialog(mes = ElanLocale.getString("EditCVDialog.Message.CVInUse") + "\n" + ElanLocale.getString("EditCVDialog.Message.CVConfirmDelete"))) {
            return;
        }
        this.deleteCV(conVoc);
    }

    @Override
    protected void deleteCV(ControlledVocabulary cv) {
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.DeleteCV");
        com.execute(this.transcription, new Object[]{cv});
        this.updateComboBox();
        if (this.cvComboBox.getItemCount() == 0) {
            this.cvEditorPanel.setControlledVocabulary(null);
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.importButton = new JButton();
        this.importButton.addActionListener(this);
        this.cvButtonPanel.add(this.importButton);
        this.externalCVButton = new JButton();
        this.externalCVButton.addActionListener(this);
        this.cvButtonPanel.add(this.externalCVButton);
        this.exportButton = new JButton();
        this.exportButton.addActionListener(this);
        this.cvButtonPanel.add(this.exportButton);
    }

    @Override
    protected boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, ElanLocale.getString("Message.Warning"), 0);
        return confirm == 0;
    }

    @Override
    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    protected void updateLabels() {
        this.closeDialogButton.setText(ElanLocale.getString("EditCVDialog.Button.Close"));
        this.deleteCVButton.setText(ElanLocale.getString("Button.Delete"));
        this.changeCVButton.setText(ElanLocale.getString("Button.Change"));
        this.addCVButton.setText(ElanLocale.getString("Button.Add"));
        this.importButton.setText(ElanLocale.getString("Button.Import"));
        this.exportButton.setText(ElanLocale.getString("EditCVDialog.Button.ExportEcv"));
        this.cvDescLabel.setText(ElanLocale.getString("EditCVDialog.Label.CVDescription"));
        this.cvNameLabel.setText(ElanLocale.getString("EditCVDialog.Label.Name"));
        this.cvPanel.setBorder(new TitledBorder(ElanLocale.getString("EditCVDialog.Label.CV")));
        this.currentCVLabel.setText(ElanLocale.getString("EditCVDialog.Label.Current"));
        this.titleLabel.setText(ElanLocale.getString("EditCVDialog.Title"));
        this.setTitle(ElanLocale.getString("EditCVDialog.Title"));
        this.cvNameExistsMessage = ElanLocale.getString("EditCVDialog.Message.CVExists");
        this.cvInvalidNameMessage = ElanLocale.getString("EditCVDialog.Message.CVValidName");
        this.cvContainsEntriesMessage = ElanLocale.getString("EditCVDialog.Message.CVInUse");
        this.deleteQuestion = ElanLocale.getString("EditCVDialog.Message.CVConfirmDelete");
        this.externalCVButton.setText(ElanLocale.getString("Button.ExternalCV"));
    }

    @Override
    protected void closeDialog() {
        if (this.cvEditorPanel instanceof ElanEditCVPanel && (((ElanEditCVPanel)this.cvEditorPanel).isPrefsChanged() || this.cvPrefsImported)) {
            HashMap cvPrefs = (HashMap)Preferences.getMap("CV.ML.Prefs", this.transcription);
            if (cvPrefs == null) {
                cvPrefs = new HashMap();
            }
            String color = "Color";
            String keyCode = "KeyCode";
            for (int i = 0; i < this.transcription.getControlledVocabularies().size(); ++i) {
                HashMap<String, HashMap<String, Color>> curCV = null;
                ControlledVocabulary cv = this.transcription.getControlledVocabularies().get(i);
                curCV = (HashMap<String, HashMap<String, Color>>)cvPrefs.get(cv.getName());
                boolean anyPref = false;
                for (CVEntry cve : cv) {
                    HashMap<String, Color> curEnt = null;
                    if (cve.getPrefColor() != null || cve.getShortcutKeyCode() > -1) {
                        anyPref = true;
                        if (curCV == null) {
                            curCV = new HashMap<String, HashMap<String, Color>>();
                            cvPrefs.put(cv.getName(), curCV);
                        }
                        if ((curEnt = (HashMap<String, Color>)curCV.get(cve.getId())) == null) {
                            curEnt = new HashMap<String, Color>(3);
                            curCV.put(cve.getId(), curEnt);
                        }
                        if (cve.getPrefColor() != null) {
                            curEnt.put(color, cve.getPrefColor());
                        } else {
                            curEnt.remove(color);
                        }
                        if (cve.getShortcutKeyCode() > -1) {
                            curEnt.put(keyCode, (Color)((Object)Integer.valueOf(cve.getShortcutKeyCode())));
                            continue;
                        }
                        curEnt.remove(keyCode);
                        continue;
                    }
                    if (curCV == null) continue;
                    curCV.remove(cve.getId());
                }
                if (anyPref || curCV == null) continue;
                cvPrefs.remove(curCV);
            }
            if (cvPrefs.size() == 0) {
                Preferences.set("CV.ML.Prefs", null, this.transcription, true);
            } else {
                Preferences.set("CV.ML.Prefs", cvPrefs, this.transcription, true, false);
            }
        }
        super.closeDialog();
    }

    private File getImportFile() {
        ArrayList<String[]> extensions = new ArrayList<String[]>();
        extensions.add(FileExtension.EAF_EXT);
        extensions.add(FileExtension.TEMPLATE_EXT);
        extensions.add(FileExtension.CSV_EXT);
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("EditCVDialog.Import.Title"), 0, extensions, FileExtension.EAF_EXT, "LastUsedEAFDir", null);
        File impFile = chooser.getSelectedFile();
        if (impFile != null) {
            return impFile;
        }
        return null;
    }

    private void addCV(ControlledVocabulary conVoc) {
        if (conVoc == null) {
            return;
        }
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddCV");
        Object[] args = new Object[]{conVoc};
        com.execute(this.transcription, args);
    }

    private void importCV() {
        File importFile = this.getImportFile();
        if (importFile == null) {
            return;
        }
        List<ControlledVocabulary> allCVs = null;
        String fileName = importFile.getAbsolutePath();
        if (fileName.toLowerCase().endsWith(".txt") || fileName.toLowerCase().endsWith(".csv")) {
            try {
                DelimitedTextReader reader = new DelimitedTextReader(importFile);
                allCVs = this.parseTextFile(importFile, reader.getDelimiter());
            }
            catch (FileNotFoundException e) {
                this.showWarningDialog(e.getMessage() + ":" + importFile.getAbsolutePath());
                LOG.warning(e.getMessage() + ":" + importFile.getAbsolutePath());
            }
            catch (IOException e) {
                this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + importFile.getAbsolutePath());
                LOG.warning("Error while reading the file: " + e.getMessage());
                return;
            }
        } else {
            EAFSkeletonParser skelParser = null;
            try {
                skelParser = new EAFSkeletonParser(importFile.getAbsolutePath());
                skelParser.parse();
                allCVs = skelParser.getControlledVocabularies();
            }
            catch (ParseException pe) {
                this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + importFile.getAbsolutePath());
                LOG.warning("Could not parse the file: " + pe.getMessage());
                return;
            }
        }
        if (allCVs == null || allCVs.size() == 0) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.NoCVFound"));
            return;
        }
        ArrayList<ExternalCV> extCVForImport = new ArrayList<ExternalCV>();
        ArrayList<ExternalReference> ecvExtRef = new ArrayList<ExternalReference>();
        Map<String, Object> preferences = Preferences.loadPreferencesForFile(importFile.getAbsolutePath());
        Map importPrefs = null;
        boolean oldPrefs = false;
        if (preferences != null) {
            Object cvPrefObj = preferences.get("CV.ML.Prefs");
            if (cvPrefObj instanceof Map) {
                importPrefs = (Map)cvPrefObj;
            } else {
                cvPrefObj = preferences.get("CV.Prefs");
                if (cvPrefObj instanceof Map) {
                    importPrefs = (Map)cvPrefObj;
                    oldPrefs = true;
                }
            }
        }
        ControlledVocabulary cv = null;
        for (int i = 0; i < allCVs.size(); ++i) {
            cv = allCVs.get(i);
            if (!(cv instanceof ExternalCV)) {
                this.importPreferencesFor(importPrefs, cv, oldPrefs);
                if (this.transcription.getControlledVocabulary(cv.getName()) != null) {
                    int option = this.showCVQuestionDialog(cv.getName());
                    if (option == 1) {
                        this.replaceCV(cv);
                        continue;
                    }
                    if (option == 2) {
                        String newName;
                        while (this.transcription.getControlledVocabulary(newName = this.showAskNameDialog(cv.getName())) != null) {
                            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.CVExists"));
                        }
                        if (newName == null || newName.length() == 0) continue;
                        cv.setName(newName);
                        this.addCV(cv);
                        continue;
                    }
                    if (option != 3) continue;
                    this.mergeCVs(cv);
                    continue;
                }
                this.addCV(cv);
                continue;
            }
            extCVForImport.add((ExternalCV)cv);
            if (ecvExtRef.contains(((ExternalCV)cv).getExternalRef())) continue;
            ecvExtRef.add(((ExternalCV)cv).getExternalRef());
        }
        if (!extCVForImport.isEmpty()) {
            for (ExternalCV ecv : extCVForImport) {
                if (this.transcription.getControlledVocabulary(ecv.getName()) != null) continue;
                this.importPreferencesFor(importPrefs, ecv, oldPrefs);
                this.addCV(ecv);
            }
            TranscriptionECVLoader ecvLoader = new TranscriptionECVLoader();
            ecvLoader.loadExternalCVs(this.transcription, null);
        }
        this.updateComboBox();
    }

    private void exportECV() {
        block7: {
            ArrayList<String> cvs = new ArrayList<String>();
            for (int i = 0; i < this.cvComboBox.getItemCount(); ++i) {
                cvs.add(this.cvComboBox.getItemAt(i).toString());
            }
            ExportExternalCVDialog dialog = new ExportExternalCVDialog((Dialog)this, cvs);
            dialog.setVisible(true);
            List<String> cvList = dialog.getCVList();
            String exportFilePath = dialog.getExportFilePath();
            if (cvList.size() > 0 && exportFilePath != null) {
                ArrayList<ExternalCV> ecvList = new ArrayList<ExternalCV>();
                for (int i = 0; i < cvList.size(); ++i) {
                    String cvName = cvList.get(i).toString();
                    ControlledVocabulary cv = this.transcription.getControlledVocabulary(cvName);
                    if (cv == null) continue;
                    ExternalCV ecv = new ExternalCV("dummy name");
                    ecv.cloneStructure(cv);
                    for (CVEntry cvEntry : cv) {
                        ExternalCVEntry ecvEntry = new ExternalCVEntry((BasicControlledVocabulary)ecv, cvEntry);
                        ecv.addEntry(ecvEntry);
                    }
                    ecvList.add(ecv);
                }
                if (ecvList.size() > 0) {
                    try {
                        new ECV02Encoder().encodeAndSave(ecvList, exportFilePath);
                    }
                    catch (IOException e) {
                        if (!LOG.isLoggable(Level.WARNING)) break block7;
                        LOG.warning("Could not save ECVs: " + e.getMessage());
                    }
                }
            }
        }
    }

    private ArrayList<ControlledVocabulary> parseTextFile(File textFile, String delimiter) throws IOException {
        String fileName = textFile.getName();
        int index = fileName.lastIndexOf(46);
        String name = fileName.substring(0, index);
        int lineNumber = 0;
        ControlledVocabulary newCV = new ControlledVocabulary(name);
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(textFile), "UTF-8");
        Scanner scanner = new Scanner(fileReader);
        boolean langId = false;
        while (scanner.hasNextLine()) {
            String aLine = scanner.nextLine();
            Scanner line = new Scanner(aLine);
            String value = null;
            String description = null;
            ++lineNumber;
            line.useDelimiter(delimiter);
            if (line.hasNext()) {
                value = line.next();
                if (lineNumber == 1) {
                    if (value.contains("\ufffd")) {
                        value = value.replace("\ufffd", "");
                    } else if (value.startsWith("\ufeff")) {
                        value = value.replace("\ufeff", "");
                    } else if (value.startsWith("\uefbbbf")) {
                        value = value.replace("\uefbbbf", "");
                    }
                }
                description = line.hasNext() ? line.next() : value;
                CVEntry entry = new CVEntry(newCV);
                entry.setValue(0, value.trim());
                entry.setDescription(0, description.trim());
                newCV.addEntry(entry);
            }
            line.close();
        }
        fileReader.close();
        scanner.close();
        ArrayList<ControlledVocabulary> list = new ArrayList<ControlledVocabulary>();
        list.add(newCV);
        return list;
    }

    private void replaceCV(ControlledVocabulary conVoc) {
        String name = conVoc.getName();
        ControlledVocabulary oldCv = this.transcription.getControlledVocabulary(name);
        if (oldCv != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.ReplaceCV");
            com.execute(this.transcription, new Object[]{oldCv, conVoc});
        }
    }

    private void mergeCVs(ControlledVocabulary conVoc) {
        String name = conVoc.getName();
        ControlledVocabulary oldCv = this.transcription.getControlledVocabulary(name);
        if (oldCv != null) {
            Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.MergeCV");
            com.execute(this.transcription, new Object[]{oldCv, conVoc});
        }
    }

    private String showAskNameDialog(String name) {
        String message = ElanLocale.getString("EditCVDialog.Message.NewName") + "\n\n- " + name;
        String newName = JOptionPane.showInputDialog(this, message, ElanLocale.getString("EditCVDialog.Message.Rename"), 3);
        return newName;
    }

    private int showCVQuestionDialog(String cvName) {
        return this.showCVQuestionDialog(cvName, false);
    }

    private int showCVQuestionDialog(String cvName, Boolean forExternalCV) {
        ArrayList<String> optionsArray = new ArrayList<String>();
        optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Skip"));
        optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Replace"));
        if (!forExternalCV.booleanValue()) {
            optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Rename"));
            optionsArray.add(ElanLocale.getString("EditCVDialog.Message.Merge"));
        }
        Object[] options = new String[optionsArray.size()];
        options = optionsArray.toArray(options);
        String message = ElanLocale.getString("EditCVDialog.Message.CVExists") + "\n\n- " + cvName + "\n";
        JOptionPane pane = new JOptionPane(message, 3, -1, null, options);
        pane.createDialog(this, "").setVisible(true);
        Object selValue = pane.getValue();
        for (int i = 0; i < options.length; ++i) {
            if (selValue != options[i]) continue;
            return i;
        }
        return 0;
    }

    protected void addCloseActions() {
        EscCloseAction escAction = new EscCloseAction(this);
        CtrlWCloseAction wAction = new CtrlWCloseAction(this);
        InputMap inputMap = this.getRootPane().getInputMap(2);
        ActionMap actionMap = this.getRootPane().getActionMap();
        if (inputMap instanceof ComponentInputMap && actionMap != null) {
            String esc = "esc";
            inputMap.put((KeyStroke)escAction.getValue("AcceleratorKey"), esc);
            actionMap.put(esc, escAction);
            String wcl = "cw";
            inputMap.put((KeyStroke)wAction.getValue("AcceleratorKey"), wcl);
            actionMap.put(wcl, wAction);
        }
    }

    private URL getExternalCVURL() {
        String urlString = new String();
        if (this instanceof JDialog) {
            GetExternalCVURLDialog dialog = new GetExternalCVURLDialog(this);
            dialog.setVisible(true);
            urlString = dialog.getExternalCVURLString();
        }
        if (urlString == null) {
            return null;
        }
        try {
            URL remoteURL = new URL(urlString);
            return remoteURL;
        }
        catch (MalformedURLException me) {
            if (urlString.length() == 0) {
                JOptionPane.showMessageDialog(this, "No url was entered. No CV will be loaded.", "Url format error", 0);
            } else {
                JOptionPane.showMessageDialog(this, "Url has an incorrect format. No CV will be loaded.", "Url format error", 0);
            }
            return null;
        }
    }

    private void connectExternalCV() {
        URL externalCVURL = this.getExternalCVURL();
        if (externalCVURL == null) {
            return;
        }
        ECV02Parser ecvParser = null;
        try {
            ECVStore eStore = new ECVStore();
            String version = eStore.ecvFileFormatTest(externalCVURL.toString());
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info(String.format("The .ecv file \"%s\" is a file of version %s", externalCVURL, version));
            }
            ecvParser = new ECV02Parser(externalCVURL.toString());
            ecvParser.parse(null);
        }
        catch (ParseException pe) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.ReadError") + externalCVURL.toString());
            LOG.warning("Could not parse the file: " + pe.getMessage());
            return;
        }
        List<ControlledVocabulary> allCVs = ecvParser.getControlledVocabularies();
        if (allCVs.size() == 0) {
            this.showWarningDialog(ElanLocale.getString("EditCVDialog.Message.NoCVFound"));
            return;
        }
        ArrayList<ExternalCV> extCVs = new ArrayList<ExternalCV>(allCVs.size());
        ExternalReferenceImpl eri = new ExternalReferenceImpl(externalCVURL.toString(), 4);
        ExternalCV cv = null;
        for (int i = 0; i < allCVs.size(); ++i) {
            cv = new ExternalCV(allCVs.get(i));
            if (eri != null) {
                try {
                    cv.setExternalRef(eri.clone());
                }
                catch (CloneNotSupportedException cnse) {
                    LOG.severe("Could not set the external reference: " + cnse.getMessage());
                }
            }
            extCVs.add(cv);
            if (this.transcription.getControlledVocabulary(cv.getName()) != null) {
                int option = this.showCVQuestionDialog(cv.getName(), true);
                if (option != 1) continue;
                this.replaceCV(cv);
                continue;
            }
            this.addCV(cv);
        }
        String saveDir = Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "CVCACHE";
        try {
            new ECV02Encoder().encodeAndSave(extCVs, saveDir, eri);
        }
        catch (IOException ioe) {
            this.showWarningDialog(ElanLocale.getString("LoadExternalCV.Message.WriteError"));
        }
        this.updateComboBox();
    }

    private void importPreferencesFor(Map<String, Object> importPrefs, ControlledVocabulary cv, boolean oldStylePrefs) {
        if (importPrefs != null && cv != null) {
            String color = "Color";
            String keyCode = "KeyCode";
            Map hm = (Map)importPrefs.get(cv.getName());
            if (hm != null) {
                for (CVEntry cve : cv) {
                    Object k;
                    String key = oldStylePrefs ? cve.getValue(0) : cve.getId();
                    Map entMap = (Map)hm.get(key);
                    if (entMap == null) continue;
                    Object c = entMap.get("Color");
                    if (c instanceof Color) {
                        cve.setPrefColor((Color)c);
                    }
                    if (!((k = entMap.get("KeyCode")) instanceof Integer)) continue;
                    cve.setShortcutKeyCode((Integer)k);
                }
                this.cvPrefsImported = true;
            }
        }
    }
}

