/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.gui.ScrollFriendlyTable;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;
import mpi.eudico.util.ExternalCV;

public class EditCVPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    protected static final String EMPTY = "";
    private static final int MOVE_BUTTON_SIZE = 24;
    private static final int MINIMAL_ENTRY_PANEL_WIDTH = 240;
    protected BasicControlledVocabulary cv;
    private boolean ascending = false;
    private boolean descending = true;
    protected CVEntry currentEntry;
    protected JButton addEntryButton;
    protected JButton changeEntryButton;
    protected JButton deleteEntryButton;
    protected JButton moveDownButton;
    protected JButton moveToBottomButton;
    protected JButton moveToTopButton;
    protected JButton moveUpButton;
    protected JButton redoButton;
    protected JButton undoButton;
    protected JButton ascendingButton;
    protected JButton descendingButton;
    protected JLabel entryDescLabel;
    protected JLabel entryValueLabel;
    protected JLabel titleLabel;
    protected JTable entryTable;
    protected JTextField entryDescTextField;
    protected JTextField entryValueTextField;
    protected String invalidValueMessage = "Invalid value";
    protected String valueExistsMessage = "Value exists";
    private CVTableModel entryTableModel;
    protected JPanel dcrPanel;
    protected JLabel dcrLabel;
    protected JTextField dcrField;
    protected JTextField dcIdField;
    protected JButton dcrRemoveButton;
    protected JButton dcrButton;
    boolean enableMoreOptions = false;
    protected JButton moreOptionsButton;
    private UndoManager undoManager = new UndoManager(){

        @Override
        public void undoableEditHappened(UndoableEditEvent e) {
            super.undoableEditHappened(e);
            EditCVPanel.this.updateUndoRedoButtons();
        }
    };
    private CVEntry selectedTableEntry;
    private int selectedTableColumn;

    public EditCVPanel() {
        this((BasicControlledVocabulary)null);
    }

    public EditCVPanel(boolean enableMoreOptions) {
        this((BasicControlledVocabulary)null, enableMoreOptions);
    }

    public EditCVPanel(BasicControlledVocabulary cv) {
        this(cv, false);
    }

    public EditCVPanel(BasicControlledVocabulary cv, boolean enableMoreOptions) {
        this.enableMoreOptions = enableMoreOptions;
        this.makeLayout();
        this.setSelectionListener();
        this.setControlledVocabulary(cv);
    }

    protected void setSelectionListener() {
        this.entryTable.getSelectionModel().addListSelectionListener(this);
        this.entryTable.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    protected void clearSelectionListener() {
        this.entryTable.getSelectionModel().removeListSelectionListener(this);
        this.entryTable.getColumnModel().getSelectionModel().removeListSelectionListener(this);
    }

    public void setControlledVocabulary(BasicControlledVocabulary cv) {
        this.cv = cv;
        this.entryTableModel.setControlledVocabulary(cv);
        this.undoManager.discardAllEdits();
        this.updateLabels();
        this.resetViewer();
        this.entryValueTextField.setEnabled(cv != null);
        this.entryDescTextField.setEnabled(cv != null);
        if (cv instanceof ControlledVocabulary) {
            ((ControlledVocabulary)cv).addUndoableEditListener(this.undoManager);
            this.undoButton.setVisible(true);
            this.redoButton.setVisible(true);
            this.dcrButton.setEnabled(true);
            for (int i = 0; i < this.entryTable.getColumnCount(); ++i) {
                TableColumn c = this.entryTable.getColumnModel().getColumn(i);
                c.setMinWidth(50);
                c.setPreferredWidth(150);
            }
            if (cv instanceof ExternalCV) {
                this.addEntryButton.setEnabled(false);
                this.changeEntryButton.setEnabled(false);
                this.deleteEntryButton.setEnabled(false);
                this.moveDownButton.setEnabled(false);
                this.moveToBottomButton.setEnabled(false);
                this.moveToTopButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
                this.redoButton.setEnabled(false);
                this.undoButton.setEnabled(false);
                this.entryDescTextField.setEnabled(false);
                this.entryValueTextField.setEnabled(false);
                this.dcrButton.setEnabled(false);
                this.moreOptionsButton.setEnabled(true);
                this.ascendingButton.setEnabled(false);
                this.descendingButton.setEnabled(false);
            }
        } else {
            this.undoButton.setVisible(false);
            this.redoButton.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.entryValueTextField) {
            this.entryDescTextField.requestFocus();
        } else if (source == this.addEntryButton || source == this.entryDescTextField) {
            this.addEntry();
        } else if (source == this.changeEntryButton) {
            this.changeEntry();
        } else if (source == this.deleteEntryButton) {
            this.deleteEntries();
        } else if (source == this.moveToTopButton) {
            this.moveEntries(0);
        } else if (source == this.moveUpButton) {
            this.moveEntries(1);
        } else if (source == this.moveDownButton) {
            this.moveEntries(2);
        } else if (source == this.moveToBottomButton) {
            this.moveEntries(3);
        } else if (source == this.undoButton) {
            this.undo();
        } else if (source == this.redoButton) {
            this.redo();
        } else if (source == this.ascendingButton) {
            this.ascending = true;
            this.sortEntries();
        } else if (source == this.descendingButton) {
            this.descending = true;
            this.sortEntries();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        BasicControlledVocabulary cv = new BasicControlledVocabulary("Name", "Description 1");
        cv.addEntry(new CVEntry(cv, 0, "Entry 1", "Entry description 1"));
        cv.addEntry(new CVEntry(cv, 0, "Entry 2", "Entry description 2"));
        cv.addEntry(new CVEntry(cv, 0, "Entry 3", "Entry description 3"));
        EditCVPanel p = new EditCVPanel(cv);
        frame.getContentPane().add(p);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getValueIsAdjusting()) {
            return;
        }
        if (lse.getSource() == this.entryTable.getSelectionModel() || lse.getSource() == this.entryTable.getColumnModel().getSelectionModel()) {
            int row = this.getSelectedEntryIndex();
            if (row >= 0 && row < this.entryTableModel.getRowCount()) {
                this.selectedTableEntry = this.entryTableModel.getEntry(row);
                int col = this.entryTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                this.selectedTableColumn = this.entryTable.convertColumnIndexToModel(col);
            } else {
                this.selectedTableEntry = null;
                this.selectedTableColumn = 0;
            }
            this.updateEntryButtons();
            this.updateTextFields();
            this.updateSortButtons();
        }
    }

    protected int getSelectedEntryIndex() {
        int row = this.entryTable.getSelectionModel().getLeadSelectionIndex();
        return this.entryTable.convertRowIndexToModel(row);
    }

    protected void addEntry() {
        if (this.cv == null) {
            return;
        }
        String entry = this.entryValueTextField.getText();
        if ((entry = entry.trim()).length() == 0) {
            this.showWarningDialog(this.invalidValueMessage);
            return;
        }
        int language = this.getSelectedColumn();
        if (this.cv.containsValue(language, entry)) {
            this.showWarningDialog(this.valueExistsMessage);
        } else {
            String desc = this.entryDescTextField.getText();
            if (desc != null) {
                desc = desc.trim();
            }
            CVEntry newEntry = new CVEntry(this.cv);
            newEntry.setValue(language, entry);
            newEntry.setDescription(language, desc);
            this.cv.addEntry(newEntry);
            this.updateList();
            this.setSelectedEntry(null);
        }
    }

    protected void changeEntry() {
        if (this.cv == null) {
            return;
        }
        String newValue = this.entryValueTextField.getText().trim();
        int language = this.getSelectedColumn();
        if (newValue.isEmpty()) {
            boolean ok = false;
            for (int i = 0; i < this.cv.getNumberOfLanguages(); ++i) {
                if (i == language || this.currentEntry.getValue(i).isEmpty()) continue;
                ok = true;
                break;
            }
            if (!ok) {
                this.showWarningDialog(this.invalidValueMessage);
                this.entryValueTextField.setText(this.currentEntry != null ? this.currentEntry.getValue(language) : EMPTY);
                return;
            }
        }
        String newDescription = this.entryDescTextField.getText().trim();
        if (newValue.equals(this.currentEntry.getValue(language))) {
            if (newDescription != null && !newDescription.equals(this.currentEntry.getDescription(language))) {
                CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
                this.cv.replaceEntry(this.currentEntry, newEntry);
                this.updateList();
                this.setSelectedEntry(newEntry);
            }
            return;
        }
        if (this.cv.containsValue(language, newValue)) {
            this.showWarningDialog(this.valueExistsMessage);
        } else {
            CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
            this.cv.replaceEntry(this.currentEntry, newEntry);
            this.updateList();
            this.setSelectedEntry(newEntry);
        }
    }

    protected void deleteEntries() {
        int[] selEntries = this.entryTable.getSelectedRows();
        if (selEntries.length == 0) {
            return;
        }
        CVEntry[] entries = new CVEntry[selEntries.length];
        for (int i = 0; i < entries.length; ++i) {
            int index = this.entryTable.convertRowIndexToModel(selEntries[i]);
            entries[i] = this.entryTableModel.getEntry(index);
        }
        this.cv.removeEntries(entries);
        this.updateList();
        this.setSelectedEntry(null);
    }

    protected void makeLayout() {
        ImageIcon topIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Top16.gif"));
        ImageIcon bottomIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Bottom16.gif"));
        ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
        ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
        ImageIcon redoIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Redo16.gif"));
        ImageIcon undoIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Undo16.gif"));
        ImageIcon removeRefIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/Remove.gif"));
        this.entryTableModel = new CVTableModel();
        this.entryTable = new ScrollFriendlyTable(this.entryTableModel);
        this.entryTable.setCellSelectionEnabled(true);
        this.entryTable.setAutoResizeMode(0);
        this.entryValueLabel = new JLabel();
        this.entryValueTextField = new JTextField();
        this.addEntryButton = new JButton();
        this.addEntryButton.setEnabled(false);
        this.changeEntryButton = new JButton();
        this.changeEntryButton.setEnabled(false);
        this.deleteEntryButton = new JButton();
        this.deleteEntryButton.setEnabled(false);
        this.titleLabel = new JLabel();
        this.entryDescLabel = new JLabel();
        this.entryDescTextField = new JTextField();
        this.dcrPanel = new JPanel(new GridBagLayout());
        this.dcrLabel = new JLabel();
        this.dcrField = new JTextField();
        this.dcIdField = new JTextField();
        this.dcIdField.setEditable(false);
        this.dcrField.setEditable(false);
        this.dcrRemoveButton = new JButton(removeRefIcon);
        this.dcrButton = new JButton();
        JPanel moveEntriesPanel = new JPanel();
        this.moveUpButton = new JButton(upIcon);
        this.moveUpButton.setEnabled(false);
        this.moveToTopButton = new JButton(topIcon);
        this.moveToTopButton.setEnabled(false);
        this.moveDownButton = new JButton(downIcon);
        this.moveDownButton.setEnabled(false);
        this.moveToBottomButton = new JButton(bottomIcon);
        this.moveToBottomButton.setEnabled(false);
        this.undoButton = new JButton(undoIcon);
        this.undoButton.setEnabled(false);
        this.redoButton = new JButton(redoIcon);
        this.redoButton.setEnabled(false);
        Dimension prefDim = new Dimension(240, 24);
        Dimension buttonDimension = new Dimension(24, 24);
        Insets insets = new Insets(2, 6, 2, 6);
        moveEntriesPanel.setLayout(new GridBagLayout());
        this.moveToTopButton.addActionListener(this);
        this.moveToTopButton.setPreferredSize(buttonDimension);
        this.moveToTopButton.setMaximumSize(buttonDimension);
        this.moveToTopButton.setMinimumSize(buttonDimension);
        this.moveUpButton.addActionListener(this);
        this.moveUpButton.setPreferredSize(buttonDimension);
        this.moveUpButton.setMaximumSize(buttonDimension);
        this.moveUpButton.setMinimumSize(buttonDimension);
        this.moveDownButton.addActionListener(this);
        this.moveDownButton.setPreferredSize(buttonDimension);
        this.moveDownButton.setMaximumSize(buttonDimension);
        this.moveDownButton.setMinimumSize(buttonDimension);
        this.moveToBottomButton.addActionListener(this);
        this.moveToBottomButton.setPreferredSize(buttonDimension);
        this.moveToBottomButton.setMaximumSize(buttonDimension);
        this.moveToBottomButton.setMinimumSize(buttonDimension);
        this.undoButton.addActionListener(this);
        this.undoButton.setPreferredSize(buttonDimension);
        this.undoButton.setMaximumSize(buttonDimension);
        this.undoButton.setMinimumSize(buttonDimension);
        this.redoButton.addActionListener(this);
        this.redoButton.setPreferredSize(buttonDimension);
        this.redoButton.setMaximumSize(buttonDimension);
        this.redoButton.setMinimumSize(buttonDimension);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        moveEntriesPanel.add((Component)this.moveToTopButton, gridBagConstraints);
        moveEntriesPanel.add((Component)this.moveUpButton, gridBagConstraints);
        moveEntriesPanel.add((Component)this.moveDownButton, gridBagConstraints);
        moveEntriesPanel.add((Component)this.moveToBottomButton, gridBagConstraints);
        moveEntriesPanel.add((Component)this.undoButton, gridBagConstraints);
        moveEntriesPanel.add((Component)this.redoButton, gridBagConstraints);
        JPanel sortEntriesPanel = new JPanel();
        sortEntriesPanel.setLayout(new GridBagLayout());
        this.ascendingButton = new JButton("Sort A-Z");
        this.ascendingButton.setEnabled(false);
        this.ascendingButton.addActionListener(this);
        this.descendingButton = new JButton("Sort Z-A");
        this.descendingButton.setEnabled(false);
        this.descendingButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        sortEntriesPanel.add((Component)this.ascendingButton, gridBagConstraints);
        sortEntriesPanel.add((Component)this.descendingButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.dcrPanel.add((Component)this.dcrLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 6);
        this.dcrPanel.add((Component)this.dcrField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.5;
        this.dcrPanel.add((Component)this.dcIdField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.dcrPanel.add((Component)this.dcrRemoveButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.dcrPanel.add((Component)this.dcrButton, gridBagConstraints);
        JScrollPane entryPane = new JScrollPane(this.entryTable);
        this.entryValueTextField.setPreferredSize(prefDim);
        this.entryValueTextField.setMinimumSize(prefDim);
        this.entryDescTextField.setPreferredSize(prefDim);
        this.entryDescTextField.setMinimumSize(prefDim);
        this.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 10.0;
        this.add((Component)entryPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = insets;
        this.add((Component)sortEntriesPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = insets;
        this.add((Component)this.entryValueLabel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        this.add((Component)this.entryValueTextField, gridBagConstraints);
        this.add((Component)this.entryDescLabel, gridBagConstraints);
        this.add((Component)this.entryDescTextField, gridBagConstraints);
        this.add((Component)this.dcrPanel, gridBagConstraints);
        this.add((Component)this.addEntryButton, gridBagConstraints);
        this.add((Component)this.changeEntryButton, gridBagConstraints);
        this.add((Component)this.deleteEntryButton, gridBagConstraints);
        if (this.enableMoreOptions) {
            this.moreOptionsButton = new JButton();
            this.add((Component)this.moreOptionsButton, gridBagConstraints);
        }
        this.add((Component)moveEntriesPanel, gridBagConstraints);
        this.undoButton.setToolTipText(this.undoManager.getUndoPresentationName());
        this.entryValueTextField.addActionListener(this);
        this.entryDescTextField.addActionListener(this);
        this.addEntryButton.addActionListener(this);
        this.changeEntryButton.addActionListener(this);
        this.deleteEntryButton.addActionListener(this);
        this.dcrRemoveButton.addActionListener(this);
        this.dcrRemoveButton.setPreferredSize(buttonDimension);
        this.dcrRemoveButton.setMaximumSize(buttonDimension);
        this.dcrRemoveButton.setMinimumSize(buttonDimension);
        this.dcrButton.addActionListener(this);
        this.dcrPanel.setVisible(false);
        if (this.enableMoreOptions) {
            this.moreOptionsButton.addActionListener(this);
        }
        this.entryDescTextField.setFont(Constants.DEFAULTFONT);
        this.entryValueTextField.setFont(Constants.DEFAULTFONT);
        this.entryTable.setFont(Constants.DEFAULTFONT);
    }

    protected void setTableModel(CVTableModel newModel) {
        this.entryTableModel = newModel;
        this.entryTable.setModel(this.entryTableModel);
    }

    protected void resetViewer() {
        if (this.cv != null) {
            CVEntry[] entries = this.cv.getEntries();
            this.currentEntry = null;
            this.entryTableModel.setEntries(entries);
            this.addEntryButton.setEnabled(true);
        } else {
            this.cv = null;
            this.addEntryButton.setEnabled(false);
        }
        this.updateEntryButtons();
        this.updateTextFields();
        this.updateSortButtons();
    }

    protected void updateLabels() {
        this.moveToTopButton.setToolTipText("Top");
        this.moveUpButton.setToolTipText("Up");
        this.moveDownButton.setToolTipText("Down");
        this.moveToBottomButton.setToolTipText("Bottom");
        this.deleteEntryButton.setText("Delete");
        this.changeEntryButton.setText("Change");
        this.addEntryButton.setText("Add");
        this.entryDescLabel.setText("Description");
        this.entryValueLabel.setText("Value");
        this.dcrLabel.setText("ISO Data Category");
        this.dcrRemoveButton.setToolTipText("Remove Ref");
        this.dcrButton.setText("Browse...");
        this.setBorder(new TitledBorder("Entries"));
        this.undoButton.setToolTipText(this.undoManager.getUndoPresentationName());
        this.redoButton.setToolTipText(this.undoManager.getRedoPresentationName());
        this.ascendingButton.setToolTipText("Ascending order");
        this.descendingButton.setToolTipText("Descending order");
        if (this.enableMoreOptions) {
            this.moreOptionsButton.setText("More Options...");
        }
    }

    protected void updateList() {
        if (this.cv != null) {
            this.clearSelectionListener();
            CVEntry[] entries = this.cv.getEntries();
            this.entryTableModel.setEntries(entries);
            this.setSelectionListener();
        }
    }

    protected void sortEntries() {
        if (this.cv != null) {
            CVEntry[] entries = null;
            int language = this.getSelectedColumn();
            if (this.ascending) {
                entries = this.cv.getEntriesSortedByAlphabet(language);
                this.ascending = false;
            } else if (this.descending) {
                entries = this.cv.getEntriesSortedByReverseAlphabetOrder(language);
                this.descending = false;
            }
            if (entries != null) {
                this.entryTableModel.setEntries(entries);
                this.entryTable.changeSelection(0, this.entryTable.convertColumnIndexToView(language), false, false);
            }
        }
    }

    protected void setSelectedEntries(CVEntry[] entries) {
        this.currentEntry = null;
        if (entries != null && entries.length > 0) {
            this.clearSelectionListener();
            int column = this.entryTable.convertColumnIndexToView(this.getSelectedColumn());
            boolean extend = false;
            for (int i = 0; i < this.entryTableModel.getRowCount(); ++i) {
                for (int j = 0; j < entries.length; ++j) {
                    if (this.entryTableModel.getEntry(i) != entries[j]) continue;
                    this.entryTable.changeSelection(i, column, false, extend);
                    this.selectedTableEntry = entries[j];
                    extend = true;
                }
            }
            this.setSelectionListener();
        } else {
            this.selectedTableEntry = null;
        }
        this.updateEntryButtons();
        this.updateTextFields();
    }

    protected void setSelectedEntry(CVEntry entry) {
        if (entry != null) {
            this.setSelectedEntries(new CVEntry[]{entry});
        } else {
            this.setSelectedEntries(null);
        }
    }

    private void moveEntries(int moveType) {
        if (this.cv == null) {
            return;
        }
        int[] selEntries = this.entryTable.getSelectedRows();
        if (selEntries.length == 0) {
            return;
        }
        CVEntry[] entriesToBeMoved = new CVEntry[selEntries.length];
        for (int i = 0; i < selEntries.length; ++i) {
            int index = this.entryTable.convertRowIndexToModel(selEntries[i]);
            entriesToBeMoved[i] = this.entryTableModel.getEntry(index);
        }
        this.entryTable.changeSelection(0, this.getSelectedColumn(), false, false);
        this.cv.moveEntries(entriesToBeMoved, moveType);
        this.updateList();
        this.setSelectedEntries(entriesToBeMoved);
    }

    private void redo() {
        try {
            this.undoManager.redo();
            this.updateList();
            this.setSelectedEntry(null);
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
        this.updateUndoRedoButtons();
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 2);
    }

    private void undo() {
        try {
            this.undoManager.undo();
            this.updateList();
            this.setSelectedEntry(null);
        }
        catch (CannotUndoException cannotUndoException) {
            // empty catch block
        }
        this.updateUndoRedoButtons();
    }

    private void updateEntryButtons() {
        if (this.entryTable == null || this.entryTable.getSelectedRowCount() == 0) {
            this.changeEntryButton.setEnabled(false);
            this.deleteEntryButton.setEnabled(false);
            this.moveToTopButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveToBottomButton.setEnabled(false);
            this.currentEntry = null;
            if (this.moreOptionsButton != null) {
                this.moreOptionsButton.setEnabled(false);
            }
        } else if (this.cv instanceof ExternalCV) {
            this.changeEntryButton.setEnabled(false);
            this.deleteEntryButton.setEnabled(false);
            this.moveToTopButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
            this.moveToBottomButton.setEnabled(false);
            if (this.moreOptionsButton != null) {
                if (this.entryTable == null || this.entryTable.getSelectedRowCount() == 0) {
                    this.moreOptionsButton.setEnabled(false);
                } else {
                    this.moreOptionsButton.setEnabled(true);
                }
            }
            this.currentEntry = this.getSelectedEntry();
        } else {
            int firstIndex = this.entryTable.getSelectedRows()[0];
            int numSelected = this.entryTable.getSelectedRows().length;
            int lastIndex = this.entryTable.getSelectedRows()[numSelected - 1];
            this.changeEntryButton.setEnabled(numSelected == 1);
            this.deleteEntryButton.setEnabled(true);
            if (this.moreOptionsButton != null) {
                this.moreOptionsButton.setEnabled(true);
            }
            if (firstIndex > 0) {
                this.moveToTopButton.setEnabled(true);
                this.moveUpButton.setEnabled(true);
            } else {
                this.moveToTopButton.setEnabled(false);
                this.moveUpButton.setEnabled(false);
            }
            if (lastIndex < this.entryTableModel.getRowCount() - 1) {
                this.moveDownButton.setEnabled(true);
                this.moveToBottomButton.setEnabled(true);
            } else {
                this.moveDownButton.setEnabled(false);
                this.moveToBottomButton.setEnabled(false);
            }
            this.currentEntry = this.getSelectedEntry();
        }
    }

    private void updateSortButtons() {
        if (this.entryTable != null && this.entryTableModel.getRowCount() > 1 && !(this.cv instanceof ExternalCV)) {
            this.ascendingButton.setEnabled(true);
            this.descendingButton.setEnabled(true);
        }
    }

    protected void updateTextFields() {
        CVEntry selEntry = this.getSelectedEntry();
        if (selEntry == null || this.selectedTableColumn < 0) {
            this.entryValueTextField.setText(EMPTY);
            this.entryDescTextField.setText(EMPTY);
        } else {
            this.entryValueTextField.setText(selEntry.getValue(this.selectedTableColumn));
            this.entryDescTextField.setText(selEntry.getDescription(this.selectedTableColumn));
        }
        if (this.entryValueTextField.isEnabled()) {
            this.entryValueTextField.requestFocus();
        }
    }

    protected CVEntry getSelectedEntry() {
        return this.selectedTableEntry;
    }

    protected int getSelectedColumn() {
        return this.selectedTableColumn;
    }

    private void updateUndoRedoButtons() {
        this.undoButton.setEnabled(this.undoManager.canUndo());
        this.redoButton.setEnabled(this.undoManager.canRedo());
    }

    protected static class CVTableModel
    extends AbstractTableModel {
        protected CVEntry[] entries;
        protected BasicControlledVocabulary cv;

        protected CVTableModel() {
        }

        public void setEntries(CVEntry[] entries) {
            this.entries = entries;
            this.fireTableDataChanged();
        }

        public void setControlledVocabulary(BasicControlledVocabulary cv) {
            this.cv = cv;
            this.fireTableChanged(new TableModelEvent(this, -1));
        }

        public CVEntry getEntry(int i) {
            return this.entries[i];
        }

        @Override
        public String getColumnName(int col) {
            return this.cv.getLanguageId(col);
        }

        @Override
        public int getRowCount() {
            if (this.entries == null) {
                return 0;
            }
            return this.entries.length;
        }

        @Override
        public int getColumnCount() {
            if (this.cv == null) {
                return 0;
            }
            return this.cv.getNumberOfLanguages();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.entries == null) {
                return EditCVPanel.EMPTY;
            }
            return this.entries[row].getValue(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return CVEntry.class;
        }
    }
}

