/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.lexicon.LexiconConfigIO;
import mpi.eudico.client.annotator.lexicon.LexiconServiceStep1;
import mpi.eudico.client.annotator.lexicon.LexiconServiceStep2;
import mpi.eudico.client.annotator.lexicon.LexiconSrvCacheDialog;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;

public class EditLexSrvcDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private static final int DEFAULT_MINIMUM_HEIGHT = 260;
    private static final int DEFAULT_MINIMUM_WIDTH = 700;
    private TranscriptionImpl transcription;
    private JPanel titlePanel;
    private JLabel titleLabel;
    private JPanel serviceInfoPanel;
    private JLabel serviceNameLabel;
    private JComboBox serviceNameBox;
    private JLabel serviceInfoLabel;
    private JTextArea serviceInfoText;
    private JPanel serviceButtonPanel;
    private JButton addServiceButton;
    private JButton editServiceButton;
    private JButton deleteServiceButton;
    private JButton importServiceButton;
    private JPanel closeButtonPanel;
    private JButton closeButton;
    private List<LexiconQueryBundle2> cacheBundles;

    public EditLexSrvcDialog(Transcription tr) {
        super((Frame)ELANCommandFactory.getRootFrame(tr), true);
        this.transcription = (TranscriptionImpl)tr;
        if (!this.transcription.isLexiconServicesLoaded()) {
            try {
                new LexiconClientFactoryLoader().loadLexiconClientFactories(this.transcription);
            }
            catch (Exception exc) {
                ClientLogger.LOG.warning("Error while loading lexicon service clients: " + exc.getMessage());
            }
        }
        this.initComponents();
        this.postInit();
    }

    private void warnIfNoExtensions() {
        if (this.transcription.getLexiconServiceClientFactories() == null || this.transcription.getLexiconServiceClientFactories().isEmpty()) {
            this.addServiceButton.setEnabled(false);
            JOptionPane.showMessageDialog(this, ElanLocale.getString("LexiconServiceClient.NoClient"), "Warning", 2);
        }
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditLexSrvcDialog.this.closeDialog();
            }

            @Override
            public void windowOpened(WindowEvent w) {
                EditLexSrvcDialog.this.warnIfNoExtensions();
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(16.0f));
        this.titlePanel.add(this.titleLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.titlePanel, gridBagConstraints);
        this.serviceInfoPanel = new JPanel();
        this.serviceInfoPanel.setLayout(new GridBagLayout());
        this.serviceNameLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.serviceInfoPanel.add((Component)this.serviceNameLabel, gridBagConstraints);
        this.serviceNameBox = new JComboBox();
        this.serviceNameBox.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = insets;
        this.serviceInfoPanel.add((Component)this.serviceNameBox, gridBagConstraints);
        this.serviceInfoLabel = new JLabel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        this.serviceInfoPanel.add((Component)this.serviceInfoLabel, gridBagConstraints);
        this.serviceInfoText = new JTextArea();
        this.serviceInfoText.setLineWrap(false);
        this.serviceInfoText.setWrapStyleWord(true);
        this.serviceInfoText.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.serviceInfoPanel.add((Component)new JScrollPane(this.serviceInfoText), gridBagConstraints);
        this.serviceButtonPanel = new JPanel();
        this.serviceButtonPanel.setLayout(new GridLayout(0, 1, 6, 6));
        this.addServiceButton = new JButton();
        this.addServiceButton.addActionListener(this);
        this.serviceButtonPanel.add(this.addServiceButton);
        this.importServiceButton = new JButton();
        this.importServiceButton.setEnabled(false);
        this.importServiceButton.addActionListener(this);
        this.serviceButtonPanel.add(this.importServiceButton);
        this.editServiceButton = new JButton();
        this.editServiceButton.setEnabled(false);
        this.editServiceButton.addActionListener(this);
        this.deleteServiceButton = new JButton();
        this.deleteServiceButton.setEnabled(false);
        this.deleteServiceButton.addActionListener(this);
        this.serviceButtonPanel.add(this.deleteServiceButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = insets;
        this.serviceInfoPanel.add((Component)this.serviceButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.serviceInfoPanel, gridBagConstraints);
        this.closeButtonPanel = new JPanel();
        this.closeButtonPanel.setLayout(new GridLayout(1, 1, 0, 2));
        this.closeButton = new JButton();
        this.closeButton.addActionListener(this);
        this.closeButtonPanel.add(this.closeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.closeButtonPanel, gridBagConstraints);
    }

    private void postInit() {
        this.addCloseActions();
        this.updateLocale();
        this.setPosition();
        this.updateServiceNameBox();
        this.updateUIforSelectedService();
        this.checkConfigCache();
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("EditLexSrvcDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("EditLexSrvcDialog.Title"));
        this.serviceNameLabel.setText(ElanLocale.getString("EditLexSrvcDialog.Label.Servicename"));
        this.serviceInfoLabel.setText(ElanLocale.getString("EditLexSrvcDialog.Label.Serviceinfo"));
        this.addServiceButton.setText(ElanLocale.getString("EditLexSrvcDialog.Button.Add"));
        this.importServiceButton.setText(ElanLocale.getString("Button.Import"));
        this.editServiceButton.setText(ElanLocale.getString("EditLexSrvcDialog.Button.Edit"));
        this.deleteServiceButton.setText(ElanLocale.getString("EditLexSrvcDialog.Button.Delete"));
        this.closeButton.setText(ElanLocale.getString("EditLexSrvcDialog.Button.Close"));
    }

    private void updateServiceNameBox() {
        this.serviceNameBox.removeItemListener(this);
        ArrayList<LexiconLink> services = this.getServices();
        this.serviceNameBox.removeAllItems();
        for (int i = 0; i < services.size(); ++i) {
            this.serviceNameBox.addItem(services.get(i));
        }
        if (services.size() > 0) {
            this.serviceNameBox.setSelectedIndex(0);
        }
        this.serviceNameBox.addItemListener(this);
    }

    private void updateUIforSelectedService() {
        if (this.serviceNameBox.getSelectedIndex() > -1) {
            LexiconLink link = (LexiconLink)this.serviceNameBox.getSelectedItem();
            String typeStr = ElanLocale.getString("EditLexSrvcDialog.Label.Type");
            String urlStr = ElanLocale.getString("EditLexSrvcDialog.Label.Url");
            String lexiconStr = ElanLocale.getString("EditLexSrvcDialog.Label.Lexicon");
            this.serviceInfoText.setText(typeStr + ": " + link.getLexSrvcClntType() + "\n" + urlStr + ": " + link.getUrl() + "\n" + lexiconStr + ": " + link.getLexId().getName());
            if (link.getSrvcClient() != null) {
                this.editServiceButton.setEnabled(true);
            } else {
                this.editServiceButton.setEnabled(false);
            }
            this.deleteServiceButton.setEnabled(true);
        } else {
            this.deleteServiceButton.setEnabled(false);
        }
    }

    private void checkConfigCache() {
        LexiconConfigIO lexIO = new LexiconConfigIO();
        try {
            this.cacheBundles = lexIO.readLexConfigs();
            if (this.cacheBundles != null && this.cacheBundles.size() > 0) {
                this.importServiceButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addToLocalCache(LexiconLink link) {
        if (link == null) {
            return;
        }
        LexiconConfigIO lexIO = new LexiconConfigIO();
        try {
            this.cacheBundles = lexIO.readLexConfigs();
            if (this.cacheBundles != null && this.cacheBundles.size() > 0) {
                LexiconQueryBundle2 bundle = null;
                for (int i = 0; i < this.cacheBundles.size(); ++i) {
                    bundle = this.cacheBundles.get(i);
                    if (!link.getName().equals(bundle.getLinkName())) continue;
                    this.cacheBundles.remove(i);
                    this.cacheBundles.add(i, new LexiconQueryBundle2(link, null));
                    lexIO.writeLexConfigs(this.cacheBundles);
                    return;
                }
                this.cacheBundles.add(new LexiconQueryBundle2(link, null));
            } else {
                this.cacheBundles = new ArrayList<LexiconQueryBundle2>(1);
                this.cacheBundles.add(new LexiconQueryBundle2(link, null));
            }
            lexIO.writeLexConfigs(this.cacheBundles);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Error while loading lexicon services from cache: " + ex.getMessage());
        }
    }

    private void importServices() {
        LexiconSrvCacheDialog lexDialog = new LexiconSrvCacheDialog((Dialog)this, true, this.cacheBundles);
        lexDialog.setVisible(true);
        List<LexiconQueryBundle2> selBundles = lexDialog.getSelectedBundles();
        if (selBundles == null || selBundles.size() == 0) {
            return;
        }
        Set names = ((HashMap)this.transcription.getLexiconLinks()).keySet();
        LexiconClientFactoryLoader loader = new LexiconClientFactoryLoader();
        for (LexiconQueryBundle2 bundle : selBundles) {
            LexiconLink lLink = bundle.getLink();
            boolean alreadyThere = false;
            for (String name : names) {
                if (!name.equals(lLink.getName())) continue;
                alreadyThere = true;
                break;
            }
            if (alreadyThere) continue;
            loader.loadLexiconClientFactory(this.transcription, lLink);
            Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddLexLink");
            Object[] args = new Object[]{lLink};
            com.execute(this.transcription, args);
        }
        this.updateServiceNameBox();
        this.updateUIforSelectedService();
    }

    private ArrayList<LexiconLink> getServices() {
        return new ArrayList<LexiconLink>(((HashMap)this.transcription.getLexiconLinks()).values());
    }

    protected void setPosition() {
        this.pack();
        this.setSize(Math.max(this.getSize().width, 700), Math.max(this.getSize().height, 260));
        this.setLocationRelativeTo(this.getParent());
    }

    protected void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addServiceButton) {
            this.showLexiconServiceWizard(null);
        } else if (ae.getSource() == this.editServiceButton) {
            this.showLexiconServiceWizard((LexiconLink)this.serviceNameBox.getSelectedItem());
        } else if (ae.getSource() == this.deleteServiceButton) {
            this.deleteService();
        } else if (ae.getSource() == this.importServiceButton) {
            this.importServices();
        } else if (ae.getSource() == this.closeButton) {
            this.closeDialog();
        }
    }

    private void deleteService() {
        LexiconLink link = (LexiconLink)this.serviceNameBox.getSelectedItem();
        if (link != null && !this.showConfirmDialog(ElanLocale.getString("EditLexSrvcDialog.Message.Confirmdelete"))) {
            return;
        }
        this.deleteService(link);
    }

    private void deleteService(LexiconLink link) {
        Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.DeleteLexLink");
        Object[] args = new Object[]{link};
        com.execute(this.transcription, args);
        this.updateServiceNameBox();
        this.updateUIforSelectedService();
    }

    private void showLexiconServiceWizard(LexiconLink oldLink) {
        LexiconLink link = oldLink;
        MultiStepPane pane = new MultiStepPane(ElanLocale.getResourceBundle());
        LexiconServiceStep1 step1 = new LexiconServiceStep1(pane, oldLink, this.transcription);
        LexiconServiceStep2 step2 = new LexiconServiceStep2(pane);
        pane.addStep(step1);
        pane.addStep(step2);
        JDialog dialog = pane.createDialog(this, ElanLocale.getString("EditLexSrvcDialog.Title"), true);
        dialog.pack();
        int w = 500;
        int h = 450;
        dialog.setSize(dialog.getSize().width > w ? w : dialog.getSize().width, dialog.getSize().height < h ? h : dialog.getSize().height);
        this.setLocationRelativeTo(this);
        dialog.setVisible(true);
        link = (LexiconLink)pane.getStepProperty("newLink");
        if (link != null) {
            if (oldLink == null) {
                Command com = ELANCommandFactory.createCommand(this.transcription, "CommandActions.AddLexLink");
                Object[] args = new Object[]{link};
                com.execute(this.transcription, args);
                this.addToLocalCache(link);
            }
            this.updateServiceNameBox();
            this.updateUIforSelectedService();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.updateUIforSelectedService();
    }

    protected boolean showConfirmDialog(String message) {
        int confirm = JOptionPane.showConfirmDialog(this, message, "Warning", 0);
        return confirm == 0;
    }
}

