/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import mpi.dcr.DCSmall;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.dcr.ELANDCRDialog;
import mpi.eudico.client.annotator.dcr.ELANLocalDCRConnector;
import mpi.eudico.client.annotator.gui.CVEntryOptionsDialog;
import mpi.eudico.client.annotator.gui.CVEntryTableCellRenderer;
import mpi.eudico.client.annotator.gui.EditCVPanel;
import mpi.eudico.client.im.ImUtil;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.util.BasicControlledVocabulary;
import mpi.eudico.util.CVEntry;

public class ElanEditCVPanel
extends EditCVPanel {
    private JPopupMenu popup;
    private Locale[] availableLocales;
    private Locale currentLocale;
    private boolean prefsChanged = false;

    public ElanEditCVPanel() {
        super(true);
        this.entryValueTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) || event.isPopupTrigger()) {
                    ElanEditCVPanel.this.createPopupMenu();
                    if (ElanEditCVPanel.this.popup != null) {
                        ElanEditCVPanel.this.popup.show(ElanEditCVPanel.this.entryValueTextField, event.getX(), event.getY());
                    }
                }
            }
        });
    }

    private void createPopupMenu() {
        if (this.popup == null) {
            try {
                this.availableLocales = ImUtil.getLanguages();
                this.popup = new JPopupMenu();
                for (int i = 0; i < this.availableLocales.length; ++i) {
                    JMenuItem item;
                    if (i == 0 && this.availableLocales[i] == Locale.getDefault()) {
                        item = new JMenuItem(this.availableLocales[i].getDisplayName() + " (System default)");
                        item.setActionCommand(this.availableLocales[i].getDisplayName());
                    } else {
                        item = new JMenuItem(this.availableLocales[i].getDisplayName());
                    }
                    item.addActionListener(this);
                    this.popup.add(item);
                }
            }
            catch (NoSuchMethodError nsme) {
                String msg = ElanLocale.getString("InlineEditBox.Message.SPI") + "\n" + ElanLocale.getString("InlineEditBox.Message.SPI2");
                JOptionPane.showMessageDialog(this, msg, null, 0);
                this.popup = null;
            }
            catch (Exception exc) {
                this.popup = null;
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.setTableModel(new EditCVPanel.CVTableModel(){

            @Override
            public Object getValueAt(int row, int col) {
                if (this.entries == null) {
                    return "";
                }
                return this.entries[row];
            }
        });
        this.entryTable.setDefaultRenderer(CVEntry.class, new CVEntryTableCellRenderer());
        this.dcrPanel.setVisible(true);
    }

    @Override
    public void setControlledVocabulary(BasicControlledVocabulary cv) {
        super.setControlledVocabulary(cv);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source instanceof JMenuItem) {
            String locale = actionEvent.getActionCommand();
            for (int i = 0; i < this.availableLocales.length; ++i) {
                if (!this.availableLocales[i].getDisplayName().equals(locale)) continue;
                this.currentLocale = this.availableLocales[i];
                ImUtil.setLanguage(this.entryValueTextField, this.currentLocale);
                this.entryValueTextField.setFont(Constants.DEFAULTFONT);
                return;
            }
        } else {
            if (source == this.dcrButton) {
                DCSmall valueObj;
                List<DCSmall> vals;
                Window ancestor = SwingUtilities.getWindowAncestor(this);
                Window dialog = null;
                if (ancestor instanceof JDialog) {
                    dialog = new ELANDCRDialog((Dialog)((JDialog)ancestor), true, 1);
                } else if (ancestor instanceof JFrame) {
                    dialog = new ELANDCRDialog((Frame)((JFrame)ancestor), true, 1);
                }
                if (dialog == null) {
                    return;
                }
                dialog.pack();
                ((Dialog)dialog).setVisible(true);
                List<DCSmall> selValue = ((ELANDCRDialog)dialog).getValue();
                if (selValue instanceof List && (vals = selValue).size() > 0 && (valueObj = vals.get(0)) instanceof DCSmall) {
                    DCSmall dcs = valueObj;
                    this.dcrField.setText(dcs.getIdentifier());
                    this.dcIdField.setText(dcs.getId());
                    this.dcrRemoveButton.setEnabled(true);
                }
                return;
            }
            if (source == this.dcrRemoveButton) {
                this.dcIdField.setText("");
                this.dcrField.setText("");
                this.dcrRemoveButton.setEnabled(false);
            } else if (source == this.moreOptionsButton) {
                Window ancestor;
                if (this.currentEntry != null && (ancestor = SwingUtilities.getWindowAncestor(this)) instanceof JDialog) {
                    CVEntryOptionsDialog dialog = new CVEntryOptionsDialog((Dialog)((JDialog)ancestor), true, this.currentEntry, this.getSelectedColumn());
                    dialog.setVisible(true);
                    CVEntry copy = dialog.getCVEntry();
                    if (copy != null) {
                        this.applyPrefChanges(copy);
                    }
                }
                return;
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    protected void updateLabels() {
        this.moveToTopButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Top"));
        this.moveUpButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Up"));
        this.moveDownButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Down"));
        this.moveToBottomButton.setToolTipText(ElanLocale.getString("EditCVDialog.Button.Bottom"));
        this.deleteEntryButton.setText(ElanLocale.getString("Button.Delete"));
        this.changeEntryButton.setText(ElanLocale.getString("Button.Change"));
        this.addEntryButton.setText(ElanLocale.getString("Button.Add"));
        this.entryDescLabel.setText(ElanLocale.getString("EditCVDialog.Label.EntryDescription"));
        this.entryValueLabel.setText(ElanLocale.getString("EditCVDialog.Label.Value"));
        this.setBorder(new TitledBorder(ElanLocale.getString("EditCVDialog.Label.Entries")));
        this.dcrLabel.setText(ElanLocale.getString("DCR.Label.ISOCategory"));
        this.dcrRemoveButton.setToolTipText(ElanLocale.getString("DCR.Label.RemoveReference"));
        this.dcrButton.setText(ElanLocale.getString("Button.Browse"));
        this.invalidValueMessage = ElanLocale.getString("EditCVDialog.Message.EntryValidValue");
        this.valueExistsMessage = ElanLocale.getString("EditCVDialog.Message.EntryExists");
        this.undoButton.setToolTipText(ElanLocale.getString("Menu.Edit.Undo"));
        this.redoButton.setToolTipText(ElanLocale.getString("Menu.Edit.Redo"));
        if (this.moreOptionsButton != null) {
            this.moreOptionsButton.setText(ElanLocale.getString("EditCVDialog.Label.MoreOptions"));
        }
    }

    public boolean isPrefsChanged() {
        return this.prefsChanged;
    }

    @Override
    protected void addEntry() {
        if (this.cv == null) {
            return;
        }
        String entry = this.entryValueTextField.getText();
        if ((entry = entry.trim()).length() == 0) {
            this.showWarningDialog(this.invalidValueMessage);
            return;
        }
        int language = this.getSelectedColumn();
        if (this.cv.containsValue(language, entry)) {
            this.showWarningDialog(this.valueExistsMessage);
        } else {
            String desc = this.entryDescTextField.getText();
            if (desc != null) {
                desc = desc.trim();
            }
            CVEntry newEntry = new CVEntry(this.cv, language, entry, desc);
            if (this.dcrField.getText() != null && this.dcIdField.getText().length() > 0) {
                ExternalReferenceImpl eri = new ExternalReferenceImpl(this.dcIdField.getText(), 2);
                newEntry.setExternalRef(eri);
            }
            this.cv.addEntry(newEntry);
            this.updateList();
            this.setSelectedEntry(null);
        }
    }

    @Override
    protected void changeEntry() {
        if (this.cv == null) {
            return;
        }
        String newValue = this.entryValueTextField.getText().trim();
        int language = this.getSelectedColumn();
        if (newValue.isEmpty()) {
            boolean ok = false;
            for (int i = 0; i < this.cv.getNumberOfLanguages(); ++i) {
                if (i == language || this.currentEntry.getValue(i).isEmpty()) continue;
                ok = true;
                break;
            }
            if (!ok) {
                this.showWarningDialog(this.invalidValueMessage);
                this.entryValueTextField.setText(this.currentEntry != null ? this.currentEntry.getValue(language) : "");
                return;
            }
        }
        String newDescription = this.entryDescTextField.getText().trim();
        if (newValue.equals(this.currentEntry.getValue(language))) {
            if (newDescription != null && !newDescription.equals(this.currentEntry.getDescription(language))) {
                CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
                String dcId = this.dcIdField.getText();
                if (dcId != null && dcId.length() != 0) {
                    newEntry.setExternalRef(new ExternalReferenceImpl(dcId, 2));
                }
                this.cv.replaceEntry(this.currentEntry, newEntry);
                this.updateList();
                this.setSelectedEntry(newEntry);
            } else {
                String dcId = this.dcIdField.getText();
                if (dcId != null && dcId.length() > 0) {
                    if (this.currentEntry.getExternalRef() instanceof ExternalReferenceImpl) {
                        if (!dcId.equals(((ExternalReferenceImpl)this.currentEntry.getExternalRef()).getValue())) {
                            CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
                            newEntry.setExternalRef(new ExternalReferenceImpl(dcId, 2));
                            this.cv.replaceEntry(this.currentEntry, newEntry);
                            this.updateList();
                            this.setSelectedEntry(newEntry);
                        }
                    } else {
                        CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
                        newEntry.setExternalRef(new ExternalReferenceImpl(dcId, 2));
                        this.cv.replaceEntry(this.currentEntry, newEntry);
                        this.updateList();
                        this.setSelectedEntry(newEntry);
                    }
                }
            }
            return;
        }
        if (!newValue.isEmpty() && this.cv.containsValue(language, newValue)) {
            this.showWarningDialog(this.valueExistsMessage);
        } else {
            CVEntry newEntry = new CVEntry(this.currentEntry, language, newValue, newDescription);
            String dcId = this.dcIdField.getText();
            if (dcId != null && dcId.length() > 0) {
                newEntry.setExternalRef(new ExternalReferenceImpl(dcId, 2));
            }
            this.cv.replaceEntry(this.currentEntry, newEntry);
            this.updateList();
            this.setSelectedEntry(newEntry);
        }
    }

    @Override
    protected void updateTextFields() {
        super.updateTextFields();
        CVEntry selEntry = this.getSelectedEntry();
        if (selEntry == null) {
            this.dcIdField.setText("");
            this.dcrField.setText("");
            this.dcrRemoveButton.setEnabled(false);
        } else if (selEntry.getExternalRef() instanceof ExternalReferenceImpl) {
            ExternalReferenceImpl eri = (ExternalReferenceImpl)selEntry.getExternalRef();
            String dcId = eri.getValue();
            this.dcIdField.setText(dcId);
            DCSmall sm = ELANLocalDCRConnector.getInstance().getDCSmall(dcId);
            if (sm != null) {
                this.dcrField.setText(sm.getIdentifier());
            }
            this.dcrRemoveButton.setEnabled(true);
        } else {
            this.dcIdField.setText("");
            this.dcrField.setText("");
            this.dcrRemoveButton.setEnabled(false);
        }
    }

    private void applyPrefChanges(CVEntry copyEntry) {
        this.currentEntry.setPrefColor(copyEntry.getPrefColor());
        if (copyEntry.getShortcutKeyCode() != -1) {
            boolean doChange = true;
            for (CVEntry cve : this.cv) {
                if (cve == this.currentEntry || cve.getShortcutKeyCode() != copyEntry.getShortcutKeyCode() || cve == this.currentEntry) continue;
                int option = JOptionPane.showOptionDialog(this, ElanLocale.getString("EditCVDialog.Message.ShortcutUsed") + " " + cve.getValue(0), "ELAN", 0, 3, null, new String[]{ElanLocale.getString("EditCVDialog.Message.ShortcutChange"), ElanLocale.getString("EditCVDialog.Message.ShortcutDontChange")}, ElanLocale.getString("EditCVDialog.Message.ShortcutChange"));
                if (option == 0) {
                    cve.setShortcutKeyCode(-1);
                    break;
                }
                doChange = false;
                break;
            }
            if (doChange) {
                this.currentEntry.setShortcutKeyCode(copyEntry.getShortcutKeyCode());
            }
        } else {
            this.currentEntry.setShortcutKeyCode(copyEntry.getShortcutKeyCode());
        }
        this.prefsChanged = true;
        this.updateList();
    }
}

