/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTable;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.HhMmSsMssMaskFormatter;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class NewAnnotationFromTimeIntervalDialog
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private ViewerManager2 vm;
    private long beginTime = -1L;
    private long endTime = -1L;
    private String annotationValue;
    private List<String> returnedTiers = new ArrayList<String>();
    private JLabel limitsLabel;
    private JButton okButton;
    private JButton cancelButton;
    private JFormattedTextField btTextField;
    private JFormattedTextField etTextField;
    private JTextField annoTextField;
    private TierExportTable tierTable;
    private TierExportTableModel model;
    private long minBeginTime = 0L;
    private long maxEndTime = Long.MAX_VALUE;
    private Boolean actionApplied = false;

    public NewAnnotationFromTimeIntervalDialog(ViewerManager2 viewerManager, Frame owner, boolean modal) throws HeadlessException {
        super(owner, modal);
        this.vm = viewerManager;
        this.transcription = (TranscriptionImpl)viewerManager.getTranscription();
        this.initComponentsForNewAnnotation();
        this.extractTiers();
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public String getAnnotationValue() {
        return this.annotationValue;
    }

    public List<String> getTiers() {
        return this.returnedTiers;
    }

    public Boolean isActionApplied() {
        return this.actionApplied;
    }

    public void setInterval(long begin, long end) {
        this.beginTime = begin;
        this.endTime = end;
        this.btTextField.setValue(TimeFormatter.toString(this.beginTime));
        this.etTextField.setValue(TimeFormatter.toString(this.endTime));
    }

    public void setBeginTime(long begin) {
        this.beginTime = begin;
        this.btTextField.setValue(TimeFormatter.toString(this.beginTime));
    }

    public void setEndTime(long end) {
        this.endTime = end;
        this.etTextField.setValue(TimeFormatter.toString(this.endTime));
    }

    public void setLimits(long minBT, long maxET) {
        this.minBeginTime = minBT;
        this.maxEndTime = maxET;
        this.limitsLabel.setText(String.format(ElanLocale.getString("ModifyTimesDialog.EnterTimes.Range"), TimeFormatter.toString(this.minBeginTime), TimeFormatter.toString(this.maxEndTime)));
        this.pack();
    }

    private void initComponentsForNewAnnotation() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.limitsLabel = new JLabel("", 0);
        JLabel btLabel = new JLabel(ElanLocale.getString("Frame.GridFrame.ColumnBeginTime"), 11);
        JLabel etLabel = new JLabel(ElanLocale.getString("Frame.GridFrame.ColumnEndTime"), 11);
        JLabel annotationLabel = new JLabel(ElanLocale.getString("Frame.GridFrame.ColumnAnnotationValue"), 11);
        JPanel timeFramePanel = new JPanel(new GridBagLayout());
        timeFramePanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.GridFrame.EnterTime.Text")));
        HhMmSsMssMaskFormatter timeFormatter = new HhMmSsMssMaskFormatter();
        this.btTextField = new JFormattedTextField(timeFormatter);
        this.etTextField = new JFormattedTextField(timeFormatter);
        this.annoTextField = new JTextField();
        this.model = new TierExportTableModel();
        this.tierTable = new TierExportTable((DefaultTableModel)this.model, 2);
        JPanel tierPanel = new JPanel();
        tierPanel.setLayout(new GridBagLayout());
        tierPanel.setBorder(new TitledBorder(ElanLocale.getString("Frame.GridFrame.ColumnSelectTiers")));
        JScrollPane tierScroll = new JScrollPane(this.tierTable);
        tierScroll.setPreferredSize(new Dimension(100, 100));
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        Insets insets = new Insets(2, 6, 2, 6);
        Container contentPane = this.getContentPane();
        ((JComponent)contentPane).setBorder(new EmptyBorder(6, 8, 2, 8));
        GridBagConstraints lgbc = new GridBagConstraints();
        lgbc.anchor = 17;
        lgbc.insets = insets;
        GridBagConstraints rgbc = new GridBagConstraints();
        rgbc.gridx = 1;
        rgbc.anchor = 17;
        rgbc.insets = insets;
        rgbc.weightx = 1.0;
        rgbc.gridy = 0;
        rgbc.fill = 13;
        timeFramePanel.add((Component)this.limitsLabel, rgbc);
        rgbc.fill = 2;
        lgbc.gridy = 1;
        timeFramePanel.add((Component)btLabel, lgbc);
        rgbc.gridy = 1;
        timeFramePanel.add((Component)this.btTextField, rgbc);
        lgbc.gridy = 2;
        timeFramePanel.add((Component)etLabel, lgbc);
        rgbc.gridy = 2;
        timeFramePanel.add((Component)this.etTextField, rgbc);
        lgbc.gridy = 3;
        timeFramePanel.add((Component)annotationLabel, lgbc);
        rgbc.gridy = 3;
        timeFramePanel.add((Component)this.annoTextField, rgbc);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        contentPane.add((Component)timeFramePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        tierPanel.add((Component)tierScroll, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        contentPane.add((Component)tierPanel, gbc);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.insets = insets;
        contentPane.add((Component)buttonPanel, gbc);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    private void extractTiers() {
        String activeTierName = null;
        if (this.vm.getMultiTierControlPanel() != null && this.vm.getMultiTierControlPanel().getActiveTier() != null) {
            TierImpl activeTier = (TierImpl)this.vm.getMultiTierControlPanel().getActiveTier();
            activeTierName = activeTier.getName();
        }
        if (this.transcription != null) {
            List<TierImpl> tiers = this.transcription.getTiers();
            this.model.extractTierNames(tiers, activeTierName);
        }
    }

    private List<String> getSelectedTiers() {
        return this.model.getSelectedTiers();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.actionApplied = false;
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.okButton) {
            this.annotationValue = this.annoTextField.getText();
            this.beginTime = TimeFormatter.toMilliSeconds((String)this.btTextField.getValue());
            this.endTime = TimeFormatter.toMilliSeconds((String)this.etTextField.getValue());
            this.returnedTiers = this.getSelectedTiers();
            if (this.beginTime >= this.endTime) {
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    ClientLogger.LOG.info(String.format("The entered begin time (%d) is >= the end time (%d).", this.beginTime, this.endTime));
                }
                JOptionPane.showMessageDialog(this, ElanLocale.getString("Message.InvalidBeginEndTime"), ElanLocale.getString("Message.Warning"), 2);
                this.actionApplied = false;
            } else {
                this.setVisible(false);
                this.dispose();
                this.actionApplied = true;
            }
        }
    }
}

