/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.ColorDialog;
import mpi.eudico.client.annotator.util.WindowLocationAndSizeManager;
import nl.mpi.media.spectrogram.SpectrogramSettings;
import nl.mpi.media.spectrogram.WindowFunction;

public class SpectrogramSettingsDialog
extends ClosableDialog
implements ActionListener,
ItemListener {
    private SpectrogramSettings curSettings;
    private JTabbedPane tabPane;
    private JPanel transformPanel;
    private JPanel displayPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton defaultsButton;
    private JFormattedTextField minFreqField;
    private JFormattedTextField maxFreqField;
    private JCheckBox adaptiveCB;
    private JRadioButton grayRB;
    private JRadioButton revGrayRB;
    private JRadioButton colorRB;
    private JPanel fgColorPanel;
    private JPanel bgColorPanel;
    private JPanel fgColorPreview;
    private JPanel bgColorPreview;
    private JButton fgColorButton;
    private JButton bgColorButton;
    private JLabel brightnessLabel;
    private JLabel fgBrightLabel;
    private JLabel bgBrightLabel;
    private JSpinner fgBrightSpinner;
    private JSpinner bgBrightSpinner;
    private JComboBox<String> functionsCombo;
    private JFormattedTextField windowDurationTF;
    private JFormattedTextField strideDurationTF;

    public SpectrogramSettingsDialog(Frame owner, SpectrogramSettings curSettings) throws HeadlessException {
        super(owner, true);
        this.curSettings = curSettings;
        this.initComponents();
        this.applySettingsToGui(curSettings);
        WindowLocationAndSizeManager.postInit(this, "SpectrogramSettingsDialog");
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("SpectrogramSettingsDialog.Title"));
        this.tabPane = new JTabbedPane(1);
        this.createDisplayPanel();
        this.tabPane.addTab(ElanLocale.getString("SpectrogramSettingsDialog.Tab.Display"), this.displayPanel);
        this.createTransformPanel();
        this.tabPane.addTab(ElanLocale.getString("SpectrogramSettingsDialog.Tab.Transform"), this.transformPanel);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 11;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)this.tabPane, gbc);
        JPanel buttonPanel = this.createButtonPanel();
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttonPanel, gbc);
        Integer tabIndex = Preferences.getInt("SpectrogramSettingsDialog.ActiveTab", null);
        if (tabIndex != null && tabIndex < this.tabPane.getTabCount()) {
            this.tabPane.setSelectedIndex(tabIndex);
        }
        this.pack();
        this.setSize(Math.max(this.getSize().width, 400), Math.max(this.getSize().height, 400));
    }

    private void createDisplayPanel() {
        this.displayPanel = new JPanel(new GridBagLayout());
        JLabel minFrLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.MinDisplayFrequency"));
        JLabel maxFrLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.MaxDisplayFrequency"));
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(1);
        nf.setMinimumFractionDigits(1);
        this.minFreqField = new JFormattedTextField(nf);
        this.minFreqField.setHorizontalAlignment(4);
        this.maxFreqField = new JFormattedTextField(nf);
        this.maxFreqField.setHorizontalAlignment(4);
        this.adaptiveCB = new JCheckBox(ElanLocale.getString("SpectrogramSettingsDialog.AdaptiveContrast"));
        this.adaptiveCB.addItemListener(this);
        JLabel colorLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.ColorScheme"));
        this.grayRB = new JRadioButton(ElanLocale.getString("SpectrogramSettingsDialog.Color.Gray"), true);
        this.revGrayRB = new JRadioButton(ElanLocale.getString("SpectrogramSettingsDialog.Color.ReversedGray"));
        this.colorRB = new JRadioButton(ElanLocale.getString("SpectrogramSettingsDialog.Color.Gradient"));
        this.fgColorPanel = this.createColorPanel(true);
        this.bgColorPanel = this.createColorPanel(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.grayRB);
        buttonGroup.add(this.revGrayRB);
        buttonGroup.add(this.colorRB);
        this.grayRB.addItemListener(this);
        this.revGrayRB.addItemListener(this);
        this.colorRB.addItemListener(this);
        this.brightnessLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.Brightness.Label"));
        this.fgBrightLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.Brightness.FG"));
        this.bgBrightLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.Brightness.BG"));
        this.fgBrightSpinner = new JSpinner(new SpinnerNumberModel(0, -30, 30, 5));
        this.bgBrightSpinner = new JSpinner(new SpinnerNumberModel(0, -30, 30, 5));
        Insets insets = new Insets(2, 6, 2, 6);
        Insets topInsets = new Insets(15, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 0.5;
        gbc.weighty = 0.0;
        this.displayPanel.add((Component)minFrLabel, gbc);
        gbc.gridx = 1;
        this.displayPanel.add((Component)this.minFreqField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.displayPanel.add((Component)maxFrLabel, gbc);
        gbc.gridx = 1;
        this.displayPanel.add((Component)this.maxFreqField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = topInsets;
        this.displayPanel.add((Component)colorLabel, gbc);
        Insets tabInsets = new Insets(2, 15, 2, 6);
        ++gbc.gridy;
        gbc.insets = tabInsets;
        this.displayPanel.add((Component)this.grayRB, gbc);
        ++gbc.gridy;
        this.displayPanel.add((Component)this.revGrayRB, gbc);
        ++gbc.gridy;
        this.displayPanel.add((Component)this.colorRB, gbc);
        Insets tab2Insets = new Insets(2, 30, 2, 6);
        ++gbc.gridy;
        gbc.insets = tab2Insets;
        this.displayPanel.add((Component)this.fgColorPanel, gbc);
        ++gbc.gridy;
        this.displayPanel.add((Component)this.bgColorPanel, gbc);
        ++gbc.gridy;
        gbc.insets = topInsets;
        this.displayPanel.add((Component)this.brightnessLabel, gbc);
        ++gbc.gridy;
        gbc.insets = tabInsets;
        this.displayPanel.add((Component)this.adaptiveCB, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.displayPanel.add((Component)this.fgBrightLabel, gbc);
        gbc.gridx = 1;
        this.displayPanel.add((Component)this.fgBrightSpinner, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.displayPanel.add((Component)this.bgBrightLabel, gbc);
        gbc.gridx = 1;
        this.displayPanel.add((Component)this.bgBrightSpinner, gbc);
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(10, 10));
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.displayPanel.add((Component)filler, gbc);
    }

    private void createTransformPanel() {
        this.transformPanel = new JPanel(new GridBagLayout());
        JLabel analysisLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.SpectralAnalysis"));
        JLabel winFunctionLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.WindowFunction"));
        JLabel winDurLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.WindowDuration"));
        JLabel strideDurLabel = new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.StrideDuration"));
        this.functionsCombo = new JComboBox();
        this.functionsCombo.addItem(WindowFunction.WF_NAME.HANN.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.GAUSSIAN.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.GAUSSIAN_TUKEY.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.HAMMING.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.BARTLETT.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.WELCH.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.BLACKMAN_HARRIS.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.TUKEY.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.KAISER_BESSEL.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.TRIANGULAR.getDisplayName());
        this.functionsCombo.addItem(WindowFunction.WF_NAME.RECTANGULAR.getDisplayName());
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(4);
        nf.setMinimumFractionDigits(3);
        this.windowDurationTF = new JFormattedTextField();
        this.strideDurationTF = new JFormattedTextField();
        this.windowDurationTF.setHorizontalAlignment(4);
        this.strideDurationTF.setHorizontalAlignment(4);
        Insets insets = new Insets(2, 6, 2, 6);
        Insets topInsets = new Insets(15, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        this.transformPanel.add((Component)analysisLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = topInsets;
        gbc.gridwidth = 1;
        gbc.weightx = 0.5;
        this.transformPanel.add((Component)winFunctionLabel, gbc);
        gbc.gridx = 1;
        this.transformPanel.add(this.functionsCombo, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        this.transformPanel.add((Component)winDurLabel, gbc);
        gbc.gridx = 1;
        this.transformPanel.add((Component)this.windowDurationTF, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = insets;
        this.transformPanel.add((Component)strideDurLabel, gbc);
        gbc.gridx = 1;
        this.transformPanel.add((Component)this.strideDurationTF, gbc);
        JPanel filler = new JPanel();
        filler.setPreferredSize(new Dimension(10, 10));
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.transformPanel.add((Component)filler, gbc);
    }

    private JPanel createColorPanel(boolean foreground) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 6, 0, 6);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        if (foreground) {
            panel.add((Component)new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.Color.Gradient.FG")), gbc);
        } else {
            panel.add((Component)new JLabel(ElanLocale.getString("SpectrogramSettingsDialog.Color.Gradient.BG")), gbc);
        }
        gbc.gridx = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        JPanel colPanel = new JPanel();
        colPanel.setPreferredSize(new Dimension(20, 20));
        colPanel.setBackground(Color.WHITE);
        colPanel.setBorder(new LineBorder(Color.DARK_GRAY, 1));
        panel.add((Component)colPanel, gbc);
        JButton browseButton = new JButton(ElanLocale.getString("Button.Select"));
        browseButton.addActionListener(this);
        gbc.gridx = 2;
        panel.add((Component)browseButton, gbc);
        if (foreground) {
            this.fgColorPreview = colPanel;
            this.fgColorButton = browseButton;
        } else {
            this.bgColorPreview = colPanel;
            this.bgColorButton = browseButton;
        }
        return panel;
    }

    private void enablePanel(JPanel panel, boolean enable) {
        for (Component cp : panel.getComponents()) {
            cp.setEnabled(enable);
        }
    }

    private void updatePanels() {
        this.enablePanel(this.fgColorPanel, this.colorRB.isSelected());
        this.enablePanel(this.bgColorPanel, this.colorRB.isSelected());
    }

    private JPanel createButtonPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 3, 6, 2));
        this.applyButton = new JButton(ElanLocale.getString("Button.Apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.defaultsButton = new JButton(ElanLocale.getString("SpectrogramSettingsDialog.ResetDefaults"));
        this.defaultsButton.addActionListener(this);
        panel.add(this.applyButton);
        panel.add(this.cancelButton);
        panel.add(this.defaultsButton);
        return panel;
    }

    private void applySettingsToGui(SpectrogramSettings settings) {
        this.minFreqField.setValue(settings.getMinDisplayFrequency());
        this.maxFreqField.setValue(settings.getMaxDisplayFrequency());
        this.adaptiveCB.setSelected(settings.isAdaptiveContrast());
        if (settings.getColorScheme() == SpectrogramSettings.COLOR_SCHEME.GRAY) {
            this.grayRB.setSelected(true);
        } else if (settings.getColorScheme() == SpectrogramSettings.COLOR_SCHEME.REVERSED_GRAY) {
            this.revGrayRB.setSelected(true);
        } else if (settings.getColorScheme() == SpectrogramSettings.COLOR_SCHEME.BI_COLOR) {
            this.colorRB.setSelected(true);
            this.fgColorPreview.setBackground(settings.getColor1());
            this.bgColorPreview.setBackground(settings.getColor2());
        }
        this.fgBrightSpinner.setValue(settings.getUpperValueAdjustment());
        this.bgBrightSpinner.setValue(settings.getLowerValueAdjustment());
        this.functionsCombo.setSelectedItem(settings.getWindowFunction());
        this.windowDurationTF.setValue(settings.getWindowDurationSec());
        this.strideDurationTF.setValue(settings.getStrideDurationSec());
        this.updatePanels();
    }

    private void closeDialog() {
        Preferences.set("SpectrogramSettingsDialog.ActiveTab", this.tabPane.getSelectedIndex(), null);
        WindowLocationAndSizeManager.storeLocationAndSizePreferences(this, "SpectrogramSettingsDialog");
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ColorDialog colDiag;
        Color nextColor;
        if (e.getSource() == this.applyButton) {
            Object minFreqVal = null;
            Object maxFreqVal = null;
            Object winDurVal = null;
            Object strideDurVal = null;
            try {
                this.minFreqField.commitEdit();
                minFreqVal = this.minFreqField.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                this.maxFreqField.commitEdit();
                maxFreqVal = this.maxFreqField.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                this.windowDurationTF.commitEdit();
                winDurVal = this.windowDurationTF.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            try {
                this.strideDurationTF.commitEdit();
                strideDurVal = this.strideDurationTF.getValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            this.curSettings.setMinMaxDisplayFrequency(((Number)minFreqVal).doubleValue(), ((Number)maxFreqVal).doubleValue());
            this.curSettings.setWindowAndStride(((Number)winDurVal).doubleValue(), ((Number)strideDurVal).doubleValue());
            this.curSettings.setAdaptiveContrast(this.adaptiveCB.isSelected());
            if (this.grayRB.isSelected()) {
                this.curSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.GRAY);
            } else if (this.revGrayRB.isSelected()) {
                this.curSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.REVERSED_GRAY);
            } else if (this.colorRB.isSelected()) {
                this.curSettings.setColorScheme(SpectrogramSettings.COLOR_SCHEME.BI_COLOR);
                this.curSettings.setColor1(this.fgColorPreview.getBackground());
                this.curSettings.setColor2(this.bgColorPreview.getBackground());
            }
            this.curSettings.setLowerValueAdjustment(((Number)this.bgBrightSpinner.getValue()).doubleValue());
            this.curSettings.setUpperValueAdjustment(((Number)this.fgBrightSpinner.getValue()).doubleValue());
            this.curSettings.setWindowFunction((String)this.functionsCombo.getSelectedItem());
            this.closeDialog();
        } else if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.defaultsButton) {
            this.applySettingsToGui(new SpectrogramSettings());
        } else if (e.getSource() == this.fgColorButton) {
            ColorDialog colDiag2 = new ColorDialog(this, this.fgColorPreview.getBackground());
            Color nextColor2 = colDiag2.chooseColor();
            if (nextColor2 != null) {
                this.fgColorPreview.setBackground(nextColor2);
            }
        } else if (e.getSource() == this.bgColorButton && (nextColor = (colDiag = new ColorDialog(this, this.bgColorPreview.getBackground())).chooseColor()) != null) {
            this.bgColorPreview.setBackground(nextColor);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.adaptiveCB) {
            this.fgBrightLabel.setEnabled(!this.adaptiveCB.isSelected());
            this.bgBrightLabel.setEnabled(!this.adaptiveCB.isSelected());
            this.fgBrightSpinner.setEnabled(!this.adaptiveCB.isSelected());
            this.bgBrightSpinner.setEnabled(!this.adaptiveCB.isSelected());
        } else {
            this.updatePanels();
        }
    }
}

