/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.gui.AbstractTierSortAndSelectPanel;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TranscriptionTierSortAndSelectPanel
extends AbstractTierSortAndSelectPanel
implements ActionListener,
ChangeListener,
ItemListener,
TableModelListener {
    protected List<String> allTypeNames;
    protected List<String> allPartNames;
    protected List<String> allAnnNames;
    protected List<String> allLangNames;
    private TranscriptionImpl transcription;

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription) {
        this(transcription, null, null, true, true);
    }

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this(transcription, null, null, true, true, tierMode);
    }

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription, List<String> tierOrder, List<String> selectedTiers) {
        this(transcription, tierOrder, selectedTiers, true, true);
    }

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering) {
        this(transcription, tierOrder, selectedTiers, allowReordering, true);
    }

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting) {
        this(transcription, tierOrder, selectedTiers, allowReordering, allowSorting, AbstractTierSortAndSelectPanel.Modes.ALL_TIERS);
    }

    public TranscriptionTierSortAndSelectPanel(TranscriptionImpl transcription, List<String> tierOrder, List<String> selectedTiers, boolean allowReordering, boolean allowSorting, AbstractTierSortAndSelectPanel.Modes tierMode) {
        this.transcription = transcription;
        this.allTierNames = tierOrder;
        if (selectedTiers != null) {
            this.selectedTierNames = selectedTiers;
            this.initialSelectedTiersProvided = true;
        } else {
            this.selectedTierNames = new ArrayList();
            this.initialSelectedTiersProvided = false;
        }
        this.allowReordering = allowReordering;
        this.allowSorting = allowSorting;
        this.mode = tierMode;
        this.tabIndices = new HashMap(4);
        this.tabIndices.put(0, "Tier");
        this.tabIndices.put(1, "Type");
        this.tabIndices.put(2, "Participant");
        this.tabIndices.put(3, "Annotators");
        this.tabIndices.put(4, "ContentLanguage");
        this.initComponents();
    }

    @Override
    protected void initTables() {
        TierImpl tier;
        int i;
        Object tiers;
        this.allTypeNames = new ArrayList<String>();
        this.allPartNames = new ArrayList<String>();
        this.allAnnNames = new ArrayList<String>();
        this.allLangNames = new ArrayList<String>();
        if (this.allTierNames == null) {
            this.allTierNames = new ArrayList();
            tiers = this.transcription.getTiers();
            block10: for (i = 0; i < tiers.size(); ++i) {
                tier = tiers.get(i);
                switch (this.mode) {
                    case ALIGNABLE_TIERS: {
                        if (!tier.isTimeAlignable()) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    case ROOT_TIERS: {
                        if (tier.getParentTier() != null) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    case ROOT_W_INCLUDED: {
                        if (tier.getParentTier() != null && (tier.getLinguisticType().getConstraints() == null || tier.getLinguisticType().getConstraints().getStereoType() != 1)) continue block10;
                        this.allTierNames.add(tier.getName());
                        continue block10;
                    }
                    default: {
                        this.allTierNames.add(tier.getName());
                    }
                }
            }
        } else {
            tiers = this.transcription.getTiers();
            block11: for (i = 0; i < tiers.size(); ++i) {
                tier = tiers.get(i);
                switch (this.mode) {
                    case ALIGNABLE_TIERS: {
                        this.addOrRemoveTierName(tier.isTimeAlignable(), tier.getName());
                        continue block11;
                    }
                    case ROOT_TIERS: {
                        this.addOrRemoveTierName(tier.getParentTier() == null, tier.getName());
                        continue block11;
                    }
                    case ROOT_W_INCLUDED: {
                        this.addOrRemoveTierName(tier.getParentTier() == null || tier.getLinguisticType().getConstraints() != null && tier.getLinguisticType().getConstraints().getStereoType() == 1, tier.getName());
                        continue block11;
                    }
                    default: {
                        this.addOrRemoveTierName(true, tier.getName());
                    }
                }
            }
        }
        if (this.allTierNames != null) {
            for (String name : this.allTierNames) {
                if (this.initialSelectedTiersProvided) {
                    this.model.addRow(this.selectedTierNames.contains(name), name);
                } else {
                    this.model.addRow(Boolean.TRUE, name);
                    this.selectedTierNames.add(name);
                }
                tier = this.transcription.getTierWithId(name);
                this.addIfNotYetIncluded(tier.getParticipant(), this.allPartNames, this.partModel);
                this.addIfNotYetIncluded(tier.getAnnotator(), this.allAnnNames, this.annotModel);
                this.addIfNotYetIncluded(tier.getLinguisticType().getLinguisticTypeName(), this.allTypeNames, this.typeModel);
                this.addIfNotYetIncluded(tier.getLangRef(), this.allLangNames, this.langModel);
            }
            if (this.model.getRowCount() == 1) {
                this.model.setValueAt(Boolean.TRUE, 0, 0);
                String name = (String)this.model.getValueAt(0, this.model.findColumn("tier"));
                if (!this.selectedTierNames.contains(name)) {
                    this.selectedTierNames.add(name);
                }
            }
        }
    }

    private void addOrRemoveTierName(boolean include, String name) {
        if (include) {
            if (!this.allTierNames.contains(name)) {
                this.allTierNames.add(name);
            }
        } else {
            this.allTierNames.remove(name);
        }
    }

    private void addIfNotYetIncluded(String name, List<String> allNames, TierExportTableModel model) {
        if (name == null || name.isEmpty()) {
            name = "not specified";
        }
        if (!allNames.contains(name)) {
            allNames.add(name);
            model.addRow(Boolean.FALSE, name);
        }
    }

    @Override
    protected void toggleRootsOnly(boolean rootsOnly) {
        if (rootsOnly) {
            int i;
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            this.unfilteredTiers = new LinkedHashMap(this.model.getRowCount());
            for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
                this.unfilteredTiers.put((String)this.model.getValueAt(i2, nameCol), (Boolean)this.model.getValueAt(i2, includeCol));
            }
            this.model.removeTableModelListener(this);
            for (i = this.model.getRowCount() - 1; i >= 0; --i) {
                String name = (String)this.model.getValueAt(i, nameCol);
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null || !t.hasParentTier()) continue;
                this.model.removeRow(i);
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            this.unfilteredTypes = new LinkedHashMap(this.typeModel.getRowCount());
            includeCol = this.typeModel.findColumn("select");
            nameCol = this.typeModel.findColumn("tier");
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                this.unfilteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            List<LinguisticType> allTypes = this.transcription.getLinguisticTypes();
            block3: for (int i3 = this.typeModel.getRowCount() - 1; i3 >= 0; --i3) {
                String name = (String)this.typeModel.getValueAt(i3, nameCol);
                for (int j = 0; j < allTypes.size(); ++j) {
                    LinguisticType type = allTypes.get(j);
                    if (!type.getLinguisticTypeName().equals(name)) continue;
                    if (type.getConstraints() == null) continue block3;
                    this.typeModel.removeRow(i3);
                    continue block3;
                }
            }
        } else {
            String name;
            int i;
            String key2;
            if (this.unfilteredTiers == null) {
                return;
            }
            this.model.removeTableModelListener(this);
            int includeCol = this.model.findColumn("select");
            int nameCol = this.model.findColumn("tier");
            LinkedHashMap<String, Boolean> filteredTiers = new LinkedHashMap<String, Boolean>(this.model.getRowCount());
            for (int i4 = 0; i4 < this.model.getRowCount(); ++i4) {
                filteredTiers.put((String)this.model.getValueAt(i4, nameCol), (Boolean)this.model.getValueAt(i4, includeCol));
            }
            int insertAfter = -1;
            block6: for (String key2 : this.unfilteredTiers.keySet()) {
                boolean shouldInsert;
                boolean bl = shouldInsert = !filteredTiers.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.model.insertRow(0, new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.model.getRowCount() - 1) {
                        this.model.addRow(new Object[]{this.unfilteredTiers.get(key2), key2});
                        insertAfter = this.model.getRowCount() - 1;
                        continue;
                    }
                    this.model.insertRow(insertAfter + 1, new Object[]{this.unfilteredTiers.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (i = 0; i < this.model.getRowCount(); ++i) {
                    name = (String)this.model.getValueAt(i, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i;
                    continue block6;
                }
            }
            this.model.addTableModelListener(this);
            this.pendingChanges = true;
            LinkedHashMap<String, Boolean> filteredTypes = new LinkedHashMap<String, Boolean>(this.typeModel.getRowCount());
            for (i = 0; i < this.typeModel.getRowCount(); ++i) {
                filteredTypes.put((String)this.typeModel.getValueAt(i, nameCol), (Boolean)this.typeModel.getValueAt(i, includeCol));
            }
            insertAfter = -1;
            Iterator keyIter = this.unfilteredTypes.keySet().iterator();
            key2 = null;
            name = null;
            block9: while (keyIter.hasNext()) {
                boolean shouldInsert;
                key2 = (String)keyIter.next();
                boolean bl = shouldInsert = !filteredTypes.containsKey(key2);
                if (shouldInsert) {
                    if (insertAfter == -1) {
                        this.typeModel.insertRow(0, new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = 0;
                        continue;
                    }
                    if (insertAfter >= this.typeModel.getRowCount() - 1) {
                        this.typeModel.addRow(new Object[]{this.unfilteredTypes.get(key2), key2});
                        insertAfter = this.typeModel.getRowCount() - 1;
                        continue;
                    }
                    this.typeModel.insertRow(insertAfter + 1, new Object[]{this.unfilteredTypes.get(key2), key2});
                    ++insertAfter;
                    continue;
                }
                for (int i5 = 0; i5 < this.typeModel.getRowCount(); ++i5) {
                    name = (String)this.typeModel.getValueAt(i5, nameCol);
                    if (!name.equals(key2)) continue;
                    insertAfter = i5;
                    continue block9;
                }
            }
        }
    }

    @Override
    protected void showTiersTab() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        this.model.removeTableModelListener(this);
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (this.selectedTierNames.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        this.model.addTableModelListener(this);
    }

    @Override
    protected void updateLinguisticTypes() {
        this.updateTierField(this.typeModel, new TierImpl.LinguisticTypeNameGetter());
    }

    @Override
    protected void updateParticipants() {
        this.updateTierField(this.partModel, new TierImpl.ParticipantGetter());
    }

    @Override
    protected void updateAnnotators() {
        this.updateTierField(this.annotModel, new TierImpl.AnnotatorGetter());
    }

    @Override
    protected void updateLanguages() {
        this.updateTierField(this.langModel, new TierImpl.LanguageGetter());
    }

    protected void updateTierField(DefaultTableModel model, TierImpl.ValueGetter getter) {
        if (this.pendingChanges) {
            this.selectedTierNames.clear();
            int includeCol = model.findColumn("select");
            int nameCol = model.findColumn("tier");
            for (int i = 0; i < model.getRowCount(); ++i) {
                Object include = model.getValueAt(i, includeCol);
                if (!((Boolean)include).booleanValue()) continue;
                String annotator = (String)model.getValueAt(i, nameCol);
                for (String s : this.allTierNames) {
                    TierImpl tier = this.transcription.getTierWithId(s);
                    String annotName = getter.getSortValue(tier);
                    if ((annotName == null || annotName.isEmpty()) && annotator == "not specified") {
                        this.selectedTierNames.add(tier.getName());
                        continue;
                    }
                    if (!annotator.equals(annotName)) continue;
                    this.selectedTierNames.add(tier.getName());
                }
            }
            this.hiddenTiers.clear();
            for (String s : this.allTierNames) {
                if (this.selectedTierNames.contains(s)) continue;
                this.hiddenTiers.add(s);
            }
        }
    }
}

