/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.MergeTranscriptionsCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.imports.TranscriptionCopier;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.util.CheckboxTreeCellEditor;
import mpi.eudico.client.util.CheckboxTreeCellRenderer;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.client.util.TierTree;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class MergeStep2
extends StepPane
implements ProgressListener,
ActionListener {
    private TranscriptionImpl firstTrans;
    private TranscriptionImpl secTrans;
    private TranscriptionImpl destTrans;
    private boolean addLinkedFiles;
    private boolean appendAnnsWithMedia;
    private boolean appendAnnsWithGivenTime;
    private boolean appendAnnsWithLastAnns;
    private long givenTimeFrame;
    private Object firstSource;
    private String secondSource;
    private String destFileName;
    private Insets insets;
    private JPanel progressPanel;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private JPanel treePanel;
    private JTable firstTable;
    private JTable secTable;
    private JTree firstTree;
    private JTree secTree;
    private JScrollPane firstScroll;
    private JScrollPane secScroll;
    private JLabel firstLabel;
    private JLabel secLabel;
    private JButton allButton;
    private JButton noneButton;
    private JCheckBox overwriteCB;
    private JCheckBox copyTiersCB;
    private JButton sortTopTreeButton;
    private JButton reverseTopTreeButton;
    private JButton sortBotTreeButton;
    private JButton reverseBotTreeButton;
    private TierTree treeTop;
    private TierTree treeBot;
    private Command com;

    public MergeStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.insets = new Insets(4, 6, 4, 6);
        this.progressPanel = new JPanel(new GridBagLayout());
        this.progressLabel = new JLabel("Loading...");
        this.progressBar = new JProgressBar();
        this.progressPanel.setPreferredSize(new Dimension(50, 80));
        this.progressLabel.setFont(Constants.deriveSmallFont(this.progressLabel.getFont()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)this.progressBar, gridBagConstraints);
        this.treePanel = new JPanel(new GridBagLayout());
        this.firstLabel = new JLabel(ElanLocale.getString("MergeTranscriptionDialog.Label.TiersSource1"));
        this.secLabel = new JLabel(ElanLocale.getString("MergeTranscriptionDialog.Label.SelectTiers"));
        this.overwriteCB = new JCheckBox(ElanLocale.getString("MergeTranscriptionDialog.Label.Overwrite"));
        this.copyTiersCB = new JCheckBox(ElanLocale.getString("MergeTranscriptionDialog.Label.CopyAndRenameTiers"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.treePanel.add((Component)this.firstLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.firstScroll = new JScrollPane(this.firstTable);
        this.treePanel.add((Component)this.firstScroll, gridBagConstraints);
        this.sortTopTreeButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortAZ"));
        this.sortTopTreeButton.addActionListener(this);
        this.reverseTopTreeButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortZA"));
        this.reverseTopTreeButton.addActionListener(this);
        JPanel sortTopButPanel = new JPanel(new GridLayout(1, 2));
        sortTopButPanel.add(this.sortTopTreeButton);
        sortTopButPanel.add(this.reverseTopTreeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.treePanel.add((Component)sortTopButPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        this.treePanel.add((Component)this.secLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.secScroll = new JScrollPane(this.secTable);
        this.treePanel.add((Component)this.secScroll, gridBagConstraints);
        this.allButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.allButton.addActionListener(this);
        this.noneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        this.noneButton.addActionListener(this);
        this.sortBotTreeButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortAZ"));
        this.sortBotTreeButton.addActionListener(this);
        this.reverseBotTreeButton = new JButton(ElanLocale.getString("EditCVDialog.Button.SortZA"));
        this.reverseBotTreeButton.addActionListener(this);
        JPanel butPanel = new JPanel(new GridLayout(1, 4));
        butPanel.add(this.allButton);
        butPanel.add(this.noneButton);
        butPanel.add(this.sortBotTreeButton);
        butPanel.add(this.reverseBotTreeButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.treePanel.add((Component)butPanel, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.treePanel.add((Component)this.overwriteCB, gridBagConstraints);
        this.copyTiersCB.addItemListener(new ItemSelListener());
        gridBagConstraints.gridy = 7;
        this.treePanel.add((Component)this.copyTiersCB, gridBagConstraints);
    }

    private void setProgressUI() {
        this.removeAll();
        this.treePanel.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.progressPanel, gridBagConstraints);
        this.progressPanel.setVisible(true);
        this.revalidate();
    }

    private void setTierTreeUI() {
        this.removeAll();
        this.progressPanel.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treePanel, gridBagConstraints);
        this.treePanel.setVisible(true);
        this.revalidate();
    }

    private void fillTrees() {
        DefaultMutableTreeNode transNode;
        if (this.destTrans != null) {
            this.treeTop = new TierTree(this.destTrans);
            transNode = this.treeTop.getTree();
            this.firstTree = new JTree(transNode);
            DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
            model.setSelectionMode(1);
            this.firstTree.setSelectionModel(model);
            this.firstTree.putClientProperty("JTree.lineStyle", "Angled");
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.firstTree.getCellRenderer();
            renderer.setLeafIcon(null);
            renderer.setOpenIcon(null);
            renderer.setClosedIcon(null);
            renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
            this.firstTree.setShowsRootHandles(true);
            this.firstTree.setRootVisible(false);
            this.firstTree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.firstScroll.setViewportView(this.firstTree);
            for (int i = 0; i < this.firstTree.getRowCount(); ++i) {
                this.firstTree.expandRow(i);
            }
        }
        if (this.secTrans != null) {
            this.treeBot = new TierTree(this.secTrans);
            transNode = this.treeBot.getTree();
            Enumeration<TreeNode> en = transNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (node == transNode) continue;
                node.setUserObject(new SelectableObject<String>((String)node.getUserObject(), true));
            }
            this.secTree = new JTree(transNode);
            DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
            model.setSelectionMode(1);
            this.secTree.setSelectionModel(model);
            this.secTree.putClientProperty("JTree.lineStyle", "Angled");
            CheckboxTreeCellRenderer render = new CheckboxTreeCellRenderer();
            render.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
            CheckboxTreeCellEditor editor = new CheckboxTreeCellEditor();
            editor.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.secTree.setCellRenderer(render);
            this.secTree.setCellEditor(editor);
            this.secTree.setRootVisible(false);
            this.secTree.setShowsRootHandles(true);
            this.secTree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            this.secScroll.setViewportView(this.secTree);
            for (int i = 0; i < this.secTree.getRowCount(); ++i) {
                this.secTree.expandRow(i);
                this.checkSelection((DefaultMutableTreeNode)this.secTree.getPathForRow(i).getLastPathComponent());
            }
            this.secTree.setEditable(true);
            this.secTree.addMouseListener(new TreeMouseListener());
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MergeTranscriptionDialog.Title");
    }

    @Override
    public void enterStepForward() {
        if (this.firstSource != null && this.secondSource != null && this.destFileName != null) {
            this.multiPane.setButtonEnabled(1, false);
            Object fs = this.multiPane.getStepProperty("Source1");
            String ss = (String)this.multiPane.getStepProperty("Source2");
            this.destFileName = (String)this.multiPane.getStepProperty("Destination");
            boolean fsChanged = false;
            boolean ssChanged = false;
            if (fs instanceof String) {
                if (!this.firstSource.equals(fs)) {
                    fsChanged = true;
                    this.firstSource = fs;
                }
            } else if (fs != this.firstSource) {
                fsChanged = true;
                this.firstSource = fs;
            }
            if (!this.secondSource.equals(ss)) {
                ssChanged = true;
                this.secondSource = ss;
            }
            if (fsChanged || ssChanged) {
                this.multiPane.setButtonEnabled(2, false);
                this.multiPane.setButtonEnabled(4, false);
                this.setProgressUI();
                new LoadThread(fsChanged, ssChanged).start();
            } else {
                this.multiPane.setButtonEnabled(3, true);
                this.multiPane.setButtonEnabled(4, true);
                this.multiPane.setButtonEnabled(2, true);
            }
        } else {
            this.multiPane.setButtonEnabled(1, false);
            this.setProgressUI();
            this.firstSource = this.multiPane.getStepProperty("Source1");
            this.secondSource = (String)this.multiPane.getStepProperty("Source2");
            this.destFileName = (String)this.multiPane.getStepProperty("Destination");
            this.appendAnnsWithMedia = (Boolean)this.multiPane.getStepProperty("appendAnnsWithMedia");
            this.appendAnnsWithGivenTime = (Boolean)this.multiPane.getStepProperty("appendAnnsWithGivenTime");
            this.appendAnnsWithLastAnns = (Boolean)this.multiPane.getStepProperty("appendAnnsLastAnns");
            this.addLinkedFiles = (Boolean)this.multiPane.getStepProperty("AddLinkedFiles");
            if (this.appendAnnsWithGivenTime) {
                this.givenTimeFrame = (Long)this.multiPane.getStepProperty("givenTimeFrame");
            }
            this.multiPane.setButtonEnabled(2, false);
            this.multiPane.setButtonEnabled(4, false);
            new LoadThread().start();
        }
    }

    @Override
    public void enterStepBackward() {
    }

    @Override
    public boolean leaveStepForward() {
        return true;
    }

    @Override
    public boolean leaveStepBackward() {
        this.multiPane.setButtonEnabled(3, false);
        return true;
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        this.setProgressUI();
        boolean overwrite = this.overwriteCB.isSelected();
        boolean copyInsteadOfMerge = this.copyTiersCB.isSelected();
        ArrayList<String> tiersToAdd = new ArrayList<String>();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.secTree.getModel().getRoot();
        Enumeration<TreeNode> en = root.preorderEnumeration();
        en.nextElement();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            SelectableObject so = (SelectableObject)node.getUserObject();
            if (!so.isSelected()) continue;
            tiersToAdd.add((String)so.getValue());
        }
        this.com = new MergeTranscriptionsCommand("MergeTranscriptions");
        ((MergeTranscriptionsCommand)this.com).addProgressListener(this);
        if (this.appendAnnsWithMedia) {
            long mediaDur = ELANCommandFactory.getViewerManager(this.firstTrans).getMasterMediaPlayer().getMediaDuration();
            this.secTrans.shiftAllAnnotations(mediaDur);
        } else if (this.appendAnnsWithLastAnns) {
            long d = this.firstTrans.getLatestTime();
            this.secTrans.shiftAllAnnotations(d);
        } else if (this.appendAnnsWithGivenTime) {
            this.secTrans.shiftAllAnnotations(this.givenTimeFrame);
        }
        Object[] args = new Object[]{this.secTrans, this.destFileName, tiersToAdd, overwrite, this.addLinkedFiles, copyInsteadOfMerge};
        this.com.execute(this.destTrans, args);
        return false;
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
            if (percent < 0) {
                percent = 0;
            } else if (percent > 100) {
                percent = 100;
            }
            this.progressBar.setValue(percent);
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
            this.progressBar.setValue(100);
            if (this.com != null) {
                Object standalone = this.multiPane.getStepProperty("Standalone");
                int option = JOptionPane.showOptionDialog(this, message + "\nOpen new transcription in ELAN?", null, 0, 1, null, new Object[]{ElanLocale.getString("Button.Yes"), ElanLocale.getString("Button.No")}, ElanLocale.getString("Button.Yes"));
                if (option == 0) {
                    FrameManager.getInstance().createFrame(this.destFileName);
                    if (standalone != null) {
                        this.multiPane.putStepProperty("CanQuit", Boolean.FALSE);
                    }
                    this.multiPane.close();
                } else if (standalone == null) {
                    this.multiPane.close();
                } else {
                    this.multiPane.previousStep();
                }
            }
        }
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (this.progressPanel.isVisible()) {
            this.progressLabel.setText(message);
            if (this.com != null) {
                this.showWarningDialog("An error occured: " + message);
                this.multiPane.close();
            }
        }
    }

    private JTree redrawTopTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        DefaultTreeSelectionModel model = new DefaultTreeSelectionModel();
        model.setSelectionMode(1);
        tree.setSelectionModel(model);
        tree.putClientProperty("JTree.lineStyle", "Angled");
        DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)tree.getCellRenderer();
        renderer.setLeafIcon(null);
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        tree.setShowsRootHandles(true);
        tree.setRootVisible(false);
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        return tree;
    }

    private JTree redrawBotTree(DefaultMutableTreeNode rootNode) {
        JTree tree = new JTree(rootNode);
        CheckboxTreeCellRenderer render = new CheckboxTreeCellRenderer();
        render.setBackgroundNonSelectionColor(Constants.DEFAULTBACKGROUNDCOLOR);
        CheckboxTreeCellEditor editor = new CheckboxTreeCellEditor();
        editor.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        tree.setCellRenderer(render);
        tree.setCellEditor(editor);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        for (int i = 0; i < tree.getRowCount(); ++i) {
            this.checkSelection((DefaultMutableTreeNode)tree.getPathForRow(i).getLastPathComponent());
        }
        return tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.allButton) {
            this.setAllSelected(true);
        } else if (e.getSource() == this.noneButton) {
            this.setAllSelected(false);
        } else if (e.getSource() == this.sortTopTreeButton) {
            TreeModel model = this.firstTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.firstTree.getExpandedDescendants(pathRoot);
            TreePath[] selectedNodes = this.firstTree.getSelectionPaths();
            this.firstTree = this.redrawTopTree(this.treeTop.sortAlphabetically());
            DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.firstTree.setSelectionModel(selectionModel);
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.firstTree.expandPath(pathToNode);
            }
            this.firstTree.setSelectionPaths(selectedNodes);
            this.treePanel.remove(this.firstScroll);
            this.firstScroll = new JScrollPane(this.firstTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.treePanel.add((Component)this.firstScroll, gbc);
            this.revalidate();
            this.repaint();
        } else if (e.getSource() == this.reverseTopTreeButton) {
            TreeModel model = this.firstTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.firstTree.getExpandedDescendants(pathRoot);
            TreePath[] selectedNodes = this.firstTree.getSelectionPaths();
            this.firstTree = this.redrawTopTree(this.treeTop.sortReverseAlphabetically());
            DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.firstTree.setSelectionModel(selectionModel);
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.firstTree.expandPath(pathToNode);
            }
            this.firstTree.setSelectionPaths(selectedNodes);
            this.treePanel.remove(this.firstScroll);
            this.firstScroll = new JScrollPane(this.firstTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.treePanel.add((Component)this.firstScroll, gbc);
            this.revalidate();
            this.repaint();
        } else if (e.getSource() == this.sortBotTreeButton) {
            TreeModel model = this.secTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.secTree.getExpandedDescendants(pathRoot);
            HashMap<String, Boolean> selectedNodes = new HashMap<String, Boolean>();
            DefaultMutableTreeNode transNode = this.treeBot.getTree();
            Enumeration<TreeNode> en = transNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (node == transNode) continue;
                SelectableObject leftSide = (SelectableObject)node.getUserObject();
                Boolean leftSideSelected = leftSide.isSelected();
                selectedNodes.put((String)leftSide.getValue(), leftSideSelected);
            }
            DefaultMutableTreeNode transNode2 = this.treeBot.sortAlphabetically();
            Enumeration<TreeNode> en2 = transNode2.breadthFirstEnumeration();
            while (en2.hasMoreElements()) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)en2.nextElement();
                if (node2 == transNode2) continue;
                SelectableObject leftSide = (SelectableObject)node2.getUserObject();
                Boolean wasSelected = (Boolean)selectedNodes.get(leftSide.getValue());
                node2.setUserObject(new SelectableObject<String>((String)leftSide.getValue(), wasSelected));
            }
            this.secTree = this.redrawBotTree(transNode2);
            this.secTree.setEditable(true);
            this.secTree.addMouseListener(new TreeMouseListener());
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.secTree.expandPath(pathToNode);
            }
            this.treePanel.remove(this.secScroll);
            this.secScroll = new JScrollPane(this.secTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 4;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.treePanel.add((Component)this.secScroll, gbc);
            this.revalidate();
            this.repaint();
        } else if (e.getSource() == this.reverseBotTreeButton) {
            TreeModel model = this.secTree.getModel();
            Object root = model.getRoot();
            Object[] path = new Object[]{root};
            TreePath pathRoot = new TreePath(path);
            Enumeration<TreePath> expandedDescendants = this.secTree.getExpandedDescendants(pathRoot);
            HashMap<String, Boolean> selectedNodes = new HashMap<String, Boolean>();
            DefaultMutableTreeNode transNode = this.treeBot.getTree();
            Enumeration<TreeNode> en = transNode.breadthFirstEnumeration();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (node == transNode) continue;
                SelectableObject leftSide = (SelectableObject)node.getUserObject();
                Boolean leftSideSelected = leftSide.isSelected();
                selectedNodes.put((String)leftSide.getValue(), leftSideSelected);
            }
            DefaultMutableTreeNode transNode2 = this.treeBot.sortReverseAlphabetically();
            Enumeration<TreeNode> en2 = transNode2.breadthFirstEnumeration();
            while (en2.hasMoreElements()) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)en2.nextElement();
                if (node2 == transNode2) continue;
                SelectableObject leftSide = (SelectableObject)node2.getUserObject();
                Boolean wasSelected = (Boolean)selectedNodes.get(leftSide.getValue());
                node2.setUserObject(new SelectableObject<String>((String)leftSide.getValue(), wasSelected));
            }
            this.secTree = this.redrawBotTree(transNode2);
            this.secTree.setEditable(true);
            this.secTree.addMouseListener(new TreeMouseListener());
            while (expandedDescendants.hasMoreElements()) {
                TreePath pathToNode = expandedDescendants.nextElement();
                this.secTree.expandPath(pathToNode);
            }
            this.treePanel.remove(this.secScroll);
            this.secScroll = new JScrollPane(this.secTree);
            Insets insets = new Insets(4, 6, 4, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 17;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridy = 4;
            gbc.gridx = 0;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.treePanel.add((Component)this.secScroll, gbc);
            this.revalidate();
            this.repaint();
        }
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private TranscriptionImpl copyTranscription(TranscriptionImpl inTrans) {
        TranscriptionImpl destTr = new TranscriptionImpl();
        destTr.setNotifying(false);
        if (inTrans == null) {
            return destTr;
        }
        TranscriptionCopier copier = new TranscriptionCopier();
        copier.copyTranscription(inTrans, destTr);
        return destTr;
    }

    private void checkSelection(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (!(obj instanceof SelectableObject)) {
            return;
        }
        boolean selected = ((SelectableObject)obj).isSelected();
        String tierName = ((SelectableObject)obj).toString();
        DefaultMutableTreeNode nextNode = null;
        SelectableObject so = null;
        String nextName = null;
        TierImpl t2 = null;
        if (!selected) {
            Enumeration<TreeNode> en = node.breadthFirstEnumeration();
            en.nextElement();
            while (en.hasMoreElements()) {
                nextNode = (DefaultMutableTreeNode)en.nextElement();
                so = (SelectableObject)nextNode.getUserObject();
                if (!so.isSelected()) continue;
                nextName = (String)so.getValue();
                TierImpl t1 = this.secTrans.getTierWithId(nextName);
                t2 = this.destTrans.getTierWithId(nextName);
                if (t2 == null) {
                    if (this.destTrans.getTierWithId(t1.getParentTier().getName()) != null && this.lingTypeCompatible(this.destTrans.getTierWithId(t1.getParentTier().getName()), t1.getParentTier())) continue;
                    so.setSelected(false);
                    continue;
                }
                if (this.lingTypeCompatible(t1, t2)) continue;
                so.setSelected(false);
            }
        } else if (node.getLevel() > 1) {
            nextNode = node;
            while (!nextNode.isRoot()) {
                so = (SelectableObject)nextNode.getUserObject();
                tierName = (String)so.getValue();
                TierImpl t1 = this.secTrans.getTierWithId(tierName);
                t2 = this.destTrans.getTierWithId(tierName);
                if (t2 != null) {
                    if (this.lingTypeCompatible(t1, t2)) break;
                    so.setSelected(false);
                    break;
                }
                so.setSelected(true);
                nextNode = (DefaultMutableTreeNode)nextNode.getParent();
            }
        }
        this.secTree.repaint();
    }

    private boolean lingTypeCompatible(TierImpl t, TierImpl t2) {
        LinguisticType lt = t.getLinguisticType();
        LinguisticType lt2 = t2.getLinguisticType();
        if (lt.hasConstraints() == lt2.hasConstraints()) {
            if (lt.getConstraints() != null) {
                return lt.getConstraints().getStereoType() == lt2.getConstraints().getStereoType();
            }
            return true;
        }
        return false;
    }

    private void setAllSelected(boolean select) {
        if (this.secTree != null) {
            Object root = this.secTree.getModel().getRoot();
            if (root instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)root;
                Enumeration<TreeNode> en = rootNode.breadthFirstEnumeration();
                while (en.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                    Object selObj = node.getUserObject();
                    if (!(selObj instanceof SelectableObject)) continue;
                    ((SelectableObject)selObj).setSelected(select);
                }
            }
            this.secTree.repaint();
        }
    }

    class ItemSelListener
    implements ItemListener {
        ItemSelListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == MergeStep2.this.copyTiersCB) {
                MergeStep2.this.overwriteCB.setEnabled(!MergeStep2.this.copyTiersCB.isSelected());
            }
        }
    }

    class TreeMouseListener
    extends MouseAdapter {
        TreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            int selRow = MergeStep2.this.secTree.getRowForLocation(me.getX(), me.getY());
            TreePath path = MergeStep2.this.secTree.getPathForLocation(me.getX(), me.getY());
            if (selRow != -1) {
                MergeStep2.this.checkSelection((DefaultMutableTreeNode)path.getLastPathComponent());
            }
        }
    }

    class LoadThread
    extends Thread {
        private boolean loadFirst = true;
        private boolean loadSec = true;

        LoadThread() {
        }

        LoadThread(boolean loadFirst, boolean loadSec) {
            this.loadFirst = loadFirst;
            this.loadSec = loadSec;
        }

        @Override
        public void run() {
            try {
                MergeStep2.this.progressUpdated(this, 5, "Loading first transcription...");
                if (this.loadFirst) {
                    if (MergeStep2.this.firstSource instanceof String) {
                        MergeStep2.this.firstTrans = new TranscriptionImpl((String)MergeStep2.this.firstSource);
                        MergeStep2.this.destTrans = MergeStep2.this.firstTrans;
                    } else {
                        MergeStep2.this.firstTrans = (TranscriptionImpl)MergeStep2.this.firstSource;
                        MergeStep2.this.destTrans = MergeStep2.this.copyTranscription(MergeStep2.this.firstTrans);
                        MergeStep2.this.destTrans.setPathName(MergeStep2.this.firstTrans.getFullPath());
                    }
                }
                MergeStep2.this.progressUpdated(this, 40, "Loading second transcription...");
                if (this.loadSec) {
                    MergeStep2.this.secTrans = new TranscriptionImpl(MergeStep2.this.secondSource);
                }
                MergeStep2.this.progressUpdated(this, 80, "Fetching tiers...");
                MergeStep2.this.progressCompleted(this, "");
                MergeStep2.this.setTierTreeUI();
                MergeStep2.this.multiPane.setButtonEnabled(2, true);
                MergeStep2.this.multiPane.setButtonEnabled(4, true);
                MergeStep2.this.multiPane.setButtonEnabled(3, true);
                MergeStep2.this.fillTrees();
            }
            catch (Exception ex) {
                MergeStep2.this.progressInterrupted(this, "An error occurred: " + ex.getMessage());
            }
        }
    }
}

