/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.ConstraintImpl;
import mpi.eudico.server.corpora.clomimpl.type.IncludedIn;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.server.corpora.clomimpl.type.TimeSubdivision;

public class UndoableTranscriptionMerger {
    private TranscriptionImpl transA;
    private TranscriptionImpl transB;
    private Map<AbstractAnnotation, DefaultMutableTreeNode> createdAnnotations;
    private Map<AbstractAnnotation, DefaultMutableTreeNode> deletedAnnotations;
    private Map<AbstractAnnotation, DefaultMutableTreeNode> modifiedAnnotations;
    private List<ArrayList<DefaultMutableTreeNode>> createdAnnotationSequences;
    private Map<String, TierImpl> createdTierMap;
    private Map<String, LinguisticType> createdTypeMap;
    private List<String> tiersToAddList;
    private boolean addEverything;
    private boolean overWriteMode = false;
    private MergeUtil mergeUtil = new MergeUtil();

    public UndoableTranscriptionMerger() {
        this.createdAnnotations = new HashMap<AbstractAnnotation, DefaultMutableTreeNode>();
        this.deletedAnnotations = new HashMap<AbstractAnnotation, DefaultMutableTreeNode>();
        this.modifiedAnnotations = new HashMap<AbstractAnnotation, DefaultMutableTreeNode>();
        this.createdAnnotationSequences = new ArrayList<ArrayList<DefaultMutableTreeNode>>();
        this.createdTierMap = new LinkedHashMap<String, TierImpl>();
        this.createdTypeMap = new LinkedHashMap<String, LinguisticType>();
    }

    public void mergeWith(TranscriptionImpl first, TranscriptionImpl second) {
        if (this.transA != null) {
            // empty if block
        }
        if (first == null) {
            throw new NullPointerException("The first transcription is null");
        }
        if (second == null) {
            throw new NullPointerException("The second transcription is null");
        }
        this.mergeWith(first, second, false);
    }

    public void mergeWith(TranscriptionImpl first, TranscriptionImpl second, boolean overwrite) {
        if (this.transA != null) {
            // empty if block
        }
        if (first == null) {
            throw new NullPointerException("The first transcription is null");
        }
        if (second == null) {
            throw new NullPointerException("The second transcription is null");
        }
        this.mergeWith(first, second, overwrite, null);
    }

    public void mergeWith(TranscriptionImpl first, TranscriptionImpl second, boolean overwrite, List<String> tiersToAdd) {
        String tierName;
        TierImpl tier;
        int i;
        if (this.transA != null) {
            // empty if block
        }
        if (first == null) {
            throw new NullPointerException("The first transcription is null");
        }
        if (second == null) {
            throw new NullPointerException("The second transcription is null");
        }
        this.overWriteMode = overwrite;
        this.transA = first;
        this.transB = second;
        ArrayList<String> addedTiers = new ArrayList<String>();
        this.tiersToAddList = new ArrayList<String>();
        if (tiersToAdd == null) {
            this.addEverything = true;
            this.getTierNames2(this.transB, this.tiersToAddList);
        } else {
            this.addEverything = false;
            this.tiersToAddList.addAll(tiersToAdd);
        }
        this.tiersToAddList = this.mergeUtil.sortTiers(this.transB, this.tiersToAddList);
        List<TierImpl> sortedTierObj = this.mergeUtil.getSortedTiers(this.transB, this.tiersToAddList);
        if (sortedTierObj == null || sortedTierObj.size() == 0) {
            ClientLogger.LOG.warning("The requested tiers are not in the transcription.");
            return;
        }
        for (i = 0; i < sortedTierObj.size(); ++i) {
            tier = sortedTierObj.get(i);
            tierName = tier.getName();
            if (this.transA.getTierWithId(tierName) != null) continue;
            if (tier.getParentTier() == null) {
                this.addNewTopLevelTier(tier, sortedTierObj);
            } else {
                this.addNewDependingTier(tier, sortedTierObj);
            }
            addedTiers.add(tierName);
        }
        if (this.addEverything) {
            for (i = 0; i < sortedTierObj.size(); ++i) {
                tier = sortedTierObj.get(i);
                tierName = tier.getName();
                if (addedTiers.contains(tierName) || this.transA.getTierWithId(tierName) != null) continue;
                ClientLogger.LOG.info("Adding a tier in a second iteration: " + tierName);
                if (tier.getParentTier() == null) {
                    this.addNewTopLevelTier(tier, sortedTierObj);
                    continue;
                }
                this.addNewDependingTier(tier, sortedTierObj);
            }
        }
        this.transA.setNotifying(false);
        int origPropMode = this.transA.getTimeChangePropagationMode();
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(0);
        }
        List<String> tiersWithoutParentInGroup = this.mergeUtil.getTiersWithoutParentInGroup(this.transA, this.tiersToAddList);
        for (int i2 = 0; i2 < tiersWithoutParentInGroup.size(); ++i2) {
            TierImpl tier2 = this.transB.getTierWithId(tiersWithoutParentInGroup.get(i2));
            if (tier2.hasParentTier()) {
                this.addAnnotationsToDependentTier(tier2, this.tiersToAddList);
                continue;
            }
            this.addAnnotations(tier2, this.tiersToAddList);
        }
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(origPropMode);
        }
        this.transA.setNotifying(true);
    }

    public void undo() {
        String[] tierKeys = this.createdTierMap.keySet().toArray(new String[0]);
        for (int i = tierKeys.length - 1; i >= 0; --i) {
            String tierName = tierKeys[i];
            TierImpl t = this.transA.getTierWithId(tierName);
            if (t != null) {
                t.removeAllAnnotations();
            }
            this.transA.removeTier(t);
        }
        String[] typeKeys = this.createdTypeMap.keySet().toArray(new String[0]);
        for (int i = typeKeys.length - 1; i >= 0; --i) {
            String typeName = typeKeys[i];
            LinguisticType lt = this.transA.getLinguisticTypeByName(typeName);
            if (lt == null) continue;
            this.transA.removeLinguisticType(lt);
        }
        this.transA.setNotifying(false);
        int origPropMode = this.transA.getTimeChangePropagationMode();
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(0);
        }
        for (AbstractAnnotation createdAnn : this.createdAnnotations.keySet()) {
            AbstractAnnotation curAnn;
            TierImpl t = (TierImpl)createdAnn.getTier();
            if (t == null || this.transA.getTierWithId(t.getName()) == null || (curAnn = (AbstractAnnotation)t.getAnnotationAtTime((createdAnn.getBeginTimeBoundary() + createdAnn.getEndTimeBoundary()) / 2L)) == null) continue;
            t.removeAnnotation(curAnn);
        }
        this.undoModifiedAnnotations();
        for (AbstractAnnotation modAnn : this.modifiedAnnotations.keySet()) {
            DefaultMutableTreeNode modNode = this.modifiedAnnotations.get(modAnn);
            AbstractAnnotation recreatedModAnn = AnnotationRecreator.createAnnotationFromTree(this.transA, modNode, true);
            if (recreatedModAnn != null) continue;
            ClientLogger.LOG.warning("Could not recreate a modified annotation: " + modAnn.getTier().getName() + " BT: " + modAnn.getBeginTimeBoundary());
        }
        for (AbstractAnnotation deletedAnn : this.deletedAnnotations.keySet()) {
            DefaultMutableTreeNode delNode = this.deletedAnnotations.get(deletedAnn);
            AbstractAnnotation recreatedAnn = AnnotationRecreator.createAnnotationFromTree(this.transA, delNode, true);
            if (recreatedAnn != null) continue;
            ClientLogger.LOG.warning("Could not recreate a deleted annotation: " + deletedAnn.getTier().getName() + " BT: " + deletedAnn.getBeginTimeBoundary());
        }
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(origPropMode);
        }
        this.transA.setNotifying(true);
    }

    private void undoModifiedAnnotations() {
        for (AbstractAnnotation modAnn : this.modifiedAnnotations.keySet()) {
            long mid;
            DefaultMutableTreeNode modNode = this.modifiedAnnotations.get(modAnn);
            AnnotationDataRecord annRecord = (AnnotationDataRecord)modNode.getUserObject();
            String tierName = annRecord.getTierName();
            TierImpl tier = this.transA.getTierWithId(tierName);
            if ((modAnn = (AbstractAnnotation)tier.getAnnotationAtTime(mid = (annRecord.getBeginTime() + annRecord.getEndTime()) / 2L)) == null && (modAnn = (AbstractAnnotation)tier.getAnnotationAtTime(annRecord.getBeginTime())) == null) {
                modAnn = (AbstractAnnotation)tier.getAnnotationAtTime(annRecord.getEndTime() - 1L);
            }
            if (modAnn == null) continue;
            tier.removeAnnotation(modAnn);
        }
    }

    public void redo() {
        String[] typeKeys = this.createdTypeMap.keySet().toArray(new String[0]);
        for (int i = 0; i < typeKeys.length; ++i) {
            String typeName = typeKeys[i];
            LinguisticType lt = this.transA.getLinguisticTypeByName(typeName);
            if (lt != null) continue;
            this.transA.addLinguisticType(this.createdTypeMap.get(typeName));
        }
        String[] tierKeys = this.createdTierMap.keySet().toArray(new String[0]);
        for (int i = 0; i < tierKeys.length; ++i) {
            TierImpl oldTier;
            LinguisticType lt;
            String tierName = tierKeys[i];
            TierImpl t = this.transA.getTierWithId(tierName);
            if (t != null || (lt = this.transA.getLinguisticTypeByName((oldTier = this.createdTierMap.get(tierName)).getLinguisticType().getLinguisticTypeName())) == null) continue;
            TierImpl parentTier = null;
            TierImpl nextTier = null;
            if (oldTier.getParentTier() != null) {
                parentTier = this.transA.getTierWithId(oldTier.getParentTier().getName());
            }
            nextTier = parentTier == null ? new TierImpl(tierName, oldTier.getParticipant(), this.transA, lt) : new TierImpl(parentTier, tierName, oldTier.getParticipant(), this.transA, lt);
            nextTier.setAnnotator(oldTier.getAnnotator());
            nextTier.setDefaultLocale(oldTier.getDefaultLocale());
            nextTier.setLangRef(oldTier.getLangRef());
            this.transA.addTier(nextTier);
        }
        this.transA.setNotifying(false);
        int origPropMode = this.transA.getTimeChangePropagationMode();
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(0);
        }
        for (AbstractAnnotation aa : this.createdAnnotations.keySet()) {
            DefaultMutableTreeNode node = this.createdAnnotations.get(aa);
            AbstractAnnotation nextAa = AnnotationRecreator.createAnnotationFromTree(this.transA, node);
            if (nextAa != null) continue;
            ClientLogger.LOG.warning("Could not create the annotation again in redo: " + aa.getTier().getName() + " BT: " + aa.getBeginTimeBoundary());
        }
        for (ArrayList<DefaultMutableTreeNode> nextList : this.createdAnnotationSequences) {
            AnnotationRecreator.createAnnotationsSequentially(this.transA, nextList, false);
        }
        if (origPropMode != 0) {
            this.transA.setTimeChangePropagationMode(origPropMode);
        }
        this.transA.setNotifying(true);
    }

    private void getTierNames2(TranscriptionImpl trans, List<String> listToAddTo) {
        if (trans == null || listToAddTo == null) {
            return;
        }
        List<TierImpl> tiers = trans.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            Tier t = tiers.get(i);
            listToAddTo.add(t.getName());
        }
    }

    private void addNewTopLevelTier(TierImpl tier, List<? extends Tier> allTiersToAdd) {
        if (tier == null || tier.getParentTier() != null) {
            return;
        }
        TierImpl nextTier = null;
        LinguisticType origType = tier.getLinguisticType();
        String ltName = origType.getLinguisticTypeName();
        LinguisticType curType = this.transA.getLinguisticTypeByName(ltName);
        if (curType != null) {
            boolean compatible = this.mergeUtil.lingTypeCompatible(curType, tier.getLinguisticType());
            if (compatible) {
                nextTier = new TierImpl(tier.getName(), tier.getParticipant(), this.transA, curType);
                nextTier.setAnnotator(tier.getAnnotator());
                nextTier.setDefaultLocale(tier.getDefaultLocale());
                nextTier.setLangRef(tier.getLangRef());
                this.createdTierMap.put(nextTier.getName(), nextTier);
            } else {
                String nextLTName = this.getUniqueLTName(this.transA, ltName);
                if (nextLTName != null) {
                    LinguisticType nextType = new LinguisticType(nextLTName);
                    nextType.setTimeAlignable(origType.isTimeAlignable());
                    this.transA.addLinguisticType(nextType);
                    this.createdTypeMap.put(nextLTName, nextType);
                    nextTier = new TierImpl(tier.getName(), tier.getParticipant(), this.transA, nextType);
                    nextTier.setAnnotator(tier.getAnnotator());
                    nextTier.setDefaultLocale(tier.getDefaultLocale());
                    nextTier.setLangRef(tier.getLangRef());
                    this.createdTierMap.put(nextTier.getName(), nextTier);
                }
            }
        } else {
            LinguisticType nextType = new LinguisticType(ltName);
            nextType.setTimeAlignable(origType.isTimeAlignable());
            this.transA.addLinguisticType(nextType);
            this.createdTypeMap.put(ltName, nextType);
            nextTier = new TierImpl(tier.getName(), tier.getParticipant(), this.transA, nextType);
            nextTier.setAnnotator(tier.getAnnotator());
            nextTier.setDefaultLocale(tier.getDefaultLocale());
            nextTier.setLangRef(tier.getLangRef());
            this.createdTierMap.put(nextTier.getName(), nextTier);
        }
        if (nextTier != null) {
            this.transA.addTier(nextTier);
        }
    }

    private void addNewDependingTier(TierImpl tier, List<? extends Tier> allTiersToAdd) {
        boolean compatible;
        if (tier == null) {
            return;
        }
        TierImpl nextTier = null;
        LinguisticType origType = tier.getLinguisticType();
        String parentName = tier.getParentTier().getName();
        TierImpl parentTier = this.transA.getTierWithId(parentName);
        if (parentTier != null && (compatible = this.mergeUtil.parentChildTypeCompatible(parentTier.getLinguisticType(), origType))) {
            LinguisticType curType = this.transA.getLinguisticTypeByName(origType.getLinguisticTypeName());
            if (curType != null) {
                boolean typeComp = this.mergeUtil.lingTypeCompatible(origType, curType);
                if (typeComp) {
                    nextTier = new TierImpl(parentTier, tier.getName(), tier.getParticipant(), this.transA, curType);
                    nextTier.setAnnotator(tier.getAnnotator());
                    nextTier.setDefaultLocale(tier.getDefaultLocale());
                    nextTier.setLangRef(tier.getLangRef());
                    this.createdTierMap.put(nextTier.getName(), nextTier);
                } else {
                    String nextLTName = this.getUniqueLTName(this.transA, curType.getLinguisticTypeName());
                    if (nextLTName != null) {
                        LinguisticType nextType = new LinguisticType(nextLTName);
                        nextType.setTimeAlignable(origType.isTimeAlignable());
                        ConstraintImpl nextConstraint = null;
                        switch (origType.getConstraints().getStereoType()) {
                            case 1: {
                                nextConstraint = new IncludedIn();
                                break;
                            }
                            case 0: {
                                nextConstraint = new TimeSubdivision();
                                break;
                            }
                            case 4: {
                                nextConstraint = new SymbolicAssociation();
                                break;
                            }
                            case 3: {
                                nextConstraint = new SymbolicSubdivision();
                            }
                        }
                        if (nextConstraint != null) {
                            nextType.addConstraint(nextConstraint);
                            this.transA.addLinguisticType(nextType);
                            this.createdTypeMap.put(nextLTName, nextType);
                            nextTier = new TierImpl(parentTier, tier.getName(), tier.getParticipant(), this.transA, nextType);
                            nextTier.setAnnotator(tier.getAnnotator());
                            nextTier.setDefaultLocale(tier.getDefaultLocale());
                            nextTier.setLangRef(tier.getLangRef());
                            this.createdTierMap.put(nextTier.getName(), nextTier);
                        }
                    }
                }
            } else {
                LinguisticType nextType = new LinguisticType(origType.getLinguisticTypeName());
                nextType.setTimeAlignable(origType.isTimeAlignable());
                ConstraintImpl nextConstraint = null;
                switch (origType.getConstraints().getStereoType()) {
                    case 1: {
                        nextConstraint = new IncludedIn();
                        break;
                    }
                    case 0: {
                        nextConstraint = new TimeSubdivision();
                        break;
                    }
                    case 4: {
                        nextConstraint = new SymbolicAssociation();
                        break;
                    }
                    case 3: {
                        nextConstraint = new SymbolicSubdivision();
                    }
                }
                if (nextConstraint != null) {
                    nextType.addConstraint(nextConstraint);
                    this.transA.addLinguisticType(nextType);
                    this.createdTypeMap.put(nextType.getLinguisticTypeName(), nextType);
                    nextTier = new TierImpl(parentTier, tier.getName(), tier.getParticipant(), this.transA, nextType);
                    nextTier.setAnnotator(tier.getAnnotator());
                    nextTier.setDefaultLocale(tier.getDefaultLocale());
                    nextTier.setLangRef(tier.getLangRef());
                    this.createdTierMap.put(nextTier.getName(), nextTier);
                }
            }
        }
        if (nextTier != null) {
            this.transA.addTier(nextTier);
        }
    }

    private void addAnnotations(TierImpl sourceTier, List<String> tierToInclude) {
        if (sourceTier == null || tierToInclude == null) {
            return;
        }
        TierImpl destTier = this.transA.getTierWithId(sourceTier.getName());
        if (destTier == null) {
            ClientLogger.LOG.warning("The tier to add annotations to is not found in the target transcription.");
            return;
        }
        TierImpl rootTier = destTier.getRootTier();
        List<AbstractAnnotation> annotations = sourceTier.getAnnotations();
        for (int i = 0; i < annotations.size(); ++i) {
            AbstractAnnotation changeAnn;
            int j;
            AbstractAnnotation srcAnn = annotations.get(i);
            long bt = srcAnn.getBeginTimeBoundary();
            long et = srcAnn.getEndTimeBoundary();
            DefaultMutableTreeNode recordNode = AnnotationRecreator.createTreeForAnnotation(srcAnn);
            List<Annotation> existAnns = rootTier != destTier ? rootTier.getOverlappingAnnotations(bt, et) : destTier.getOverlappingAnnotations(bt, et);
            if (!this.overWriteMode && !existAnns.isEmpty()) continue;
            if (destTier.hasParentTier()) {
                for (j = 0; j < existAnns.size(); ++j) {
                    changeAnn = (AbstractAnnotation)existAnns.get(j);
                    if (this.modifiedAnnotations.containsKey(changeAnn)) continue;
                    this.modifiedAnnotations.put(changeAnn, AnnotationRecreator.createTreeForAnnotation(changeAnn));
                }
            } else {
                for (j = 0; j < existAnns.size(); ++j) {
                    changeAnn = (AbstractAnnotation)existAnns.get(j);
                    if (changeAnn.getBeginTimeBoundary() < bt) {
                        if (this.modifiedAnnotations.containsKey(changeAnn)) continue;
                        this.modifiedAnnotations.put(changeAnn, AnnotationRecreator.createTreeForAnnotation(changeAnn));
                        continue;
                    }
                    if (changeAnn.getEndTimeBoundary() > et) {
                        if (this.modifiedAnnotations.containsKey(changeAnn)) continue;
                        this.modifiedAnnotations.put(changeAnn, AnnotationRecreator.createTreeForAnnotation(changeAnn));
                        continue;
                    }
                    if (this.deletedAnnotations.containsKey(changeAnn)) continue;
                    this.deletedAnnotations.put(changeAnn, AnnotationRecreator.createTreeForAnnotation(changeAnn));
                }
            }
            Enumeration<TreeNode> en = recordNode.breadthFirstEnumeration();
            ArrayList<DefaultMutableTreeNode> processedNodes = new ArrayList<DefaultMutableTreeNode>();
            while (en.hasMoreElements()) {
                AnnotationDataRecord annData;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
                if (processedNodes.contains(node) || !tierToInclude.contains((annData = (AnnotationDataRecord)node.getUserObject()).getTierName())) continue;
                AbstractAnnotation destAnn = AnnotationRecreator.createAnnotationFromTree(this.transA, node);
                if (destAnn != null) {
                    this.createdAnnotations.put(destAnn, node);
                }
                Enumeration<TreeNode> nextEn = node.breadthFirstEnumeration();
                while (nextEn.hasMoreElements()) {
                    processedNodes.add((DefaultMutableTreeNode)nextEn.nextElement());
                }
            }
        }
    }

    private void addAnnotationsToDependentTier(TierImpl sourceTier, List<String> tierToInclude) {
        if (sourceTier == null || tierToInclude == null) {
            return;
        }
        TierImpl destTier = this.transA.getTierWithId(sourceTier.getName());
        if (destTier == null) {
            ClientLogger.LOG.warning("The tier to add annotations to is not found in the target transcription.");
            return;
        }
        TierImpl sourceParentTier = sourceTier.getParentTier();
        if (destTier.getLinguisticType().getConstraints().getStereoType() != 4) {
            List<AbstractAnnotation> parAnnotations = sourceParentTier.getAnnotations();
            for (AbstractAnnotation parAnn : parAnnotations) {
                List<Annotation> curChildren = parAnn.getChildrenOnTier(sourceTier);
                if (curChildren.isEmpty() || !this.overWriteMode) continue;
                ArrayList<DefaultMutableTreeNode> curNodeGroup = new ArrayList<DefaultMutableTreeNode>();
                for (Annotation aa : curChildren) {
                    curNodeGroup.add(AnnotationRecreator.createTreeForAnnotation((AbstractAnnotation)aa));
                }
                this.createdAnnotationSequences.add(curNodeGroup);
                AnnotationRecreator.createAnnotationsSequentially(this.transA, curNodeGroup, false);
            }
        } else {
            List<AbstractAnnotation> sourceAnnotations = sourceTier.getAnnotations();
            for (AbstractAnnotation srcAnn : sourceAnnotations) {
                DefaultMutableTreeNode recNode;
                AbstractAnnotation nextAnn;
                long refTime = (srcAnn.getBeginTimeBoundary() + srcAnn.getEndTimeBoundary()) / 2L;
                AbstractAnnotation curDestAnn = (AbstractAnnotation)destTier.getAnnotationAtTime(refTime);
                if (curDestAnn != null) {
                    if (!this.overWriteMode) continue;
                    this.deletedAnnotations.put(curDestAnn, new DefaultMutableTreeNode(AnnotationRecreator.createTreeForAnnotation(curDestAnn)));
                    destTier.removeAnnotation(curDestAnn);
                }
                if ((nextAnn = AnnotationRecreator.createAnnotationFromTree(this.transA, recNode = AnnotationRecreator.createTreeForAnnotation(srcAnn))) == null) continue;
                this.createdAnnotations.put(nextAnn, recNode);
            }
        }
    }

    private String getUniqueLTName(TranscriptionImpl trans, String ltName) {
        if (trans == null || ltName == null) {
            return null;
        }
        for (int i = 1; i < 20; ++i) {
            String newName = ltName + "-" + i;
            if (trans.getLinguisticTypeByName(newName) != null) continue;
            return newName;
        }
        return null;
    }

    private Annotation getRootAnnotation(Annotation annotation) {
        if (annotation != null && annotation.hasParentAnnotation()) {
            Annotation iterAnn = annotation.getParentAnnotation();
            while (iterAnn.hasParentAnnotation()) {
                iterAnn = iterAnn.getParentAnnotation();
            }
            return iterAnn;
        }
        return annotation;
    }
}

