/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public abstract class AbstractMFImportStep1
extends StepPane
implements ActionListener {
    protected JLabel selectFilesLabel;
    protected JButton selectFilesBtn;
    protected JButton removeFilesBtn;
    protected JList fileList;
    protected DefaultListModel model;
    private List<Object> selectedFiles;
    protected Insets globalInset = new Insets(2, 4, 2, 4);
    protected FileChooser chooser;

    public AbstractMFImportStep1(MultiStepPane mp) {
        super(mp);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.selectFilesLabel = new JLabel(ElanLocale.getString("OverlapsDialog.Radio.FilesFromFileBrowser"));
        this.selectFilesBtn = new JButton(ElanLocale.getString("Button.Browse"));
        this.selectFilesBtn.addActionListener(this);
        this.removeFilesBtn = new JButton(ElanLocale.getString("FileChooser.Button.Remove"));
        this.removeFilesBtn.setEnabled(false);
        this.removeFilesBtn.addActionListener(this);
        this.model = new DefaultListModel();
        this.fileList = new JList(this.model);
        this.fileList.setSelectionMode(2);
        JPanel selectedFilesPanel = new JPanel(new GridBagLayout());
        selectedFilesPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileImport.Step1.SelectedFiles")));
        JScrollPane jsp = new JScrollPane(this.fileList);
        jsp.setPreferredSize(new Dimension(jsp.getPreferredSize().getSize().width - 30, jsp.getPreferredSize().getSize().height));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 10;
        selectedFilesPanel.add((Component)jsp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.globalInset;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.add((Component)this.selectFilesLabel, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.selectFilesBtn, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        this.add((Component)selectedFilesPanel, gbc);
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        this.add((Component)this.removeFilesBtn, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileImport.Step1.Title");
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("FilesToBeImported", this.getFilesToBeImported());
        return true;
    }

    private Object[] getFilesToBeImported() {
        int i;
        Object[] files = new Object[this.model.getSize()];
        ArrayList<String> selectedFileNames = new ArrayList<String>();
        for (i = 0; i < this.model.getSize(); ++i) {
            selectedFileNames.add((String)this.model.get(i));
        }
        for (i = 0; i < this.selectedFiles.size(); ++i) {
            if (!selectedFileNames.contains(((File)this.selectedFiles.get(i)).getAbsolutePath())) continue;
            files[i] = this.selectedFiles.get(i);
        }
        return files;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e != null) {
            JButton button = (JButton)e.getSource();
            if (button == this.selectFilesBtn) {
                List<Object> files;
                Object[] array = this.getMultipleFiles();
                if (array != null && (files = Arrays.asList(array)) != null && files.size() != 0) {
                    this.selectedFiles = files;
                    this.initializeFileList();
                }
            } else if (button == this.removeFilesBtn) {
                this.removeFiles();
            }
        }
        this.updateButtonStates();
    }

    protected abstract Object[] getMultipleFiles();

    protected Object[] getMultipleFiles(String title, String[] mainFilterExt, String prefStringToLoadtheCurrentPath) {
        return this.getMultipleFiles(title, mainFilterExt, prefStringToLoadtheCurrentPath, 0);
    }

    protected Object[] getMultipleFiles(String title, String[] mainFilterExt, String prefStringToLoadtheCurrentPath, int fileType) {
        this.chooser = new FileChooser(this);
        this.chooser.createAndShowMultiFileDialog(title, 0, null, null, mainFilterExt, false, prefStringToLoadtheCurrentPath, fileType, null);
        return this.chooser.getSelectedFiles();
    }

    protected Object[] getFilesFromFilesAndFolders(Object[] files, String[] fileExtensions) {
        ArrayList<String> extensions = new ArrayList<String>();
        for (String ext : fileExtensions) {
            if (extensions.contains(ext.toLowerCase())) continue;
            extensions.add(ext.toLowerCase());
        }
        ArrayList<File> validFiles = new ArrayList<File>();
        for (Object f : files) {
            File file = (File)f;
            if (file.isFile()) {
                if (!file.canRead() || validFiles.contains(file)) continue;
                validFiles.add(file);
                continue;
            }
            if (!file.isDirectory()) continue;
            this.chooser.addFiles(file, validFiles, extensions);
        }
        return validFiles.toArray();
    }

    public void updateButtonStates() {
        if (this.model.size() > 0) {
            this.multiPane.setButtonEnabled(1, true);
            this.removeFilesBtn.setEnabled(true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
            this.removeFilesBtn.setEnabled(false);
        }
        this.multiPane.setButtonEnabled(2, false);
    }

    public void removeFiles() {
        int[] selIndices = this.fileList.getSelectedIndices();
        if (selIndices.length == 0) {
            return;
        }
        for (int i = selIndices.length - 1; i >= 0; --i) {
            this.model.removeElementAt(selIndices[i]);
        }
        if (this.model.getSize() > 0) {
            this.fileList.setSelectedIndex(this.model.getSize() - 1);
            this.fileList.ensureIndexIsVisible(this.model.getSize() - 1);
        }
    }

    protected void initializeFileList() {
        while (this.model.size() != 0) {
            this.model.removeElementAt(0);
        }
        if (this.selectedFiles != null) {
            for (Object f : this.selectedFiles) {
                if (this.model.contains(f)) continue;
                int curIndex = this.fileList.getSelectedIndex();
                this.model.add(curIndex + 1, ((File)f).getAbsolutePath());
                this.fileList.setSelectedIndex(curIndex + 1);
            }
        }
    }
}

