/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.io.File;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.SaveAs27Preferences;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;

public abstract class AbstractMFImportStep4
extends ProgressStepPane
implements ProcessReporter {
    protected Object[] files;
    private boolean useOriginalDir;
    private boolean newDir;
    private String newDirName;
    private boolean sameDir;
    private String sameDirName;
    private boolean useOriginalFileName;
    private boolean useOriginalFileNameWithSuffix;
    protected String encoding;
    protected ProcessReport report;
    private final String EXTENSION = ".eaf";
    protected TranscriptionImpl transImpl;

    public AbstractMFImportStep4(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileImport.Step4.Title");
    }

    @Override
    public void enterStepForward() {
        this.useOriginalDir = (Boolean)this.multiPane.getStepProperty("UseOriginalDir");
        this.newDir = (Boolean)this.multiPane.getStepProperty("NewDirectory");
        this.newDirName = (String)this.multiPane.getStepProperty("NewDirName");
        this.sameDir = (Boolean)this.multiPane.getStepProperty("TogetherInSameDir");
        this.sameDirName = (String)this.multiPane.getStepProperty("SameDirectoryName");
        this.useOriginalFileName = (Boolean)this.multiPane.getStepProperty("UseOriginalFileName");
        this.useOriginalFileNameWithSuffix = (Boolean)this.multiPane.getStepProperty("UseOriginalFileNameWithSuffix");
        this.files = (Object[])this.multiPane.getStepProperty("FilesToBeImported");
        this.encoding = (String)this.multiPane.getStepProperty("Encoding");
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.completed = false;
        this.multiPane.setButtonEnabled(8, false);
        this.report = new SimpleReport(this.multiPane.getDialog().getTitle());
        ImportThread t = new ImportThread();
        t.start();
        return false;
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    protected abstract boolean doImport(File var1);

    private class ImportThread
    extends Thread {
        private final int YES = 1;
        private final int NO = 2;
        private final int YES_TO_ALL = 0;
        private final int NO_TO_ALL = 3;

        private String getDirectoryToSave(String fileName) {
            int index = fileName.lastIndexOf(File.separatorChar);
            String originalDirectory = fileName.substring(0, index + 1);
            if (AbstractMFImportStep4.this.useOriginalDir) {
                return originalDirectory;
            }
            if (AbstractMFImportStep4.this.newDir) {
                return originalDirectory + AbstractMFImportStep4.this.newDirName;
            }
            if (AbstractMFImportStep4.this.sameDir) {
                return AbstractMFImportStep4.this.sameDirName;
            }
            return null;
        }

        private String getFileName(String path, File sourceFile) {
            String orifileName = sourceFile.getName();
            int index = orifileName.lastIndexOf(46);
            orifileName = orifileName.substring(0, index);
            if (AbstractMFImportStep4.this.useOriginalFileName) {
                return orifileName + ".eaf";
            }
            if (AbstractMFImportStep4.this.useOriginalFileNameWithSuffix) {
                int i = 1;
                Object fileName = orifileName;
                File f = new File(path + (String)fileName + ".eaf");
                while (f.exists()) {
                    fileName = orifileName + i;
                    f = new File(path + (String)fileName + ".eaf");
                    ++i;
                }
                return (String)fileName + ".eaf";
            }
            return orifileName + ".eaf";
        }

        private boolean createDirectory(String directoryPath) {
            boolean directoryExists = true;
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                directoryExists = new File(directoryPath).mkdir();
            }
            return directoryExists;
        }

        @Override
        public void run() {
            int failedImports = 0;
            int refusedImports = 0;
            boolean saveForever = false;
            boolean skipForever = false;
            AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.NoOfFiles") + " " + AbstractMFImportStep4.this.files.length);
            AbstractMFImportStep4.this.report("\n");
            for (int f = 0; f < AbstractMFImportStep4.this.files.length; ++f) {
                if ((File)AbstractMFImportStep4.this.files[f] == null || !((File)AbstractMFImportStep4.this.files[f]).exists()) {
                    if ((File)AbstractMFImportStep4.this.files[f] != null) {
                        AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportFileName") + " " + ((File)AbstractMFImportStep4.this.files[f]).getAbsolutePath());
                    }
                    ++failedImports;
                    AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.NoFile"));
                    AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportFailed"));
                    AbstractMFImportStep4.this.report("\n");
                    continue;
                }
                String newfileName = null;
                String fileName = ((File)AbstractMFImportStep4.this.files[f]).getAbsolutePath();
                AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportFileName") + " " + fileName);
                try {
                    Object path = this.getDirectoryToSave(fileName);
                    if (((String)path).charAt(((String)path).length() - 1) != File.separatorChar) {
                        path = (String)path + File.separatorChar;
                    }
                    String directoryToSave = newfileName = (String)path + this.getFileName((String)path, (File)AbstractMFImportStep4.this.files[f]);
                    AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ResultingFileName") + " " + newfileName);
                    boolean directoryExists = this.createDirectory((String)path);
                    boolean saveThisFile = true;
                    boolean fileExists = new File(directoryToSave).exists();
                    if (fileExists && skipForever) {
                        saveThisFile = false;
                    }
                    if (!skipForever && !saveForever && fileExists) {
                        Object[] possibleValues = new Object[]{"Yes To All", "Yes", "No", "No To All"};
                        int choice = JOptionPane.showOptionDialog(null, ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description1") + " " + newfileName + " " + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description2") + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description3") + "\t " + directoryToSave + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description4") + "\n", ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Title"), -1, 2, null, possibleValues, possibleValues[2]);
                        switch (choice) {
                            case 1: {
                                saveThisFile = true;
                                break;
                            }
                            case 0: {
                                saveForever = true;
                                break;
                            }
                            case 3: {
                                skipForever = true;
                                saveThisFile = false;
                                break;
                            }
                            default: {
                                saveThisFile = false;
                            }
                        }
                    }
                    if (directoryExists) {
                        if (saveForever || saveThisFile) {
                            boolean imported = AbstractMFImportStep4.this.doImport((File)AbstractMFImportStep4.this.files[f]);
                            if (!imported) {
                                AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportFailed"));
                                ++failedImports;
                            } else {
                                TranscriptionStore store = ACMTranscriptionStore.getCurrentTranscriptionStore();
                                int saveAsType = SaveAs27Preferences.saveAsTypeWithCheck(AbstractMFImportStep4.this.transImpl);
                                store.storeTranscription(AbstractMFImportStep4.this.transImpl, null, null, newfileName, saveAsType);
                                if (fileExists) {
                                    AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.FileOverWrite"));
                                }
                                AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportSucceed"));
                            }
                        } else {
                            AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.FileExits"));
                            AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ImportFailed"));
                            ++refusedImports;
                        }
                    } else {
                        ++failedImports;
                    }
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not handle file: " + fileName + "\n" + ex.getMessage());
                    AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.ExceptionOccured") + "\n" + ex.getMessage());
                }
                if (f + 1 < AbstractMFImportStep4.this.files.length) {
                    AbstractMFImportStep4.this.progressUpdated(AbstractMFImportStep4.this, Math.round((float)(100 * (f + 1)) / (float)AbstractMFImportStep4.this.files.length), null);
                }
                AbstractMFImportStep4.this.report("\n");
            }
            String msg = AbstractMFImportStep4.this.files.length - failedImports - refusedImports + " " + ElanLocale.getString("ExportTiersDialog.Message.OutOf") + " " + AbstractMFImportStep4.this.files.length + " " + ElanLocale.getString("MultiFileImport.Report.Msg.Success");
            if (refusedImports > 0) {
                msg = msg + "\n" + refusedImports + " " + ElanLocale.getString("MultiFileImport.Report.Msg.RefusedImports");
            }
            if (failedImports > 0) {
                msg = msg + "\n" + failedImports + " " + ElanLocale.getString("MultiFileImport.Report.Msg.FaliedImports");
            }
            AbstractMFImportStep4.this.report(ElanLocale.getString("MultiFileImport.Report.Summary"));
            AbstractMFImportStep4.this.report("\n" + msg);
            AbstractMFImportStep4.this.progressCompleted(AbstractMFImportStep4.this, ElanLocale.getString("MultiFileImport.Step4.ImportFinished"));
            new ReportDialog(AbstractMFImportStep4.this.report).setVisible(true);
        }
    }
}

