/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.multiplefiles;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.ShoeboxMarkerDialog;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.imports.multiplefiles.AbstractMFImportStep2;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxDecoderInfo2;
import nl.mpi.util.FileExtension;

public class MFToolboxImportStep2
extends AbstractMFImportStep2
implements ActionListener,
ItemListener {
    public static final String VALUE_PROPERTY = "value";
    public static final String TEXT_KEY = "TextFile";
    public static final String TYPE_KEY = "TypeFile";
    private JRadioButton typeRB;
    private JLabel typeLabel;
    private JTextField typField;
    private JButton typButton;
    private JRadioButton specRB;
    private JButton fieldSpecButton;
    private JLabel fieldSpecLabel;
    private JLabel intervalLabel;
    private JTextField intervalField;
    private JCheckBox timeInRefMarker;
    private JCheckBox allUnicodeCB;
    private JCheckBox calcCharBytesCB;
    private JCheckBox scrubOnImportCB;
    private final String INTERVAL_PREF = "ShoeboxChatBlockDuration";
    private List<MarkerRecord> markers = null;

    public MFToolboxImportStep2(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.typeRB = new JRadioButton();
        this.typeRB.setSelected(true);
        this.typeLabel = new JLabel(ElanLocale.getString("ImportDialog.Label.TypeToolbox"));
        this.typField = new JTextField("", 23);
        this.typButton = new JButton("...");
        this.specRB = new JRadioButton();
        this.fieldSpecButton = new JButton(ElanLocale.getString("ImportDialog.Button.FieldSpec"));
        this.fieldSpecButton.setEnabled(false);
        this.fieldSpecLabel = new JLabel("-");
        this.fieldSpecLabel.setFont(this.fieldSpecLabel.getFont().deriveFont(10.0f));
        this.allUnicodeCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.AllUnicode"));
        this.allUnicodeCB.setSelected(true);
        this.calcCharBytesCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.CorrectForBytesPerChar"));
        this.calcCharBytesCB.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.typeRB);
        buttonGroup.add(this.specRB);
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.typeRB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.typeLabel, gbc);
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.typField, gbc);
        gbc.gridx = 3;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.typButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.add((Component)this.specRB, gbc);
        gbc.gridx = 1;
        this.add((Component)this.fieldSpecButton, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 2;
        this.add((Component)this.fieldSpecLabel, gbc);
        gbc.gridx = 1;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.add((Component)this.allUnicodeCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.calcCharBytesCB, gbc);
        this.intervalLabel = new JLabel(ElanLocale.getString("ImportDialog.Label.BlockDuration"));
        this.intervalField = new JTextField();
        Integer intPref = Preferences.getInt("ShoeboxChatBlockDuration", null);
        if (intPref != null) {
            this.intervalField.setText(String.valueOf(intPref));
        } else {
            this.intervalField.setText(String.valueOf(1000));
        }
        this.timeInRefMarker = new JCheckBox(ElanLocale.getString("ImportDialog.Label.TimeInRefMarker"));
        this.scrubOnImportCB = new JCheckBox(ElanLocale.getString("ImportDialog.Label.ScrubAnnotations"));
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        optionsPanel.add((Component)new JLabel(ElanLocale.getString("ImportDialog.Label.Options")), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 10, 4, 6);
        optionsPanel.add((Component)this.intervalLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        optionsPanel.add((Component)this.intervalField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        optionsPanel.add((Component)this.timeInRefMarker, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        optionsPanel.add((Component)this.scrubOnImportCB, gridBagConstraints);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 4;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 6, 10, 6);
        this.add((Component)optionsPanel, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
        this.setShoeboxMarkerRB();
        this.loadPreferences();
        this.typeRB.addItemListener(this);
        this.specRB.addItemListener(this);
        this.typButton.addActionListener(this);
        this.fieldSpecButton.addActionListener(this);
    }

    private void setShoeboxMarkerRB() {
        Boolean boolPref = Preferences.getBool("LastUsedShoeboxImportWithType", null);
        if (boolPref != null && !boolPref.booleanValue()) {
            this.specRB.setSelected(true);
            this.typButton.setEnabled(false);
            this.fieldSpecButton.setEnabled(true);
            this.allUnicodeCB.setEnabled(true);
            this.preloadMarkers();
        } else {
            this.typeRB.setSelected(true);
            String luTypFile = Preferences.getString("LastUsedShoeboxTypFile", null);
            if (luTypFile != null) {
                this.typField.setText(luTypFile);
            }
            this.typButton.setEnabled(true);
            this.allUnicodeCB.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadMarkers() {
        String markerFile = Preferences.getString("LastUsedShoeboxMarkerFile", null);
        if (markerFile != null) {
            File f = new File(markerFile);
            if (!f.exists()) {
                return;
            }
            String line = null;
            this.markers = new ArrayList<MarkerRecord>();
            FileReader filereader = null;
            BufferedReader br = null;
            try {
                filereader = new FileReader(f);
                br = new BufferedReader(filereader);
                MarkerRecord newRecord = null;
                while ((line = br.readLine()) != null) {
                    String label = this.getLabelPart(line = line.trim());
                    if (label == null) continue;
                    String value = this.getValuePart(line);
                    if (label.equals("marker")) {
                        newRecord = new MarkerRecord();
                        if (value.equals("null")) continue;
                        newRecord.setMarker(value);
                        continue;
                    }
                    if (newRecord == null) continue;
                    if (label.equals("parent")) {
                        if (value.equals("null")) continue;
                        newRecord.setParentMarker(value);
                        continue;
                    }
                    if (label.equals("stereotype")) {
                        if (value.equals("null")) continue;
                        newRecord.setStereoType(value);
                        continue;
                    }
                    if (label.equals("charset")) {
                        if (value.equals("null")) continue;
                        newRecord.setCharset(value);
                        continue;
                    }
                    if (label.equals("exclude")) {
                        if (value.equals("null")) continue;
                        if (value.equals("true")) {
                            newRecord.setExcluded(true);
                            continue;
                        }
                        newRecord.setExcluded(false);
                        continue;
                    }
                    if (!label.equals("participant")) continue;
                    if (!value.equals("null")) {
                        if (value.equals("true")) {
                            newRecord.setParticipantMarker(true);
                        } else {
                            newRecord.setParticipantMarker(false);
                        }
                    }
                    if ("ELANBegin".equals(newRecord.getMarker()) || "ELANEnd".equals(newRecord.getMarker()) || "ELANParticipant".equals(newRecord.getMarker())) continue;
                    this.markers.add(newRecord);
                }
                this.fieldSpecLabel.setText(markerFile);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (filereader != null) {
                        filereader.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getLabelPart(String theLine) {
        String label = null;
        int index = theLine.indexOf(58);
        if (index > 0) {
            label = theLine.substring(0, index);
        }
        return label;
    }

    private String getValuePart(String theLine) {
        String value = null;
        int index = theLine.indexOf(58);
        if (index < theLine.length() - 2) {
            value = theLine.substring(index + 1).trim();
        }
        return value;
    }

    private void loadPreferences() {
        Boolean val = Preferences.getBool("ToolboxImport.AllUnicode", null);
        if (val != null) {
            this.allUnicodeCB.setSelected(val);
        }
        if ((val = Preferences.getBool("ToolboxImport.TimeInRefMarker", null)) != null) {
            this.timeInRefMarker.setSelected(val);
        }
        if ((val = Preferences.getBool("ToolboxImport.CalcForCharBytes", null)) != null) {
            this.calcCharBytesCB.setSelected(val);
        }
        if ((val = Preferences.getBool("ToolboxImport.ScrubAnnotations", null)) != null) {
            this.scrubOnImportCB.setSelected(val);
        }
    }

    private void savePreferences() {
        Preferences.set("ToolboxImport.AllUnicode", this.allUnicodeCB.isSelected(), null);
        Preferences.set("ToolboxImport.TimeInRefMarker", this.timeInRefMarker.isSelected(), null);
        Preferences.set("ToolboxImport.CalcForCharBytes", this.calcCharBytesCB.isSelected(), null);
        Preferences.set("ToolboxImport.ScrubAnnotations", this.scrubOnImportCB.isSelected(), null);
    }

    @Override
    public boolean leaveStepForward() {
        String typPath = null;
        if (this.typField.getText() != null) {
            typPath = this.typField.getText().trim();
        }
        if (this.typeRB.isSelected()) {
            if (typPath == null || typPath.length() == 0) {
                this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyType"));
                return false;
            }
            if (!new File(typPath).exists()) {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoType"));
                return false;
            }
        } else if (this.markers == null || this.markers.size() == 0) {
            this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyMarkers"));
            return false;
        }
        int durVal = 1000;
        if (this.intervalField != null) {
            String dur = this.intervalField.getText();
            try {
                durVal = Integer.parseInt(dur);
                Preferences.set("ShoeboxChatBlockDuration", durVal, null);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.savePreferences();
        ToolboxDecoderInfo2 decInfo = new ToolboxDecoderInfo2(null);
        decInfo.setBlockDuration(durVal);
        if (this.typeRB.isSelected()) {
            decInfo.setTypeFile(typPath);
            decInfo.setAllUnicode(this.allUnicodeCB.isSelected());
        } else {
            decInfo.setShoeboxMarkers(this.markers);
            decInfo.setAllUnicode(this.allUnicodeCB.isSelected());
        }
        decInfo.setTimeInRefMarker(this.timeInRefMarker.isSelected());
        decInfo.setRecalculateForCharBytes(this.calcCharBytesCB.isSelected());
        decInfo.setScrubAnnotations(this.scrubOnImportCB.isSelected());
        this.multiPane.putStepProperty("ToolboxDecoderInfo", decInfo);
        return true;
    }

    private void chooseTyp() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_TYP_EXT, false, "LastUsedShoeboxTypDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.typField.setText(f.getAbsolutePath());
            Preferences.set("LastUsedShoeboxTypFile", f.getAbsolutePath(), null);
            Preferences.set("LastUsedShoeboxImportWithType", Boolean.TRUE, null);
        }
    }

    private void specifyFieldSpecs() {
        ShoeboxMarkerDialog smd = new ShoeboxMarkerDialog(null, true, true);
        smd.setVisible(true);
        this.markers = smd.getValue();
        Preferences.set("LastUsedShoeboxImportWithType", Boolean.FALSE, null);
        String markerFile = Preferences.getString("LastUsedShoeboxMarkerFile", null);
        if (markerFile != null) {
            this.fieldSpecLabel.setText(markerFile);
        }
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Error"), 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.typButton) {
            this.chooseTyp();
        } else if (source == this.fieldSpecButton) {
            this.specifyFieldSpecs();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.typeRB && e.getStateChange() == 1) {
            this.typeLabel.setEnabled(true);
            this.typButton.setEnabled(true);
            this.typField.setEnabled(true);
            this.allUnicodeCB.setEnabled(true);
            this.fieldSpecButton.setEnabled(false);
            this.markers = null;
            if (this.typField.getText() == null || this.typField.getText().length() == 0) {
                this.typButton.doClick(200);
            }
        } else if (e.getSource() == this.specRB && e.getStateChange() == 1) {
            this.typeLabel.setEnabled(false);
            this.typButton.setEnabled(false);
            this.typField.setEnabled(false);
            this.fieldSpecButton.setEnabled(true);
            this.fieldSpecButton.doClick(200);
        }
    }
}

