/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.praat;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import nl.mpi.util.FileExtension;

public class ImportPraatTGStep1
extends StepPane
implements ActionListener,
ChangeListener {
    private JTextField sourceField;
    private JButton browseButton;
    private JCheckBox pointTiersCB;
    private JSpinner durationSp;
    private JLabel durationLabel;
    private JCheckBox skipEmptyCB;
    private final Integer DEF_DUR = 40;
    private String encoding;

    public ImportPraatTGStep1(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.sourceField = new JTextField();
        this.sourceField.setEditable(false);
        this.browseButton = new JButton(ElanLocale.getString("Button.Browse"));
        this.pointTiersCB = new JCheckBox(ElanLocale.getString("ImportDialog.Praat.Label.PointTiers"));
        this.durationSp = new JSpinner(new SpinnerNumberModel(this.DEF_DUR, 1, 10000, 10));
        this.durationSp.setEnabled(false);
        this.durationLabel = new JLabel(ElanLocale.getString("ImportDialog.Praat.Label.PointDuration"));
        this.durationLabel.setEnabled(false);
        this.skipEmptyCB = new JCheckBox(ElanLocale.getString("ImportDialog.Praat.Label.SkipEmpty"));
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.insets = insets;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.sourceField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.browseButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(20, 6, 4, 6);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.pointTiersCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.durationSp, gbc);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)this.durationLabel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.skipEmptyCB, gbc);
        this.browseButton.addActionListener(this);
        this.pointTiersCB.addChangeListener(this);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ImportDialog.Praat.Title1");
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(4, true);
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("Source", this.sourceField.getText());
        this.multiPane.putStepProperty("Encoding", this.encoding);
        if (this.pointTiersCB.isSelected()) {
            this.multiPane.putStepProperty("PointTier", Boolean.TRUE);
            System.out.println(this.durationSp.getValue().getClass().getName());
            this.multiPane.putStepProperty("PointDuration", this.durationSp.getValue() != null ? this.durationSp.getValue() : this.DEF_DUR);
        }
        if (this.skipEmptyCB.isSelected()) {
            this.multiPane.putStepProperty("SkipEmpty", Boolean.TRUE);
        } else {
            this.multiPane.putStepProperty("SkipEmpty", Boolean.FALSE);
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = this.getFileName();
        if (file != null) {
            this.sourceField.setText(file.getAbsolutePath());
            this.multiPane.setButtonEnabled(1, true);
        }
    }

    private File getFileName() {
        FileChooser chooser = new FileChooser(null);
        String[] encodings = new String[]{ElanLocale.getString("Button.Default"), "UTF-8", "UTF-16"};
        chooser.createAndShowFileAndEncodingDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, null, FileExtension.PRAAT_TEXTGRID_EXT, "LastUsedPraatDir", encodings, "UTF-8", null);
        this.encoding = chooser.getSelectedEncoding();
        return chooser.getSelectedFile();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.durationSp.setEnabled(this.pointTiersCB.isSelected());
        this.durationLabel.setEnabled(this.pointTiersCB.isSelected());
    }
}

