/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.integration;

import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IMDISessionParser {
    public static final String EAF = "text/x-eaf+xml";
    private SAXParser parser;
    private HashMap<String, String> filesMap = new HashMap(3);

    public IMDISessionParser() throws SAXException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            parserFactory.setNamespaceAware(true);
            this.parser = parserFactory.newSAXParser();
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce);
        }
    }

    public void parse(String pathToImdiSession) throws IOException, SAXException {
        if (pathToImdiSession == null) {
            return;
        }
        this.parser.parse(pathToImdiSession, (DefaultHandler)new SessionHandler());
    }

    public HashMap<String, String> getFilesMap() {
        return this.filesMap;
    }

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            try {
                new IMDISessionParser().parse(args[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class SessionHandler
    extends DefaultHandler {
        private final String MF = "MediaFile";
        private final String WRITTEN_RES = "WrittenResource";
        private final String LINK = "ResourceLink";
        private final String TYPE = "Type";
        private final String FORMAT = "Format";
        private final String VIDEO = "video";
        private final String AUDIO = "audio";
        private String curResLink;
        private String curContent;
        private String curFormat;
        private String curType;

        SessionHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.curContent = new String(ch, start, length);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("Type")) {
                this.curType = this.curContent;
            } else if (localName.equals("Format")) {
                this.curFormat = this.curContent;
            } else if (localName.equals("ResourceLink")) {
                this.curResLink = this.curContent;
            } else if (localName.equals("WrittenResource")) {
                if (this.curFormat.equalsIgnoreCase(IMDISessionParser.EAF) && !IMDISessionParser.this.filesMap.containsKey(IMDISessionParser.EAF) && this.curResLink != null && this.curResLink.length() > 0) {
                    IMDISessionParser.this.filesMap.put(IMDISessionParser.EAF, this.curResLink);
                }
                this.resetFields();
            } else if (localName.equals("MediaFile")) {
                if (this.curType.equalsIgnoreCase("video")) {
                    if (!IMDISessionParser.this.filesMap.containsKey("video") && this.curResLink != null && this.curResLink.length() > 0) {
                        IMDISessionParser.this.filesMap.put("video", this.curResLink);
                    }
                } else if (this.curType.equalsIgnoreCase("audio") && !IMDISessionParser.this.filesMap.containsKey("audio") && this.curResLink != null && this.curResLink.length() > 0) {
                    IMDISessionParser.this.filesMap.put("audio", this.curResLink);
                }
                this.resetFields();
            }
        }

        void resetFields() {
            this.curResLink = null;
            this.curContent = null;
            this.curFormat = null;
            this.curType = null;
        }
    }
}

