/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.interannotator.CompareUnit;
import mpi.eudico.client.annotator.tier.AnnotatorCompareUtil;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class AnnotatorCompareUtil2
extends AnnotatorCompareUtil {
    public double getAverageRatio(CompareCombi compareCombi) {
        int j;
        if (compareCombi == null) {
            return 0.0;
        }
        CompareUnit cu1 = compareCombi.getFirstUnit();
        CompareUnit cu2 = compareCombi.getSecondUnit();
        int numAnn1 = cu1.annotations.size();
        int numAnn2 = cu2.annotations.size();
        double totalRatio = 0.0;
        int itemCount = 0;
        AnnotationCore aa1 = null;
        AnnotationCore aa2 = null;
        int lastInserted2 = -1;
        ArrayList<AnnotationCore> overlapList = new ArrayList<AnnotationCore>(5);
        ArrayList<AnnotationCore> addedList2 = new ArrayList<AnnotationCore>(numAnn2);
        for (int i = 0; i < numAnn1; ++i) {
            long et2;
            long bt2;
            overlapList.clear();
            aa1 = cu1.annotations.get(i);
            long bt1 = aa1.getBeginTimeBoundary();
            long et1 = aa1.getEndTimeBoundary();
            for (j = lastInserted2 + 1; j < numAnn2; ++j) {
                aa2 = cu2.annotations.get(j);
                bt2 = aa2.getBeginTimeBoundary();
                if (this.overlaps(bt1, et1, bt2, et2 = aa2.getEndTimeBoundary())) {
                    if (addedList2.contains(aa2)) continue;
                    overlapList.add(aa2);
                    continue;
                }
                if (bt2 <= et1) continue;
                lastInserted2 = j - 1 - overlapList.size();
                break;
            }
            if (overlapList.size() != 0) {
                if (overlapList.size() == 1) {
                    aa2 = (AnnotationCore)overlapList.get(0);
                    bt2 = aa2.getBeginTimeBoundary();
                    et2 = aa2.getEndTimeBoundary();
                    long ov = this.calcOverlap(bt1, et1, bt2, et2);
                    long te = this.calcExtent(bt1, et1, bt2, et2);
                    totalRatio += (double)ov / (double)te;
                    addedList2.add(aa2);
                } else {
                    long lov = 0L;
                    int indexLov = 0;
                    for (int j2 = 0; j2 < overlapList.size(); ++j2) {
                        aa2 = (AnnotationCore)overlapList.get(j2);
                        long ov = this.calcOverlap(bt1, et1, aa2.getBeginTimeBoundary(), aa2.getEndTimeBoundary());
                        if (ov <= lov) continue;
                        lov = ov;
                        indexLov = j2;
                    }
                    aa2 = (AnnotationCore)overlapList.get(indexLov);
                    bt2 = aa2.getBeginTimeBoundary();
                    et2 = aa2.getEndTimeBoundary();
                    long te = this.calcExtent(bt1, et1, bt2, et2);
                    totalRatio += (double)lov / (double)te;
                    addedList2.add(aa2);
                }
            }
            ++itemCount;
        }
        for (j = 0; j < numAnn2; ++j) {
            aa2 = cu2.annotations.get(j);
            if (addedList2.contains(aa2)) continue;
            ++itemCount;
        }
        if (itemCount != 0) {
            return totalRatio / (double)itemCount;
        }
        return 0.0;
    }

    public Map<AnnotationCore, AnnotationCore> matchAnnotations(CompareCombi compareCombi) {
        if (compareCombi == null) {
            return null;
        }
        return this.matchAnnotations(compareCombi, 0.0);
    }

    public Map<AnnotationCore, AnnotationCore> matchAnnotations(CompareCombi compareCombi, double minimalOverlapPercentage) {
        if (compareCombi == null) {
            return null;
        }
        CompareUnit cu1 = compareCombi.getFirstUnit();
        CompareUnit cu2 = compareCombi.getSecondUnit();
        int numAnn1 = cu1.annotations.size();
        int numAnn2 = cu2.annotations.size();
        AnnotationCore aa1 = null;
        AnnotationCore aa2 = null;
        int lastInserted2 = 0;
        ArrayList<OverlapPair> allOverlaps = new ArrayList<OverlapPair>();
        ArrayList<AnnotationCore> overlapList = new ArrayList<AnnotationCore>(5);
        block0: for (int i = 0; i < numAnn1; ++i) {
            overlapList.clear();
            aa1 = cu1.annotations.get(i);
            long bt1 = aa1.getBeginTimeBoundary();
            long et1 = aa1.getEndTimeBoundary();
            for (int j = lastInserted2; j < numAnn2; ++j) {
                long et2;
                aa2 = cu2.annotations.get(j);
                long bt2 = aa2.getBeginTimeBoundary();
                if (this.overlaps(bt1, et1, bt2, et2 = aa2.getEndTimeBoundary())) {
                    double percentage = this.calculateOverlapPercentage(bt1, et1, bt2, et2);
                    if (!(percentage >= minimalOverlapPercentage)) continue;
                    long overlap = this.calcOverlap(bt1, et1, bt2, et2);
                    allOverlaps.add(new OverlapPair(aa1, aa2, percentage, overlap));
                    overlapList.add(aa2);
                    continue;
                }
                if (bt2 < et1) continue;
                lastInserted2 = j - 1 - overlapList.size();
                if (lastInserted2 >= 0) continue block0;
                lastInserted2 = 0;
                continue block0;
            }
        }
        HashMap<AnnotationCore, AnnotationCore> matchedAnnotations = new HashMap<AnnotationCore, AnnotationCore>();
        ArrayList<OverlapPair> curGroup = new ArrayList<OverlapPair>();
        Collections.sort(allOverlaps);
        while (allOverlaps.size() > 0) {
            OverlapPair op1 = (OverlapPair)allOverlaps.get(allOverlaps.size() - 1);
            if (op1.percentage == 1.0) {
                matchedAnnotations.put(op1.ac1, op1.ac2);
                allOverlaps.remove(op1);
                continue;
            }
            if (matchedAnnotations.containsKey(op1.ac1) || matchedAnnotations.containsValue(op1.ac2)) {
                allOverlaps.remove(op1);
                continue;
            }
            curGroup.clear();
            curGroup.add(op1);
            for (int i = allOverlaps.size() - 2; i >= 0; --i) {
                OverlapPair op2 = (OverlapPair)allOverlaps.get(i);
                if (op2.percentage != op1.percentage) break;
                if (matchedAnnotations.containsKey(op2.ac1) || matchedAnnotations.containsValue(op2.ac2) || op2.ac1 != op1.ac1 && op2.ac2 != op1.ac2) continue;
                curGroup.add(op2);
            }
            if (curGroup.size() == 1) {
                matchedAnnotations.put(op1.ac1, op1.ac2);
                allOverlaps.remove(op1);
                continue;
            }
            OverlapPair bestCandidate = op1;
            OverlapPair iterOP = null;
            for (int k = curGroup.size() - 1; k >= 0; --k) {
                long minST;
                iterOP = (OverlapPair)curGroup.get(k);
                if (iterOP.rawOverlap > bestCandidate.rawOverlap) {
                    bestCandidate = iterOP;
                    continue;
                }
                if (iterOP.rawOverlap != bestCandidate.rawOverlap || (minST = Math.min(iterOP.ac1.getBeginTimeBoundary(), iterOP.ac2.getBeginTimeBoundary())) >= bestCandidate.ac1.getBeginTimeBoundary() && minST >= bestCandidate.ac2.getBeginTimeBoundary()) continue;
                bestCandidate = iterOP;
            }
            matchedAnnotations.put(op1.ac1, op1.ac2);
            allOverlaps.remove(op1);
        }
        return matchedAnnotations;
    }

    public double calculateOverlapPercentage(long bt1, long et1, long bt2, long et2) {
        return (double)(Math.min(et1, et2) - Math.max(bt1, bt2)) / (double)Math.max(et1 - bt1, et2 - bt2);
    }

    private class OverlapPair
    implements Comparable<OverlapPair> {
        AnnotationCore ac1;
        AnnotationCore ac2;
        double percentage;
        long rawOverlap;

        public OverlapPair(AnnotationCore ac1, AnnotationCore ac2, double percentage, long rawOverlap) {
            this.ac1 = ac1;
            this.ac2 = ac2;
            this.percentage = percentage;
            this.rawOverlap = rawOverlap;
        }

        @Override
        public int compareTo(OverlapPair op) {
            if (op.percentage > this.percentage) {
                return -1;
            }
            if (op.percentage < this.percentage) {
                return 1;
            }
            if (op.rawOverlap > this.rawOverlap) {
                return -1;
            }
            if (op.rawOverlap < this.rawOverlap) {
                return 1;
            }
            return 0;
        }
    }
}

