/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import mpi.eudico.client.annotator.interannotator.CompareUnit;

public class CompareCombi {
    private CompareUnit firstUnit;
    private CompareUnit secondUnit;
    private double overallAgreement;
    private Map<String, Double> perValueAgreement;

    public CompareCombi(CompareUnit firstUnit, CompareUnit secondUnit) {
        this.firstUnit = firstUnit;
        this.secondUnit = secondUnit;
        this.overallAgreement = 0.0;
        this.perValueAgreement = new HashMap<String, Double>();
    }

    public CompareUnit getFirstUnit() {
        return this.firstUnit;
    }

    public CompareUnit getSecondUnit() {
        return this.secondUnit;
    }

    public Map<String, Double> getPerValueAgreement() {
        return this.perValueAgreement;
    }

    public void setPerValueAgreement(Map<String, Double> perValueAgreement) {
        this.perValueAgreement = perValueAgreement;
    }

    public void addAgreementForValue(String value, double agreement) {
        if (this.perValueAgreement == null) {
            this.perValueAgreement = new HashMap<String, Double>();
        }
        this.perValueAgreement.put(value, agreement);
    }

    public double getAgreementForValue(String value) {
        Double ag;
        if (this.perValueAgreement != null && (ag = this.perValueAgreement.get(value)) != null) {
            return ag;
        }
        return 0.0;
    }

    public double getOverallAgreement() {
        return this.overallAgreement;
    }

    public void setOverallAgreement(double overallAgreement) {
        this.overallAgreement = overallAgreement;
    }

    public void calculateOverallAgreement() {
        if (this.perValueAgreement != null) {
            int count = this.perValueAgreement.size();
            if (count == 0) {
                return;
            }
            double aTotal = 0.0;
            Iterator<Double> valueIterator = this.perValueAgreement.values().iterator();
            while (valueIterator.hasNext()) {
                aTotal += valueIterator.next().doubleValue();
            }
            this.overallAgreement = aTotal / (double)count;
        }
    }
}

