/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import mpi.eudico.client.annotator.interannotator.CompareCombi;

public class CompareResultWriter {
    final String TAB = "\t";
    final String NL = "\n";
    final String NL2 = "\n\n";

    public void writeResults(List<CompareCombi> resultList, File outputFile, String encoding) throws IOException {
        if (resultList == null) {
            throw new NullPointerException("There are no results to save.");
        }
        if (outputFile == null) {
            throw new IOException("There is no file location specified.");
        }
        if (encoding == null) {
            encoding = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            FileOutputStream out = new FileOutputStream(outputFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            DecimalFormat decFormat = new DecimalFormat("#0.0000", new DecimalFormatSymbols(Locale.US));
            writer.write(String.format("Output created: %tD %<tT", Calendar.getInstance()));
            writer.write("\n\n");
            writer.write("Number of pairs of tiers in the comparison: " + resultList.size());
            writer.write("\n\n");
            int totalCount = 0;
            double totalAgr = 0.0;
            for (CompareCombi cc : resultList) {
                if (cc.getPerValueAgreement() == null || cc.getPerValueAgreement().size() == 0) {
                    writer.write("File 1: " + cc.getFirstUnit().fileName + " Tier 1: " + cc.getFirstUnit().tierName);
                    writer.write("\n");
                    writer.write("Number of annotations 1: " + cc.getFirstUnit().annotations.size());
                    writer.write("\n");
                    writer.write("File 2: " + cc.getSecondUnit().fileName + " Tier 2: " + cc.getSecondUnit().tierName);
                    writer.write("\n");
                    writer.write("Number of annotations 2: " + cc.getSecondUnit().annotations.size());
                    writer.write("\n");
                    writer.write("Agreement: " + decFormat.format(cc.getOverallAgreement()));
                    writer.write("\n\n");
                }
                ++totalCount;
                totalAgr += cc.getOverallAgreement();
            }
            if (totalCount > 0) {
                writer.write("Average agreement: " + decFormat.format(totalAgr / (double)totalCount));
            } else {
                writer.write("There is no overall average agreement avaialable: no tier combinations found.");
            }
        }
        catch (Exception ex) {
            throw new IOException("Cannot write to file: " + ex.getMessage());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

