/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;

public class DocumenSelectionStep
extends StepPane {
    private Transcription transcription;
    private static final long serialVersionUID = 1L;
    private JPanel documentPanel;
    private JPanel matchingPanel;
    private JLabel locationLabel;
    private JLabel matchingLabel;
    private TitledBorder border;
    private JRadioButton currentDocumentRB;
    private JRadioButton singleFileRB;
    private JRadioButton multipleFileRB;
    private JRadioButton manualSelectRB;
    private JRadioButton affixBasedRB;
    private JRadioButton sameNameRB;

    public DocumenSelectionStep(MultiStepPane wizard, Transcription transcription) {
        super(wizard);
        this.transcription = transcription;
        this.setName("CompareAnnotatorsDialog.DocumentSelectionStep");
        this.createPanel();
    }

    private void setInitialButtonState() {
        if (this.transcription == null) {
            this.currentDocumentRB.setEnabled(false);
            this.singleFileRB.setSelected(true);
        } else {
            this.currentDocumentRB.setEnabled(true);
            this.currentDocumentRB.setSelected(true);
        }
        this.sameNameRB.setEnabled(false);
    }

    private void loadPreferences() {
        String prefTierSource = Preferences.getString("Compare.TierSource", null);
        String prefTierMatch = Preferences.getString("Compare.TierMatching", null);
        if (this.transcription == null) {
            if (prefTierSource != null && CompareConstants.FILE_MATCHING.ACROSS_FILES.value.equals(prefTierSource)) {
                this.multipleFileRB.setSelected(true);
            }
        } else if (prefTierSource != null) {
            if (CompareConstants.FILE_MATCHING.CURRENT_DOC.value.equals(prefTierSource)) {
                this.currentDocumentRB.setSelected(true);
            } else if (CompareConstants.FILE_MATCHING.IN_SAME_FILE.value.equals(prefTierSource)) {
                this.singleFileRB.setSelected(true);
            } else if (CompareConstants.FILE_MATCHING.ACROSS_FILES.value.equals(prefTierSource)) {
                this.multipleFileRB.setSelected(true);
            }
        }
        this.setStateOnRadioButtonEvent();
        if (prefTierMatch != null) {
            if (CompareConstants.MATCHING.MANUAL.value.equals(prefTierMatch)) {
                this.manualSelectRB.setSelected(true);
            } else if (CompareConstants.MATCHING.AFFIX.value.equals(prefTierMatch)) {
                this.affixBasedRB.setSelected(true);
            } else if (CompareConstants.MATCHING.SAME_NAME.value.equals(prefTierMatch) && this.sameNameRB.isEnabled()) {
                this.sameNameRB.setSelected(true);
            }
        }
    }

    private void setStateOnRadioButtonEvent() {
        if (this.currentDocumentRB.isSelected()) {
            this.sameNameRB.setEnabled(false);
            if (this.sameNameRB.isSelected()) {
                this.manualSelectRB.setSelected(true);
            }
        } else if (this.singleFileRB.isSelected()) {
            this.sameNameRB.setEnabled(false);
            if (this.sameNameRB.isSelected()) {
                this.manualSelectRB.setSelected(true);
            }
        } else if (this.multipleFileRB.isSelected()) {
            this.sameNameRB.setEnabled(true);
        }
    }

    public void updateLocale() {
        this.border.setTitle(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.Hint"));
        this.locationLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.TierLocation"));
        this.currentDocumentRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.CurrentDocumentRB"));
        this.singleFileRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.SingleFileRB"));
        this.multipleFileRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.MultipleFileRB"));
        this.matchingLabel.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.TierMatching"));
        this.manualSelectRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.ManualMatching"));
        this.affixBasedRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.AffixBased"));
        this.sameNameRB.setText(ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.SameName"));
    }

    public void createPanel() {
        this.border = new TitledBorder("");
        this.locationLabel = new JLabel();
        this.currentDocumentRB = new JRadioButton();
        this.singleFileRB = new JRadioButton();
        this.multipleFileRB = new JRadioButton();
        this.matchingLabel = new JLabel();
        this.manualSelectRB = new JRadioButton();
        this.manualSelectRB.setSelected(true);
        this.affixBasedRB = new JRadioButton();
        this.sameNameRB = new JRadioButton();
        this.updateLocale();
        this.setInitialButtonState();
        RadioButtonListener radioButtonListener = new RadioButtonListener();
        this.currentDocumentRB.addActionListener(radioButtonListener);
        this.singleFileRB.addActionListener(radioButtonListener);
        this.multipleFileRB.addActionListener(radioButtonListener);
        ButtonGroup documentButtonGroup = new ButtonGroup();
        documentButtonGroup.add(this.currentDocumentRB);
        documentButtonGroup.add(this.singleFileRB);
        documentButtonGroup.add(this.multipleFileRB);
        this.documentPanel = new JPanel(new GridBagLayout());
        this.documentPanel.setBorder(this.border);
        Insets globalInset = new Insets(5, 10, 5, 10);
        Insets singleTabInset = new Insets(0, 30, 0, 10);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = globalInset;
        this.documentPanel.add((Component)this.locationLabel, gbc);
        gbc.gridy = 1;
        gbc.insets = singleTabInset;
        this.documentPanel.add((Component)this.currentDocumentRB, gbc);
        gbc.gridy = 2;
        this.documentPanel.add((Component)this.singleFileRB, gbc);
        gbc.gridy = 3;
        this.documentPanel.add((Component)this.multipleFileRB, gbc);
        this.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets = globalInset;
        gbc.fill = 1;
        this.add((Component)this.documentPanel, gbc);
        this.matchingPanel = new JPanel(new GridBagLayout());
        ButtonGroup matchGroup = new ButtonGroup();
        matchGroup.add(this.manualSelectRB);
        matchGroup.add(this.affixBasedRB);
        matchGroup.add(this.sameNameRB);
        GridBagConstraints mgbc = new GridBagConstraints();
        Insets mgbcInsets = new Insets(5, 0, 5, 10);
        mgbc.anchor = 18;
        mgbc.fill = 2;
        mgbc.insets = mgbcInsets;
        mgbc.weightx = 1.0;
        this.matchingPanel.add((Component)this.matchingLabel, mgbc);
        mgbc.gridy = 1;
        mgbc.insets = new Insets(0, 20, 0, 10);
        this.matchingPanel.add((Component)this.manualSelectRB, mgbc);
        mgbc.gridy = 2;
        this.matchingPanel.add((Component)this.affixBasedRB, mgbc);
        mgbc.gridy = 3;
        this.matchingPanel.add((Component)this.sameNameRB, mgbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridheight = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.insets = new Insets(15, 10, 5, 10);
        this.documentPanel.add((Component)this.matchingPanel, gbc);
        gbc.gridy = 5;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.documentPanel.add((Component)new JPanel(), gbc);
        this.loadPreferences();
    }

    @Override
    public void enterStepForward() {
        this.multiPane.setButtonEnabled(1, true);
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(3, false);
    }

    @Override
    public boolean leaveStepForward() {
        CompareConstants.MATCHING curTierMatch;
        if (this.transcription != null) {
            if (this.currentDocumentRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSource", (Object)CompareConstants.FILE_MATCHING.CURRENT_DOC);
            } else if (this.singleFileRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSource", (Object)CompareConstants.FILE_MATCHING.IN_SAME_FILE);
            } else if (this.multipleFileRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSource", (Object)CompareConstants.FILE_MATCHING.ACROSS_FILES);
            }
        } else {
            if (this.currentDocumentRB.isSelected()) {
                ClientLogger.LOG.warning("Cannot proceed to the next step when \"current\" is selected and there's no transcription loaded.");
                return false;
            }
            if (this.singleFileRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSource", (Object)CompareConstants.FILE_MATCHING.IN_SAME_FILE);
            } else if (this.multipleFileRB.isSelected()) {
                this.multiPane.putStepProperty("Compare.TierSource", (Object)CompareConstants.FILE_MATCHING.ACROSS_FILES);
            }
        }
        if (this.manualSelectRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.TierMatching", (Object)CompareConstants.MATCHING.MANUAL);
        } else if (this.affixBasedRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.TierMatching", (Object)CompareConstants.MATCHING.AFFIX);
        } else if (this.sameNameRB.isSelected()) {
            this.multiPane.putStepProperty("Compare.TierMatching", (Object)CompareConstants.MATCHING.SAME_NAME);
        }
        CompareConstants.FILE_MATCHING curTierSource = (CompareConstants.FILE_MATCHING)((Object)this.multiPane.getStepProperty("Compare.TierSource"));
        if (curTierSource != null) {
            Preferences.set("Compare.TierSource", curTierSource.value, null);
        }
        if ((curTierMatch = (CompareConstants.MATCHING)((Object)this.multiPane.getStepProperty("Compare.TierMatching"))) != null) {
            Preferences.set("Compare.TierMatching", curTierMatch.value, null);
        }
        return true;
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.DocumentSelectionStep.Title");
    }

    private class RadioButtonListener
    implements ActionListener {
        private RadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumenSelectionStep.this.setStateOnRadioButtonEvent();
        }
    }
}

