/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.interannotator.CompareConstants;
import mpi.eudico.client.annotator.interannotator.TierAndFileMatcher;
import mpi.eudico.client.annotator.interannotator.TierLoader;
import mpi.eudico.client.annotator.tier.SelectableContentTableModel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.UneditableTableModel;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.EmptyStringComparator;

public class TiersSelectionStep
extends StepPane
implements ListSelectionListener,
TableModelListener {
    private TranscriptionImpl transcription;
    private static final long serialVersionUID = 1L;
    JTable table1;
    JTable table2;
    private JLabel hint1;
    private JLabel hint2;
    private CompareConstants.METHOD method;
    private CompareConstants.FILE_MATCHING tierSource;
    private CompareConstants.MATCHING tierMatching;
    private List<File> selFiles;
    private List<File> oldSelFiles;
    private List<String> allTierNames;
    private String tierCustomSeparator;
    private JPanel tierPanel;
    private JScrollPane table1ScrollPane;
    private JScrollPane table2ScrollPane;
    private TierAndFileMatcher tierMatcher;
    private boolean synchronousMode = false;
    private boolean groupCompareMode = false;

    public TiersSelectionStep(MultiStepPane wizard, TranscriptionImpl transcription) {
        super(wizard);
        this.transcription = transcription;
        this.setName("CompareAnnotatorsDialog.TierSelectionStep");
        this.allTierNames = new ArrayList<String>();
        this.tierMatcher = new TierAndFileMatcher();
        this.createPanel();
    }

    private void setStateFinish(boolean enable) {
        this.multiPane.setButtonEnabled(3, enable);
    }

    private void checkConditions() {
        CompareConstants.FILE_MATCHING oldTierSource = this.tierSource;
        CompareConstants.MATCHING oldTierMatching = this.tierMatching;
        boolean oldGroupCompare = this.groupCompareMode;
        if (this.selFiles != null) {
            this.oldSelFiles = new ArrayList<File>(this.selFiles);
        }
        this.method = (CompareConstants.METHOD)((Object)this.multiPane.getStepProperty("Compare.CompareMethod"));
        this.tierSource = (CompareConstants.FILE_MATCHING)((Object)this.multiPane.getStepProperty("Compare.TierSource"));
        this.tierMatching = (CompareConstants.MATCHING)((Object)this.multiPane.getStepProperty("Compare.TierMatching"));
        this.selFiles = (List)this.multiPane.getStepProperty("Compare.SelectedFiles");
        this.tierCustomSeparator = (String)this.multiPane.getStepProperty("Compare.TierSeparator");
        boolean bl = this.groupCompareMode = Boolean.TRUE == this.multiPane.getStepProperty("Compare.GroupWise");
        if (this.transcription == null && (this.selFiles == null || this.selFiles.isEmpty())) {
            this.setStateFinish(false);
        }
        boolean rebuildLayout = false;
        boolean reloadTiers = false;
        if (oldTierSource != this.tierSource) {
            rebuildLayout = true;
            if (oldTierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC && this.tierSource != CompareConstants.FILE_MATCHING.CURRENT_DOC || oldTierSource != CompareConstants.FILE_MATCHING.CURRENT_DOC && this.tierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
                reloadTiers = true;
            }
        }
        if (this.oldSelFiles == null && this.selFiles != null) {
            reloadTiers = true;
        } else if (this.oldSelFiles != null && this.selFiles == null) {
            reloadTiers = true;
        } else if (this.oldSelFiles != null && this.selFiles != null) {
            if (this.oldSelFiles.size() != this.selFiles.size()) {
                reloadTiers = true;
            } else {
                for (File f : this.oldSelFiles) {
                    if (this.selFiles.contains(f)) continue;
                    reloadTiers = true;
                    break;
                }
            }
        }
        if (oldTierMatching != this.tierMatching) {
            rebuildLayout = true;
        }
        if (oldGroupCompare != this.groupCompareMode) {
            rebuildLayout = true;
        }
        if (rebuildLayout) {
            if (this.tierPanel != null) {
                this.tierPanel.removeAll();
            }
            this.updatePanel(this.tierMatching);
        }
        if (reloadTiers) {
            this.reloadTiers();
            this.fillTables();
        } else if (rebuildLayout) {
            this.fillTables();
        }
        this.updateButtonState();
    }

    public void updateLocale() {
        this.hint1.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint1"));
        this.hint2.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint2"));
    }

    private void createPanel() {
        this.hint1 = new JLabel();
        this.hint2 = new JLabel();
        this.updateLocale();
        UneditableTableModel model1 = new UneditableTableModel(0, 0);
        UneditableTableModel model2 = new UneditableTableModel(0, 0);
        this.table1 = new JTable(model1);
        this.table1.getSelectionModel().setSelectionMode(0);
        this.table2 = new JTable(model2);
        this.table2.getSelectionModel().setSelectionMode(0);
        this.table1.getSelectionModel().addListSelectionListener(this);
        this.table2.getSelectionModel().addListSelectionListener(this);
        Dimension prdim = new Dimension(400, 80);
        this.table1ScrollPane = new JScrollPane(this.table1);
        this.table1ScrollPane.setPreferredSize(prdim);
        this.table2ScrollPane = new JScrollPane(this.table2);
        this.table2ScrollPane.setPreferredSize(prdim);
        this.tierPanel = new JPanel();
        this.tierPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(6, 6, 6, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = insets;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.tierPanel.add((Component)this.hint1, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)this.table1ScrollPane, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.tierPanel.add((Component)this.hint2, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.tierPanel.add((Component)this.table2ScrollPane, gbc);
        this.setLayout(new GridBagLayout());
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.tierPanel, gbc);
    }

    private void updatePanel(CompareConstants.MATCHING mode) {
        this.table2.getSelectionModel().removeListSelectionListener(this);
        if (mode == CompareConstants.MATCHING.MANUAL && !this.groupCompareMode) {
            Insets insets = new Insets(6, 6, 6, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.tierPanel.add((Component)this.hint1, gbc);
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.tierPanel.add((Component)this.table1ScrollPane, gbc);
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.tierPanel.add((Component)this.hint2, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.tierPanel.add((Component)this.table2ScrollPane, gbc);
            this.table2.setEnabled(true);
            this.table2.getSelectionModel().addListSelectionListener(this);
            this.hint1.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint1"));
            this.hint2.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint2"));
        } else if (mode == CompareConstants.MATCHING.AFFIX || mode == CompareConstants.MATCHING.SUFFIX || mode == CompareConstants.MATCHING.PREFIX) {
            Insets insets = new Insets(6, 6, 6, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.tierPanel.add((Component)this.hint1, gbc);
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.tierPanel.add((Component)this.table1ScrollPane, gbc);
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.weighty = 0.0;
            this.tierPanel.add((Component)this.hint2, gbc);
            gbc.gridy = 3;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.tierPanel.add((Component)this.table2ScrollPane, gbc);
            this.table2.setEnabled(false);
            this.hint1.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint3"));
            this.hint2.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint4"));
        } else if (mode == CompareConstants.MATCHING.SAME_NAME || this.groupCompareMode) {
            Insets insets = new Insets(6, 6, 6, 6);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.insets = insets;
            gbc.weightx = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.tierPanel.add((Component)this.hint1, gbc);
            gbc.gridy = 1;
            gbc.fill = 1;
            gbc.weighty = 1.0;
            this.tierPanel.add((Component)this.table1ScrollPane, gbc);
            this.hint1.setText(ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Suggestion.Hint5"));
        }
    }

    private void reloadTiers() {
        this.setStateFinish(false);
        List<Object> tierNames = null;
        if (this.transcription != null && this.tierSource == CompareConstants.FILE_MATCHING.CURRENT_DOC) {
            tierNames = new ArrayList();
            if (this.transcription != null) {
                for (int i = 0; i < this.transcription.getTiers().size(); ++i) {
                    TierImpl ti = this.transcription.getTiers().get(i);
                    tierNames.add(ti.getName());
                }
            }
        } else if (this.selFiles != null) {
            TierLoader tierLoader = new TierLoader(this.selFiles);
            if (!this.synchronousMode) {
                tierLoader.start();
                while (tierLoader.isAlive()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                tierLoader.run();
            }
            tierNames = tierLoader.getTierNames();
        }
        this.allTierNames.clear();
        this.allTierNames.addAll(tierNames);
        this.multiPane.putStepProperty("Compare.AllTierNames", tierNames);
    }

    private void fillTables() {
        if (this.tierMatching == CompareConstants.MATCHING.MANUAL && !this.groupCompareMode) {
            UneditableTableModel tierModel1 = new UneditableTableModel(0, 1);
            UneditableTableModel tierModel2 = new UneditableTableModel(0, 1);
            for (String s : this.allTierNames) {
                Object[] rowData = new String[]{s};
                tierModel1.addRow(rowData);
                tierModel2.addRow(rowData);
            }
            this.table1.setModel(tierModel1);
            this.table2.setModel(tierModel2);
            this.table1.getTableHeader().setReorderingAllowed(false);
            this.table2.getTableHeader().setReorderingAllowed(false);
            tierModel1.setColumnIdentifiers(new Object[]{ElanLocale.getString("EditTierDialog.Label.TierName")});
            tierModel2.setColumnIdentifiers(new Object[]{ElanLocale.getString("EditTierDialog.Label.TierName")});
            TiersSelectionStep.makeRowsSortable(this.table1, tierModel1, new int[]{0});
            TiersSelectionStep.makeRowsSortable(this.table2, tierModel2, new int[]{0});
            this.table1.getSelectionModel().setSelectionMode(0);
            this.table2.getSelectionModel().setSelectionMode(0);
            this.table1.getSelectionModel().addListSelectionListener(this);
            this.table2.getSelectionModel().addListSelectionListener(this);
        } else if (this.tierMatching == CompareConstants.MATCHING.AFFIX || this.tierMatching == CompareConstants.MATCHING.PREFIX || this.tierMatching == CompareConstants.MATCHING.SUFFIX) {
            TreeSet<String> tierColumnData = new TreeSet<String>();
            for (String s : this.allTierNames) {
                tierColumnData.add(s);
            }
            SelectableContentTableModel tierModel1 = new SelectableContentTableModel(tierColumnData);
            UneditableTableModel tierModel2 = new UneditableTableModel(0, 1);
            tierModel2.setRowCount(tierColumnData.size());
            Iterator tierIter = tierColumnData.iterator();
            int row = 0;
            while (tierIter.hasNext()) {
                tierModel2.setValueAt(tierIter.next(), row, 0);
                ++row;
            }
            this.table1.setModel(tierModel1);
            this.table2.setModel(tierModel2);
            this.table1.getTableHeader().setReorderingAllowed(false);
            this.table2.getTableHeader().setReorderingAllowed(false);
            TiersSelectionStep.makeRowsSortable(this.table1, tierModel1, new int[]{1});
            TiersSelectionStep.makeRowsSortable(this.table2, tierModel2, new int[]{0});
            this.table1.getColumnModel().getColumn(0).setHeaderValue(null);
            this.table1.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
            this.table1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.table2.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
            this.table1.getSelectionModel().setSelectionMode(2);
            this.table2.getSelectionModel().setSelectionMode(2);
            this.table2.setEnabled(false);
            tierModel1.addTableModelListener(this);
        } else if (this.tierMatching == CompareConstants.MATCHING.SAME_NAME || this.groupCompareMode) {
            TreeSet<String> tierColumnData = new TreeSet<String>();
            for (String s : this.allTierNames) {
                tierColumnData.add(s);
            }
            SelectableContentTableModel tierModel1 = new SelectableContentTableModel(tierColumnData);
            this.table1.setModel(tierModel1);
            this.table1.getTableHeader().setReorderingAllowed(false);
            TiersSelectionStep.makeRowsSortable(this.table1, tierModel1, new int[]{1});
            this.table1.getColumnModel().getColumn(0).setHeaderValue(null);
            this.table1.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("FileAndTierSelectionStepPane.Column.TierName"));
            this.table1.getColumnModel().getColumn(0).setMaxWidth(30);
            this.table1.getSelectionModel().setSelectionMode(2);
            tierModel1.addTableModelListener(this);
        }
    }

    private void updateButtonState() {
        if (this.tierMatching == null) {
            this.setStateFinish(false);
            return;
        }
        if (this.tierMatching == CompareConstants.MATCHING.MANUAL) {
            if (this.table1.getSelectedRow() != -1 && this.table2.getSelectedRow() != -1) {
                if (this.tierSource == CompareConstants.FILE_MATCHING.ACROSS_FILES) {
                    this.setStateFinish(true);
                } else {
                    this.setStateFinish(this.table1.getSelectedRow() != this.table2.getSelectedRow());
                }
            } else {
                this.setStateFinish(false);
            }
        } else {
            TableModel tierModel = this.table1.getModel();
            if (tierModel instanceof SelectableContentTableModel) {
                SelectableContentTableModel tm = (SelectableContentTableModel)tierModel;
                this.setStateFinish(!tm.nothingSelected());
            } else {
                this.setStateFinish(this.table1.getSelectedRow() != -1);
            }
        }
    }

    private void updateMatchingTiersTable() {
        TableModel tierModel = this.table1.getModel();
        if (tierModel instanceof SelectableContentTableModel) {
            SelectableContentTableModel tm = (SelectableContentTableModel)tierModel;
            List<Object> selectedTiers1 = tm.getSelectedValues();
            ArrayList<String> selTierNames = new ArrayList<String>(selectedTiers1.size());
            for (Object oo : selectedTiers1) {
                selTierNames.add((String)oo);
            }
            List<List<String>> matchedTiers = this.tierMatcher.getMatchingTiers(this.allTierNames, selTierNames, this.tierMatching, this.tierCustomSeparator);
            ArrayList<String> allMatches = new ArrayList<String>();
            for (List<String> mt : matchedTiers) {
                for (String name : mt) {
                    if (selTierNames.contains(name)) continue;
                    allMatches.add(name);
                }
            }
            this.table2.getSelectionModel().clearSelection();
            int numRows = this.table2.getRowCount();
            String rowValue = null;
            for (int i = 0; i < numRows; ++i) {
                rowValue = (String)this.table2.getValueAt(i, 0);
                if (!allMatches.contains(rowValue)) continue;
                this.table2.addRowSelectionInterval(i, i);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean isAdjusting = e.getValueIsAdjusting();
        if (!isAdjusting) {
            this.updateButtonState();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tierModel = this.table1.getModel();
        if (tierModel instanceof SelectableContentTableModel) {
            if (this.tierMatching == CompareConstants.MATCHING.AFFIX || this.tierMatching == CompareConstants.MATCHING.PREFIX || this.tierMatching == CompareConstants.MATCHING.SUFFIX) {
                this.updateMatchingTiersTable();
            }
            this.updateButtonState();
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("CompareAnnotatorsDialog.TierSelectionStep.Title");
    }

    @Override
    public void enterStepForward() {
        this.setStateFinish(false);
        this.checkConditions();
    }

    @Override
    public void enterStepBackward() {
        this.setStateFinish(true);
    }

    @Override
    public boolean leaveStepBackward() {
        if (this.selFiles != null) {
            if (this.oldSelFiles == null) {
                this.oldSelFiles = new ArrayList<File>();
            }
            this.oldSelFiles.clear();
            this.oldSelFiles.addAll(this.selFiles);
        }
        return true;
    }

    @Override
    public boolean leaveStepForward() {
        ArrayList<String> selectedTierNames;
        Object matchingProp = this.multiPane.getStepProperty("Compare.TierMatching");
        if (matchingProp == CompareConstants.MATCHING.MANUAL) {
            if (this.table1.getSelectedRow() < 0) {
                ClientLogger.LOG.warning("For manual matching a tier should be selected in the first table.");
                return false;
            }
            if (this.table2.getSelectedRow() < 0) {
                ClientLogger.LOG.warning("For manual matching a tier should be selected in the second table.");
                return false;
            }
            this.multiPane.putStepProperty("Compare.TierName1", this.table1.getValueAt(this.table1.getSelectedRow(), 0));
            this.multiPane.putStepProperty("Compare.TierName2", this.table2.getValueAt(this.table2.getSelectedRow(), 0));
            return true;
        }
        TableModel tierModel = this.table1.getModel();
        if (tierModel instanceof SelectableContentTableModel) {
            SelectableContentTableModel tm = (SelectableContentTableModel)tierModel;
            List<Object> selectedValues = tm.getSelectedValues();
            if (selectedValues.size() == 0) {
                ClientLogger.LOG.warning("For same name or affix based matching at least one tier should be selected in the (first) table.");
                return false;
            }
            selectedTierNames = new ArrayList<String>(selectedValues.size());
            for (Object selected : selectedValues) {
                selectedTierNames.add((String)selected);
            }
        } else {
            ClientLogger.LOG.warning("The type of tier selection and tier matching is unclear.");
            return false;
        }
        this.multiPane.putStepProperty("Compare.SelectedTierNames", selectedTierNames);
        return true;
    }

    @Override
    public String getPreferredPreviousStep() {
        return super.getPreferredPreviousStep();
    }

    @Override
    public boolean doFinish() {
        if (this.leaveStepForward()) {
            this.multiPane.nextStep();
            return false;
        }
        return false;
    }

    public static void makeRowsSortable(JTable table, TableModel model, int[] sortableColumnIndices) {
        if (sortableColumnIndices.length == 0) {
            return;
        }
        TableRowSorter<TableModel> rowSorter = new TableRowSorter<TableModel>(model);
        EmptyStringComparator emptyComp = new EmptyStringComparator();
        for (int i = 0; i < sortableColumnIndices.length; ++i) {
            rowSorter.setComparator(sortableColumnIndices[i], emptyComp);
        }
        table.setRowSorter(rowSorter);
    }
}

