/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.modkappa;

import java.util.ArrayList;
import java.util.List;

public class AgreementTable {
    protected int[][] table;
    protected String idLabel;
    protected List<String> scoreLabels;

    public AgreementTable(String idLabel, List<String> labels) {
        if (labels == null) {
            throw new NullPointerException("No labels provided for agreement table.");
        }
        this.idLabel = idLabel;
        this.scoreLabels = new ArrayList<String>(labels);
        int numLabels = this.scoreLabels.size();
        this.table = new int[numLabels][numLabels];
    }

    AgreementTable(String idLabel) {
        this.idLabel = idLabel;
    }

    public boolean increment(String rowLabel, String colLabel) {
        int row = this.scoreLabels.indexOf(rowLabel);
        if (row < 0) {
            return false;
        }
        int col = this.scoreLabels.indexOf(colLabel);
        if (col < 0) {
            return false;
        }
        int[] nArray = this.table[row];
        int n = col;
        nArray[n] = nArray[n] + 1;
        return true;
    }

    public boolean increment(String scoreLabel) {
        int rowCol = this.scoreLabels.indexOf(scoreLabel);
        if (rowCol < 0) {
            return false;
        }
        int[] nArray = this.table[rowCol];
        int n = rowCol;
        nArray[n] = nArray[n] + 1;
        return true;
    }

    public boolean addCount(String rowLabel, String colLabel, int count) {
        int row = this.scoreLabels.indexOf(rowLabel);
        if (row < 0) {
            return false;
        }
        int col = this.scoreLabels.indexOf(colLabel);
        if (col < 0) {
            return false;
        }
        int[] nArray = this.table[row];
        int n = col;
        nArray[n] = nArray[n] + count;
        return true;
    }

    public boolean addCount(String scoreLabel, int count) {
        int rowCol = this.scoreLabels.indexOf(scoreLabel);
        if (rowCol < 0) {
            return false;
        }
        int[] nArray = this.table[rowCol];
        int n = rowCol;
        nArray[n] = nArray[n] + count;
        return true;
    }

    public void doubleMatchedValues() {
        int lastMatched = this.table.length;
        if (this.scoreLabels.contains("Unmatched")) {
            --lastMatched;
        }
        for (int i = 0; i < lastMatched; ++i) {
            int j = 0;
            while (j < lastMatched) {
                int[] nArray = this.table[i];
                int n = j++;
                nArray[n] = nArray[n] * 2;
            }
        }
    }

    public int[][] getTable() {
        return this.table;
    }

    public List<String> getLabels() {
        return this.scoreLabels;
    }

    public String getIdLabel() {
        return this.idLabel;
    }

    public int getTotalSum() {
        int totalSum = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (int j = 0; j < this.table.length; ++j) {
                totalSum += this.table[i][j];
            }
        }
        return totalSum;
    }
}

