/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.modkappa;

import java.util.Arrays;
import mpi.eudico.client.annotator.interannotator.modkappa.IPFUtil;

public class GlobalCKappa {
    private double[][] matrixDouble;
    public final double rawAgreementMatched;
    public final double chanceAgreementMatched;
    public final double kappaMatched;
    public final double maxKappaMatched;
    public final int numTotalMatched;
    public final double numDiagonalTotalMatched;
    private double diagonalTotalFitted;
    public final double rawAgreementAll;
    public final double chanceAgreementAll;
    public final double kappaAll;
    public final double maxKappaAll;
    public final double kappaAllIPF;
    public final int numTotalAll;
    public final double numDiagonalTotalAll;

    public GlobalCKappa(int[][] matrix, boolean matrixIncludesUnmatched) {
        if (matrix.length != matrix[0].length) {
            throw new IllegalArgumentException("The table should be square.");
        }
        if (matrix.length < 2) {
            throw new IllegalArgumentException("The size of the table should be 2 or more.");
        }
        int[][] matrixIntMatched = matrix;
        if (matrixIncludesUnmatched) {
            matrixIntMatched = this.getSubMatrix(matrix);
        }
        int[] rowMarginalsMatched = this.getRowMarginals(matrixIntMatched);
        int[] colMarginalsMatched = this.getColMarginals(matrixIntMatched);
        this.numTotalMatched = this.getSum(matrixIntMatched);
        if (this.numTotalMatched == 0) {
            // empty if block
        }
        this.numDiagonalTotalMatched = this.getDiagonalSum(matrixIntMatched);
        this.rawAgreementMatched = this.numTotalMatched != 0 ? this.numDiagonalTotalMatched / (double)this.numTotalMatched : Double.NaN;
        this.chanceAgreementMatched = this.calcChanceAgreement(rowMarginalsMatched, colMarginalsMatched, this.numTotalMatched);
        if (this.chanceAgreementMatched == 1.0 || Double.isNaN(this.chanceAgreementMatched)) {
            this.kappaMatched = Double.NaN;
            this.maxKappaMatched = Double.NaN;
        } else {
            this.kappaMatched = (this.rawAgreementMatched - this.chanceAgreementMatched) / (1.0 - this.chanceAgreementMatched);
            double poM = this.calcPMax(rowMarginalsMatched, colMarginalsMatched, this.numTotalMatched);
            this.maxKappaMatched = (poM - this.chanceAgreementMatched) / (1.0 - this.chanceAgreementMatched);
        }
        if (!matrixIncludesUnmatched) {
            this.chanceAgreementAll = this.chanceAgreementMatched;
            this.rawAgreementAll = this.rawAgreementMatched;
            this.kappaAll = this.kappaMatched;
            this.maxKappaAll = this.maxKappaMatched;
            this.kappaAllIPF = 0.0;
            this.numTotalAll = this.numTotalMatched;
            this.numDiagonalTotalAll = this.numDiagonalTotalMatched;
            return;
        }
        int[] rowMarginals = this.getRowMarginals(matrix);
        int[] colMarginals = this.getColMarginals(matrix);
        this.numTotalAll = this.getSum(rowMarginals);
        this.numDiagonalTotalAll = this.getDiagonalSum(matrix);
        this.rawAgreementAll = this.numTotalAll == 0 ? Double.NaN : this.numDiagonalTotalAll / (double)this.numTotalAll;
        this.chanceAgreementAll = this.calcChanceAgreement(rowMarginals, colMarginals, this.numTotalAll);
        if (this.chanceAgreementAll != 1.0) {
            this.kappaAll = (this.rawAgreementAll - this.chanceAgreementAll) / (1.0 - this.chanceAgreementAll);
            double poMAll = this.calcPMax(rowMarginals, colMarginals, this.numTotalAll);
            this.maxKappaAll = (poMAll - this.chanceAgreementAll) / (1.0 - this.chanceAgreementAll);
        } else {
            this.kappaAll = Double.NaN;
            this.maxKappaAll = Double.NaN;
        }
        int[][] seedMatrix = this.createMatrix(matrix.length, 1);
        seedMatrix[seedMatrix.length - 1][seedMatrix.length - 1] = 0;
        IPFUtil ipfUtil = new IPFUtil();
        this.matrixDouble = ipfUtil.applyIPF(rowMarginals, colMarginals, seedMatrix, 20);
        this.diagonalTotalFitted = this.getDiagonalSum(this.matrixDouble);
        double chanceAgreementAllIPF = Double.NaN;
        if (this.numTotalAll != 0) {
            chanceAgreementAllIPF = this.diagonalTotalFitted / (double)this.numTotalAll;
        }
        this.kappaAllIPF = chanceAgreementAllIPF != 1.0 ? (this.rawAgreementAll - chanceAgreementAllIPF) / (1.0 - chanceAgreementAllIPF) : Double.NaN;
    }

    private int[] getRowMarginals(int[][] matrix) {
        int[] rowMarginals = new int[matrix.length];
        int sum = 0;
        for (int i = 0; i < matrix.length; ++i) {
            int[] row = matrix[i];
            sum = 0;
            for (int j = 0; j < row.length; ++j) {
                sum += row[j];
            }
            rowMarginals[i] = sum;
        }
        return rowMarginals;
    }

    private int[] getRowMarginalsMatched(int[][] matrix) {
        int[] rowMarginals = new int[matrix.length - 1];
        int sum = 0;
        for (int i = 0; i < matrix.length - 1; ++i) {
            int[] row = matrix[i];
            sum = 0;
            for (int j = 0; j < row.length - 1; ++j) {
                sum += row[j];
            }
            rowMarginals[i] = sum;
        }
        return rowMarginals;
    }

    private int[] getColMarginals(int[][] matrix) {
        int[] colMarginals = new int[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                int n = j;
                colMarginals[n] = colMarginals[n] + matrix[i][j];
            }
        }
        return colMarginals;
    }

    private int[] getColMarginalsMatched(int[][] matrix) {
        int[] colMarginals = new int[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                int n = j;
                colMarginals[n] = colMarginals[n] + matrix[i][j];
            }
        }
        return colMarginals;
    }

    private int[][] createMatrix(int size, int value) {
        int[][] filledMatrix;
        for (int[] row : filledMatrix = new int[size][size]) {
            Arrays.fill(row, value);
        }
        return filledMatrix;
    }

    private int[][] getSubMatrix(int[][] matrix) {
        int[][] subMatrix = new int[matrix.length - 1][matrix.length - 1];
        for (int i = 0; i < matrix.length - 1; ++i) {
            for (int j = 0; j < matrix.length - 1; ++j) {
                subMatrix[i][j] = matrix[i][j];
            }
        }
        return subMatrix;
    }

    private int getSum(int[] marginals) {
        int sum = 0;
        for (int i : marginals) {
            sum += i;
        }
        return sum;
    }

    private int getSum(int[][] matrix) {
        int sum = 0;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix.length; ++j) {
                sum += matrix[i][j];
            }
        }
        return sum;
    }

    private int getDiagonalSum(int[][] matrix) {
        int sum = 0;
        for (int i = 0; i < matrix.length; ++i) {
            sum += matrix[i][i];
        }
        return sum;
    }

    private double getDiagonalSum(double[][] doubleMatrix) {
        double sum = 0.0;
        for (int i = 0; i < doubleMatrix.length - 1; ++i) {
            sum += doubleMatrix[i][i];
        }
        return sum;
    }

    private double calcChanceAgreement(int[] rowMarginals, int[] colMarginals, int totalSum) {
        if (totalSum == 0) {
            return Double.NaN;
        }
        double sumCA = 0.0;
        double totalDouble = totalSum;
        for (int i = 0; i < rowMarginals.length; ++i) {
            double perc1 = (double)rowMarginals[i] / totalDouble;
            double perc2 = (double)colMarginals[i] / totalDouble;
            sumCA += perc1 * perc2;
        }
        return sumCA;
    }

    private double calcPMax(int[] rowMarginals, int[] colMarginals, int totalSum) {
        if (totalSum == 0) {
            return Double.NaN;
        }
        int minimalRC = 0;
        for (int i = 0; i < rowMarginals.length; ++i) {
            minimalRC += Math.min(rowMarginals[i], colMarginals[i]);
        }
        return (double)minimalRC / (double)totalSum;
    }
}

