/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.multi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import mpi.eudico.client.annotator.interannotator.CompareUnit;
import mpi.eudico.client.annotator.interannotator.multi.CompareCombiMulti;
import mpi.eudico.client.annotator.interannotator.multi.MatchCluster;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class AnnotatorCompareUtilMulti {
    private double avgRatioThreshold = 0.7;

    public void setAvgRatioThreshold(double avgRatioThreshold) {
        if (avgRatioThreshold >= 0.0 && avgRatioThreshold <= 1.0) {
            this.avgRatioThreshold = avgRatioThreshold;
        }
    }

    public List<MatchCluster> matchAnnotationsMulti(CompareCombiMulti compareCombi) {
        if (compareCombi == null) {
            return null;
        }
        int numRaters = compareCombi.getCompareUnits().size();
        if (numRaters < 2) {
            return null;
        }
        TreeSet<Long> timePoints = new TreeSet<Long>();
        for (CompareUnit cmUnit : compareCombi.getCompareUnits()) {
            for (AnnotationCore ac : cmUnit.annotations) {
                timePoints.add(ac.getBeginTimeBoundary());
                timePoints.add(ac.getEndTimeBoundary());
            }
        }
        if (timePoints.size() == 0) {
            return null;
        }
        Long[] tpArray = timePoints.toArray(new Long[0]);
        int numSegments = tpArray.length - 1;
        MatchCluster[] clusters = new MatchCluster[numSegments];
        for (int i = 0; i < numSegments; ++i) {
            clusters[i] = new MatchCluster(numRaters);
            clusters[i].overlapInterval[0] = tpArray[i];
            clusters[i].overlapInterval[1] = tpArray[i + 1];
            clusters[i].overlapDuration = tpArray[i + 1] - tpArray[i];
        }
        for (int cu = 0; cu < compareCombi.getCompareUnits().size(); ++cu) {
            CompareUnit cmUnit = compareCombi.getCompareUnits().get(cu);
            int aIndex = 0;
            block4: for (AnnotationCore ac : cmUnit.annotations) {
                while (aIndex < numSegments) {
                    if (ac.getBeginTimeBoundary() < clusters[aIndex].overlapInterval[1]) {
                        if (clusters[aIndex].overlapInterval[0] >= ac.getEndTimeBoundary()) continue block4;
                        ++clusters[aIndex].numberOfAnnos;
                        clusters[aIndex].sumOverlapRatios += (double)clusters[aIndex].overlapDuration / (double)(ac.getEndTimeBoundary() - ac.getBeginTimeBoundary());
                        clusters[aIndex].matchingAnnos[cu] = ac;
                    }
                    ++aIndex;
                }
            }
        }
        ClusterComparator clComp = new ClusterComparator();
        ArrayList<MatchCluster> clusterList = new ArrayList<MatchCluster>();
        for (MatchCluster mc : clusters) {
            if (mc.numberOfAnnos <= 0) continue;
            clusterList.add(mc);
        }
        clusterList.sort(clComp);
        ArrayList<AnnotationCore> matchedAnnos = new ArrayList<AnnotationCore>();
        ArrayList<MatchCluster> resultList = new ArrayList<MatchCluster>();
        while (!clusterList.isEmpty()) {
            MatchCluster mc = (MatchCluster)clusterList.get(0);
            int oldNumAnnos = mc.numberOfAnnos;
            for (int i = 0; i < mc.matchingAnnos.length; ++i) {
                AnnotationCore ac = mc.matchingAnnos[i];
                if (ac == null || !matchedAnnos.contains(ac)) continue;
                mc.matchingAnnos[i] = null;
                --mc.numberOfAnnos;
            }
            if (mc.numberOfAnnos == 0) {
                clusterList.remove(mc);
                continue;
            }
            if (oldNumAnnos != mc.numberOfAnnos) {
                double nextSOR = 0.0;
                for (AnnotationCore ac : mc.matchingAnnos) {
                    if (ac == null) continue;
                    nextSOR += (double)mc.overlapDuration / (double)(ac.getEndTimeBoundary() - ac.getBeginTimeBoundary());
                }
                mc.sumOverlapRatios = nextSOR;
                clusterList.remove(mc);
                int insPoint = Collections.binarySearch(clusterList, mc, clComp);
                if (insPoint >= 0) continue;
                clusterList.add(-insPoint - 1, mc);
                continue;
            }
            clusterList.remove(mc);
            resultList.add(mc);
            for (AnnotationCore ac : mc.matchingAnnos) {
                matchedAnnos.add(ac);
            }
        }
        return resultList;
    }

    private void testCompare(Set<MatchCluster> clusterSet, ClusterComparator comparator) {
        Iterator<MatchCluster> mcIter = clusterSet.iterator();
        MatchCluster prevMC = null;
        while (mcIter.hasNext()) {
            MatchCluster curMC = mcIter.next();
            if (prevMC != null) {
                System.out.println("Compare: 1 to 2: " + comparator.compare(prevMC, curMC) + " 2 to 1: " + comparator.compare(curMC, prevMC));
            }
            prevMC = curMC;
        }
    }

    private void validate(CompareCombiMulti ccm, List<MatchCluster> clusters) {
        int annIn = 0;
        int annOut = 0;
        for (CompareUnit cu : ccm.getCompareUnits()) {
            annIn += cu.annotations.size();
        }
        for (MatchCluster mc : clusters) {
            annOut += mc.numberOfAnnos;
        }
        System.out.println(String.format("Validation of clustering: annotations in: %d, annotations out: %d", annIn, annOut));
    }

    public class ClusterComparator
    implements Comparator<MatchCluster> {
        @Override
        public int compare(MatchCluster mc1, MatchCluster mc2) {
            if (mc1 == mc2) {
                return 0;
            }
            if (mc1.numberOfAnnos > mc2.numberOfAnnos) {
                if (mc1.sumOverlapRatios / (double)mc1.numberOfAnnos >= AnnotatorCompareUtilMulti.this.avgRatioThreshold) {
                    return -1;
                }
                if (mc1.numberOfAnnos - mc2.numberOfAnnos == 1 && mc2.sumOverlapRatios / (double)mc2.numberOfAnnos >= AnnotatorCompareUtilMulti.this.avgRatioThreshold) {
                    return 1;
                }
                if (mc1.sumOverlapRatios > mc2.sumOverlapRatios) {
                    return -1;
                }
                if (mc2.sumOverlapRatios > mc1.sumOverlapRatios) {
                    return 1;
                }
            }
            if (mc2.numberOfAnnos > mc1.numberOfAnnos) {
                if (mc2.sumOverlapRatios / (double)mc2.numberOfAnnos >= AnnotatorCompareUtilMulti.this.avgRatioThreshold) {
                    return 1;
                }
                if (mc2.numberOfAnnos - mc1.numberOfAnnos == 1 && mc1.sumOverlapRatios / (double)mc1.numberOfAnnos >= AnnotatorCompareUtilMulti.this.avgRatioThreshold) {
                    return -1;
                }
                if (mc2.sumOverlapRatios > mc1.sumOverlapRatios) {
                    return 1;
                }
                if (mc1.sumOverlapRatios > mc2.sumOverlapRatios) {
                    return -1;
                }
            }
            if (mc1.numberOfAnnos == mc2.numberOfAnnos) {
                if (mc1.sumOverlapRatios > mc2.sumOverlapRatios) {
                    return -1;
                }
                if (mc2.sumOverlapRatios > mc1.sumOverlapRatios) {
                    return 1;
                }
            }
            if (mc1.overlapDuration > mc2.overlapDuration) {
                return -1;
            }
            if (mc2.overlapDuration > mc1.overlapDuration) {
                return 1;
            }
            if (mc1.overlapInterval[0] < mc2.overlapInterval[0]) {
                return -1;
            }
            if (mc2.overlapInterval[0] < mc1.overlapInterval[0]) {
                return 1;
            }
            return 0;
        }
    }
}

