/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.multi;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mpi.eudico.client.annotator.interannotator.CompareCombi;
import mpi.eudico.client.annotator.interannotator.CompareUnit;

public class CompareCombiMulti
extends CompareCombi {
    private List<CompareUnit> unitList;
    private String cvName;
    private Set<String> valuesSet = null;

    public CompareCombiMulti(CompareUnit firstUnit, CompareUnit secondUnit) {
        super(firstUnit, secondUnit);
        this.addCompareUnit(firstUnit);
        this.addCompareUnit(secondUnit);
    }

    public CompareCombiMulti() {
        super(null, null);
        this.unitList = new ArrayList<CompareUnit>();
    }

    public CompareCombiMulti(CompareUnit firstUnit) {
        super(firstUnit, null);
        this.addCompareUnit(firstUnit);
    }

    public CompareCombiMulti(CompareUnit ... compareUnits) {
        super(null, null);
        for (CompareUnit cu : compareUnits) {
            this.addCompareUnit(cu);
        }
    }

    public CompareCombiMulti(List<CompareUnit> unitList) {
        super(null, null);
        this.unitList = unitList;
    }

    public void addCompareUnit(CompareUnit compareUnit) {
        if (this.unitList == null) {
            this.unitList = new ArrayList<CompareUnit>();
        }
        this.unitList.add(compareUnit);
    }

    @Override
    public CompareUnit getFirstUnit() {
        if (this.unitList.size() > 0) {
            return this.unitList.get(0);
        }
        return null;
    }

    @Override
    public CompareUnit getSecondUnit() {
        if (this.unitList.size() > 1) {
            return this.unitList.get(1);
        }
        return null;
    }

    public CompareUnit getCompareUnit(int index) {
        if (this.unitList.size() > index && index >= 0) {
            return this.unitList.get(index);
        }
        return null;
    }

    public List<CompareUnit> getCompareUnits() {
        return this.unitList;
    }

    public void addValues(List<String> values) {
        if (this.valuesSet == null) {
            this.valuesSet = new HashSet<String>();
        }
        this.valuesSet.addAll(values);
    }

    public void addValue(String value) {
        if (this.valuesSet == null) {
            this.valuesSet = new HashSet<String>();
        }
        this.valuesSet.add(value);
    }

    public Set<String> getValues() {
        return this.valuesSet;
    }

    public String getCVName() {
        return this.cvName;
    }

    public void setCVName(String cvName) {
        this.cvName = this.cvName != null && !this.cvName.equals(cvName) ? this.cvName + ", " + cvName : cvName;
    }
}

