/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interannotator.multi;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.client.annotator.interannotator.multi.CompareCombiMulti;
import mpi.eudico.client.annotator.interannotator.multi.MatchCluster;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class MultiMatrix {
    private int[][] matrixIU;
    private int[][] matrixEU;
    private int[] rowIUMarginalTotals;
    private int[] rowEUMarginalTotals;
    private int[] colIUMarginalTotals;
    private int[] colEUMarginalTotals;
    private double[] rowIUMarginalProp;
    private double[] rowEUMarginalProp;
    private double[] colIUMarginalProp;
    private double[] colEUMarginalProp;
    private int numRaters;
    private int numIUObservations;
    private int numEUObservations;
    private int numIUCategories;
    private List<String> valueList;
    private String UNMATCHED = "Unmatched";
    private double peIU;
    private double peEU;
    private double avgPIU;
    private double avgPEU;

    public MultiMatrix(CompareCombiMulti ccm, List<MatchCluster> clusters) {
        if (ccm == null || clusters == null) {
            return;
        }
        this.numRaters = ccm.getCompareUnits().size();
        if (ccm.getValues() != null) {
            this.numIUCategories = ccm.getValues().size() + 1;
            this.valueList = new ArrayList<String>(ccm.getValues());
            this.valueList.add(this.UNMATCHED);
        } else {
            this.numIUCategories = 1;
            this.valueList = new ArrayList<String>(1);
            this.valueList.add(this.UNMATCHED);
        }
        this.numIUObservations = clusters.size();
        this.createInclMatrix(clusters);
        this.createExclMatrix();
        this.calculateMarginals();
    }

    private void createInclMatrix(List<MatchCluster> clusters) {
        this.matrixIU = new int[this.numIUObservations][this.numIUCategories];
        for (int i = 0; i < clusters.size(); ++i) {
            MatchCluster mc = clusters.get(i);
            for (AnnotationCore ac : mc.matchingAnnos) {
                if (ac != null) {
                    int col = this.valueList.indexOf(ac.getValue().strip());
                    col = col < 0 ? this.numIUCategories - 1 : col;
                    int[] nArray = this.matrixIU[i];
                    int n = col;
                    nArray[n] = nArray[n] + 1;
                    continue;
                }
                int[] nArray = this.matrixIU[i];
                int n = this.numIUCategories - 1;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    private void createExclMatrix() {
        int i;
        if (this.matrixIU == null) {
            return;
        }
        int col = this.numIUCategories - 1;
        for (i = 0; i < this.numIUObservations; ++i) {
            if (this.matrixIU[i][col] != 0) continue;
            ++this.numEUObservations;
        }
        this.matrixEU = new int[this.numEUObservations][this.numIUCategories - 1];
        int j = 0;
        for (i = 0; i < this.numIUObservations && j < this.numEUObservations; ++i) {
            if (this.matrixIU[i][col] != 0) continue;
            for (int k = 0; k < this.numIUCategories - 1; ++k) {
                this.matrixEU[j][k] = this.matrixIU[i][k];
            }
            ++j;
        }
    }

    private void calculateMarginals() {
        int i;
        int i2;
        int i3;
        int i4;
        if (this.matrixIU == null) {
            return;
        }
        this.rowIUMarginalTotals = new int[this.numIUObservations];
        this.rowIUMarginalProp = new double[this.numIUObservations];
        this.colIUMarginalTotals = new int[this.numIUCategories];
        this.colIUMarginalProp = new double[this.numIUCategories];
        for (int i5 = 0; i5 < this.numIUObservations; ++i5) {
            for (int j = 0; j < this.numIUCategories; ++j) {
                int n = j;
                this.colIUMarginalTotals[n] = this.colIUMarginalTotals[n] + this.matrixIU[i5][j];
                int n2 = i5;
                this.rowIUMarginalTotals[n2] = this.rowIUMarginalTotals[n2] + this.matrixIU[i5][j];
            }
        }
        int totalObs = 0;
        for (i4 = 0; i4 < this.colIUMarginalTotals.length; ++i4) {
            totalObs += this.colIUMarginalTotals[i4];
        }
        for (i4 = 0; i4 < this.colIUMarginalTotals.length; ++i4) {
            this.colIUMarginalProp[i4] = (double)this.colIUMarginalTotals[i4] / (double)totalObs;
        }
        double factor = 1.0 / (double)(this.numRaters * (this.numRaters - 1));
        for (int i6 = 0; i6 < this.numIUObservations; ++i6) {
            int powerTot = 0;
            for (int j = 0; j < this.numIUCategories; ++j) {
                powerTot = (int)((double)powerTot + Math.pow(this.matrixIU[i6][j], 2.0));
            }
            this.rowIUMarginalProp[i6] = factor * (double)(powerTot - this.numRaters);
        }
        double sumRowProp = 0.0;
        for (i3 = 0; i3 < this.rowIUMarginalProp.length; ++i3) {
            sumRowProp += this.rowIUMarginalProp[i3];
        }
        this.avgPIU = sumRowProp / (double)this.numIUObservations;
        this.peIU = 0.0;
        for (i3 = 0; i3 < this.colIUMarginalProp.length; ++i3) {
            this.peIU += Math.pow(this.colIUMarginalProp[i3], 2.0);
        }
        double k = (this.avgPIU - this.peIU) / (1.0 - this.peIU);
        if (this.matrixEU == null) {
            return;
        }
        this.rowEUMarginalTotals = new int[this.numEUObservations];
        this.rowEUMarginalProp = new double[this.numEUObservations];
        this.colEUMarginalTotals = new int[this.numIUCategories - 1];
        this.colEUMarginalProp = new double[this.numIUCategories - 1];
        for (int i7 = 0; i7 < this.numEUObservations; ++i7) {
            for (int j = 0; j < this.numIUCategories - 1; ++j) {
                int n = j;
                this.colEUMarginalTotals[n] = this.colEUMarginalTotals[n] + this.matrixEU[i7][j];
                int n3 = i7;
                this.rowEUMarginalTotals[n3] = this.rowEUMarginalTotals[n3] + this.matrixEU[i7][j];
            }
        }
        int totalObsEx = 0;
        for (i2 = 0; i2 < this.colEUMarginalTotals.length; ++i2) {
            totalObsEx += this.colEUMarginalTotals[i2];
        }
        for (i2 = 0; i2 < this.colEUMarginalTotals.length; ++i2) {
            this.colEUMarginalProp[i2] = (double)this.colEUMarginalTotals[i2] / (double)totalObsEx;
        }
        for (i2 = 0; i2 < this.numEUObservations; ++i2) {
            int powerTot = 0;
            for (int j = 0; j < this.numIUCategories - 1; ++j) {
                powerTot = (int)((double)powerTot + Math.pow(this.matrixEU[i2][j], 2.0));
            }
            this.rowEUMarginalProp[i2] = factor * (double)(powerTot - this.numRaters);
        }
        double sumRowPropEx = 0.0;
        for (i = 0; i < this.rowEUMarginalProp.length; ++i) {
            sumRowPropEx += this.rowEUMarginalProp[i];
        }
        this.avgPEU = sumRowPropEx / (double)this.numEUObservations;
        this.peEU = 0.0;
        for (i = 0; i < this.colEUMarginalProp.length; ++i) {
            this.peEU += Math.pow(this.colEUMarginalProp[i], 2.0);
        }
        double ke = (this.avgPEU - this.peEU) / (1.0 - this.peEU);
    }

    public void printMatrix(Writer writer, DecimalFormat decFormat, boolean includingUnmatched) throws IOException {
        writer.write("\t");
        if (includingUnmatched) {
            int j;
            for (String s : this.valueList) {
                writer.write(s);
                writer.write("\t");
            }
            writer.write("Pi");
            writer.write("\n");
            for (int i = 0; i < this.numIUObservations; ++i) {
                writer.write(String.valueOf(i + 1));
                writer.write("\t");
                for (int j2 = 0; j2 < this.numIUCategories; ++j2) {
                    writer.write(String.valueOf(this.matrixIU[i][j2]));
                    writer.write("\t");
                }
                writer.write(decFormat.format(this.rowIUMarginalProp[i]));
                writer.write("\n");
            }
            writer.write("Total\t");
            for (j = 0; j < this.numIUCategories; ++j) {
                writer.write(String.valueOf(this.colIUMarginalTotals[j]));
                writer.write("\t");
            }
            writer.write("\t\n");
            writer.write("pj\t");
            for (j = 0; j < this.numIUCategories; ++j) {
                writer.write(decFormat.format(this.colIUMarginalProp[j]));
                writer.write("\t");
            }
            writer.write("\t\n");
        } else {
            int j;
            int i;
            for (i = 0; i < this.valueList.size() - 1; ++i) {
                writer.write(this.valueList.get(i));
                writer.write("\t");
            }
            writer.write("Pi");
            writer.write("\n");
            for (i = 0; i < this.numEUObservations; ++i) {
                writer.write(String.valueOf(i + 1));
                writer.write("\t");
                for (int j3 = 0; j3 < this.numIUCategories - 1; ++j3) {
                    writer.write(String.valueOf(this.matrixEU[i][j3]));
                    writer.write("\t");
                }
                writer.write(decFormat.format(this.rowEUMarginalProp[i]));
                writer.write("\n");
            }
            writer.write("Total\t");
            for (j = 0; j < this.numIUCategories - 1; ++j) {
                writer.write(String.valueOf(this.colEUMarginalTotals[j]));
                writer.write("\t");
            }
            writer.write("\t\n");
            writer.write("pj\t");
            for (j = 0; j < this.numIUCategories - 1; ++j) {
                writer.write(decFormat.format(this.colEUMarginalProp[j]));
                writer.write("\t");
            }
            writer.write("\t\n");
        }
    }

    public double getPeIU() {
        return this.peIU;
    }

    public double getPeEU() {
        return this.peEU;
    }

    public double getAvgPIU() {
        return this.avgPIU;
    }

    public double getAvgPEU() {
        return this.avgPEU;
    }

    public double getKappaIU() {
        return (this.avgPIU - this.peIU) / (1.0 - this.peIU);
    }

    public double getKappaEU() {
        return (this.avgPEU - this.peEU) / (1.0 - this.peEU);
    }

    private void testMatrix() {
        this.matrixEU = new int[][]{{0, 0, 0, 0, 14}, {0, 2, 6, 4, 2}, {0, 0, 3, 5, 6}, {0, 3, 9, 2, 0}, {2, 2, 8, 1, 1}, {7, 7, 0, 0, 0}, {3, 2, 6, 3, 0}, {2, 5, 3, 2, 2}, {6, 5, 2, 1, 0}, {0, 2, 2, 3, 7}};
        this.numEUObservations = this.matrixEU.length;
        this.numIUCategories = this.matrixEU[0].length + 1;
        this.numRaters = 14;
        this.matrixIU = new int[][]{{0, 0, 0, 0, 14, 0}, {0, 2, 6, 4, 2, 0}, {0, 0, 3, 5, 6, 0}, {0, 3, 9, 2, 0, 0}, {2, 2, 8, 1, 1, 0}, {7, 7, 0, 0, 0, 0}, {3, 2, 6, 3, 0, 0}, {2, 5, 3, 2, 2, 0}, {6, 5, 2, 1, 0, 0}, {0, 2, 2, 3, 7, 0}};
        this.numIUObservations = this.matrixIU.length;
        this.valueList = new ArrayList<String>(this.numIUCategories);
        this.valueList.add("1");
        this.valueList.add("2");
        this.valueList.add("3");
        this.valueList.add("4");
        this.valueList.add("5");
        this.valueList.add(this.UNMATCHED);
    }

    private void testFAMatrix() {
        this.matrixEU = new int[][]{{0, 0, 0, 14, 0}, {0, 0, 0, 14, 0}, {0, 0, 14, 0, 0}, {0, 14, 0, 0, 0}, {14, 0, 0, 0, 0}, {0, 14, 0, 0, 0}, {0, 0, 14, 0, 0}, {0, 0, 0, 14, 0}, {0, 0, 0, 14, 0}, {0, 0, 0, 14, 0}};
        this.numEUObservations = this.matrixEU.length;
        this.numIUCategories = this.matrixEU[0].length + 1;
        this.numRaters = 14;
        this.matrixIU = new int[][]{{14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {14, 0, 0, 0, 0, 0}, {0, 0, 14, 0, 0, 0}};
        this.numIUObservations = this.matrixIU.length;
        this.valueList = new ArrayList<String>(this.numIUCategories);
        this.valueList.add("1");
        this.valueList.add("2");
        this.valueList.add("3");
        this.valueList.add("4");
        this.valueList.add("5");
        this.valueList.add(this.UNMATCHED);
    }
}

