/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JPanel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.mediacontrol.ControllerEvent;

public class IGTPlayerControlPanel
extends AbstractViewer {
    private JButton playPauseButton;
    private PlaybackProgressPanel ppPanel;
    private int margin = 5;
    private Dimension prefSize;
    private Dimension minSize;

    public IGTPlayerControlPanel() {
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(this.margin, this.margin, this.margin, this.margin);
        this.playPauseButton = new JButton();
        this.add((Component)this.playPauseButton, gbc);
        this.ppPanel = new PlaybackProgressPanel();
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(this.margin, 0, this.margin, this.margin);
        this.add((Component)this.ppPanel, gbc);
    }

    @Override
    public void setViewerManager(ViewerManager2 viewerManager) {
        super.setViewerManager(viewerManager);
        if (viewerManager != null && this.playPauseButton != null) {
            this.playPauseButton.setAction(ELANCommandFactory.getCommandAction(this.getViewerManager().getTranscription(), "Menu.Play.PlaySelection"));
            this.revalidate();
        }
    }

    @Override
    public void controllerUpdate(ControllerEvent event) {
        this.ppPanel.repaint();
    }

    @Override
    public void updateSelection() {
        if (this.getSelectionBeginTime() == this.getSelectionEndTime()) {
            this.setEnabled(false);
        } else if (!this.isEnabled()) {
            this.setEnabled(true);
        }
        this.ppPanel.repaint();
    }

    protected float getMediaAdvance() {
        long b = this.getSelectionBeginTime();
        long e = this.getSelectionEndTime();
        long m = this.getMediaTime();
        if (b != e && m >= b && m <= e) {
            if (m == e) {
                return 1.0f;
            }
            return (float)(m - b) / (float)(e - b);
        }
        return 0.0f;
    }

    @Override
    public void updateActiveAnnotation() {
    }

    @Override
    public void updateLocale() {
    }

    @Override
    public void preferencesChanged() {
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.playPauseButton.setEnabled(enabled);
        this.ppPanel.setEnabled(enabled);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension d = this.playPauseButton.getPreferredSize();
            Dimension d2 = this.ppPanel.getPreferredSize();
            int w = d.width + 3 * this.margin + d2.width;
            int h = d.height + 2 * this.margin;
            this.prefSize = new Dimension(w, h);
        }
        return this.prefSize;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.minSize == null) {
            Dimension d = this.playPauseButton.getMinimumSize();
            Dimension d2 = this.ppPanel.getMinimumSize();
            int w = d.width + 2 * this.margin + d2.width;
            int h = d.height;
            this.minSize = new Dimension(w, h);
        }
        return this.minSize;
    }

    private class PlaybackProgressPanel
    extends JPanel {
        private Dimension prefSizePPP;
        private Dimension minSize;

        public PlaybackProgressPanel() {
            super(null);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            float adv = IGTPlayerControlPanel.this.getMediaAdvance();
            int w = (int)(adv * (float)this.getWidth());
            boolean enabled = this.isEnabled();
            if (enabled) {
                g.setColor(Constants.SELECTIONCOLOR);
            } else {
                g.setColor(Color.LIGHT_GRAY);
            }
            g.fillRect(0, 0, w, this.getHeight());
            if (enabled) {
                g.setColor(Constants.CROSSHAIRCOLOR);
            } else {
                g.setColor(Constants.MEDIAPLAYERCONTROLSLIDERSELECTIONCOLOR);
            }
            if (w == 0) {
                ++w;
            }
            if (w >= this.getWidth() - 1) {
                w -= 2;
            }
            g.drawLine(w, 0, w, this.getHeight());
            g.setColor(Constants.MEDIAPLAYERCONTROLSLIDERSELECTIONCOLOR);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.prefSizePPP == null) {
                Dimension butSize = IGTPlayerControlPanel.this.playPauseButton.getPreferredSize();
                this.prefSizePPP = new Dimension(butSize.width, butSize.height / 2);
            }
            return this.prefSizePPP;
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.minSize == null) {
                Dimension butSize = IGTPlayerControlPanel.this.playPauseButton.getPreferredSize();
                this.minSize = new Dimension(butSize.height / 2, butSize.height / 2);
            }
            return this.minSize;
        }
    }
}

