/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.interlinear.BlockMetrics;
import mpi.eudico.client.annotator.interlinear.PixelRenderer;
import mpi.eudico.client.annotator.interlinear.ToolboxMetrics;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class Interlinear {
    public static final int CM = 0;
    public static final int INCH = 1;
    public static final int PIXEL = 2;
    public static final int NUM_CHARACTERS = 3;
    public static final int EACH_BLOCK = 0;
    public static final int BLOCK_BOUNDARY = 1;
    public static final int WITHIN_BLOCKS = 2;
    public static final int NO_WRAP = 3;
    public static final int NEXT_LINE = 4;
    public static final int END_OF_BLOCK = 5;
    public static final int HHMMSSMS = 0;
    public static final int SSMS = 1;
    public static final int MS = 2;
    public static final int PIXELS = 0;
    public static final int BYTES = 1;
    public static final int CHARACTERS = 2;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static Font DEFAULTFONT = new Font("MS Arial Unicode", 0, 12);
    public static Font MONOSPACED_FONT = new Font("Monospaced", 0, 12);
    public static final int TIMECODE_FONT_SIZE = 10;
    public static final int TEMPLATE = 0;
    public static final int HIDE_EMPTY_LINES = 1;
    public static final int EXTERNALLY_SPECIFIED = 0;
    public static final int TIER_HIERARCHY = 1;
    public static final int BY_NAME = 2;
    public static final int BY_LINGUISTIC_TYPE = 3;
    public static final int BY_PARTICIPANT = 4;
    public static final int BY_ANNOTATOR = 5;
    public static final int BY_LANGUAGE = 6;
    public static final int USER_DEFINED = 7;
    public static final int SINGLE_TIMECODE = 0;
    public static final int MULTIPLE_TIMECODE = 1;
    public static final int MIN_SILENCE = 20;
    public static final int UTF8 = 0;
    public static final int ISOLATIN = 1;
    public static final int SIL = 2;
    public static final int PRINT = 100;
    public static final int INTERLINEAR_TEXT = 101;
    public static final int SHOEBOX_TEXT = 102;
    public static final int HTML = 103;
    public static final int DEFAULT_NUM_CHARS = 80;
    public static final int LABEL_VALUE_MARGIN = 3;
    public static final int DEFAULT_TEXT_BLOCK_SPACING = 2;
    private final TranscriptionImpl transcription;
    private int width;
    private int height;
    private List<Tier> visibleTiers;
    private boolean tierLabelsShown;
    private long[] visibleTimeInterval;
    private int blockWrapStyle;
    private int lineWrapStyle;
    private boolean timeCodeShown;
    private int timeCodeType;
    private boolean playSoundSel;
    private String mediaURL;
    private Map<String, Font> fonts;
    private Map<String, Integer> fontSizes;
    private boolean emptySlotsShown;
    private int lineSpacing;
    private int blockSpacing = -1;
    private int emptySpace;
    private Annotation activeAnnotation;
    private long[] selection;
    private long mediaTime;
    private int alignmentUnit;
    private int emptyLineStyle;
    private int sortingStyle;
    private Map<String, Integer> charEncodings;
    private int outputMode;
    private int timeCodeMultiplicity;
    private BlockMetrics metrics;
    private int pageHeight;
    private boolean selectionOnly = false;
    private long timeOffset = 0L;
    private boolean insertTabs = false;
    private boolean tabsReplaceSpaces = false;
    private boolean showPageNumber = true;
    public int pageNumberAreaHeight = 14;
    private final String EMPTY = "";
    private boolean showSilenceDuration = false;
    private int minSilenceDuration;
    private int noOfDecimalDigits;
    private int cachedLineWrapWidth = -1;
    final String prefSelectionOnly = "Interlinear.SelectionOnly";
    final String prefSilenceDurationShown = "Interlinear.SilenceDurationShown";
    final String prefMinSilenceDurationValue = "Interlinear.MinSilenceDurationValue";
    final String prefNoOfDecimalDigits = "NumberOfDecimalDigits";
    final String prefLabelsShown = "Interlinear.LabelsShown";
    final String prefTimeCodeShown = "Interlinear.TimeCodeShown";
    final String prefEmptyLineStyle = "Interlinear.EmptyLineStyle";
    final String prefTimeCodeType = "Interlinear.TimeCodeType";
    final String prefPlaySoundSel = "Interlinear.PlayMediaSel";
    final String prefBlockWrapStyle = "Interlinear.BlockWrapStyle";
    final String prefLineWrapStyle = "Interlinear.LineWrapStyle";
    final String prefBlockSpacing = "Interlinear.BlockSpacing";
    final String prefBlockSpacingTextOut = "Interlinear.BlockSpacing.Text";
    final String prefLineSpacing = "Interlinear.LineSpacing";
    final String prefTierSortingStyle = "Interlinear.TierSortingStyle";
    final String prefVisibleTiers = "Interlinear.VisibleTiers";
    final String prefTierOrder = "Interlinear.TierOrder";
    final String prefFontSizes = "Interlinear.FontSizes";
    final String prefNumCharPerLine = "Interlinear.NumCharPerLine";
    final String prefHTMLPixWidth = "Interlinear.HTMLPixWidth";
    final String prefInsertTab = "Interlinear.InsertSpace";
    final String prefTabsInsteadOfSpaces = "Interlinear.TabsInsteadOfSpaces";
    final String prefPageNumber = "Interlinear.PageNumber";
    final String prefHiddenTiers = "Interlinear.HiddenTiers";
    final String prefTierSelectionMode = "Interlinear.SelectTiersMode";

    public Interlinear(TranscriptionImpl tr) {
        this(tr, 100);
    }

    public Interlinear(TranscriptionImpl tr, int mode) {
        this.transcription = tr;
        this.outputMode = mode < 100 || mode > 103 ? 100 : mode;
        this.metrics = mode == 102 ? new ToolboxMetrics(this) : new BlockMetrics(this);
        this.setDefaultValues();
    }

    private void resetMetrics() {
        this.metrics.reset();
    }

    private void setDefaultValues() {
        if (this.outputMode == 100) {
            this.width = 550;
            this.height = this.pageHeight = 600;
            this.alignmentUnit = 0;
            this.blockSpacing = 0;
            this.emptySpace = 10;
            this.emptySlotsShown = false;
        } else if (this.outputMode == 101) {
            this.width = 80;
            this.pageHeight = this.height = 800;
            this.alignmentUnit = 2;
            this.emptySpace = 1;
            this.emptySlotsShown = false;
        } else if (this.outputMode == 102) {
            this.width = 80;
            this.pageHeight = this.height = 800;
            this.alignmentUnit = 2;
            this.emptySpace = 1;
            this.emptySlotsShown = false;
        } else {
            this.width = 800;
            this.pageHeight = 800;
            this.height = 800;
            this.alignmentUnit = 0;
            this.emptySpace = 10;
            this.emptySlotsShown = true;
        }
        this.tierLabelsShown = true;
        this.blockWrapStyle = 1;
        this.lineWrapStyle = 4;
        this.timeCodeShown = false;
        this.timeCodeType = 0;
        this.minSilenceDuration = 20;
        this.noOfDecimalDigits = 2;
        this.emptyLineStyle = 1;
        this.sortingStyle = 0;
        this.timeCodeMultiplicity = 1;
        this.visibleTiers = new ArrayList<Tier>();
        this.fonts = new HashMap<String, Font>();
        this.fontSizes = new HashMap<String, Integer>();
        this.charEncodings = new HashMap<String, Integer>();
        if (this.transcription != null) {
            this.visibleTiers.addAll(this.transcription.getTiers());
            for (TierImpl tierImpl : this.visibleTiers) {
                if (this.outputMode == 100 || this.outputMode == 103) {
                    this.setFont(tierImpl.getName(), DEFAULTFONT);
                } else {
                    this.setFont(tierImpl.getName(), MONOSPACED_FONT);
                }
                this.setFontSize(tierImpl.getName(), 12);
            }
        }
        this.loadPreferences();
    }

    public void savePreferences() {
        Preferences.set("Interlinear.SelectionOnly", this.selectionOnly, (Transcription)this.transcription);
        Preferences.set("Interlinear.BlockWrapStyle", this.blockWrapStyle, null);
        Preferences.set("Interlinear.LabelsShown", this.tierLabelsShown, null);
        Preferences.set("Interlinear.LineSpacing", this.lineSpacing, null);
        Preferences.set("Interlinear.LineWrapStyle", this.lineWrapStyle, null);
        Preferences.set("Interlinear.TierSortingStyle", this.sortingStyle, null);
        Preferences.set("Interlinear.TimeCodeType", this.timeCodeType, null);
        Preferences.set("Interlinear.TimeCodeShown", this.timeCodeShown, null);
        Preferences.set("Interlinear.EmptyLineStyle", this.emptyLineStyle, null);
        Preferences.set("Interlinear.PlayMediaSel", this.playSoundSel, null);
        if (this.showSilenceDuration) {
            Preferences.set("Interlinear.SilenceDurationShown", this.showSilenceDuration, null);
            Preferences.set("Interlinear.MinSilenceDurationValue", this.minSilenceDuration, null);
            Preferences.set("NumberOfDecimalDigits", this.noOfDecimalDigits, null);
        } else {
            Preferences.set("Interlinear.SilenceDurationShown", this.showSilenceDuration, null);
        }
        String[] tierNames = new String[this.visibleTiers.size()];
        ArrayList<String> tierNameList = new ArrayList<String>(this.visibleTiers.size());
        for (int i = 0; i < this.visibleTiers.size(); ++i) {
            tierNames[i] = this.visibleTiers.get(i).getName();
            tierNameList.add(this.visibleTiers.get(i).getName());
        }
        Preferences.set("Interlinear.VisibleTiers", tierNameList, (Transcription)this.transcription);
        if (this.outputMode == 100) {
            Preferences.set("Interlinear.FontSizes", this.fontSizes, (Transcription)this.transcription);
            Preferences.set("Interlinear.BlockSpacing", this.blockSpacing, null);
            Preferences.set("Interlinear.PageNumber", this.showPageNumber, null);
        } else if (this.outputMode == 103) {
            Preferences.set("Interlinear.FontSizes", this.fontSizes, (Transcription)this.transcription);
            Preferences.set("Interlinear.HTMLPixWidth", this.getWidth(), null);
            Preferences.set("Interlinear.BlockSpacing.Text", this.blockSpacing, null);
            if (this.cachedLineWrapWidth > -1) {
                Preferences.set("Interlinear.NumCharPerLine", this.cachedLineWrapWidth, null);
            }
        } else {
            Preferences.set("Interlinear.NumCharPerLine", this.width, null);
            Preferences.set("Interlinear.BlockSpacing.Text", this.blockSpacing, null);
            if (this.outputMode == 101) {
                Preferences.set("Interlinear.InsertSpace", this.insertTabs, null);
                Preferences.set("Interlinear.TabsInsteadOfSpaces", this.tabsReplaceSpaces, null);
                if (this.cachedLineWrapWidth > -1) {
                    Preferences.set("Interlinear.NumCharPerLine", this.cachedLineWrapWidth, null);
                }
            }
        }
    }

    void loadPreferences() {
        List<String> allOrdered;
        Integer intPref;
        Boolean boolPref = Preferences.getBool("Interlinear.SelectionOnly", this.transcription);
        if (boolPref != null) {
            this.setSelectionOnly(boolPref);
        }
        if ((intPref = Preferences.getInt("Interlinear.EmptyLineStyle", null)) != null) {
            this.setEmptyLineStyle(intPref);
        }
        if ((intPref = Preferences.getInt("Interlinear.BlockWrapStyle", null)) != null) {
            this.setBlockWrapStyle(intPref);
        }
        if ((intPref = Preferences.getInt("Interlinear.LineWrapStyle", null)) != null) {
            this.setLineWrapStyle(intPref);
        }
        if ((boolPref = Preferences.getBool("Interlinear.LabelsShown", null)) != null) {
            this.setTierLabelsShown(boolPref);
        }
        if ((boolPref = Preferences.getBool("Interlinear.TimeCodeShown", null)) != null) {
            this.setTimeCodeShown(boolPref);
        }
        if ((intPref = Preferences.getInt("Interlinear.TimeCodeType", null)) != null) {
            this.setTimeCodeType(intPref);
        }
        if ((boolPref = Preferences.getBool("Interlinear.PlayMediaSel", null)) != null) {
            this.setPlaySoundSel(boolPref);
        }
        if ((boolPref = Preferences.getBool("Interlinear.SilenceDurationShown", null)) != null) {
            this.setShowSilenceDuration(boolPref);
        }
        if ((intPref = Preferences.getInt("Interlinear.MinSilenceDurationValue", null)) != null) {
            this.setMinSilenceDuration(intPref);
        }
        if ((intPref = Preferences.getInt("NumberOfDecimalDigits", null)) != null) {
            this.setNumOfDecimalDigits(intPref);
            Preferences.set("Interlinear.prefNoOfDecimalDigits", null, null);
        } else {
            intPref = Preferences.getInt("Interlinear.prefNoOfDecimalDigits", null);
            if (intPref != null) {
                Preferences.set("NumberOfDecimalDigits", intPref, null);
                Preferences.set("Interlinear.prefNoOfDecimalDigits", null, null);
                this.setNumOfDecimalDigits(intPref);
            }
        }
        List<String> visList = Preferences.getListOfString("Interlinear.VisibleTiers", this.transcription);
        ArrayList<Tier> allVis = new ArrayList<Tier>();
        if (visList != null) {
            for (String name : visList) {
                TierImpl t = this.transcription.getTierWithId(name);
                if (t == null) continue;
                allVis.add(t);
            }
        }
        List<String> at = (allOrdered = Preferences.getListOfString("Interlinear.TierOrder", this.transcription)) != null ? allOrdered : new ArrayList<String>(0);
        List<TierImpl> v = this.transcription.getTiers();
        for (TierImpl tierImpl : v) {
            String string = tierImpl.getName();
            if (allVis.contains(tierImpl) || at.contains(string)) continue;
            allVis.add(tierImpl);
        }
        this.setVisibleTiers(allVis);
        if (this.outputMode == 100 || this.outputMode == 103) {
            Map<String, Font> map;
            Map<String, Integer> pref = Preferences.getMapOfInt("Interlinear.FontSizes", this.transcription);
            if (pref != null) {
                this.fontSizes = pref;
                for (Map.Entry<String, Integer> entry : this.fontSizes.entrySet()) {
                    String tierName = entry.getKey();
                    Integer size = entry.getValue();
                    this.setFontSize(tierName, size);
                }
            }
            if ((map = Preferences.getMapOfFont("TierFonts", this.transcription)) != null) {
                for (Map.Entry<String, Font> e : map.entrySet()) {
                    String key = e.getKey();
                    Font ft = e.getValue();
                    if (key == null || ft == null) continue;
                    this.setFont(key, ft);
                }
            }
            if ((intPref = Preferences.getInt("Interlinear.LineSpacing", null)) != null) {
                this.setLineSpacing(intPref);
            }
            if ((intPref = Preferences.getInt("Interlinear.BlockSpacing", null)) != null) {
                this.setBlockSpacing(intPref);
            }
            if (this.outputMode == 100 && (boolPref = Preferences.getBool("Interlinear.PageNumber", null)) != null) {
                this.setShowPageNumber(boolPref);
            }
        }
        if (this.outputMode == 103) {
            intPref = Preferences.getInt("Interlinear.HTMLPixWidth", null);
            if (intPref != null) {
                this.setWidth(intPref);
            }
            if ((intPref = Preferences.getInt("Interlinear.BlockSpacing.Text", null)) != null) {
                this.setBlockSpacing(intPref);
            }
        } else if (this.outputMode != 100) {
            intPref = Preferences.getInt("Interlinear.NumCharPerLine", null);
            if (intPref != null) {
                this.setWidth(intPref);
                this.cachedLineWrapWidth = intPref;
            }
            if ((intPref = Preferences.getInt("Interlinear.BlockSpacing.Text", null)) != null) {
                this.setBlockSpacing(intPref);
            }
        }
        if (this.outputMode == 101) {
            boolPref = Preferences.getBool("Interlinear.InsertSpace", null);
            if (boolPref != null) {
                this.setInsertTabs(boolPref);
            }
            if ((boolPref = Preferences.getBool("Interlinear.TabsInsteadOfSpaces", null)) != null) {
                this.setTabsReplaceSpaces(boolPref);
            }
        }
    }

    public void renderView(BufferedImage bi) {
        this.calculateMetrics(bi.getGraphics());
    }

    public void renderView() {
        this.calculateMetrics();
    }

    public boolean renderPage(Graphics g, int pageIndex) {
        if (this.alignmentUnit == 0) {
            PixelRenderer.render(this, g, pageIndex);
            return true;
        }
        return false;
    }

    protected void calculateMetrics(Graphics graphics) {
        this.resetMetrics();
        this.metrics.calculateAnnotationBlocks(graphics);
        this.metrics.calculatePrintBlocks();
        this.metrics.calculatePageBreaks();
        this.setHeight(this.pageHeight * this.metrics.getPageBreaks().size());
    }

    protected void calculateMetrics() {
        this.resetMetrics();
        this.metrics.calculateAnnotationBlocks(null);
        this.metrics.calculatePrintBlocks();
        this.metrics.calculatePageBreaks();
    }

    public void drawViewOnImage(BufferedImage bi, int[] offset) {
        if (this.alignmentUnit == 0) {
            PixelRenderer.render(this, bi, offset);
        } else {
            PixelRenderer.renderCharacterPreview(this, bi, offset);
        }
    }

    public Annotation getActiveAnnotation() {
        return this.activeAnnotation;
    }

    public int getAlignmentUnit() {
        return this.alignmentUnit;
    }

    public int getBlockWrapStyle() {
        return this.blockWrapStyle;
    }

    public boolean isEmptySlotsShown() {
        return this.emptySlotsShown;
    }

    public Font getFont(String tierName) {
        Font f = this.fonts.get(tierName);
        if (f == null) {
            f = DEFAULTFONT;
        }
        return f;
    }

    public int getFontSize(String tierName) {
        int size = 0;
        Integer sizeInt = this.fontSizes.get(tierName);
        size = sizeInt != null ? sizeInt : 12;
        return size;
    }

    public int getHeight() {
        if (this.height > 0) {
            return this.height;
        }
        return 0;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public int getBlockSpacing() {
        if (this.blockSpacing < 0) {
            if (this.outputMode == 100) {
                return 20 + 3 * this.getLineSpacing();
            }
            return 2;
        }
        return this.blockSpacing;
    }

    public void setBlockSpacing(int blockSpacing) {
        this.blockSpacing = blockSpacing;
    }

    public int getLineWrapStyle() {
        return this.lineWrapStyle;
    }

    public String getMediaURL() throws IOException {
        List<MediaDescriptor> mds = this.transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            MediaDescriptor md = mds.get(0);
            if (md.mediaURL != null && !md.mediaURL.equals("")) {
                this.mediaURL = md.mediaURL;
            }
        } else {
            this.mediaURL = "";
        }
        return this.mediaURL;
    }

    public boolean isMediaVideo() {
        List<MediaDescriptor> mds = this.transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            MediaDescriptor md = mds.get(0);
            if (md.mimeType != null && md.mimeType.startsWith("video")) {
                return true;
            }
        }
        return false;
    }

    public long getMediaTime() {
        return this.mediaTime;
    }

    public long[] getSelection() {
        return this.selection;
    }

    public boolean isTierLabelsShown() {
        return this.tierLabelsShown;
    }

    public boolean isPlaySoundSel() {
        return this.playSoundSel;
    }

    public boolean isTimeCodeShown() {
        return this.timeCodeShown;
    }

    public int getTimeCodeType() {
        return this.timeCodeType;
    }

    public List<Tier> getVisibleTiers() {
        return this.visibleTiers;
    }

    public long[] getVisibleTimeInterval() {
        return this.visibleTimeInterval;
    }

    public int getWidth() {
        if (this.width > 0) {
            return this.width;
        }
        return 0;
    }

    public void setActiveAnnotation(Annotation annotation) {
        this.activeAnnotation = annotation;
    }

    public void setAlignmentUnit(int i) {
        this.alignmentUnit = i;
    }

    public void setBlockWrapStyle(int i) {
        this.blockWrapStyle = i;
    }

    public void setEmptySlotsShown(boolean b) {
        this.emptySlotsShown = b;
    }

    public void setHeight(int i) {
        this.height = i;
    }

    public void setLineSpacing(int i) {
        this.lineSpacing = i;
    }

    public void setLineWrapStyle(int i) {
        this.lineWrapStyle = i;
    }

    public void setMediaTime(long l) {
        this.mediaTime = l;
    }

    public void setSelection(long[] ls) {
        this.selection = ls;
    }

    public void setTierLabelsShown(boolean show) {
        this.tierLabelsShown = show;
    }

    public void setTimeCodeShown(boolean b) {
        this.timeCodeShown = b;
    }

    public void setShowSilenceDuration(boolean b) {
        this.showSilenceDuration = b;
    }

    public boolean isShowSilenceDuration() {
        return this.showSilenceDuration;
    }

    public void setMinSilenceDuration(int i) {
        this.minSilenceDuration = i;
    }

    public int getMinSilenceDuration() {
        return this.minSilenceDuration;
    }

    public void setTimeCodeType(int i) {
        this.timeCodeType = i;
    }

    public void setPlaySoundSel(boolean b) {
        this.playSoundSel = b;
    }

    public int getNumOfDecimalDigits() {
        return this.noOfDecimalDigits;
    }

    public void setNumOfDecimalDigits(int digits) {
        this.noOfDecimalDigits = digits;
    }

    public void setVisibleTiers(String[] strings) {
        this.visibleTiers.clear();
        if (strings != null) {
            for (String string : strings) {
                TierImpl t = this.transcription.getTierWithId(string);
                if (t == null) continue;
                this.visibleTiers.add(t);
            }
        }
    }

    public void setVisibleTiers(List<Tier> visTiers) {
        if (visTiers != null) {
            this.visibleTiers = visTiers;
        } else {
            this.visibleTiers.clear();
        }
    }

    public void setVisibleTimeInterval(long[] ls) {
        this.visibleTimeInterval = ls;
    }

    public void setWidth(int i) {
        this.width = i;
        if (i != Integer.MAX_VALUE && (this.getOutputMode() == 101 || this.getOutputMode() == 103)) {
            this.cachedLineWrapWidth = i;
        }
    }

    public void setFont(String tierName, Font f) {
        int fontSize = this.getFontSize(tierName);
        f = f.deriveFont((float)fontSize);
        this.fonts.put(tierName, f);
    }

    public void setFontSize(String tierName, int size) {
        this.fontSizes.put(tierName, size);
        this.fonts.put(tierName, this.getFont(tierName).deriveFont((float)size));
    }

    public int getEmptyLineStyle() {
        return this.emptyLineStyle;
    }

    public void setEmptyLineStyle(int i) {
        this.emptyLineStyle = i;
    }

    public int getSortingStyle() {
        return this.sortingStyle;
    }

    public void setSortingStyle(int i) {
        this.sortingStyle = i;
    }

    public TranscriptionImpl getTranscription() {
        return this.transcription;
    }

    public int getOutputMode() {
        return this.outputMode;
    }

    public void setOutputMode(int mode) {
        this.outputMode = mode;
    }

    public int getPageHeight() {
        return this.pageHeight;
    }

    public void setPageHeight(int height) {
        this.pageHeight = height;
    }

    public int getCharEncoding(String tierName) {
        int encoding = 0;
        if (tierName == null) {
            return encoding;
        }
        if (!this.charEncodings.containsKey(tierName)) {
            return encoding;
        }
        Integer encodingInt = this.charEncodings.get(tierName);
        if (encodingInt != null) {
            encoding = encodingInt;
        }
        return encoding;
    }

    public void setCharEncoding(String tierName, int charEncoding) {
        this.charEncodings.put(tierName, charEncoding);
    }

    public int getEmptySpace() {
        return this.emptySpace;
    }

    public BlockMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isSelectionOnly() {
        return this.selectionOnly;
    }

    public void setSelectionOnly(boolean b) {
        this.selectionOnly = b;
    }

    public void setTimeCodeMultiplicity(int style) {
        this.timeCodeMultiplicity = style;
    }

    public int getTimeCodeMultiplicity() {
        return this.timeCodeMultiplicity;
    }

    public boolean isInsertTabs() {
        return this.insertTabs;
    }

    public void setInsertTabs(boolean insertTabs) {
        this.insertTabs = insertTabs;
    }

    public boolean isTabsReplaceSpaces() {
        return this.tabsReplaceSpaces;
    }

    public void setTabsReplaceSpaces(boolean tabsReplaceSpaces) {
        this.tabsReplaceSpaces = tabsReplaceSpaces;
    }

    public long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(long timeOffset) {
        this.timeOffset = timeOffset;
    }

    public boolean isShowPageNumber() {
        return this.showPageNumber;
    }

    public void setShowPageNumber(boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }
}

