/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PreviewPanelTimeAlignedInterlinear
extends JPanel
implements ComponentListener,
AdjustmentListener {
    private BufferedImage bi;
    private JScrollPane scrollPane;
    private int[] offset = new int[]{0, 0};
    private Dimension visibleDimensions = new Dimension(550, 600);
    private JEditorPane htmlPanel;
    private String htmlText;

    public PreviewPanelTimeAlignedInterlinear() {
        this.initComponents();
    }

    private void initComponents() {
        this.htmlPanel = new JEditorPane();
        this.htmlPanel.setContentType("text/html");
        this.htmlPanel.setEditable(false);
        this.scrollPane = new JScrollPane(this.htmlPanel);
        this.scrollPane.setPreferredSize(this.visibleDimensions);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(12);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(12);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.scrollPane, gbc);
        this.createBufferedImage(10, 10);
        this.addComponentListener(this);
    }

    private void createBufferedImage(int width, int height) {
        if (this.bi == null || this.bi.getWidth() < width || this.bi.getHeight() < height) {
            this.bi = new BufferedImage(width, height, 1);
            this.repaint();
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bi;
    }

    public int[] getOffset() {
        return this.offset;
    }

    public void updateView() {
        if (!this.htmlText.equals(null)) {
            final int vscroll = this.scrollPane.getVerticalScrollBar().getValue();
            this.htmlPanel.setText(this.htmlText);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviewPanelTimeAlignedInterlinear.this.scrollPane.getVerticalScrollBar().setValue(vscroll);
                }
            });
        } else {
            this.htmlPanel.setText("htmlText equals null.");
        }
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.createBufferedImage(this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.offset[0] = this.scrollPane.getHorizontalScrollBar().getValue();
        this.offset[1] = this.scrollPane.getVerticalScrollBar().getValue();
        this.repaint();
    }

    public String getHtmlText() {
        return this.htmlText;
    }

    public void setHtmlText(String htmlText) {
        this.htmlText = htmlText;
    }

    private class ImagePanel
    extends JPanel {
        private ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (PreviewPanelTimeAlignedInterlinear.this.bi != null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.drawImage((Image)PreviewPanelTimeAlignedInterlinear.this.bi, PreviewPanelTimeAlignedInterlinear.this.offset[0], PreviewPanelTimeAlignedInterlinear.this.offset[1], null);
            }
        }
    }
}

