/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import mpi.eudico.client.annotator.interlinear.Interlinear;
import mpi.eudico.client.annotator.interlinear.ToolboxRenderer;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.AnnotationDocEncoder;
import mpi.eudico.server.corpora.clom.EncoderInfo;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;

public class ToolboxEncoder
implements AnnotationDocEncoder {
    private final String NEWLINE = "\n";
    private final String EMPTY = "";
    private final String SPACE = " ";
    private final String defaultDBType = "ElanExport";
    private final String elanMediaURLLabel = "\\ELANMediaURL";
    private final String elanMediaExtractedLabel = "\\ELANMediaExtracted";
    private final String elanMediaMIMELabel = "\\ELANMediaMIME";
    private final String elanMediaOriginLabel = "\\ELANMediaOrigin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeAndSave(Transcription transcription, EncoderInfo encoderInfo, List<TierImpl> tierOrder, String path) throws IOException {
        if (transcription == null) {
            ClientLogger.LOG.severe("Transcription object is null");
            throw new NullPointerException("Transcription object is null");
        }
        if (path == null) {
            ClientLogger.LOG.severe("Export file is null");
            throw new NullPointerException("Export file is null");
        }
        Interlinear interlinear = new Interlinear((TranscriptionImpl)transcription, 102);
        ToolboxEncoderInfo tei = (ToolboxEncoderInfo)encoderInfo;
        if (encoderInfo != null) {
            interlinear.setWidth(tei.getPageWidth());
            interlinear.setBlockWrapStyle(0);
            if (tei.isWrapLines()) {
                interlinear.setLineWrapStyle(tei.getLineWrapStyle());
            } else {
                interlinear.setLineWrapStyle(3);
            }
            if (tei.isIncludeEmptyMarkers()) {
                interlinear.setEmptyLineStyle(0);
            } else if (interlinear.getLineWrapStyle() == 5 || interlinear.getWidth() != Integer.MAX_VALUE) {
                interlinear.setEmptyLineStyle(0);
            }
            interlinear.setBlockSpacing(1);
            interlinear.setTierLabelsShown(true);
            interlinear.setTimeCodeShown(false);
            interlinear.setPlaySoundSel(false);
            interlinear.setShowSilenceDuration(false);
            interlinear.setTimeCodeType(tei.getTimeFormat());
            interlinear.setTimeOffset(tei.getTimeOffset());
        }
        try (BufferedWriter writer = null;){
            FileOutputStream out = new FileOutputStream(path);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            writer = new BufferedWriter(osw);
            this.writeHeader(writer, tei.getDatabaseType());
            ToolboxRenderer renderer = new ToolboxRenderer();
            renderer.renderText(writer, interlinear, tei);
            this.writeMediaDescriptors(writer, transcription);
        }
        if (writer != null) {
            writer.close();
        }
    }

    private void writeHeader(Writer writer, String dbType) throws IOException {
        if (dbType != null) {
            writer.write("\\_sh v3.0  400  " + dbType + "\n");
        } else {
            writer.write("\\_sh v3.0  400  ElanExport\n");
        }
        writer.write("\\_DateStampHasFourDigitYear\n");
        writer.write("\n\n");
    }

    private void writeMediaDescriptors(Writer writer, Transcription transcription) throws IOException {
        List<MediaDescriptor> mds = transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            writer.write("\n");
            for (int i = 0; i < mds.size(); ++i) {
                MediaDescriptor md = mds.get(i);
                if (md.mediaURL != null && !md.mediaURL.equals("")) {
                    writer.write("\\ELANMediaURL " + md.mediaURL + "\n");
                }
                if (md.mimeType != null && !md.mimeType.equals("")) {
                    writer.write("\\ELANMediaMIME " + md.mimeType + "\n");
                }
                if (md.timeOrigin != 0L) {
                    writer.write("\\ELANMediaOrigin " + md.timeOrigin + "\n");
                }
                if (md.extractedFrom == null || md.extractedFrom.equals("")) continue;
                writer.write("\\ELANMediaExtracted " + md.extractedFrom + "\n");
            }
        }
    }
}

