/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import mpi.eudico.client.annotator.interlinear.IGTTierType;
import mpi.eudico.client.annotator.interlinear.edit.IGTViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTDataModelListener;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTViewerModelEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.IGTViewerModelListener;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTDataModel;

public class IGTViewerModelImpl
implements IGTViewerModel,
IGTDataModelListener,
TableModel {
    private List<IGTDataModel> rowData;
    private int editingRow = -1;
    private boolean isExpanded = false;
    private List<IGTViewerModelListener> listeners;
    private Collection<String> hiddenTiers;
    private List<String> visibleParticipants;
    private List<String> visibleTiersCollapsed;
    private boolean timeCodesVisible = true;
    private boolean speakerLabelsVisible = true;
    protected EventListenerList listenerList = new EventListenerList();

    public IGTViewerModelImpl() {
        this.rowData = new ArrayList<IGTDataModel>();
        this.listeners = new ArrayList<IGTViewerModelListener>(4);
    }

    @Override
    public int getRowCount() {
        return this.rowData.size();
    }

    @Override
    public int getEditingRow() {
        return this.editingRow;
    }

    @Override
    public void startEditingRow(int row) {
        this.editingRow = row;
    }

    @Override
    public boolean getExpandedState() {
        return this.isExpanded;
    }

    @Override
    public void setExpandedState(boolean expanded) {
        this.isExpanded = expanded;
    }

    @Override
    public void setVisibleTiersInCollapsedState(List<String> tierNames) {
        this.visibleTiersCollapsed = tierNames;
    }

    @Override
    public List<String> getVisibleTiersInCollapsedState() {
        return this.visibleTiersCollapsed;
    }

    @Override
    public void setHiddenTiers(Collection<String> tierNames) {
        this.hiddenTiers = tierNames;
    }

    @Override
    public Collection<String> getHiddenTiers() {
        return this.hiddenTiers;
    }

    @Override
    public void setVisibleParticipants(List<String> partNames) {
        this.visibleParticipants = partNames;
    }

    @Override
    public List<String> getVisibleParticipants() {
        return this.visibleParticipants;
    }

    @Override
    public void setSpecialTierVisibility(IGTTierType specialTier, boolean visible) {
        switch (specialTier) {
            case TIME_CODE: {
                if (visible == this.timeCodesVisible) break;
                for (IGTDataModel dataModel : this.rowData) {
                    dataModel.setSpecialTierVisibility(specialTier, visible);
                }
                this.timeCodesVisible = visible;
                if (this.rowData.size() <= 0) break;
                this.fireTableRowsUpdated(0, this.rowData.size() - 1);
                break;
            }
            case SPEAKER_LABEL: {
                if (visible == this.speakerLabelsVisible) break;
                for (IGTDataModel dataModel : this.rowData) {
                    dataModel.setSpecialTierVisibility(specialTier, visible);
                }
                this.speakerLabelsVisible = visible;
                if (this.rowData.size() <= 0) break;
                this.fireTableRowsUpdated(0, this.rowData.size() - 1);
                break;
            }
        }
    }

    @Override
    public boolean getSpecialTierVisibility(IGTTierType specialTier) {
        switch (specialTier) {
            case TIME_CODE: {
                return this.timeCodesVisible;
            }
            case SPEAKER_LABEL: {
                return this.speakerLabelsVisible;
            }
        }
        return false;
    }

    @Override
    public void addRow(IGTDataModel nextRowData) {
        if (nextRowData != null) {
            this.rowData.add(nextRowData);
            nextRowData.addIGTDataModelListener(this);
            int rowNr = this.rowData.size() - 1;
            this.fireTableRowsInserted(rowNr, rowNr);
        }
    }

    @Override
    public void insertRow(IGTDataModel nextRowData, int row) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("Insert row, index is less than zero: " + row);
        }
        if (row > this.rowData.size()) {
            throw new ArrayIndexOutOfBoundsException("Insert row, index is greater than model size: " + row);
        }
        if (this.rowData != null) {
            this.rowData.add(row, nextRowData);
            nextRowData.addIGTDataModelListener(this);
            this.fireTableRowsInserted(row, row);
        }
    }

    @Override
    public IGTDataModel getRowData(int row) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("Get row, index is less than zero: " + row);
        }
        if (row > this.rowData.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("Get row, index is greater than model size: " + row);
        }
        return this.rowData.get(row);
    }

    @Override
    public IGTDataModel removeRow(int row) throws ArrayIndexOutOfBoundsException {
        if (row < 0) {
            throw new ArrayIndexOutOfBoundsException("Remove row, index is less than zero: " + row);
        }
        if (row > this.rowData.size() - 1) {
            throw new ArrayIndexOutOfBoundsException("Remove row, index is greater than model size: " + row);
        }
        IGTDataModel remRowData = this.rowData.remove(row);
        if (remRowData != null) {
            remRowData.removeIGTDataModelListener(this);
        }
        this.fireTableRowsDeleted(row, row);
        return remRowData;
    }

    @Override
    public boolean removeRowData(IGTDataModel remRowData) {
        if (remRowData == null) {
            return false;
        }
        int rowNr = this.rowData.indexOf(remRowData);
        if (rowNr >= 0) {
            this.rowData.remove(rowNr);
            remRowData.removeIGTDataModelListener(this);
            this.fireTableRowsDeleted(rowNr, rowNr);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAllRows() {
        int numRows = this.rowData.size();
        if (numRows == 0) {
            return true;
        }
        for (int i = numRows - 1; i >= 0; --i) {
            IGTDataModel remRowData = this.rowData.remove(i);
            remRowData.removeIGTDataModelListener(this);
        }
        this.fireTableRowsDeleted(0, numRows - 1);
        return this.rowData.isEmpty();
    }

    @Override
    public synchronized void addIGTViewerModelListener(IGTViewerModelListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void removeIGTViewerModelListener(IGTViewerModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dataModelChanged(IGTDataModelEvent event) {
        IGTDataModel rowModel;
        int rowIndex;
        if (event != null && (rowIndex = this.rowData.indexOf(rowModel = (IGTDataModel)event.getSource())) > -1) {
            IGTViewerModelEvent vmEvent = new IGTViewerModelEvent((IGTViewerModel)this, rowIndex, event);
            for (IGTViewerModelListener l : this.listeners) {
                l.viewerModelChanged(vmEvent);
            }
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return "IGTGroup";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return IGTDataModel.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.getRowData(rowIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(TableModelListener.class, l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(TableModelListener.class, l);
    }

    public TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.listenerList.getListeners(TableModelListener.class);
    }

    public void fireTableChanged(TableModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableModelListener.class) continue;
            ((TableModelListener)listeners[i + 1]).tableChanged(e);
        }
    }

    public void fireTableRowsInserted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 1));
    }

    public void fireTableRowsUpdated(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, 0));
    }

    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        this.fireTableChanged(new TableModelEvent(this, firstRow, lastRow, -1, -1));
    }
}

