/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import mpi.eudico.client.annotator.interlinear.edit.IGTCalculator;
import mpi.eudico.client.annotator.interlinear.edit.IGTSuggestionRenderer;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTAnnotation;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTTier;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTBlockRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTNodeRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTSuggestionRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.IGTViewerRenderInfo;
import mpi.eudico.client.annotator.interlinear.edit.render.SuggestionFlowLayout;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexCont;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;

public class SuggestionComponent
extends JComponent
implements SuggestionFlowLayout.Location,
MouseMotionListener {
    private int sugIndex;
    private IGTSuggestionModel sugModel;
    private IGTSuggestionRenderInfo sugRenderInfo;
    private IGTViewerRenderInfo viewerRenderInfo;
    private IGTSuggestionViewerModel svModel;
    private int fragNr;
    static final int NO_FRAG = -99999;
    private static final String htmlTTTableOpen = "<html><table>";
    private static final String htmlTTTableClose = "</table></html>";
    private static final String htmlTTRow = "<tr><td>%s</td><td>%s</td></tr>";
    private int incrementalModeLevel = -1;

    public SuggestionComponent(int sugIndex, IGTViewerRenderInfo viewerRenderInfo, IGTSuggestionViewerModel svModel) {
        this.sugIndex = sugIndex;
        this.viewerRenderInfo = viewerRenderInfo;
        this.svModel = svModel;
        this.sugModel = svModel.getRowData(sugIndex);
        this.sugRenderInfo = (IGTSuggestionRenderInfo)this.sugModel.getRenderInfo();
        this.fragNr = -99999;
        this.sugModel.showTierLabels(sugIndex == 0);
        this.sugModel.getRenderInfo().height = 75;
        this.sugModel.getRenderInfo().width = 120;
        String label = this.sugModel.getSuggestionSet().getLabel();
        if (label != null) {
            this.setToolTipText(label);
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 1L) != 0L && e.getChanged() == SuggestionComponent.this) {
                    SuggestionComponent.this.calculateLocationAndSize();
                    SuggestionComponent.this.removeHierarchyListener(this);
                }
            }
        });
        this.addMouseMotionListener(this);
    }

    private void calculateLocationAndSize() {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        int tierRowCount = this.sugModel.getRowCount();
        if (tierRowCount > 0) {
            IGTTier rootTier = this.sugModel.getRootRow();
            int w = IGTCalculator.calculateTierAndAnnotationsLAS(g, this.viewerRenderInfo, rootTier, true);
            IGTBlockRenderInfo sugRenderInfo = this.sugModel.getRenderInfo();
            sugRenderInfo.width = w;
            if (this.sugModel.showTierLabels()) {
                sugRenderInfo.width += this.svModel.getRenderInfo().rowHeaderWidth;
            }
            int h = this.svModel.getRenderInfo().getColumnHeaderHeight(g) - this.viewerRenderInfo.getHeightForTier(g, rootTier.getTierName());
            h += this.viewerRenderInfo.vertLineMargin;
            h += IGTCalculator.calculateTierYPositionRecursive(g, this.viewerRenderInfo, rootTier, h);
            sugRenderInfo.height = h += this.viewerRenderInfo.vertLineMargin;
        }
    }

    public void setFragNr(int fragNr) {
        if (this.fragNr != fragNr) {
            this.fragNr = fragNr;
            if (this.fragNr > -99999) {
                int hash = this.getHashOfFrag(fragNr);
                int colour = (int)((long)hash * 31L % 262143L);
                int cr = 0x80 | colour >> 11 & 0x7E;
                int cg = 0x80 | colour >> 5 & 0x7E;
                int cb = 0x80 | colour << 1 & 0x7E;
                this.sugRenderInfo.setHighlightBGColor(new Color(cr, cg, cb));
            } else {
                this.sugRenderInfo.setHighlightBGColor(null);
            }
            this.repaint();
        }
    }

    public int getFragNr() {
        return this.fragNr;
    }

    public void setIncrementalModeLevel(int level) {
        this.incrementalModeLevel = level;
    }

    @Override
    public void paintComponent(Graphics g) {
        Rectangle rect;
        if (this.incrementalModeLevel > -1) {
            this.paintComponentIM(g);
            return;
        }
        IGTSuggestionRenderer.renderOneSuggestion(g, this.sugIndex, this.viewerRenderInfo, this.svModel);
        if (this.fragNr > -99999 && (rect = this.getRectOfFrag(this.fragNr)) != null) {
            int height = this.sugRenderInfo.height;
            int rx = rect.x;
            int ww = rect.width;
            if (this.fragNr != 0) {
                --rx;
                ww += 2;
            } else {
                ++ww;
            }
            if (this.fragNr == this.sugModel.getColumnCountForRow(1) - 1) {
                ww -= 2;
            }
            g.setColor(Color.BLUE);
            g.drawRect(rx, rect.y - 1, ww, height - rect.y - 2);
        }
    }

    private void paintComponentIM(Graphics g) {
        IGTSuggestionRenderer.renderOneSuggestion(g, this.sugIndex, this.incrementalModeLevel, this.viewerRenderInfo, this.svModel);
        Rectangle rect = this.getRectOfFrag(this.incrementalModeLevel);
        if (rect != null) {
            int height = this.sugModel.getRenderInfo().height;
            int rx = rect.x;
            int ww = rect.width;
            if (this.incrementalModeLevel != 0) {
                --rx;
                ww += 2;
            } else {
                ++ww;
            }
            if (this.incrementalModeLevel == this.sugModel.getColumnCountForRow(1) - 1) {
                ww -= 2;
            }
            g.setColor(Color.BLUE);
            g.drawRect(rx, rect.y - 1, ww, height - rect.y - 2);
            int cvx = rect.x + rect.width + 2;
            int cvw = this.sugModel.getRenderInfo().width - cvx;
            Color col = this.svModel.getRenderInfo().blockBackGround;
            if (this.fragNr > -99999 && ((IGTSuggestionRenderInfo)this.sugModel.getRenderInfo()).getHighlightBGColor() != null) {
                col = ((IGTSuggestionRenderInfo)this.sugModel.getRenderInfo()).getHighlightBGColor();
            }
            g.setColor(col);
            g.fillRect(cvx, rect.y - 2, cvw, height - rect.y - 1);
        }
    }

    private IGTAnnotation getFrag(int fragNr) {
        IGTSuggestionModel sugg = this.svModel.getRowData(this.sugIndex);
        IGTTier firstTier = sugg.getRowData(1);
        ArrayList<IGTAnnotation> annotations = firstTier.getAnnotations();
        int size = annotations.size();
        if (fragNr < 0) {
            fragNr += size;
        }
        if (fragNr >= 0 && fragNr < size) {
            return annotations.get(fragNr);
        }
        return null;
    }

    public int getHashOfFrag(int fragNr) {
        IGTAnnotation firstPart = this.getFrag(fragNr);
        if (firstPart != null) {
            return firstPart.hashCodeOfText();
        }
        return 0;
    }

    public Rectangle getRectOfFrag(int fragNr) {
        IGTAnnotation firstPart = this.getFrag(fragNr);
        if (firstPart != null) {
            IGTNodeRenderInfo ri = firstPart.getRenderInfo();
            int offx = this.sugModel.showTierLabels() ? this.svModel.getRenderInfo().rowHeaderWidth : 0;
            return new Rectangle(offx + ri.x, ri.y, ri.calcWidth, ri.height);
        }
        return null;
    }

    public int getFragOfX(int x, boolean fromRight) {
        IGTSuggestionModel sugg = this.svModel.getRowData(this.sugIndex);
        IGTTier firstTier = sugg.getRowData(1);
        ArrayList<IGTAnnotation> annotations = firstTier.getAnnotations();
        int offx = this.sugModel.showTierLabels() ? this.svModel.getRenderInfo().rowHeaderWidth : 0;
        x -= offx;
        int fragNr = -1;
        for (IGTAnnotation ann : annotations) {
            IGTNodeRenderInfo ri = ann.getRenderInfo();
            if (ri.x > x) break;
            ++fragNr;
        }
        if (fragNr < 0) {
            fragNr = -99999;
        } else if (fromRight) {
            fragNr -= annotations.size();
        }
        return fragNr;
    }

    private boolean inColumnHeader(int yPos) {
        return yPos < this.svModel.renderInfo.getColumnHeaderHeight() + this.svModel.renderInfo.suggestionMargin;
    }

    @Override
    public Dimension getPreferredSize() {
        IGTBlockRenderInfo renderInfo = this.sugModel.getRenderInfo();
        return new Dimension(renderInfo.width, renderInfo.height);
    }

    public int getIndex() {
        return this.sugIndex;
    }

    @Override
    public void setGrid(int col, int row) {
        IGTBlockRenderInfo sugRenderInfo = this.sugModel.getRenderInfo();
        if (col == 0) {
            if (!this.sugModel.showTierLabels()) {
                sugRenderInfo.width += this.svModel.getRenderInfo().rowHeaderWidth;
                this.sugModel.showTierLabels(true);
            }
        } else if (this.sugModel.showTierLabels()) {
            sugRenderInfo.width -= this.svModel.getRenderInfo().rowHeaderWidth;
            this.sugModel.showTierLabels(false);
        }
        this.setSize(sugRenderInfo.width, sugRenderInfo.height);
    }

    @Override
    public Dimension getPreferredSize(int col, int row) {
        IGTBlockRenderInfo sugRenderInfo = this.sugModel.getRenderInfo();
        int width = sugRenderInfo.width;
        if (col == 0) {
            if (!this.sugModel.showTierLabels()) {
                width += this.svModel.getRenderInfo().rowHeaderWidth;
            }
        } else if (this.sugModel.showTierLabels()) {
            width -= this.svModel.getRenderInfo().rowHeaderWidth;
        }
        return new Dimension(width, sugRenderInfo.height);
    }

    @Override
    public void setPreferredSize(Dimension dim) {
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.setFragNr(-99999);
            this.incrementalModeLevel = -1;
        }
    }

    public void workAroundToolTipBug(MouseAndMotionListener mml) {
        this.addMouseListener(mml);
        this.addMouseMotionListener(mml);
    }

    public void removeWorkAroundToolTipBug(MouseAndMotionListener mml) {
        this.removeMouseListener(mml);
        this.removeMouseMotionListener(mml);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.isShiftDown() || e.isAltDown()) {
            int x = e.getX();
            int frag = this.getFragOfX(x, e.isAltDown());
            if (frag != this.fragNr) {
                Container parent = this.getParent();
                for (Component sibling : parent.getComponents()) {
                    if (!(sibling instanceof SuggestionComponent)) continue;
                    SuggestionComponent sc = (SuggestionComponent)sibling;
                    sc.setFragNr(frag);
                }
            }
        } else if (this.inColumnHeader(e.getY())) {
            String label = this.sugModel.getSuggestionSet().getLabel();
            if (label != null) {
                this.setToolTipText(label);
            }
        } else {
            int frag = this.getFragOfX(e.getX(), e.isAltDown());
            if (this.incrementalModeLevel > -1 && frag > this.incrementalModeLevel) {
                this.setToolTipText(null);
                return;
            }
            if (frag > -1) {
                IGTSuggestionModel curModel = this.svModel.getRowData(this.sugIndex);
                SuggestionSet suggset = curModel.getSuggestionSet();
                if (frag < suggset.getSuggestions().size()) {
                    Suggestion s = (Suggestion)suggset.getSuggestions().get(frag);
                    if (s.getLexEntry() != null) {
                        this.setToolTipText(this.getToolTipText(s.getLexEntry()));
                    } else {
                        this.setToolTipText(s.getContent());
                    }
                }
            } else {
                this.setToolTipText(null);
            }
        }
    }

    private String getToolTipText(LexEntry entry) {
        if (entry != null) {
            StringBuilder sb = new StringBuilder(htmlTTTableOpen);
            for (int i = 0; i < entry.getLexItems().size(); ++i) {
                LexCont lc;
                LexItem lex = (LexItem)entry.getLexItems().get(i);
                if (lex instanceof LexAtom) {
                    sb.append(String.format(htmlTTRow, lex.getType(), ((LexAtom)lex).getLexValue()));
                    continue;
                }
                if (!(lex instanceof LexCont) || (lc = (LexCont)lex).getLexItems() == null) continue;
                for (LexItem li : lc.getLexItems()) {
                    sb.append(String.format(htmlTTRow, li.getType(), ((LexAtom)li).getLexValue()));
                }
            }
            sb.append(htmlTTTableClose);
            return sb.toString();
        }
        return null;
    }

    public static interface MouseAndMotionListener
    extends MouseListener,
    MouseMotionListener {
    }
}

