/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.awt.Component;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.commands.AnnotationsFromSuggestionSetCommand;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.interlinear.edit.TextAnalyzerRegistry;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerConfig;
import mpi.eudico.client.annotator.interlinear.edit.config.AnalyzerTypeConfig;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSelectionEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSelectionListener;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetEvent;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetListener;
import mpi.eudico.client.annotator.interlinear.edit.event.SuggestionSetProvider;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionModel;
import mpi.eudico.client.annotator.interlinear.edit.model.IGTSuggestionViewerModel;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import mpi.eudico.util.Pair;
import nl.mpi.lexan.analyzers.LexiconTextAnalyzer;
import nl.mpi.lexan.analyzers.TextAnalyzer;
import nl.mpi.lexan.analyzers.TextAnalyzerContext;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.helpers.Information;
import nl.mpi.lexan.analyzers.helpers.LexanSuggestionSelectionListener;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.PositionLexicon;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.helpers.prompt.Prompt;

public class TextAnalyzerHostContext
implements TextAnalyzerContext,
SuggestionSelectionListener,
SuggestionSetProvider {
    private File analyzerCacheFolder = new File(Constants.ELAN_DATA_DIR, "Analyzers");
    private InterlinearizationManager manager;
    private Transcription transcription;
    private List<SuggestionSetListener> suggestionListeners;
    private List<LexanSuggestionSelectionListener> suggestionSelectionListeners;
    private List<TextAnalyzer> loadedAnalyzers;
    private Map<String, List<TextAnalyzer>> sourceAnalyzerMap;
    private List<AnalyzerConfig> configs;
    private Map<AnalyzerConfig, List<SourceTargetConfiguration>> configsMap;
    private boolean recursive = false;
    private boolean sugWindowOpened = false;
    private boolean autoAnalyzeMode = false;
    private Deque<Pair<TextAnalyzer, Position>> positionQueue;

    public TextAnalyzerHostContext(InterlinearizationManager manager) {
        this.manager = manager;
        this.transcription = manager.getTranscription();
        this.loadedAnalyzers = new ArrayList<TextAnalyzer>();
        this.configs = new ArrayList<AnalyzerConfig>(6);
        this.configsMap = new HashMap<AnalyzerConfig, List<SourceTargetConfiguration>>(6);
        this.suggestionListeners = new ArrayList<SuggestionSetListener>(4);
        this.sourceAnalyzerMap = new HashMap<String, List<TextAnalyzer>>();
        this.positionQueue = new ArrayDeque<Pair<TextAnalyzer, Position>>();
        this.ensureCacheFolder();
    }

    public void ensureCacheFolder() {
        block6: {
            if (this.analyzerCacheFolder == null) {
                this.analyzerCacheFolder = new File(Constants.ELAN_DATA_DIR, "Analyzers");
            }
            try {
                if (this.analyzerCacheFolder.exists()) break block6;
                try {
                    this.analyzerCacheFolder.mkdir();
                }
                catch (Throwable t) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning(String.format("Cannot create the cache folder for analyzers: %s", t.getMessage()));
                    }
                    return;
                }
            }
            catch (Throwable thr) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block6;
                ClientLogger.LOG.warning(String.format("Cannot check the existence of the analyzers cache folder: %s", thr.getMessage()));
            }
        }
    }

    public Transcription getTranscription() {
        return this.transcription;
    }

    public void addConfig(AnalyzerConfig config) {
        if (!this.configs.contains(config)) {
            this.configs.add(config);
            List<SourceTargetConfiguration> sourceTargetConfList = this.convertToSTConfList(config);
            TextAnalyzer ta = TextAnalyzerRegistry.getInstance().getAnalyzerForDocAndConfig(this.transcription.getURN().toString(), config.getAnnotId(), config.getConfigKey());
            boolean success = false;
            if (ta != null) {
                if (this.loadedAnalyzers.contains(ta)) {
                    success = ta.partLoad(sourceTargetConfList);
                } else {
                    boolean bl = success = ta == this.loadAnalyzer(config, sourceTargetConfList);
                }
            }
            if (success) {
                for (SourceTargetConfiguration stc : sourceTargetConfList) {
                    List<TextAnalyzer> la = this.sourceAnalyzerMap.get(stc.getSource().getTierId());
                    if (la == null) {
                        la = new ArrayList<TextAnalyzer>();
                        this.sourceAnalyzerMap.put(stc.getSource().getTierId(), la);
                    }
                    la.add(ta);
                }
                this.configsMap.put(config, sourceTargetConfList);
            }
            if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.fine(String.format("Initialized annotation analyzer '%s': %s\n", config.getAnnotId().getName(), success));
            }
            this.manager.getInterEditor().configsChanged();
        }
    }

    private Position tierToPosition(Tier tier) {
        if (tier == null) {
            return null;
        }
        Object pos = null;
        LinguisticType sourceType = tier.getLinguisticType();
        LexiconQueryBundle2 lexBundle = sourceType.getLexiconQueryBundle();
        if (lexBundle != null) {
            String lexiconName = lexBundle.getLink().getLexId().getName();
            String field = lexBundle.getFldId().getName();
            pos = lexiconName != null && field != null ? new PositionLexicon(tier.getName(), lexiconName, field, tier.getLangRef()) : new Position(tier.getName());
        } else {
            pos = new Position(tier.getName());
        }
        return pos;
    }

    private SourceTargetConfiguration convertToSTConfiguration(AnalyzerConfig ac) {
        if (ac == null || ac instanceof AnalyzerTypeConfig) {
            return null;
        }
        Tier sourceTier = this.transcription.getTierWithId(ac.getSource());
        if (sourceTier == null) {
            return null;
        }
        Position sourcePos = this.tierToPosition(sourceTier);
        if (sourcePos == null) {
            return null;
        }
        ArrayList<Position> targetPosList = new ArrayList<Position>(2);
        for (String targetName : ac.getDest()) {
            Tier targetTier = this.transcription.getTierWithId(targetName);
            Position targetPos = this.tierToPosition(targetTier);
            if (targetPos == null) continue;
            targetPosList.add(targetPos);
        }
        if (targetPosList.isEmpty()) {
            return null;
        }
        SourceTargetConfiguration stConfig = new SourceTargetConfiguration(sourcePos, targetPosList);
        stConfig.setDocumentId(this.transcription.getURN().toString());
        return stConfig;
    }

    private List<SourceTargetConfiguration> convertToSTConfList(AnalyzerConfig ac) {
        if (ac == null) {
            return null;
        }
        ArrayList<SourceTargetConfiguration> sourceTargetList = new ArrayList<SourceTargetConfiguration>();
        List<AnalyzerConfig> acTierConfList = ac.getTierConfigurations();
        for (AnalyzerConfig anaCon : acTierConfList) {
            SourceTargetConfiguration stc = this.convertToSTConfiguration(anaCon);
            if (stc == null) continue;
            sourceTargetList.add(stc);
        }
        return sourceTargetList;
    }

    public void removeConfig(AnalyzerConfig config) {
        if (this.configs.remove(config)) {
            List<SourceTargetConfiguration> sourceTargetConfList = this.configsMap.get(config);
            if (sourceTargetConfList == null || sourceTargetConfList.isEmpty()) {
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    ClientLogger.LOG.log(Level.INFO, String.format("Source-target configuration not removed for analyzer config: %s", config.toString()));
                }
                return;
            }
            this.unloadAnalyzer(config, sourceTargetConfList);
            for (SourceTargetConfiguration stc : sourceTargetConfList) {
                List<TextAnalyzer> la = this.sourceAnalyzerMap.remove(stc.getSource().getTierId());
                if (!ClientLogger.LOG.isLoggable(Level.FINE)) continue;
                ClientLogger.LOG.fine(String.format("Removed %d analyzer(s) for source %s", la == null ? 0 : la.size(), stc.getSource().getTierId()));
            }
        }
    }

    public List<AnalyzerConfig> getConfigurations() {
        return this.configs;
    }

    public List<Information> listTextAnalyzersInfo() {
        return TextAnalyzerRegistry.getInstance().getAnalyzersInfo();
    }

    public List<TextAnalyzer> getAnalyzerInstances(Information info, String configKey) {
        return TextAnalyzerRegistry.getInstance().getAnalyzersForConfig(info, configKey);
    }

    public boolean isAnalyzerSource(String tierName) {
        if (tierName != null) {
            Tier t = this.transcription.getTierWithId(tierName);
            String typeName = t.getLinguisticType().getLinguisticTypeName();
            for (AnalyzerConfig ac : this.configs) {
                if (!ac.getSource().equals(typeName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConfigurable(Information info) {
        if (info == null) {
            return false;
        }
        for (TextAnalyzer a : this.loadedAnalyzers) {
            if (!info.equals((Object)a.getInformation())) continue;
            return a.isConfigurable();
        }
        return false;
    }

    private TextAnalyzer loadAnalyzer(AnalyzerConfig config, List<SourceTargetConfiguration> stConfigs) {
        if (stConfigs == null || stConfigs.isEmpty()) {
            return null;
        }
        TextAnalyzer ta = TextAnalyzerRegistry.getInstance().getAnalyzerForDocAndConfig(this.transcription.getURN().toString(), config.getAnnotId(), config.getConfigKey());
        if (ta != null) {
            this.prepareAnalyzer(ta);
            if (ta.load(stConfigs)) {
                ta.loadSettingsFor(config.getConfigKey());
                this.loadedAnalyzers.add(ta);
                return ta;
            }
        }
        return null;
    }

    private void unloadAnalyzer(AnalyzerConfig config, List<SourceTargetConfiguration> stConfigs) {
        TextAnalyzer toUnLoad = null;
        for (TextAnalyzer a : this.loadedAnalyzers) {
            if (!config.getAnnotId().equals((Object)a.getInformation())) continue;
            toUnLoad = a;
            break;
        }
        if (toUnLoad == null) {
            return;
        }
        if (toUnLoad.partUnload(stConfigs) == 0) {
            toUnLoad.unload();
            this.loadedAnalyzers.remove(toUnLoad);
            toUnLoad.setAnalyzerContext(null);
            if (toUnLoad instanceof LexiconTextAnalyzer) {
                ((LexiconTextAnalyzer)toUnLoad).setLexiconContext(null);
            }
            TextAnalyzerRegistry.getInstance().removeAnalyzerForDocAndConfig(this.transcription.getURN().toString(), config.getAnnotId(), config.getConfigKey());
            return;
        }
    }

    public Component getConfigurationComponent(Information info, String configId, boolean loadIt) {
        TextAnalyzer ta;
        if (info == null) {
            return null;
        }
        for (TextAnalyzer a : this.loadedAnalyzers) {
            if (!info.equals((Object)a.getInformation())) continue;
            Component c = a.getConfigurationComponent(configId);
            return c;
        }
        if (loadIt && (ta = TextAnalyzerRegistry.getInstance().getAnalyzerForDoc(this.transcription.getURN().toString(), info)) != null) {
            this.prepareAnalyzer(ta);
            Component c = ta.getConfigurationComponent(configId);
            return c;
        }
        return null;
    }

    private void prepareAnalyzer(TextAnalyzer ta) {
        ta.setAnalyzerContext((TextAnalyzerContext)this);
        ta.setCacheFolder(this.analyzerCacheFolder);
        if (ta instanceof LexiconTextAnalyzer) {
            ((LexiconTextAnalyzer)ta).setLexiconContext((TextAnalyzerLexiconContext)this.manager.getTextAnalyzerLexiconContext());
        }
    }

    public boolean isPositionPending() {
        return this.sugWindowOpened || !this.positionQueue.isEmpty();
    }

    public void setAutoAnalyzeMode(boolean autoAnalyzeMode) {
        if (this.autoAnalyzeMode == autoAnalyzeMode) {
            return;
        }
        if (autoAnalyzeMode) {
            this.notifyCancelSuggestionSet();
            this.positionQueue.clear();
            this.sugWindowOpened = false;
        }
        this.autoAnalyzeMode = autoAnalyzeMode;
    }

    public boolean isAutoAnalyzeMode() {
        return this.autoAnalyzeMode;
    }

    public void setRecursive(boolean selected) {
        this.recursive = selected;
    }

    public void analyze(Position pos) {
        List<TextAnalyzer> relAnalyzers;
        if (this.sugWindowOpened || !this.positionQueue.isEmpty()) {
            this.notifyCancelSuggestionSet();
            this.positionQueue.clear();
        }
        if ((relAnalyzers = this.sourceAnalyzerMap.get(pos.getTierId())) != null) {
            for (TextAnalyzer a : relAnalyzers) {
                this.positionQueue.addFirst(new Pair<TextAnalyzer, Position>(a, pos));
            }
        }
        this.analyzeNext();
    }

    private void addPositionsToQueue(List<Position> sourcePositions) {
        String sourceId;
        List<TextAnalyzer> relAnalyzers;
        if (!sourcePositions.isEmpty() && (relAnalyzers = this.sourceAnalyzerMap.get(sourceId = sourcePositions.get(0).getTierId())) != null) {
            for (int i = sourcePositions.size() - 1; i >= 0; --i) {
                Position pos = sourcePositions.get(i);
                for (TextAnalyzer ta : relAnalyzers) {
                    this.positionQueue.addFirst(new Pair<TextAnalyzer, Position>(ta, pos));
                }
            }
        }
    }

    private void analyzeNext() {
        if (!this.positionQueue.isEmpty()) {
            Pair<TextAnalyzer, Position> np = this.positionQueue.peekFirst();
            np.getFirst().analyze(np.getSecond());
        }
    }

    public boolean changeAnnotation(Position pos, Suggestion ann) {
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Change annotation: Position is null");
            }
            return false;
        }
        if (ann == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Change annotation: no annotation specified");
            }
            return false;
        }
        boolean changed = false;
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier != null) {
            long t = (pos.getBeginTime() + pos.getEndTime()) / 2L;
            AbstractAnnotation aa = (AbstractAnnotation)destTier.getAnnotationAtTime(t);
            if (aa != null) {
                String oldText = aa.getValue();
                String newText = ann.getContent();
                if (newText == null) {
                    newText = "";
                }
                Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.ModifyAnnotation");
                command.execute(aa, new Object[]{oldText, newText});
                changed = true;
            } else if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Change annotation: there is no annotation at the specified position");
            }
        }
        return changed;
    }

    public boolean newAnnotation(Position pos, Suggestion ann) {
        if (ann == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "New annotation: no new annotation specified");
            }
            return false;
        }
        ArrayList<Suggestion> list = new ArrayList<Suggestion>(1);
        list.add(ann);
        return this.newAnnotation(pos, list);
    }

    public boolean newAnnotation(Position pos, List<Suggestion> annotations) {
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "New annotation: Position is null");
            }
            return false;
        }
        if (annotations == null || annotations.isEmpty()) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "New annotation: no new annotations specified");
            }
            return false;
        }
        boolean created = false;
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier != null) {
            Constraint cons = destTier.getLinguisticType().getConstraints();
            if (cons == null && ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "The destination tier is an independent tier");
            }
            SuggestionSet sugSet = new SuggestionSet(pos);
            sugSet.addAll(annotations);
            this.removePositionFromQueue(sugSet);
            this.notifyLexanSuggestionSelected(0, sugSet);
            this.annotationsFromSuggestionSet(sugSet);
            this.analyzeNext();
        }
        return created;
    }

    private void annotationsFromSuggestionSet(SuggestionSet sugSet) {
        List<? extends Annotation> recurses;
        AnnotationsFromSuggestionSetCommand command = (AnnotationsFromSuggestionSetCommand)ELANCommandFactory.createCommand(this.transcription, "CommandActions.AnnotationsFromSuggestionSet");
        command.execute(this.transcription, new Object[]{sugSet, this.recursive});
        if (this.recursive && (recurses = command.getCreatedAnnotations()) != null) {
            ArrayList<Position> posList = new ArrayList<Position>(recurses.size());
            for (AbstractAnnotation abstractAnnotation : recurses) {
                Position np = new Position(abstractAnnotation.getTier().getName(), abstractAnnotation.getBeginTimeBoundary(), abstractAnnotation.getEndTimeBoundary());
                posList.add(np);
            }
            this.addPositionsToQueue(posList);
        }
    }

    public boolean newAnnotations(List<SuggestionSet> sugSets) {
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.log(Level.FINE, String.format("newAnnotations(): the Positions queue has %d items\n", this.positionQueue.size()));
        }
        if (sugSets != null) {
            if (sugSets.size() == 1) {
                SuggestionSet sugSet = sugSets.get(0);
                this.removePositionFromQueue(sugSet);
                this.notifyLexanSuggestionSelected(0, sugSet);
                this.annotationsFromSuggestionSet(sugSet);
                this.analyzeNext();
                return true;
            }
            if (sugSets.isEmpty()) {
                if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                    ClientLogger.LOG.log(Level.INFO, "The analyzer returned an empty list (0 suggestions)");
                }
            } else {
                this.notifySuggestionSetDelivered(sugSets);
                this.sugWindowOpened = true;
                return true;
            }
        }
        return false;
    }

    private void notifySuggestionSetDelivered(List<SuggestionSet> sugSets) {
        if (ClientLogger.LOG.isLoggable(Level.FINE)) {
            ClientLogger.LOG.log(Level.FINE, String.format("notifySuggestionSetDelivered: this opens a window; position queue has %d items", this.positionQueue.size()));
        }
        SuggestionSetEvent event = new SuggestionSetEvent(this, sugSets, 0);
        for (SuggestionSetListener ssl : this.suggestionListeners) {
            ssl.suggestionSetDelivered(event);
        }
    }

    private void notifyCancelSuggestionSet() {
        for (SuggestionSetListener ssl : this.suggestionListeners) {
            ssl.cancelSuggestionSet();
        }
    }

    public Object prompt(Prompt arg0) {
        return null;
    }

    public List<Suggestion> readAnnotation(Position pos) {
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Read annotations: Position is null");
            }
            return null;
        }
        ArrayList<Suggestion> annotations = new ArrayList<Suggestion>();
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier != null) {
            List<AbstractAnnotation> curAnnos = destTier.getAnnotations();
            long posBeginTime = pos.getBeginTime();
            long posEndTime = pos.getEndTime() >= 0L ? pos.getEndTime() : Long.MAX_VALUE;
            for (int i = 0; i < curAnnos.size(); ++i) {
                AbstractAnnotation aa = curAnnos.get(i);
                long annoEndTime = aa.getEndTimeBoundary();
                if (annoEndTime < posBeginTime) continue;
                long annoBeginTime = aa.getBeginTimeBoundary();
                if (annoBeginTime > posEndTime) break;
                if (annoBeginTime < posBeginTime || annoEndTime > posEndTime) continue;
                Suggestion a = new Suggestion(aa.getValue(), new Position(pos, annoBeginTime, annoEndTime));
                annotations.add(a);
            }
        }
        return annotations;
    }

    public List<Suggestion> readParentAnnotation(Position pos) {
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Read parent annotation: Position is null");
            }
            return null;
        }
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier == null || destTier.getParentTier() == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Read parent annotation: Requested tier and/or its parent tier is null");
            }
            return null;
        }
        ArrayList<Suggestion> annotations = new ArrayList<Suggestion>();
        TierImpl parentTier = destTier.getParentTier();
        List<AbstractAnnotation> curAnnos = parentTier.getAnnotations();
        long posBeginTime = pos.getBeginTime();
        long posEndTime = pos.getEndTime() >= 0L ? pos.getEndTime() : Long.MAX_VALUE;
        for (int i = 0; i < curAnnos.size(); ++i) {
            AbstractAnnotation aa = curAnnos.get(i);
            long annoEndTime = aa.getEndTimeBoundary();
            if (annoEndTime < posBeginTime) continue;
            long annoBeginTime = aa.getBeginTimeBoundary();
            if (annoBeginTime > posEndTime) break;
            if (annoBeginTime < posBeginTime || annoEndTime > posEndTime) continue;
            Suggestion a = new Suggestion(aa.getValue(), new Position(parentTier.getName(), annoBeginTime, annoEndTime));
            annotations.add(a);
        }
        return annotations;
    }

    public List<Suggestion> readSiblingAnnotations(Position pos) {
        AbstractAnnotation parentAnn;
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Read sibling annotations: Position is null");
            }
            return null;
        }
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier == null || destTier.getParentTier() == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Read sibling annotations: Requested tier and/or its parent tier is null");
            }
            return null;
        }
        ArrayList<Suggestion> annotations = new ArrayList<Suggestion>();
        List<AbstractAnnotation> curAnnos = destTier.getAnnotations();
        long posBeginTime = pos.getBeginTime();
        long posEndTime = pos.getEndTime() >= 0L ? pos.getEndTime() : Long.MAX_VALUE;
        Annotation firstInInterval = null;
        for (int i = 0; i < curAnnos.size(); ++i) {
            AbstractAnnotation aa = curAnnos.get(i);
            long annoEndTime = aa.getEndTimeBoundary();
            if (annoEndTime < posBeginTime) continue;
            long annoBeginTime = aa.getBeginTimeBoundary();
            if (annoBeginTime > posEndTime) break;
            if (annoBeginTime < posBeginTime || annoEndTime > posEndTime) continue;
            firstInInterval = aa;
            break;
        }
        if (firstInInterval != null && (parentAnn = (AbstractAnnotation)firstInInterval.getParentAnnotation()) != null) {
            long parBeginTime = parentAnn.getBeginTimeBoundary();
            long parEndTime = parentAnn.getEndTimeBoundary();
            for (int i = 0; i < curAnnos.size(); ++i) {
                AbstractAnnotation aa = curAnnos.get(i);
                long annoEndTime = aa.getEndTimeBoundary();
                if (annoEndTime < parBeginTime) continue;
                long annoBeginTime = aa.getBeginTimeBoundary();
                if (annoBeginTime > parEndTime) break;
                if (annoBeginTime < parBeginTime || annoEndTime > parEndTime) continue;
                Suggestion a = new Suggestion(aa.getValue(), new Position(pos, annoBeginTime, annoEndTime));
                annotations.add(a);
            }
        }
        return annotations;
    }

    public boolean remAnnotation(Position pos) {
        if (pos == null) {
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Remove annotation: Position is null");
            }
            return false;
        }
        TierImpl destTier = (TierImpl)this.transcription.getTierWithId(pos.getTierId());
        if (destTier != null) {
            long t = (pos.getBeginTime() + pos.getEndTime()) / 2L;
            AbstractAnnotation aa = (AbstractAnnotation)destTier.getAnnotationAtTime(t);
            if (aa != null) {
                Command command = ELANCommandFactory.createCommand(this.transcription, "Menu.Annotation.DeleteAnnotation");
                command.execute(destTier, new Object[]{ELANCommandFactory.getViewerManager(this.transcription), aa});
                return true;
            }
            if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                ClientLogger.LOG.log(Level.WARNING, "Remove annotation: there is no annotation at the specified position");
            }
        }
        return false;
    }

    @Override
    public void addSuggestionSetListener(SuggestionSetListener listener) {
        if (listener != null && !this.suggestionListeners.contains(listener)) {
            this.suggestionListeners.add(listener);
        }
    }

    @Override
    public void removeSuggestionSetListener(SuggestionSetListener listener) {
        this.suggestionListeners.remove(listener);
    }

    @Override
    public void suggestionSelected(SuggestionSelectionEvent event) {
        block3: {
            if (event != null) {
                IGTSuggestionViewerModel viewModel = (IGTSuggestionViewerModel)event.getSource();
                int row = event.getSelectedRow();
                try {
                    IGTSuggestionModel sugModel = viewModel.getRowData(row);
                    SuggestionSet sugSet = sugModel.getSuggestionSet();
                    this.removePositionFromQueue(sugSet);
                    this.notifyLexanSuggestionSelected(row, sugSet);
                    this.annotationsFromSuggestionSet(sugSet);
                    this.analyzeNext();
                }
                catch (ArrayIndexOutOfBoundsException abe) {
                    if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block3;
                    ClientLogger.LOG.log(Level.WARNING, "The row of the selcted suggestion does not exist: " + row);
                }
            }
        }
        this.sugWindowOpened = false;
    }

    @Override
    public void suggestionClosed(SuggestionSelectionEvent event) {
        if (event != null) {
            IGTSuggestionViewerModel viewModel = (IGTSuggestionViewerModel)event.getSource();
            IGTSuggestionModel sugModel = viewModel.getRowData(0);
            SuggestionSet sugSet = sugModel.getSuggestionSet();
            this.notifyLexanSuggestionClosed(sugSet);
            this.removePositionFromQueue(sugSet);
            this.analyzeNext();
        }
        this.sugWindowOpened = false;
        this.autoAnalyzeMode = false;
    }

    private void removePositionFromQueue(SuggestionSet sugSet) {
        if (sugSet != null) {
            Pair<TextAnalyzer, Position> firstPos = this.positionQueue.peekFirst();
            if (firstPos != null && firstPos.getSecond().equals((Object)sugSet.getSource())) {
                this.positionQueue.removeFirst();
            } else if (firstPos != null) {
                for (AnalyzerConfig ac : this.configs) {
                    if (!ac.getAnnotId().equals((Object)firstPos.getFirst().getInformation())) continue;
                    for (AnalyzerConfig at : ac.getTierConfigurations()) {
                        if (!at.getDest().contains(sugSet.getSource().getTierId())) continue;
                        this.positionQueue.removeFirst();
                        return;
                    }
                }
            } else if (ClientLogger.LOG.isLoggable(Level.FINE)) {
                ClientLogger.LOG.log(Level.FINE, "The processed Position is not the first object in the queue, cannot remove it");
            }
        } else if (this.positionQueue.peekFirst() != null) {
            this.positionQueue.removeFirst();
        }
    }

    @Override
    public void suggestionIgnored(SuggestionSelectionEvent event) {
        if (event != null) {
            IGTSuggestionViewerModel viewModel = (IGTSuggestionViewerModel)event.getSource();
            IGTSuggestionModel sugModel = viewModel.getRowData(0);
            SuggestionSet sugSet = sugModel.getSuggestionSet();
            this.removePositionFromQueue(sugSet);
            this.notifyLexanSuggestionIgnored(sugSet);
            this.analyzeNext();
        }
        this.sugWindowOpened = false;
    }

    @Override
    public void suggestionRemoved(SuggestionSelectionEvent event) {
        if (event != null) {
            IGTSuggestionViewerModel viewModel = (IGTSuggestionViewerModel)event.getSource();
            IGTSuggestionModel sugModel = viewModel.getRowData(event.getSelectedRow());
            SuggestionSet sugSet = sugModel.getSuggestionSet();
            this.notifyLexanSuggestionRemoved(sugSet);
        }
    }

    public void annotationDeleted(Position pos) {
    }

    public void annotationsAdded(Position pos) {
    }

    public void addSuggestionSelectionListener(LexanSuggestionSelectionListener l) {
        if (this.suggestionSelectionListeners == null) {
            this.suggestionSelectionListeners = new ArrayList<LexanSuggestionSelectionListener>();
        }
        if (l != null && !this.suggestionSelectionListeners.contains(l)) {
            this.suggestionSelectionListeners.add(l);
        }
    }

    public void removeSuggestionSelectionListener(LexanSuggestionSelectionListener l) {
        if (this.suggestionSelectionListeners != null) {
            this.suggestionSelectionListeners.remove(l);
        }
    }

    private void notifyLexanSuggestionSelected(int nr, SuggestionSet selection) {
        if (this.suggestionSelectionListeners != null) {
            for (LexanSuggestionSelectionListener l : this.suggestionSelectionListeners) {
                l.suggestionSelected(nr, selection);
            }
        }
    }

    private void notifyLexanSuggestionIgnored(SuggestionSet sugSet) {
        if (this.suggestionSelectionListeners != null) {
            for (LexanSuggestionSelectionListener l : this.suggestionSelectionListeners) {
                l.suggestionIgnored(sugSet);
            }
        }
    }

    private void notifyLexanSuggestionClosed(SuggestionSet sugSet) {
        if (this.suggestionSelectionListeners != null) {
            for (LexanSuggestionSelectionListener l : this.suggestionSelectionListeners) {
                l.suggestionClosed(sugSet);
            }
        }
    }

    private void notifyLexanSuggestionRemoved(SuggestionSet sugSet) {
        if (this.suggestionSelectionListeners != null) {
            for (LexanSuggestionSelectionListener l : this.suggestionSelectionListeners) {
                l.suggestionRemoved(sugSet);
            }
        }
    }
}

