/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.interlinear.edit.lexicon.LexanLexiconImpl;
import mpi.eudico.client.annotator.layout.InterlinearizationManager;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.lexicon.LexiconQueryBundle2;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;
import nl.mpi.lexiconcomponent.events.LexiconEditListener;
import nl.mpi.lexiconcomponent.events.LexiconEvent;
import nl.mpi.lexiconcomponent.exceptions.LexiconNotFoundException;
import nl.mpi.lexiconcomponent.impl.EntryImpl;
import nl.mpi.lexiconcomponent.impl.LexiconContext;
import nl.mpi.lexiconcomponent.impl.LexiconImpl;
import nl.mpi.lexiconcomponent.impl.SenseImpl;

public class TextAnalyzerLexiconHostContext
implements TextAnalyzerLexiconContext,
LexiconEditListener {
    private File lexiconFolder = new File(Constants.ELAN_DATA_DIR, "LexanLexicons");
    private InterlinearizationManager manager;
    private Map<LexanLexicon, LexiconImpl> lexiconMap = new HashMap<LexanLexicon, LexiconImpl>();
    private List<LexiconChangeListener> listeners = new ArrayList<LexiconChangeListener>();

    public TextAnalyzerLexiconHostContext(InterlinearizationManager manager) {
        this.manager = manager;
        this.ensureLexiconFolder();
        LexiconContext.getInstance().scanLexiconsFromFolder(this.lexiconFolder);
    }

    public Transcription getTranscription() {
        return this.manager.getTranscription();
    }

    public List<String> getLexiconNames() {
        ArrayList<String> lexNames = new ArrayList<String>();
        for (String lexName : this.getAvailableLexicons()) {
            if (lexNames.contains(lexName)) continue;
            lexNames.add(lexName);
        }
        return lexNames;
    }

    public void ensureLexiconFolder() {
        block8: {
            String prefLexFolder = System.getProperty("LexiconComponent.LexiconFolder");
            if (prefLexFolder != null) {
                this.lexiconFolder = new File(prefLexFolder);
                if (!this.lexiconFolder.exists() || !this.lexiconFolder.isDirectory() || !this.lexiconFolder.canRead() && !this.lexiconFolder.canWrite()) {
                    this.lexiconFolder = null;
                }
            }
            if (this.lexiconFolder == null) {
                this.lexiconFolder = new File(Constants.ELAN_DATA_DIR, "LexanLexicons");
            }
            try {
                if (this.lexiconFolder.exists()) break block8;
                try {
                    this.lexiconFolder.mkdir();
                }
                catch (Throwable t) {
                    if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                        ClientLogger.LOG.warning(String.format("Cannot create the folder for LEXAN lexicons: %s", t.getMessage()));
                    }
                    return;
                }
            }
            catch (Throwable thr) {
                if (!ClientLogger.LOG.isLoggable(Level.WARNING)) break block8;
                ClientLogger.LOG.warning(String.format("Cannot check the existence of the LEXAN lexicons folder: %s", thr.getMessage()));
            }
        }
    }

    private String[] getAvailableLexicons() {
        return LexiconContext.getInstance().getAvailableLexicons();
    }

    public LexanLexicon getLexicon(String lexiconName) {
        for (String lexName : this.getAvailableLexicons()) {
            if (!lexName.equals(lexiconName)) continue;
            try {
                LexiconImpl lexImpl = LexiconContext.getInstance().getLexicon(lexName);
                LexanLexiconImpl lexProx = new LexanLexiconImpl(lexImpl);
                lexImpl.addLexiconEditListener((LexiconEditListener)lexProx);
                this.lexiconMap.put(lexProx, lexImpl);
                return lexProx;
            }
            catch (LexiconNotFoundException lnfe) {
                System.err.printf("Lexicon not found: %s\n", lnfe.toString());
            }
        }
        File file = new File(Constants.ELAN_DATA_DIR, lexiconName + ".xml");
        if (file.exists()) {
            try {
                LexiconImpl lexImpl = LexiconContext.getInstance().loadLexiconFromURL(file.toURI().toURL());
                LexanLexiconImpl lexProx = new LexanLexiconImpl(lexImpl);
                lexImpl.addLexiconEditListener((LexiconEditListener)lexProx);
                this.lexiconMap.put(lexProx, lexImpl);
                return lexProx;
            }
            catch (LexiconNotFoundException lexImpl) {
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public File getLexiconFolder() {
        return this.lexiconFolder;
    }

    public String getDefaultLexiconName() {
        String[] lexicons = this.getAvailableLexicons();
        if (lexicons.length > 0) {
            return lexicons[0];
        }
        return "";
    }

    public void initiateCreateNewEntry(LexiconQueryBundle2 lexIdBundle, Map<String, String> fieldValues) {
        if (lexIdBundle == null) {
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("Cannot create Add Entry dialog, no lexicon name and lexicon type specified (LexiconQueryBundle2 is null)");
            }
            return;
        }
        if (fieldValues == null || fieldValues.isEmpty()) {
            if (ClientLogger.LOG.isLoggable(Level.INFO)) {
                ClientLogger.LOG.info("Cannot create Add Entry dialog, no initial field value(s) specified");
            }
            return;
        }
        String string = lexIdBundle.getLink().getLexSrvcClntType();
        Objects.requireNonNull(LexiconContext.getInstance());
        if (string.equals("ELAN Lexicon Component")) {
            try {
                LexiconImpl lexicon = LexiconContext.getInstance().getLexicon(lexIdBundle.getLink().getName());
                this.manager.getLexiconPanel().createNewEntry(lexicon, fieldValues);
            }
            catch (LexiconNotFoundException lnfe) {
                if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
                    ClientLogger.LOG.warning(String.format("The lexicon named \"%s\" is not found", lexIdBundle.getLink().getName()));
                }
            }
        } else if (ClientLogger.LOG.isLoggable(Level.WARNING)) {
            Objects.requireNonNull(LexiconContext.getInstance());
            ClientLogger.LOG.warning("Cannot create Add Entry dialog, the lexicon is not of type " + "ELAN Lexicon Component");
        }
    }

    public boolean addToLexicalEntry(LexanLexicon lex, LexEntry lexEntry, LexItem lexItem) {
        return false;
    }

    public boolean addEntryToLexicon(LexanLexicon lex, String entryValue) {
        return false;
    }

    public boolean addEntryToLexicon(LexanLexicon lex, Map<String, String> entryValues) {
        return false;
    }

    public void lexiconEdited(LexiconEvent<LexiconImpl> arg0) {
    }

    public void lexiconEntryEdited(LexiconEvent<EntryImpl> arg0) {
    }

    public void lexiconSenseEdited(LexiconEvent<SenseImpl> arg0) {
    }
}

