/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class TierTypeMapCreator {
    private Map<String, List<String>> tiersChildrenMap;
    private Map<String, List<String>> typesChildrenMap;
    private Map<String, List<String>> typesToTiersMap;

    public TierTypeMapCreator(Transcription transcription) {
        this.createMaps(transcription);
    }

    private void createMaps(Transcription transcription) {
        this.typesChildrenMap = new HashMap<String, List<String>>();
        this.tiersChildrenMap = new HashMap<String, List<String>>();
        this.typesToTiersMap = new HashMap<String, List<String>>();
        List<? extends Tier> list = transcription.getTiers();
        ArrayList<String> allTierNames = new ArrayList<String>(list.size());
        ArrayList<String> allTypeNames = new ArrayList<String>();
        for (Tier tier : list) {
            List<String> typeToTiersList;
            String typeName = tier.getLinguisticType().getLinguisticTypeName();
            allTierNames.add(tier.getName());
            if (!allTypeNames.contains(typeName)) {
                allTypeNames.add(typeName);
            }
            List<String> childTypeNamesList = null;
            if (this.typesChildrenMap.containsKey(typeName)) {
                childTypeNamesList = this.typesChildrenMap.get(typeName);
            }
            if ((typeToTiersList = this.typesToTiersMap.get(typeName)) == null) {
                typeToTiersList = new ArrayList<String>();
                this.typesToTiersMap.put(typeName, typeToTiersList);
            }
            typeToTiersList.add(tier.getName());
            List<? extends Tier> childList = tier.getChildTiers();
            if (childList == null || childList.isEmpty()) continue;
            ArrayList<String> childTierNamesList = new ArrayList<String>();
            if (childTypeNamesList == null) {
                childTypeNamesList = new ArrayList<String>();
            }
            for (Tier tier2 : childList) {
                childTierNamesList.add(tier2.getName());
                String linguisticTypeName = tier2.getLinguisticType().getLinguisticTypeName();
                if (childTypeNamesList.contains(linguisticTypeName)) continue;
                childTypeNamesList.add(linguisticTypeName);
            }
            this.tiersChildrenMap.put(tier.getName(), childTierNamesList);
            this.typesChildrenMap.put(typeName, childTypeNamesList);
        }
        for (LinguisticType linguisticType : transcription.getLinguisticTypes()) {
            if (this.typesChildrenMap.containsKey(linguisticType.getLinguisticTypeName())) continue;
            this.typesChildrenMap.put("", new ArrayList(0));
        }
        this.tiersChildrenMap.put("", allTierNames);
        this.typesChildrenMap.put("", allTypeNames);
    }

    public Map<String, List<String>> getTiersChildrenMap() {
        return this.tiersChildrenMap;
    }

    public Map<String, List<String>> getTypesChildrenMap() {
        return this.typesChildrenMap;
    }

    public Map<String, List<String>> getTypesToTiersMap() {
        return this.typesToTiersMap;
    }

    public List<String> getTiersNotOfType(String typeName) {
        ArrayList<String> otherTypeTiers = new ArrayList<String>();
        for (String key : this.typesToTiersMap.keySet()) {
            if (key.equals(typeName)) continue;
            otherTypeTiers.addAll((Collection<String>)this.typesToTiersMap.get(key));
        }
        return otherTypeTiers;
    }
}

